/*

$Id: gdisp_plotEarthData.c,v 1.2 2007/11/21 21:55:35 esteban Exp $

-----------------------------------------------------------------------

GDISP+ - Graphic Tool based on GTK+,
         for being used upon the generic Transport Sampling Protocol.

Copyright (c) 2007 - Euskadi

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------

Project   : TSP
Maintainer: tsp@astrium-space.com
Component : Graphic Tool

-----------------------------------------------------------------------

Purpose   : Graphic Tool based on GTK+ that provide several kinds of
            plot. This tool is to be used with the generic TSP protocol.

File      : Definition of 'earth' polygons (frontiers included)

-----------------------------------------------------------------------
*/

/*
 * Continent bounding box. (lonMin, lonMax, latMin, latMax)
 */
static float
gdisp_earthZoneBoundingBox[] = {
-3.141593, +3.319035, -1.493711, +1.459968
};

/*
 * Number of points per continent zones (polygons).
 */
static unsigned int
gdisp_nbPointsPerEarthZones[] = { 
274,  20,   4,   6,   7,   8,   8,  12,  13,  20,
  4,   6,   5,   8,  14,  26, 127,  73, 121,  28,
 13,  11,  21,  23,  50, 314,   4,  24,   7,   6,
 17,   4,  20,   8,   5,   8,   6,  17,  31,  34,
 55,   6,  18,  16,   9,  11,  11,   7,   6,   9,
  6,  21,   8, 113,  11,   7,  29,  21,  56,   5,
 51,  39,  42,  13,   4,   8,  57,  38,   9,   7,
  4,  10,   6,   8,   5,   8, 483,  10,  51,  16,
  8,   8,   4, 186,   4,  37,   5,   6,  89,  30,
  6,   6,   9,  57,   6, 171,  15,   5,  91,  98,
 94,   6,   9,  10,  16,  17,  45, 103,  23,  46,
 39,  58,   6,   7,   6,   5,  15,  94,  16,  15,
  5,  13, 168,  68,  20,  22,  37,   6,   4,  13,
 17,  72,  22,  84,  24,  68,   7,   6,   5,  79,
 40,  15,  10,  27, 153,  13,  49,  11,  18, 157,
  6,  19,  67,   6,  33,  69,  27,  15,  43,  33,
 10,  11,   5,   5,  72,   6,   4,   5,  17, 133,
 46,  14,   9,  17,  28,  43,  18,  79,  16, 291,
  7,  23, 121,   8,   5,   7,  24,   7,   5,   8,
 16,  74,  21,  16,  79,  43,   8,   5,   7,  47,
  5,  19,   7,  13,   4,   5,   5,   5, 190,   5,
  8,  53,  46,   4,   5,  22,  12,   8,   8,   5,
  7,   4,  15,   5,   9,   8,   9,   5, 480,  35,
  6,  10,   5,  27,   9,   8,   5,   9,   4  };

/*
 * Continent point coordinates (longitude,latitude).
 */
static float
gdisp_earthZoneLonLatCoordinates[] = { 
/* zone 1 with 274 points. */
-2.074034, +1.208058, -2.098760, +1.212421, -2.117667, +1.218821, -2.146755, +1.218821,
-2.155482, +1.210676, -2.170026, +1.211549, -2.171480, +1.221730, -2.187479, +1.211549,
-2.202024, +1.214458, -2.210751, +1.223185, -2.234021, +1.231911, -2.242748, +1.221730,
-2.258747, +1.218821, -2.266019, +1.226093, -2.289290, +1.221439, -2.314016, +1.215912,
-2.327106, +1.210967, -2.341650, +1.214458, -2.359103, +1.213003, -2.372193, +1.207186,
-2.373648, +1.199913, -2.396918, +1.204277, -2.414372, +1.209804, -2.434734, +1.214458,
-2.460915, +1.215039, -2.475458, +1.218821, -2.492912, +1.223185, -2.513274, +1.223185,
-2.532182, +1.221730, -2.551089, +1.225512, -2.574361, +1.225512, -2.600540, +1.229875,
-2.623812, +1.230165, -2.644174, +1.230165, -2.661627, +1.236856, -2.693624, +1.236856,
-2.702352, +1.241510, -2.728531, +1.245001, -2.750348, +1.236856, -2.775073, +1.236275,
-2.799799, +1.229002, -2.820161, +1.227548, -2.839069, +1.220276, -2.844887, +1.212131,
-2.853613, +1.205731, -2.876884, +1.202823, -2.897246, +1.201367, -2.900155, +1.192641,
-2.884156, +1.186532, -2.862340, +1.181005, -2.853613, +1.172279, -2.836160, +1.166461,
-2.823071, +1.159189, -2.830342, +1.153371, -2.857977, +1.153371, -2.859431, +1.160644,
-2.873976, +1.160644, -2.892883, +1.156280, -2.911791, +1.151917, -2.929244, +1.144645,
-2.919064, +1.141736, -2.903064, +1.140281, -2.908882, +1.134463, -2.903064, +1.128646,
-2.878339, +1.125737, -2.856523, +1.127192, -2.839068, +1.124282, -2.825979, +1.128646,
-2.809980, +1.131555, -2.814343, +1.124282, -2.805616, +1.117010, -2.809980, +1.108283,
-2.831797, +1.106829, -2.844887, +1.099557, -2.860886, +1.103920, -2.873976, +1.099557,
-2.876884, +1.093739, -2.888520, +1.085012, -2.897246, +1.073377, -2.884156, +1.066105,
-2.878339, +1.057378, -2.868157, +1.048651, -2.859431, +1.041379, -2.844887, +1.041379,
-2.830342, +1.048651, -2.821615, +1.038470, -2.825979, +1.032653, -2.820161, +1.025380,
-2.809980, +1.028289, -2.785254, +1.028289, -2.773619, +1.019563, -2.769256, +1.025380,
-2.757620, +1.023926, -2.747439, +1.025380, -2.748894, +1.015200, -2.751802, +1.005018,
-2.763438, +0.999201, -2.775073, +0.991929, -2.791072, +0.986111, -2.801253, +0.977384,
-2.817252, +0.975930, -2.833251, +0.971567, -2.843432, +0.964294, -2.860886, +0.959931,
-2.878339, +0.952659, -2.875430, +0.948295, -2.856523, +0.954113, -2.841978, +0.959931,
-2.827434, +0.962839, -2.817252, +0.967203, -2.801253, +0.970112, -2.785254, +0.974475,
-2.770710, +0.977384, -2.764893, +0.984657, -2.751802, +0.989020, -2.734349, +0.994837,
-2.725622, +1.002110, -2.709623, +1.009381, -2.693624, +1.015200, -2.684897, +1.021017,
-2.676171, +1.028289, -2.689261, +1.031198, -2.684898, +1.037016, -2.671808, +1.041379,
-2.661627, +1.048651, -2.657264, +1.057378, -2.647082, +1.063196, -2.629629, +1.069014,
-2.616539, +1.069014, -2.625266, +1.063196, -2.641265, +1.060287, -2.642719, +1.050106,
-2.651446, +1.041379, -2.642719, +1.038470, -2.651446, +1.032653, -2.633993, +1.034107,
-2.620903, +1.039925, -2.609267, +1.045743, -2.594723, +1.045743, -2.585996, +1.054469,
-2.588904, +1.064651, -2.574361, +1.061741, -2.559816, +1.061741, -2.548181, +1.057378,
-2.530727, +1.051560, -2.513274, +1.047197, -2.495821, +1.047197, -2.478368, +1.047197,
-2.462368, +1.042833, -2.447824, +1.041379, -2.437643, +1.045743, -2.434734, +1.037016,
-2.420190, +1.032653, -2.407100, +1.025380, -2.395464, +1.019563, -2.382375, +1.015200,
-2.376556, +1.006473, -2.364921, +0.999201, -2.359103, +0.990474, -2.351831, +0.980293,
-2.351831, +0.991929, -2.356194, +1.002110, -2.356194, +1.010836, -2.367830, +1.016654,
-2.359103, +1.016654, -2.356194, +1.023926, -2.350377, +1.016654, -2.351831, +1.010836,
-2.347468, +1.002110, -2.347468, +0.994837, -2.338741, +0.999201, -2.334378, +1.005018,
-2.328560, +0.999201, -2.321288, +0.993383, -2.335833, +0.996292, -2.344559, +0.990474,
-2.341650, +0.981747, -2.332924, +0.983202, -2.332924, +0.975930, -2.328560, +0.970112,
-2.322742, +0.965749, -2.312562, +0.961385, -2.305289, +0.954113, -2.305289, +0.964294,
-2.314015, +0.974475, -2.321288, +0.981747, -2.312562, +0.978838, -2.303835, +0.978838,
-2.305289, +0.973021, -2.299472, +0.965749, -2.292199, +0.959931, -2.282018, +0.955567,
-2.270383, +0.958476, -2.276200, +0.949750, -2.271837, +0.945387, -2.282018, +0.941023,
-2.274746, +0.932297, -2.264565, +0.927933, -2.254384, +0.917752, -2.241294, +0.913389,
-2.236931, +0.904662, -2.229658, +0.898844, -2.229658, +0.893027, -2.216568, +0.887209,
-2.203478, +0.884300, -2.190389, +0.879936, -2.180207, +0.874119, -2.170026, +0.868301,
-2.159845, +0.863938, -2.149664, +0.868301, -2.149664, +0.859574, -2.142392, +0.855211,
-2.136575, +0.847939, -2.139483, +0.845030, -2.133666, +0.837758, -2.138029, +0.829031,
-2.139483, +0.831940, -2.146755, +0.829031, -2.139483, +0.836303, -2.149664, +0.840667,
-2.161300, +0.840667, -2.175844, +0.845030, -2.177299, +0.840667, -2.174390, +0.836303,
-2.170026, +0.829031, -2.165663, +0.820305, -2.164208, +0.814487, -2.162754, +0.808669,
-2.149664, +0.805760, -2.162754, +0.805760, -2.162754, +0.799942, -2.161300, +0.792670,
-2.164208, +0.785398, -2.164208, +0.776672, -2.165663, +0.767945, -2.168571, +0.757764,
-2.172935, +0.747583, -2.171480, +0.738856, -2.167117, +0.733038, -2.164208, +0.724312,
-2.165663, +0.715585, -2.170026, +0.706858, -2.170026, +0.702495, -2.164208, +0.698132,
-2.159845, +0.692314, -2.159845, +0.686496, -2.158391, +0.679224, -2.152573, +0.673406,
-2.145301, +0.669043, -2.146755, +0.663225, -2.138029, +0.661771, -2.138029, +0.666134,
-2.132212, +0.664680, -2.135120, +0.661771, -2.130757, +0.654498, -2.138029, +0.658862,
-2.136575, +0.651590, -2.132212, +0.645772, -2.126393, +0.645772, -2.126393, +0.638499,
-2.127849, +0.634136, -2.119122, +0.628318, -2.113304, +0.621046, -2.104577, +0.612320,
-2.104577, +0.603593, -2.091487, +0.600684, -2.081306, +0.597775, -2.072579, +0.594866,
-2.066762, +0.594866, -2.065308, +0.589049, -2.059489, +0.589049, -2.050763, +0.583231,
-2.046399, +0.575959, -2.043490, +0.567232, 
/* zone 2 with 20 points. */
-2.186026, +1.258091, -2.161300, +1.250819, -2.148210, +1.240638, -2.124940, +1.245001,
-2.104577, +1.246455, -2.088578, +1.255182, -2.081306, +1.266818, -2.056581, +1.272635,
-2.033310, +1.277580, -2.008584, +1.282817, -2.034764, +1.288634, -2.052217, +1.295906,
-2.084215, +1.295906, -2.114758, +1.300270, -2.140938, +1.295906, -2.171480, +1.292997,
-2.159845, +1.282817, -2.164208, +1.273799, -2.175844, +1.265363, -2.186026, +1.258091, 
/* zone 3 with 4 points. */
-3.087778, +0.901753, -3.077597, +0.903208, -3.084869, +0.906117, -3.087778, +0.901753, 
/* zone 4 with 6 points. */
-2.952516, +0.920661, -2.937971, +0.927933, -2.932153, +0.930842, -2.932153, +0.935205,
-2.940880, +0.933751, -2.952516, +0.920661, 
/* zone 5 with 7 points. */
-2.926335, +0.930842, -2.914700, +0.933751, -2.904519, +0.937242, -2.904519, +0.942478,
-2.917608, +0.942478, -2.917608, +0.936660, -2.926335, +0.930842, 
/* zone 6 with 8 points. */
-2.997602, +1.111193, -2.997603, +1.105374, -2.980149, +1.106829, -2.964150, +1.101011,
-2.946697, +1.105374, -2.964150, +1.106829, -2.975786, +1.111193, -2.997602, +1.111193, 
/* zone 7 with 8 points. */
-2.921972, +1.050106, -2.911791, +1.045743, -2.900155, +1.044288, -2.888520, +1.047197,
-2.888520, +1.051560, -2.898701, +1.053015, -2.910336, +1.051560, -2.921972, +1.050106, 
/* zone 8 with 12 points. */
-2.702352, +0.999201, -2.689261, +0.990474, -2.677626, +0.994837, -2.671808, +1.000655,
-2.657264, +1.003564, -2.661627, +1.009381, -2.670354, +1.010836, -2.654355, +1.015200,
-2.661627, +1.019563, -2.674717, +1.013744, -2.686353, +1.007927, -2.702352, +0.999201, 
/* zone 9 with 13 points. */
-2.322742, +0.945387, -2.321288, +0.935205, -2.312562, +0.930842, -2.308198, +0.922115,
-2.300926, +0.914843, -2.286382, +0.907571, -2.292199, +0.916298, -2.300926, +0.920661,
-2.298018, +0.926479, -2.303835, +0.935205, -2.298018, +0.943932, -2.309652, +0.943932,
-2.322742, +0.945387, 
/* zone 10 with 20 points. */
-2.239840, +0.884300, -2.229658, +0.875573, -2.218023, +0.871210, -2.206388, +0.866847,
-2.207842, +0.862483, -2.197660, +0.859574, -2.190389, +0.855211, -2.181662, +0.855211,
-2.181662, +0.850847, -2.168571, +0.846484, -2.158391, +0.843575, -2.149664, +0.846484,
-2.158391, +0.853757, -2.171480, +0.861029, -2.181662, +0.868301, -2.190389, +0.877028,
-2.203478, +0.879936, -2.219478, +0.882845, -2.232567, +0.887209, -2.239840, +0.884300, 
/* zone 11 with 4 points. */
-2.796599, +0.381063, -2.794272, +0.383682, -2.794272, +0.382227, -2.796598, +0.381064, 
/* zone 12 with 6 points. */
-2.789327, +0.384554, -2.785836, +0.382227, -2.781764, +0.382227, -2.780310, +0.387754,
-2.785254, +0.387754, -2.789327, +0.384554, 
/* zone 13 with 5 points. */
-2.762566, +0.376700, -2.759656, +0.371755, -2.751802, +0.371755, -2.757329, +0.379027,
-2.762566, +0.376700, 
/* zone 14 with 8 points. */
-2.734640, +0.365647, -2.730859, +0.362738, -2.730276, +0.358956, -2.726204, +0.359829,
-2.722423, +0.361865, -2.727658, +0.365937, -2.730859, +0.364774, -2.734640, +0.365647, 
/* zone 15 with 14 points. */
-2.720677, +0.353720, -2.720387, +0.348193, -2.723586, +0.344993, -2.720677, +0.337721,
-2.721259, +0.333067, -2.716605, +0.330449, -2.714277, +0.333940, -2.710496, +0.336267,
-2.705260, +0.337430, -2.701770, +0.340630, -2.705551, +0.343539, -2.707587, +0.347611,
-2.711659, +0.349939, -2.720967, +0.354302, 
/* zone 16 with 26 points. */
-2.183116, +1.153371, -2.156936, +1.154243, -2.129303, +1.156280, -2.111850, +1.151917,
-2.129303, +1.147553, -2.142392, +1.144645, -2.151118, +1.134463, -2.124939, +1.134463,
-2.122030, +1.140281, -2.106031, +1.146099, -2.103123, +1.140281, -2.111850, +1.131555,
-2.082761, +1.140862, -2.094396, +1.148717, -2.066762, +1.146099, -2.060944, +1.153371,
-2.053672, +1.159189, -2.078398, +1.157734, -2.103123, +1.159189, -2.090033, +1.163552,
-2.075488, +1.167915, -2.094397, +1.170824, -2.117667, +1.165007, -2.140938, +1.162098,
-2.161300, +1.158317, -2.183116, +1.153371, 
/* zone 17 with 127 points. */
-2.043490, +0.567232, -2.037673, +0.558505, -2.034764, +0.551233, -2.030400, +0.545415,
-2.030400, +0.541052, -2.024583, +0.536689, -2.024583, +0.529416, -2.020220, +0.527962,
-2.018765, +0.517781, -2.010038, +0.514872, -2.001312, +0.507600, -1.995494, +0.501782,
-1.989676, +0.495964, -1.989676, +0.488692, -1.996948, +0.484329, -2.007130, +0.485783,
-1.998403, +0.479966, -1.995494, +0.474148, -1.989676, +0.471239, -1.982404, +0.466876,
-1.975132, +0.466875, -1.969315, +0.461058, -1.960588, +0.456695, -1.956224, +0.447968,
-1.956224, +0.439241, -1.960588, +0.433423, -1.948952, +0.429060, -1.941680, +0.423242,
-1.934407, +0.415970, -1.925681, +0.410152, -1.919863, +0.398517, -1.909682, +0.407243,
-1.915500, +0.414516, -1.922772, +0.423242, -1.930044, +0.423242, -1.934407, +0.430515,
-1.931499, +0.433423, -1.937316, +0.439241, -1.937316, +0.445059, -1.943134, +0.453786,
-1.946043, +0.462512, -1.954770, +0.471239, -1.960588, +0.479966, -1.967859, +0.485783,
-1.970769, +0.494510, -1.976586, +0.501782, -1.983859, +0.509054, -1.989676, +0.516326,
-1.996948, +0.520690, -2.001312, +0.526508, -1.999857, +0.533780, -2.002767, +0.541052,
-2.004221, +0.548324, -2.002767, +0.554142, -1.992585, +0.549779, -1.986768, +0.551233,
-1.980949, +0.546870, -1.973678, +0.543961, -1.973678, +0.536689, -1.969315, +0.527962,
-1.967859, +0.522144, -1.962042, +0.514872, -1.957679, +0.506145, -1.948952, +0.497419,
-1.940226, +0.488692, -1.930044, +0.487238, -1.930044, +0.478511, -1.919864, +0.471239,
-1.915500, +0.465421, -1.911137, +0.465421, -1.906774, +0.459603, -1.909682, +0.453786,
-1.909682, +0.449422, -1.902410, +0.445059, -1.890775, +0.440696, -1.884956, +0.430515,
-1.877685, +0.424697, -1.870412, +0.418879, -1.863140, +0.410152, -1.857322, +0.404335,
-1.850050, +0.397063, -1.844233, +0.391245, -1.841323, +0.379609, -1.835505, +0.375246,
-1.835505, +0.369428, -1.841323, +0.363610, -1.838414, +0.359247, -1.844233, +0.354883,
-1.838414, +0.346157, -1.831142, +0.337430, -1.820961, +0.333067, -1.812235, +0.327249,
-1.806417, +0.319977, -1.794782, +0.315614, -1.784600, +0.314159, -1.780237, +0.314159,
-1.772964, +0.308342, -1.762784, +0.301069, -1.754057, +0.298160, -1.745330, +0.295252,
-1.736604, +0.290888, -1.727877, +0.289434, -1.719151, +0.285070, -1.710423, +0.280707,
-1.700243, +0.279253, -1.690062, +0.276344, -1.679880, +0.273435, -1.669700, +0.277798,
-1.660973, +0.282162, -1.652246, +0.282162, -1.644974, +0.280707, -1.637702, +0.277798,
-1.630429, +0.273435, -1.626066, +0.269072, -1.618793, +0.261799, -1.611522, +0.255982,
-1.605704, +0.250164, -1.596977, +0.245800, -1.588251, +0.242892, -1.579524, +0.242892,
-1.570796, +0.238528, -1.566432, +0.234165, -1.559160, +0.234165, -1.550433, +0.229802,
-1.543161, +0.229802, -1.532980, +0.229802, -1.530071, +0.234165, 
/* zone 18 with 73 points. */
-1.538798, +0.319977, -1.534434, +0.312705, -1.530071, +0.321431, -1.528617, +0.331612,
-1.527163, +0.340339, -1.525708, +0.349066, -1.522799, +0.357792, -1.515527, +0.365065,
-1.515527, +0.372337, -1.519890, +0.375246, -1.528617, +0.375246, -1.535889, +0.376700,
-1.544616, +0.375246, -1.553342, +0.372337, -1.562069, +0.370883, -1.570796, +0.369428,
-1.576615, +0.366519, -1.578070, +0.356338, -1.579524, +0.349066, -1.582433, +0.343248,
-1.582433, +0.335976, -1.588251, +0.333067, -1.594069, +0.328704, -1.592614, +0.324340,
-1.602795, +0.321431, -1.602795, +0.324340, -1.612976, +0.325795, -1.623158, +0.321431,
-1.633338, +0.319977, -1.643519, +0.317068, -1.649337, +0.317068, -1.655155, +0.322886,
-1.663881, +0.325795, -1.672608, +0.328704, -1.678426, +0.335976, -1.682790, +0.343248,
-1.687153, +0.351975, -1.692970, +0.357792, -1.697333, +0.363610, -1.700243, +0.370883,
-1.697333, +0.376700, -1.706060, +0.382518, -1.708969, +0.391245, -1.706060, +0.398517,
-1.706060, +0.407243, -1.706060, +0.415970, -1.706060, +0.424697, -1.703152, +0.433423,
-1.700243, +0.442150, -1.695879, +0.449422, -1.697333, +0.456695, -1.697333, +0.465421,
-1.700243, +0.474148, -1.698788, +0.482874, -1.692970, +0.488692, -1.684244, +0.494510,
-1.675517, +0.500328, -1.666790, +0.501782, -1.660973, +0.506145, -1.655155, +0.510509,
-1.659518, +0.517781, -1.653701, +0.520690, -1.653701, +0.513418, -1.644974, +0.517781,
-1.637702, +0.519235, -1.627521, +0.520690, -1.618793, +0.517781, -1.610067, +0.516326,
-1.602795, +0.520690, -1.594069, +0.514872, -1.592614, +0.509054, -1.583887, +0.507600,
-1.573707, +0.509054, 
/* zone 19 with 121 points. */
-1.537343, +0.984657, -1.553342, +0.990474, -1.570796, +0.993383, -1.588251, +0.999201,
-1.601340, +0.996292, -1.611522, +0.993383, -1.611522, +0.999201, -1.617339, +1.006473,
-1.617339, +1.013744, -1.624612, +1.023926, -1.636248, +1.025380, -1.647882, +1.023926,
-1.653701, +1.031198, -1.653701, +1.039925, -1.652246, +1.050106, -1.647882, +1.057378,
-1.643519, +1.064651, -1.634792, +1.073377, -1.626066, +1.080649, -1.614430, +1.083558,
-1.614430, +1.092284, -1.598432, +1.095194, -1.580978, +1.098103, -1.582433, +1.106829,
-1.570796, +1.117010, -1.544616, +1.117010, -1.531526, +1.125736, -1.518435, +1.134463,
-1.518435, +1.143190, -1.500982, +1.154825, -1.514072, +1.160644, -1.492256, +1.162098,
-1.484983, +1.157734, -1.461713, +1.154825, -1.442805, +1.162098, -1.420988, +1.169370,
-1.416625, +1.179551, -1.438441, +1.183914, -1.438441, +1.192641, -1.419534, +1.197004,
-1.419534, +1.207767, -1.444260, +1.210094, -1.447168, +1.215912, -1.470439, +1.218821,
-1.492256, +1.218821, -1.492256, +1.210094, -1.490802, +1.199913, -1.490802, +1.189732,
-1.509709, +1.183914, -1.509709, +1.176642, -1.522799, +1.173734, -1.538798, +1.183914,
-1.535889, +1.192641, -1.535889, +1.199913, -1.551888, +1.208640, -1.569342, +1.197004,
-1.582433, +1.205731, -1.594069, +1.213003, -1.612976, +1.217366, -1.594069, +1.224639,
-1.604250, +1.233365, -1.617339, +1.239183, -1.631884, +1.246455, -1.643519, +1.255182,
-1.631884, +1.261000, -1.640611, +1.266817, -1.624612, +1.269727, -1.604250, +1.269727,
-1.594069, +1.276999, -1.582433, +1.284271, -1.573707, +1.288634, -1.591160, +1.291834,
-1.626066, +1.294452, -1.660973, +1.291543, -1.668244, +1.284271, -1.662427, +1.276999,
-1.658064, +1.268272, -1.658064, +1.261000, -1.658064, +1.252274, -1.672608, +1.247910,
-1.679880, +1.238602, -1.688607, +1.229002, -1.669700, +1.218821, -1.640611, +1.211549,
-1.652246, +1.204277, -1.644974, +1.195550, -1.660973, +1.186823, -1.666791, +1.186532,
-1.672608, +1.178097, -1.690062, +1.183623, -1.691516, +1.193514, -1.668244, +1.199913,
-1.682790, +1.210094, -1.708969, +1.218821, -1.720605, +1.210094, -1.738058, +1.204277,
-1.710423, +1.197004, -1.722059, +1.191187, -1.723514, +1.181005, -1.745330, +1.179551,
-1.775873, +1.182460, -1.797690, +1.187405, -1.825324, +1.192932, -1.844233, +1.202531,
-1.866049, +1.199913, -1.889319, +1.197004, -1.902410, +1.191187, -1.882048, +1.186823,
-1.887865, +1.179551, -1.906774, +1.182460, -1.924227, +1.186823, -1.947497, +1.183914,
-1.972223, +1.181005, -1.992585, +1.183914, -2.012947, +1.183914, -2.008584, +1.189733,
-1.991131, +1.192060, -2.001312, +1.199331, -2.024583, +1.203695, -2.050763, +1.204277,
-2.074034, +1.208058, 
/* zone 20 with 28 points. */
-2.042036, +1.067559, -2.024583, +1.061741, -2.011493, +1.061741, -1.996948, +1.064651,
-1.988222, +1.063196, -1.985313, +1.069014, -1.970769, +1.071922, -1.957679, +1.074831,
-1.950406, +1.083558, -1.935862, +1.087921, -1.916954, +1.089375, -1.922772, +1.093739,
-1.902410, +1.093740, -1.919864, +1.096648, -1.932953, +1.096648, -1.947497, +1.093739,
-1.953316, +1.089375, -1.962042, +1.083558, -1.973678, +1.082104, -1.986768, +1.085012,
-1.992585, +1.089375, -2.012947, +1.089375, -2.008584, +1.085012, -1.998403, +1.079194,
-2.011493, +1.077741, -2.012947, +1.071922, -2.021674, +1.067559, -2.042036, +1.067559, 
/* zone 21 with 13 points. */
-1.941680, +1.023926, -1.925681, +1.022471, -1.919863, +1.028289, -1.906774, +1.031198,
-1.889319, +1.031198, -1.874776, +1.034107, -1.884956, +1.037016, -1.895138, +1.037016,
-1.905318, +1.041379, -1.914045, +1.041379, -1.922772, +1.034107, -1.931499, +1.029744,
-1.941680, +1.023926, 
/* zone 22 with 11 points. */
-1.799145, +0.983202, -1.783146, +0.987565, -1.783146, +0.994837, -1.783146, +1.002110,
-1.772964, +1.006473, -1.781692, +1.015200, -1.788963, +1.007927, -1.794781, +1.002110,
-1.788963, +0.994837, -1.793327, +0.989020, -1.799145, +0.983202, 
/* zone 23 with 21 points. */
-1.732241, +0.930842, -1.726422, +0.925024, -1.722059, +0.916298, -1.713332, +0.911934,
-1.713332, +0.906117, -1.700243, +0.906117, -1.698788, +0.897390, -1.690062, +0.900299,
-1.691516, +0.893027, -1.692970, +0.885755, -1.692970, +0.878482, -1.682790, +0.881391,
-1.678426, +0.893027, -1.685699, +0.900299, -1.692970, +0.910480, -1.697333, +0.919207,
-1.703152, +0.927933, -1.707515, +0.936660, -1.717696, +0.938114, -1.727877, +0.938114,
-1.732241, +0.930842, 
/* zone 24 with 23 points. */
-1.765693, +0.926479, -1.759874, +0.917752, -1.752603, +0.922116, -1.745330, +0.917752,
-1.749694, +0.913389, -1.749694, +0.904662, -1.739512, +0.900299, -1.727877, +0.893027,
-1.727877, +0.887209, -1.722059, +0.881391, -1.723514, +0.875573, -1.710423, +0.877028,
-1.714787, +0.884300, -1.720605, +0.888663, -1.724968, +0.894481, -1.722059, +0.901753,
-1.730786, +0.903208, -1.739512, +0.900299, -1.742421, +0.910480, -1.738058, +0.914843,
-1.738058, +0.920661, -1.749694, +0.926479, -1.765693, +0.926479, 
/* zone 25 with 50 points. */
-2.076942, +1.249655, -2.055126, +1.245583, -2.060944, +1.239765, -2.043490, +1.234819,
-2.014402, +1.233365, -1.989676, +1.233948, -1.966405, +1.229002, -1.989676, +1.224639,
-2.015857, +1.224639, -2.037673, +1.223766, -2.031856, +1.213003, -2.010038, +1.208640,
-1.985313, +1.208640, -1.973678, +1.197004, -1.948952, +1.198168, -1.919863, +1.199913,
-1.892229, +1.204277, -1.868958, +1.207186, -1.850050, +1.213003, -1.834051, +1.206895,
-1.812235, +1.201949, -1.790418, +1.204277, -1.771510, +1.209513, -1.780237, +1.215912,
-1.759874, +1.217366, -1.756966, +1.225512, -1.786055, +1.228711, -1.810781, +1.233365,
-1.828234, +1.240056, -1.825324, +1.250237, -1.835505, +1.259545, -1.841323, +1.266818,
-1.826779, +1.274962, -1.818052, +1.281363, -1.832597, +1.286307, -1.860230, +1.285726,
-1.874775, +1.276999, -1.884956, +1.268272, -1.912591, +1.274090, -1.934407, +1.271472,
-1.953316, +1.275544, -1.976586, +1.269145, -1.983859, +1.279325, -2.004221, +1.279325,
-2.020220, +1.274381, -2.042036, +1.271181, -2.059489, +1.266818, -2.059489, +1.261872,
-2.074034, +1.257218, -2.076942, +1.249655, 
/* zone 26 with 314 points. */
-1.573707, +0.509054, -1.567886, +0.511963, -1.562069, +0.510509, -1.557706, +0.506145,
-1.554796, +0.509054, -1.563523, +0.514872, -1.563523, +0.517781, -1.559160, +0.520690,
-1.557706, +0.525053, -1.564978, +0.525053, -1.572251, +0.523599, -1.578070, +0.525053,
-1.573707, +0.532325, -1.564978, +0.527962, -1.556252, +0.532325, -1.548979, +0.532325,
-1.540253, +0.530871, -1.535889, +0.535234, -1.532980, +0.529416, -1.524254, +0.529416,
-1.515527, +0.530871, -1.506800, +0.532325, -1.500982, +0.527962, -1.492256, +0.525053,
-1.489347, +0.517781, -1.480620, +0.519235, -1.473348, +0.523599, -1.464622, +0.525053,
-1.457349, +0.519235, -1.450077, +0.509054, -1.445714, +0.507600, -1.442805, +0.498873,
-1.444260, +0.491601, -1.444260, +0.485783, -1.438441, +0.487238, -1.441350, +0.478511,
-1.439896, +0.472693, -1.434078, +0.466876, -1.429715, +0.459603, -1.425351, +0.450877,
-1.418079, +0.445059, -1.415171, +0.437787, -1.407898, +0.439241, -1.403535, +0.442150,
-1.399172, +0.450877, -1.397717, +0.461058, -1.397717, +0.471239, -1.402081, +0.481420,
-1.406444, +0.491601, -1.406444, +0.497419, -1.412262, +0.506145, -1.415171, +0.514872,
-1.419534, +0.523599, -1.420988, +0.532325, -1.422442, +0.541052, -1.418079, +0.549779,
-1.413716, +0.558505, -1.404989, +0.565778, -1.396263, +0.570141, -1.387536, +0.575959,
-1.381719, +0.581776, -1.377355, +0.587594, -1.368629, +0.591958, -1.361356, +0.593412,
-1.354084, +0.599230, -1.346812, +0.605048, -1.336631, +0.606502, -1.332267, +0.610865,
-1.340994, +0.610865, -1.332267, +0.616683, -1.326449, +0.616683, -1.323541, +0.621046,
-1.323541, +0.626864, -1.330812, +0.626864, -1.339540, +0.626864, -1.332267, +0.629773,
-1.326449, +0.631227, -1.322086, +0.629773, -1.317723, +0.623955, -1.322086, +0.629773,
-1.323541, +0.637045, -1.326449, +0.642863, -1.333722, +0.648681, -1.333722, +0.654499,
-1.332267, +0.661771, -1.342448, +0.667588, -1.333722, +0.666134, -1.335176, +0.671952,
-1.336631, +0.680678, -1.333722, +0.686496, -1.326449, +0.689405, -1.329358, +0.683587,
-1.329358, +0.677769, -1.332267, +0.670497, -1.324995, +0.667588, -1.326449, +0.663225,
-1.320632, +0.663225, -1.323541, +0.657408, -1.326449, +0.648681, -1.322086, +0.650135,
-1.319178, +0.658862, -1.313359, +0.666134, -1.308996, +0.670497, -1.316269, +0.680678,
-1.319178, +0.689405, -1.313359, +0.686496, -1.308996, +0.680678, -1.300270, +0.686496,
-1.294452, +0.695223, -1.291543, +0.703950, -1.297360, +0.706858, -1.291543, +0.712676,
-1.282816, +0.717039, -1.274090, +0.719948, -1.265363, +0.719948, -1.256637, +0.719948,
-1.247910, +0.722857, -1.245001, +0.728675, -1.240638, +0.724312, -1.233365, +0.727220,
-1.233365, +0.724312, -1.221730, +0.727220, -1.221729, +0.733038, -1.221729, +0.728675,
-1.230456, +0.728675, -1.233365, +0.735947, -1.239183, +0.738856, -1.234819, +0.743219,
-1.236274, +0.747583, -1.231911, +0.753401, -1.226093, +0.759218, -1.226093, +0.762127,
-1.217366, +0.765036, -1.207186, +0.767945, -1.201367, +0.775217, -1.197004, +0.772308,
-1.186823, +0.775217, -1.178097, +0.778126, -1.169370, +0.782489, -1.169370, +0.788307,
-1.156280, +0.788307, -1.144645, +0.791216, -1.131555, +0.797033, -1.133009, +0.791216,
-1.121373, +0.792670, -1.133009, +0.786852, -1.140281, +0.783944, -1.150462, +0.778126,
-1.154825, +0.770854, -1.151917, +0.763582, -1.143190, +0.759218, -1.134463, +0.765036,
-1.125736, +0.770854, -1.119919, +0.776672, -1.111192, +0.776672, -1.099557, +0.781035,
-1.082104, +0.785398, -1.067559, +0.788307, -1.064651, +0.794124, -1.054469, +0.797033,
-1.044288, +0.802851, -1.055923, +0.808669, -1.054469, +0.817395, -1.058832, +0.820305,
-1.064651, +0.813032, -1.073377, +0.805760, -1.073377, +0.798488, -1.082104, +0.799942,
-1.092284, +0.797033, -1.103920, +0.798488, -1.117010, +0.804306, -1.127191, +0.807214,
-1.133009, +0.815941, -1.134463, +0.826122, -1.131555, +0.833394, -1.146099, +0.830485,
-1.157734, +0.839212, -1.140281, +0.839212, -1.131555, +0.842121, -1.121373, +0.846484,
-1.121373, +0.852302, -1.127191, +0.856665, -1.138826, +0.859574, -1.151917, +0.858120,
-1.165007, +0.856665, -1.176642, +0.852302, -1.186823, +0.849393, -1.198459, +0.845030,
-1.208640, +0.839212, -1.215912, +0.831940, -1.223185, +0.826122, -1.230456, +0.820305,
-1.242092, +0.817395, -1.234819, +0.823213, -1.229002, +0.829031, -1.221729, +0.834849,
-1.215912, +0.840667, -1.208640, +0.847939, -1.198459, +0.853757, -1.186823, +0.861029,
-1.175187, +0.861029, -1.172278, +0.868301, -1.165007, +0.874119, -1.151917, +0.877028,
-1.141736, +0.877028, -1.130100, +0.877028, -1.117010, +0.878482, -1.106829, +0.877028,
-1.096647, +0.877028, -1.085012, +0.877028, -1.076285, +0.874119, -1.063196, +0.875573,
-1.047196, +0.875573, -1.038470, +0.881391, -1.031198, +0.887209, -1.023926, +0.893027,
-1.009381, +0.897390, -0.991929, +0.898844, -0.980293, +0.904662, -0.971566, +0.909025,
-0.977384, +0.920661, -0.974475, +0.927933, -0.986111, +0.936660, -0.999201, +0.936660,
-1.000654, +0.943932, -1.018108, +0.945387, -1.003564, +0.951204, -1.012290, +0.955568,
-1.028289, +0.957022, -1.034107, +0.962840, -1.053015, +0.964294, -1.055923, +0.971567,
-1.070468, +0.975930, -1.077740, +0.981748, -1.077740, +0.990474, -1.070468, +0.996292,
-1.079194, +1.000655, -1.079194, +1.006473, -1.087921, +1.012290, -1.096648, +1.021017,
-1.103920, +1.029744, -1.114101, +1.038470, -1.122828, +1.047197, -1.128646, +1.053015,
-1.137372, +1.047197, -1.144645, +1.042833, -1.138826, +1.037016, -1.146099, +1.029744,
-1.159189, +1.025380, -1.165007, +1.019563, -1.182460, +1.015200, -1.194096, +1.025380,
-1.204276, +1.026834, -1.213003, +1.034107, -1.213003, +1.039925, -1.211549, +1.048651,
-1.215912, +1.055923, -1.213003, +1.063196, -1.226093, +1.064651, -1.239183, +1.064651,
-1.252274, +1.069014, -1.247910, +1.074831, -1.261000, +1.079194, -1.272635, +1.085012,
-1.285726, +1.089375, -1.306087, +1.086467, -1.317723, +1.086467, -1.333722, +1.089375,
-1.351175, +1.090830, -1.362810, +1.086467, -1.362810, +1.079194, -1.352630, +1.074831,
-1.356993, +1.067559, -1.362810, +1.060287, -1.354084, +1.055923, -1.351175, +1.047197,
-1.351175, +1.039925, -1.359901, +1.032653, -1.371537, +1.031198, -1.372992, +1.025380,
-1.362810, +1.019563, -1.352630, +1.016654, -1.346811, +1.006473, -1.343903, +0.999201,
-1.339540, +0.989020, -1.339540, +0.977384, -1.348267, +0.970112, -1.361356, +0.962840,
-1.374446, +0.957022, -1.387536, +0.952659, -1.381719, +0.945387, -1.377355, +0.938114,
-1.375900, +0.927933, -1.375900, +0.919207, -1.368629, +0.910480, -1.378809, +0.901753,
-1.393353, +0.895935, -1.391899, +0.890118, -1.403535, +0.895935, -1.409352, +0.903208,
-1.418079, +0.909025, -1.425351, +0.916298, -1.436987, +0.923570, -1.434078, +0.932297,
-1.434078, +0.939569, -1.438441, +0.946841, -1.434078, +0.959931, -1.448623, +0.964294,
-1.466076, +0.964294, -1.483529, +0.964294, -1.500982, +0.971566, -1.515527, +0.974475,
-1.527163, +0.977384, -1.537343, +0.984657, 
/* zone 27 with 4 points. */
-1.736604, +1.394517, -1.704606, +1.391899, -1.724968, +1.399172, -1.736604, +1.394517, 
/* zone 28 with 24 points. */
-1.855867, +1.382300, -1.848596, +1.378810, -1.818052, +1.375900, -1.832597, +1.370665,
-1.818052, +1.366592, -1.783146, +1.364265, -1.759874, +1.364265, -1.745330, +1.356993,
-1.724968, +1.359901, -1.695879, +1.360774, -1.672608, +1.361356, -1.665336, +1.366592,
-1.672608, +1.370955, -1.710423, +1.377064, -1.713332, +1.369792, -1.720605, +1.362810,
-1.738058, +1.363683, -1.745330, +1.369792, -1.745330, +1.376773, -1.770056, +1.382300,
-1.797690, +1.382300, -1.819507, +1.385500, -1.844233, +1.385500, -1.855867, +1.382300, 
/* zone 29 with 7 points. */
-1.692970, +1.355538, -1.660973, +1.352048, -1.626066, +1.350012, -1.611522, +1.353793,
-1.614430, +1.357865, -1.658064, +1.358447, -1.692970, +1.355538, 
/* zone 30 with 6 points. */
-1.844233, +1.355538, -1.838414, +1.347102, -1.815144, +1.345357, -1.825325, +1.351466,
-1.828234, +1.356993, -1.844233, +1.355538, 
/* zone 31 with 17 points. */
-1.832597, +1.336631, -1.819507, +1.329358, -1.815144, +1.323541, -1.797690, +1.316269,
-1.771510, +1.320050, -1.755511, +1.310160, -1.716242, +1.310160, -1.707515, +1.319178,
-1.710423, +1.326449, -1.710423, +1.333140, -1.736604, +1.338085, -1.767147, +1.338667,
-1.778783, +1.333722, -1.780237, +1.326449, -1.797690, +1.332850, -1.815144, +1.337503,
-1.832597, +1.336631, 
/* zone 32 with 4 points. */
-1.828234, +1.311032, -1.807871, +1.311323, -1.819507, +1.317142, -1.828234, +1.311032, 
/* zone 33 with 20 points. */
-1.796236, +1.272635, -1.786055, +1.267691, -1.780237, +1.261000, -1.761330, +1.261000,
-1.743876, +1.253728, -1.727877, +1.245001, -1.707515, +1.250819, -1.682790, +1.253728,
-1.679880, +1.263909, -1.687153, +1.273799, -1.711878, +1.276999, -1.694425, +1.285144,
-1.706060, +1.293870, -1.724968, +1.290089, -1.748240, +1.291543, -1.767147, +1.288634,
-1.770056, +1.282816, -1.754057, +1.274672, -1.780237, +1.275253, -1.796236, +1.272635, 
/* zone 34 with 8 points. */
-1.985312, +1.365720, -1.954769, +1.366592, -1.937316, +1.364265, -1.912591, +1.364847,
-1.900955, +1.368047, -1.932953, +1.371537, -1.972223, +1.370083, -1.985312, +1.365720, 
/* zone 35 with 5 points. */
-2.015857, +1.359901, -2.004221, +1.356120, -1.991131, +1.356993, -1.994040, +1.362810,
-2.015857, +1.359901, 
/* zone 36 with 8 points. */
-1.982404, +1.356993, -1.976586, +1.351175, -1.950406, +1.349721, -1.922772, +1.354084,
-1.919863, +1.361938, -1.938770, +1.361647, -1.959133, +1.359029, -1.982404, +1.356993, 
/* zone 37 with 6 points. */
-2.085670, +1.319178, -2.068216, +1.317432, -2.060944, +1.322086, -2.055126, +1.328776,
-2.075488, +1.324704, -2.085670, +1.319178, 
/* zone 38 with 17 points. */
-2.167117, +1.330812, -2.148210, +1.324122, -2.127849, +1.324995, -2.104577, +1.323541,
-2.085670, +1.329358, -2.075488, +1.335176, -2.050763, +1.331685, -2.027492, +1.338958,
-2.034764, +1.345357, -2.015857, +1.349721, -2.037673, +1.354084, -2.053672, +1.349139,
-2.082761, +1.349721, -2.103123, +1.346520, -2.123485, +1.341866, -2.142392, +1.335176,
-2.167117, +1.330812, 
/* zone 39 with 31 points. */
-2.055126, +1.313359, -2.030400, +1.311323, -2.011493, +1.308414, -1.994040, +1.313359,
-1.976586, +1.307542, -1.998403, +1.304051, -1.989676, +1.300270, -1.967859, +1.298816,
-1.948952, +1.300852, -1.931499, +1.305506, -1.911137, +1.308996, -1.874775, +1.308124,
-1.852959, +1.309578, -1.850050, +1.317142, -1.844233, +1.324122, -1.867503, +1.326740,
-1.895138, +1.332267, -1.905318, +1.340412, -1.919863, +1.336631, -1.932953, +1.330812,
-1.916954, +1.328195, -1.921317, +1.323541, -1.909682, +1.317723, -1.944589, +1.318887,
-1.954770, +1.324995, -1.967859, +1.329358, -1.995494, +1.333722, -2.020220, +1.334595,
-2.031856, +1.328776, -2.044945, +1.320632, -2.055126, +1.313359, 
/* zone 40 with 34 points. */
-1.607159, +0.814487, -1.598432, +0.814487, -1.586796, +0.818850, -1.579524, +0.811578,
-1.566432, +0.815941, -1.553342, +0.820305, -1.540253, +0.827576, -1.531526, +0.827577,
-1.543161, +0.821759, -1.543161, +0.815941, -1.531526, +0.817395, -1.524254, +0.810124,
-1.512618, +0.810123, -1.498074, +0.814487, -1.483529, +0.815941, -1.483529, +0.811578,
-1.474803, +0.811578, -1.479166, +0.818850, -1.477712, +0.826122, -1.483529, +0.830485,
-1.483529, +0.836303, -1.496619, +0.836303, -1.503891, +0.842121, -1.509709, +0.850847,
-1.524254, +0.850847, -1.537343, +0.855211, -1.543161, +0.849393, -1.554796, +0.845030,
-1.560615, +0.839212, -1.567886, +0.834849, -1.579524, +0.831940, -1.588251, +0.826122,
-1.598432, +0.820305, -1.607159, +0.814487, 
/* zone 41 with 55 points. */
-1.535889, +0.778126, -1.522799, +0.783944, -1.527163, +0.776672, -1.528617, +0.770854,
-1.531526, +0.760673, -1.534434, +0.753401, -1.532980, +0.746128, -1.532980, +0.735947,
-1.527163, +0.727221, -1.519890, +0.727220, -1.512618, +0.730129, -1.508255, +0.735947,
-1.505345, +0.746128, -1.506800, +0.754855, -1.509709, +0.762127, -1.509709, +0.769399,
-1.505345, +0.776672, -1.502437, +0.783944, -1.489347, +0.788307, -1.483529, +0.797033,
-1.474803, +0.797033, -1.467530, +0.794124, -1.458803, +0.791216, -1.454440, +0.785398,
-1.454440, +0.775217, -1.463167, +0.766490, -1.463167, +0.760673, -1.455894, +0.766490,
-1.447168, +0.769399, -1.442805, +0.760673, -1.438441, +0.751946, -1.426805, +0.756309,
-1.426806, +0.766490, -1.422442, +0.775217, -1.419534, +0.782489, -1.422442, +0.788307,
-1.412262, +0.781035, -1.397717, +0.776672, -1.391899, +0.782489, -1.400626, +0.792670,
-1.409352, +0.801397, -1.425351, +0.804306, -1.436987, +0.805760, -1.448623, +0.805760,
-1.460258, +0.807214, -1.468985, +0.807214, -1.466076, +0.801397, -1.480620, +0.801397,
-1.487892, +0.802851, -1.496619, +0.801397, -1.514072, +0.798488, -1.518435, +0.798488,
-1.524254, +0.792670, -1.530071, +0.785398, -1.535889, +0.778126, 
/* zone 42 with 6 points. */
-1.450077, +0.799942, -1.438441, +0.797033, -1.429715, +0.794124, -1.426805, +0.801397,
-1.436987, +0.799942, -1.450077, +0.799942, 
/* zone 43 with 18 points. */
-1.457349, +0.728675, -1.445714, +0.724312, -1.435533, +0.724312, -1.425352, +0.725766,
-1.415171, +0.730129, -1.404989, +0.733038, -1.393353, +0.737402, -1.383173, +0.741765,
-1.375900, +0.747583, -1.387536, +0.747583, -1.399172, +0.747583, -1.404989, +0.743219,
-1.412262, +0.744674, -1.422442, +0.743219, -1.428261, +0.737402, -1.439896, +0.733038,
-1.450077, +0.733038, -1.457349, +0.728675, 
/* zone 44 with 16 points. */
-1.391899, +0.754855, -1.383173, +0.753401, -1.371537, +0.756309, -1.361356, +0.756309,
-1.351175, +0.754855, -1.340994, +0.756309, -1.329358, +0.759218, -1.330812, +0.767945,
-1.327904, +0.773763, -1.338085, +0.770854, -1.343903, +0.766490, -1.355538, +0.767945,
-1.364265, +0.766490, -1.375900, +0.765036, -1.386082, +0.762127, -1.391899, +0.754855, 
/* zone 45 with 9 points. */
-1.291543, +0.708313, -1.279907, +0.709767, -1.268272, +0.711222, -1.256637, +0.715585,
-1.262454, +0.718494, -1.271181, +0.715585, -1.279907, +0.714131, -1.290089, +0.712676,
-1.291543, +0.708313, 
/* zone 46 with 11 points. */
-1.124282, +0.869755, -1.112646, +0.865392, -1.108283, +0.861029, -1.098103, +0.858120,
-1.086467, +0.856666, -1.076285, +0.856665, -1.082104, +0.862483, -1.090830, +0.865392,
-1.101011, +0.868301, -1.112646, +0.869755, -1.124282, +0.869755, 
/* zone 47 with 11 points. */
-1.121373, +0.814487, -1.115556, +0.810124, -1.105374, +0.805760, -1.090830, +0.801397,
-1.090830, +0.807214, -1.082104, +0.811578, -1.095194, +0.810123, -1.105374, +0.810123,
-1.115556, +0.813032, -1.117010, +0.818850, -1.121373, +0.814487, 
/* zone 48 with 7 points. */
-1.460258, +1.085012, -1.445714, +1.086467, -1.429715, +1.093740, -1.429715, +1.095194,
-1.441350, +1.095194, -1.454440, +1.092284, -1.460258, +1.085012, 
/* zone 49 with 6 points. */
-1.397717, +1.087921, -1.399172, +1.077741, -1.391899, +1.073377, -1.384627, +1.080649,
-1.383173, +1.087921, -1.397717, +1.087921, 
/* zone 50 with 9 points. */
-1.396263, +0.981748, -1.386082, +0.983202, -1.397717, +0.975930, -1.387536, +0.975930,
-1.381719, +0.980293, -1.381719, +0.973021, -1.377355, +0.983202, -1.381719, +0.987565,
-1.396263, +0.981748, 
/* zone 51 with 6 points. */
-1.431170, +0.925024, -1.420988, +0.922116, -1.409352, +0.919207, -1.413716, +0.926479,
-1.420988, +0.927933, -1.431170, +0.925024, 
/* zone 52 with 21 points. */
-1.521344, +1.111193, -1.498074, +1.111193, -1.496619, +1.102466, -1.480620, +1.103920,
-1.468985, +1.111193, -1.458803, +1.117010, -1.445714, +1.117010, -1.431170, +1.112647,
-1.416625, +1.106829, -1.400626, +1.114101, -1.418079, +1.118464, -1.426805, +1.125736,
-1.439896, +1.131555, -1.460258, +1.137372, -1.477712, +1.144645, -1.483529, +1.153371,
-1.500982, +1.146099, -1.505345, +1.138826, -1.508255, +1.128646, -1.503891, +1.118464,
-1.521344, +1.111193, 
/* zone 53 with 8 points. */
-1.348267, +1.181005, -1.340994, +1.172279, -1.320632, +1.173734, -1.308996, +1.178097,
-1.306087, +1.185369, -1.314814, +1.191187, -1.335176, +1.191187, -1.348267, +1.181005, 
/* zone 54 with 113 points. */
-1.570796, +1.252274, -1.553342, +1.245001, -1.540253, +1.236275, -1.524254, +1.229002,
-1.496619, +1.223185, -1.471893, +1.223185, -1.436987, +1.220276, -1.419534, +1.221730,
-1.393353, +1.214458, -1.378809, +1.217366, -1.362810, +1.226093, -1.352630, +1.218821,
-1.323541, +1.210094, -1.329358, +1.198459, -1.308996, +1.204277, -1.295906, +1.195550,
-1.274090, +1.189732, -1.268272, +1.181005, -1.262454, +1.173734, -1.274090, +1.167915,
-1.287180, +1.160644, -1.301724, +1.154825, -1.285726, +1.146099, -1.303179, +1.140281,
-1.326449, +1.140281, -1.352630, +1.143190, -1.355538, +1.137372, -1.365720, +1.135918,
-1.371537, +1.128646, -1.361356, +1.121373, -1.335176, +1.121373, -1.322086, +1.125736,
-1.303179, +1.124282, -1.285726, +1.119919, -1.269727, +1.117010, -1.255182, +1.112647,
-1.255182, +1.105374, -1.240638, +1.099557, -1.227548, +1.096648, -1.210094, +1.093739,
-1.204277, +1.089375, -1.188277, +1.085012, -1.172278, +1.082104, -1.154825, +1.080649,
-1.154825, +1.087921, -1.167915, +1.093739, -1.182460, +1.101011, -1.195550, +1.106829,
-1.202822, +1.114101, -1.182460, +1.109737, -1.166461, +1.103920, -1.147553, +1.098103,
-1.125736, +1.098103, -1.121373, +1.109737, -1.134463, +1.117010, -1.135918, +1.125736,
-1.147553, +1.131555, -1.166461, +1.138827, -1.176642, +1.147553, -1.172278, +1.159189,
-1.143190, +1.150462, -1.134463, +1.140281, -1.114101, +1.134463, -1.108283, +1.143190,
-1.087921, +1.146099, -1.083558, +1.153371, -1.071922, +1.163552, -1.085012, +1.169370,
-1.102466, +1.175188, -1.121373, +1.181005, -1.137372, +1.188277, -1.165007, +1.188277,
-1.188277, +1.195550, -1.188277, +1.204277, -1.165007, +1.207186, -1.185369, +1.214458,
-1.178097, +1.221730, -1.192641, +1.230456, -1.217366, +1.236274, -1.243546, +1.246455,
-1.263908, +1.250818, -1.291543, +1.252274, -1.291543, +1.261000, -1.297360, +1.266818,
-1.322086, +1.265363, -1.340994, +1.268854, -1.358447, +1.270599, -1.378809, +1.264782,
-1.399172, +1.264781, -1.416625, +1.259545, -1.410807, +1.268272, -1.422442, +1.276417,
-1.416625, +1.284271, -1.425351, +1.288634, -1.447168, +1.287180, -1.471893, +1.281363,
-1.492256, +1.274090, -1.493711, +1.265364, -1.495165, +1.258091, -1.489347, +1.250818,
-1.506800, +1.256637, -1.508255, +1.263909, -1.509709, +1.271181, -1.502437, +1.278453,
-1.492256, +1.283399, -1.466076, +1.288053, -1.490802, +1.288634, -1.518435, +1.288634,
-1.535889, +1.284271, -1.554796, +1.276999, -1.563523, +1.269727, -1.570796, +1.262454,
-1.570796, +1.252274, 
/* zone 55 with 11 points. */
-1.404989, +1.287180, -1.410807, +1.281363, -1.404989, +1.273799, -1.381719, +1.271181,
-1.364265, +1.273799, -1.336631, +1.271763, -1.333722, +1.276999, -1.339540, +1.284271,
-1.358447, +1.287762, -1.383173, +1.288634, -1.404989, +1.287180, 
/* zone 56 with 7 points. */
-1.685699, +1.308996, -1.663881, +1.305797, -1.636248, +1.303179, -1.636248, +1.312487,
-1.649337, +1.318596, -1.669700, +1.318596, -1.685699, +1.308996, 
/* zone 57 with 29 points. */
-1.678426, +1.344484, -1.679880, +1.338085, -1.659518, +1.330812, -1.627521, +1.332267,
-1.608613, +1.327904, -1.602795, +1.320632, -1.608613, +1.313359, -1.605704, +1.304633,
-1.570796, +1.300852, -1.538798, +1.299688, -1.509709, +1.298816, -1.479166, +1.298816,
-1.460258, +1.304633, -1.434078, +1.300270, -1.403535, +1.303179, -1.393353, +1.310451,
-1.393353, +1.317142, -1.423897, +1.321505, -1.450077, +1.321505, -1.480620, +1.323250,
-1.514072, +1.319178, -1.548979, +1.321214, -1.573707, +1.326159, -1.564978, +1.329358,
-1.583887, +1.332850, -1.592614, +1.337794, -1.623158, +1.337794, -1.646428, +1.342448,
-1.678426, +1.344484, 
/* zone 58 with 21 points. */
-1.658064, +1.396263, -1.637702, +1.391317, -1.626066, +1.384627, -1.634792, +1.378518,
-1.628975, +1.370665, -1.605704, +1.364265, -1.557706, +1.364265, -1.537343, +1.370665,
-1.522799, +1.378810, -1.499528, +1.383173, -1.499528, +1.389863, -1.530071, +1.391899,
-1.521344, +1.399172, -1.535889, +1.403535, -1.575161, +1.404989, -1.594069, +1.410225,
-1.605704, +1.418079, -1.633338, +1.418079, -1.636248, +1.410225, -1.658064, +1.404117,
-1.658064, +1.396263, 
/* zone 59 with 56 points. */
-1.579524, +1.422442, -1.570796, +1.413716, -1.540253, +1.407898, -1.492256, +1.407898,
-1.457349, +1.410225, -1.407898, +1.410225, -1.355538, +1.412262, -1.388990, +1.407316,
-1.439896, +1.404408, -1.460258, +1.400626, -1.498074, +1.403535, -1.512618, +1.393936,
-1.486438, +1.391026, -1.486438, +1.383173, -1.476256, +1.376482, -1.500982, +1.374446,
-1.528617, +1.364265, -1.493711, +1.359901, -1.535889, +1.358447, -1.535889, +1.351175,
-1.518435, +1.348266, -1.538798, +1.346230, -1.562069, +1.340994, -1.562069, +1.333722,
-1.531526, +1.332267, -1.486438, +1.330812, -1.466076, +1.333722, -1.442805, +1.332267,
-1.423897, +1.335176, -1.413716, +1.329358, -1.378809, +1.333722, -1.356993, +1.340994,
-1.383173, +1.348266, -1.355538, +1.354084, -1.361356, +1.359901, -1.323541, +1.361356,
-1.308996, +1.370083, -1.308996, +1.378810, -1.291543, +1.387536, -1.247910, +1.391317,
-1.221729, +1.399754, -1.201367, +1.406444, -1.165007, +1.412844, -1.122828, +1.420988,
-1.121373, +1.425352, -1.090830, +1.430297, -1.067559, +1.434660, -1.067559, +1.438441,
-1.098103, +1.440768, -1.124282, +1.445132, -1.172278, +1.447168, -1.217366, +1.450077,
-1.265363, +1.450077, -1.300270, +1.448332, -1.340994, +1.449495, -1.409352, +1.447168, 
/* zone 60 with 5 points. */
-1.483529, +1.436987, -1.512618, +1.433496, -1.512618, +1.429715, -1.553342, +1.429715,
-1.579524, +1.422442, 
/* zone 61 with 51 points. */
-1.035562, +0.836303, -1.032653, +0.829031, -1.019563, +0.831940, -1.005018, +0.830485,
-0.991929, +0.830485, -0.978838, +0.830485, -0.967203, +0.829031, -0.967203, +0.823213,
-0.975930, +0.818850, -0.965748, +0.817395, -0.957022, +0.826122, -0.949750, +0.827577,
-0.941023, +0.826122, -0.945387, +0.817395, -0.936660, +0.821759, -0.936660, +0.814487,
-0.926479, +0.814487, -0.923570, +0.823213, -0.920661, +0.831940, -0.929388, +0.830485,
-0.925024, +0.839212, -0.930842, +0.837758, -0.936660, +0.830485, -0.941023, +0.833394,
-0.938114, +0.839212, -0.925024, +0.847939, -0.938114, +0.846484, -0.942477, +0.852302,
-0.933751, +0.859574, -0.942478, +0.862483, -0.954113, +0.862483, -0.965748, +0.861029,
-0.975930, +0.866847, -0.968657, +0.871210, -0.978838, +0.874119, -0.991929, +0.868301,
-0.986111, +0.877028, -0.980293, +0.882845, -0.973021, +0.891572, -0.968657, +0.900299,
-0.977384, +0.900299, -0.989020, +0.895935, -0.994837, +0.890118, -0.999201, +0.882845,
-1.006473, +0.874119, -1.010836, +0.863938, -1.019563, +0.855211, -1.025380, +0.847939,
-1.019563, +0.846484, -1.028289, +0.840667, -1.035562, +0.836303, 
/* zone 62 with 39 points. */
-1.530071, +0.234165, -1.524254, +0.226893, -1.530071, +0.226893, -1.524254, +0.219620,
-1.518435, +0.213803, -1.511164, +0.206531, -1.503891, +0.200713, -1.496619, +0.194895,
-1.496619, +0.187623, -1.498074, +0.180351, -1.495165, +0.173079, -1.489347, +0.171624,
-1.486438, +0.168715, -1.480620, +0.174533, -1.476257, +0.168715, -1.466076, +0.162897,
-1.460258, +0.157080, -1.461713, +0.148353, -1.452986, +0.146899, -1.448623, +0.142535,
-1.444260, +0.145444, -1.435533, +0.143990, -1.426805, +0.141081, -1.422442, +0.135263,
-1.413716, +0.135263, -1.412262, +0.125082, -1.404989, +0.126536, -1.396263, +0.130900,
-1.403535, +0.136717, -1.404989, +0.142535, -1.397717, +0.145444, -1.391899, +0.149807,
-1.387536, +0.157080, -1.381719, +0.157080, -1.374446, +0.152716, -1.370083, +0.145444,
-1.364265, +0.145444, -1.368629, +0.139626, -1.364265, +0.129445, 
/* zone 63 with 42 points. */
-1.352630, +0.151262, -1.358447, +0.157080, -1.365720, +0.162897, -1.372992, +0.164352,
-1.380263, +0.167261, -1.388990, +0.167261, -1.393353, +0.161443, -1.402081, +0.158534,
-1.410807, +0.155625, -1.420988, +0.152716, -1.426805, +0.157080, -1.434078, +0.157080,
-1.436987, +0.164352, -1.444260, +0.168715, -1.451531, +0.174533, -1.455894, +0.181805,
-1.460258, +0.189077, -1.463167, +0.196349, -1.460258, +0.203622, -1.460258, +0.212348,
-1.457349, +0.222530, -1.457349, +0.231256, -1.457349, +0.241437, -1.452986, +0.248709,
-1.452986, +0.261799, -1.455894, +0.264708, -1.463167, +0.267617, -1.470439, +0.274889,
-1.477712, +0.276344, -1.483529, +0.277798, -1.492256, +0.276344, -1.500982, +0.277798,
-1.509709, +0.274889, -1.518435, +0.273435, -1.528617, +0.276344, -1.538798, +0.271980,
-1.546070, +0.276344, -1.553342, +0.279253, -1.544616, +0.285070, -1.540253, +0.296706,
-1.540253, +0.305433, -1.538798, +0.319977, 
/* zone 64 with 13 points. */
-1.367174, +0.317068, -1.361356, +0.317068, -1.355538, +0.311250, -1.348266, +0.309796,
-1.342448, +0.312705, -1.336631, +0.311250, -1.330812, +0.311250, -1.333722, +0.317068,
-1.340994, +0.319977, -1.349721, +0.321431, -1.358447, +0.322886, -1.365720, +0.319977,
-1.367174, +0.317068, 
/* zone 65 with 4 points. */
-1.045451, +0.232129, -1.045451, +0.226893, -1.041961, +0.226893, -1.045451, +0.232129, 
/* zone 66 with 8 points. */
-1.449786, +0.379900, -1.447750, +0.376991, -1.449495, +0.374664, -1.445714, +0.374082,
-1.439896, +0.375827, -1.442513, +0.380773, -1.446296, +0.383682, -1.449786, +0.379900, 
/* zone 67 with 57 points. */
-1.480620, +0.381063, -1.468985, +0.381064, -1.466076, +0.386881, -1.455894, +0.386881,
-1.450077, +0.391245, -1.444260, +0.395608, -1.435533, +0.394154, -1.423897, +0.392699,
-1.432624, +0.389790, -1.426805, +0.385427, -1.418079, +0.383972, -1.404989, +0.383972,
-1.399172, +0.379609, -1.391899, +0.378155, -1.383173, +0.375246, -1.374446, +0.376700,
-1.371537, +0.373791, -1.370083, +0.366519, -1.361356, +0.360701, -1.348266, +0.360701,
-1.345357, +0.354883, -1.351175, +0.350520, -1.355538, +0.346157, -1.343903, +0.346157,
-1.335176, +0.347611, -1.326449, +0.347611, -1.317723, +0.346157, -1.308996, +0.346157,
-1.303179, +0.349066, -1.294452, +0.350520, -1.295906, +0.353429, -1.300270, +0.353429,
-1.306087, +0.359247, -1.314814, +0.360701, -1.320632, +0.359247, -1.319178, +0.366519,
-1.326449, +0.367974, -1.335176, +0.369428, -1.343903, +0.375246, -1.351175, +0.378155,
-1.358447, +0.382518, -1.367174, +0.386881, -1.375900, +0.389790, -1.384627, +0.389790,
-1.390445, +0.395608, -1.397717, +0.398517, -1.404989, +0.401426, -1.413716, +0.401426,
-1.422442, +0.404335, -1.431170, +0.404335, -1.439896, +0.401426, -1.448623, +0.399971,
-1.457349, +0.398517, -1.466076, +0.394154, -1.471893, +0.389790, -1.471893, +0.383972,
-1.480620, +0.381063, 
/* zone 68 with 38 points. */
-1.300270, +0.319977, -1.288634, +0.314159, -1.285726, +0.317068, -1.276999, +0.317068,
-1.269727, +0.315614, -1.262454, +0.317068, -1.253728, +0.315614, -1.246455, +0.306887,
-1.240638, +0.314159, -1.240638, +0.318523, -1.231911, +0.321431, -1.231911, +0.317068,
-1.223185, +0.318523, -1.213003, +0.321431, -1.204276, +0.321431, -1.198459, +0.315614,
-1.192641, +0.322886, -1.199913, +0.330158, -1.214458, +0.333067, -1.207186, +0.337430,
-1.217366, +0.337430, -1.220275, +0.343248, -1.230456, +0.344703, -1.239183, +0.346157,
-1.250818, +0.346157, -1.256637, +0.343248, -1.266817, +0.347611, -1.276999, +0.347611,
-1.282816, +0.343248, -1.274090, +0.343248, -1.269727, +0.337430, -1.269727, +0.331612,
-1.262454, +0.324340, -1.269727, +0.319977, -1.278453, +0.319977, -1.285726, +0.322886,
-1.294452, +0.324340, -1.300270, +0.319977, 
/* zone 69 with 9 points. */
-1.172278, +0.314159, -1.165007, +0.312705, -1.157734, +0.314159, -1.150462, +0.314159,
-1.146099, +0.318523, -1.151917, +0.322886, -1.162098, +0.322886, -1.172278, +0.322886,
-1.172278, +0.314159, 
/* zone 70 with 7 points. */
-1.079194, +0.283616, -1.077740, +0.277798, -1.074831, +0.282162, -1.070468, +0.282162,
-1.073377, +0.286525, -1.074831, +0.282162, -1.079194, +0.283616, 
/* zone 71 with 4 points. */
-1.067559, +0.258890, -1.061741, +0.252782, -1.062904, +0.255691, -1.067559, +0.258890, 
/* zone 72 with 10 points. */
-1.365720, +0.439241, -1.364265, +0.433423, -1.368629, +0.429060, -1.359901, +0.421788,
-1.355538, +0.413061, -1.352630, +0.418879, -1.356993, +0.424697, -1.356993, +0.430515,
-1.361356, +0.439241, -1.365720, +0.439241, 
/* zone 73 with 6 points. */
-1.285726, +0.365065, -1.276999, +0.365065, -1.274090, +0.372337, -1.276999, +0.367974,
-1.282816, +0.369428, -1.285726, +0.365065, 
/* zone 74 with 8 points. */
-1.378809, +0.466003, -1.373573, +0.462512, -1.365429, +0.465421, -1.360192, +0.465421,
-1.357865, +0.461931, -1.361356, +0.464258, -1.374446, +0.460767, -1.378809, +0.466003, 
/* zone 75 with 5 points. */
-1.353793, +0.468912, -1.345648, +0.461931, -1.349139, +0.453204, -1.348266, +0.461931,
-1.353793, +0.468912, 
/* zone 76 with 8 points. */
-1.595523, +0.001454, -1.596977, -0.007272, -1.591160, -0.011636, -1.596977, -0.015999,
-1.591160, -0.018908, -1.585341, -0.013090, -1.589705, -0.005818, -1.595523, +0.001454, 
/* zone 77 with 483 points. */
-1.364265, +0.129445, -1.356993, +0.122173, -1.351175, +0.114901, -1.352630, +0.107629,
-1.351175, +0.095993, -1.351175, +0.087266, -1.349720, +0.078540, -1.352630, +0.069813,
-1.346811, +0.063995, -1.352630, +0.056723, -1.356993, +0.046542, -1.367174, +0.046542,
-1.372992, +0.037816, -1.371537, +0.030543, -1.378809, +0.029089, -1.375900, +0.021817,
-1.384627, +0.017453, -1.396263, +0.011636, -1.397717, +0.000000, -1.404989, -0.005818,
-1.404989, -0.014544, -1.412262, -0.017453, -1.409352, -0.029089, -1.409352, -0.037816,
-1.412262, -0.040724, -1.406444, -0.043633, -1.399172, -0.052360, -1.397717, -0.043633,
-1.390445, -0.043633, -1.393353, -0.049451, -1.396263, -0.058178, -1.402081, -0.061087,
-1.410807, -0.066904, -1.419534, -0.074176, -1.419534, -0.081449, -1.416625, -0.090175,
-1.410807, -0.098902, -1.416625, -0.104720, -1.410807, -0.109083, -1.402081, -0.113446,
-1.396263, -0.119264, -1.390445, -0.126536, -1.387536, -0.136717, -1.378809, -0.142535,
-1.372992, -0.151262, -1.370083, -0.159988, -1.367174, -0.168715, -1.364265, -0.177442,
-1.355538, -0.189077, -1.352630, -0.197804, -1.346811, -0.206531, -1.343903, -0.212348,
-1.338085, -0.218166, -1.335176, -0.226893, -1.329358, -0.238528, -1.330812, -0.247255,
-1.323541, -0.255982, -1.317723, -0.261799, -1.311905, -0.267617, -1.300270, -0.274889,
-1.291543, -0.276344, -1.282816, -0.283616, -1.271181, -0.289434, -1.265363, -0.290888,
-1.256637, -0.296706, -1.247910, -0.301069, -1.242092, -0.308342, -1.236274, -0.311250,
-1.227548, -0.318523, -1.227548, -0.327249, -1.226093, -0.337430, -1.223185, -0.349066,
-1.224639, -0.357792, -1.224639, -0.366519, -1.223185, -0.375246, -1.224639, -0.383972,
-1.226093, -0.392699, -1.230456, -0.401426, -1.230456, -0.410152, -1.230456, -0.418879,
-1.231911, -0.427606, -1.230456, -0.436332, -1.230456, -0.443605, -1.234819, -0.449422,
-1.231911, -0.459603, -1.237729, -0.471239, -1.237729, -0.479966, -1.242092, -0.488692,
-1.243546, -0.497419, -1.247910, -0.506145, -1.245001, -0.511963, -1.243546, -0.523599,
-1.249364, -0.527962, -1.250818, -0.536689, -1.249364, -0.546870, -1.247910, -0.555596,
-1.247910, -0.561414, -1.245001, -0.567232, -1.250818, -0.578868, -1.249364, -0.587594,
-1.253728, -0.593412, -1.255182, -0.602139, -1.259545, -0.610865, -1.265363, -0.619592,
-1.268272, -0.628318, -1.271181, -0.637045, -1.275544, -0.639954, -1.275544, -0.648681,
-1.282816, -0.648681, -1.285726, -0.658862, -1.281362, -0.666134, -1.281362, -0.673406,
-1.279907, -0.680678, -1.278453, -0.689405, -1.285726, -0.698132, -1.285726, -0.708313,
-1.288634, -0.715585, -1.287180, -0.722857, -1.284270, -0.728675, -1.276999, -0.730129,
-1.274090, -0.724312, -1.265363, -0.727221, -1.269727, -0.733038, -1.265363, -0.735947,
-1.269727, -0.738856, -1.269727, -0.750492, -1.274090, -0.757764, -1.271181, -0.763582,
-1.276999, -0.770854, -1.274090, -0.775217, -1.281363, -0.779580, -1.279907, -0.785398,
-1.284270, -0.794124, -1.285726, -0.788307, -1.288634, -0.785398, -1.284270, -0.779580,
-1.285726, -0.775217, -1.282816, -0.770854, -1.288634, -0.765036, -1.295906, -0.770854,
-1.300270, -0.778126, -1.297360, -0.785398, -1.300270, -0.789761, -1.303179, -0.795579,
-1.300270, -0.799942, -1.308996, -0.801397, -1.304633, -0.805760, -1.317723, -0.813032,
-1.317723, -0.818850, -1.308996, -0.814487, -1.300270, -0.817395, -1.291543, -0.817395,
-1.298816, -0.827577, -1.300270, -0.834849, -1.300270, -0.843575, -1.307542, -0.833394,
-1.314814, -0.834849, -1.316269, -0.840667, -1.316269, -0.847939, -1.319178, -0.858120,
-1.316269, -0.862483, -1.317723, -0.869755, -1.308996, -0.871210, -1.314814, -0.875573,
-1.314814, -0.885754, -1.300270, -0.872664, -1.303179, -0.879936, -1.300270, -0.885755,
-1.306087, -0.884300, -1.308996, -0.893027, -1.314814, -0.900299, -1.300270, -0.895935,
-1.297360, -0.890118, -1.294452, -0.898844, -1.297360, -0.904662, -1.308996, -0.903208,
-1.308996, -0.911934, -1.300270, -0.914843, -1.294452, -0.910480, -1.291543, -0.917752,
-1.282816, -0.919207, -1.282816, -0.923570, -1.276999, -0.927933, -1.265363, -0.932297,
-1.256637, -0.927933, -1.247910, -0.920661, -1.240638, -0.922115, -1.245001, -0.927933,
-1.261000, -0.932297, -1.256637, -0.936660, -1.243546, -0.939569, -1.237729, -0.938114,
-1.237729, -0.929388, -1.234819, -0.920661, -1.221730, -0.916298, -1.214458, -0.916298,
-1.213003, -0.911934, -1.204277, -0.911934, -1.192641, -0.913389, -1.201367, -0.904662,
-1.204277, -0.897390, -1.207186, -0.890118, -1.204276, -0.881391, -1.195550, -0.875573,
-1.183914, -0.872664, -1.181005, -0.863938, -1.178097, -0.855211, -1.169370, -0.849393,
-1.157734, -0.843575, -1.149008, -0.837758, -1.146099, -0.829031, -1.147553, -0.823213,
-1.160644, -0.823213, -1.169370, -0.817395, -1.176642, -0.811578, -1.178097, -0.802851,
-1.172278, -0.794124, -1.166461, -0.789761, -1.154825, -0.785398, -1.144645, -0.785398,
-1.144645, -0.779580, -1.137372, -0.776672, -1.137372, -0.767945, -1.138826, -0.762127,
-1.134463, -0.756309, -1.122828, -0.750492, -1.134463, -0.747583, -1.125736, -0.741765,
-1.119919, -0.747583, -1.111192, -0.747583, -1.109737, -0.743219, -1.112646, -0.734493,
-1.125736, -0.738856, -1.134463, -0.734493, -1.134463, -0.724312, -1.137372, -0.715585,
-1.131555, -0.711222, -1.122828, -0.715585, -1.114101, -0.718494, -1.099557, -0.718494,
-1.087921, -0.714131, -1.086467, -0.708313, -1.089375, -0.703950, -1.085012, -0.695223,
-1.082104, -0.689405, -1.087921, -0.683587, -1.086467, -0.676315, -1.082104, -0.680678,
-1.069014, -0.680678, -1.055923, -0.679224, -1.047197, -0.677769, -1.035562, -0.676315,
-1.023926, -0.673406, -1.015200, -0.670497, -1.005018, -0.666134, -1.002110, -0.658862,
-0.994837, -0.651590, -0.989020, -0.642863, -0.990474, -0.634136, -0.997746, -0.632682,
-1.002110, -0.625410, -0.997746, -0.616683, -1.003564, -0.610865, -1.018108, -0.605048,
-1.021017, -0.599230, -1.018108, -0.593412, -1.009381, -0.600684, -0.997746, -0.600684,
-0.991929, -0.605048, -0.981747, -0.607956, -0.971566, -0.606502, -0.959931, -0.607956,
-0.951204, -0.606502, -0.942478, -0.602139, -0.935205, -0.596321, -0.933751, -0.590503,
-0.925024, -0.584685, -0.917752, -0.575959, -0.914843, -0.567232, -0.907571, -0.561414,
-0.898844, -0.555596, -0.890118, -0.549779, -0.884300, -0.541052, -0.878482, -0.532325,
-0.875573, -0.523599, -0.869755, -0.514872, -0.862483, -0.506145, -0.855211, -0.500328,
-0.850847, -0.497419, -0.847939, -0.488692, -0.846484, -0.479966, -0.847939, -0.471239,
-0.847939, -0.459603, -0.847939, -0.450877, -0.840667, -0.443605, -0.833394, -0.436332,
-0.824668, -0.429060, -0.817395, -0.421788, -0.808669, -0.418879, -0.798488, -0.413061,
-0.792670, -0.415970, -0.785398, -0.407243, -0.776672, -0.407243, -0.779580, -0.401426,
-0.767945, -0.399971, -0.759218, -0.401426, -0.750492, -0.401426, -0.741765, -0.399971,
-0.733038, -0.399971, -0.733038, -0.392699, -0.724312, -0.388336, -0.715585, -0.383972,
-0.715585, -0.375246, -0.712676, -0.366519, -0.703949, -0.357792, -0.701041, -0.349066,
-0.692314, -0.340339, -0.690859, -0.331612, -0.690859, -0.322886, -0.689405, -0.314159,
-0.683587, -0.308342, -0.683587, -0.299615, -0.682133, -0.289434, -0.679224, -0.279253,
-0.680678, -0.270526, -0.680678, -0.261799, -0.682133, -0.253073, -0.680678, -0.244346,
-0.679224, -0.232710, -0.670497, -0.226893, -0.663225, -0.219620, -0.655953, -0.209440,
-0.651590, -0.200713, -0.645772, -0.191986, -0.641408, -0.187623, -0.632682, -0.181805,
-0.628318, -0.174533, -0.621046, -0.167261, -0.616683, -0.159988, -0.612320, -0.151262,
-0.607956, -0.142535, -0.606502, -0.130900, -0.607956, -0.122173, -0.610865, -0.111992,
-0.613774, -0.101811, -0.618137, -0.091630, -0.628318, -0.088721, -0.637045, -0.090175,
-0.645772, -0.088721, -0.651590, -0.082903, -0.660316, -0.078540, -0.666134, -0.072722,
-0.671952, -0.066904, -0.680678, -0.061087, -0.689405, -0.055269, -0.698132, -0.049451,
-0.706858, -0.049451, -0.715585, -0.052360, -0.724312, -0.052360, -0.733038, -0.047997,
-0.741765, -0.047997, -0.750492, -0.043633, -0.759218, -0.042179, -0.767945, -0.046542,
-0.778126, -0.049451, -0.775217, -0.040724, -0.779580, -0.033452, -0.782489, -0.026180,
-0.791216, -0.029089, -0.794124, -0.023271, -0.805760, -0.020362, -0.814487, -0.017453,
-0.824668, -0.011636, -0.834849, -0.011636, -0.840667, -0.014544, -0.846484, -0.027634,
-0.850847, -0.024726, -0.847939, -0.017453, -0.845030, -0.005818, -0.855211, -0.002909,
-0.863938, -0.004363, -0.872664, -0.002909, -0.879936, -0.007272, -0.879936, -0.017453,
-0.882845, -0.029089, -0.887209, -0.017453, -0.897390, -0.021817, -0.895935, -0.011636,
-0.893027, -0.002909, -0.885754, +0.002909, -0.879936, +0.008727, -0.872664, +0.017453,
-0.871210, +0.030543, -0.881391, +0.031998, -0.884300, +0.043633, -0.890118, +0.055269,
-0.890118, +0.065450, -0.898844, +0.074176, -0.904662, +0.078540, -0.913389, +0.084357,
-0.920661, +0.090175, -0.929388, +0.094539, -0.936660, +0.097447, -0.942478, +0.098902,
-0.951204, +0.101811, -0.959931, +0.103265, -0.968657, +0.103265, -0.977384, +0.101811,
-0.986111, +0.101811, -0.996292, +0.103265, -1.000654, +0.109083, -1.006473, +0.113446,
-1.015200, +0.119264, -1.022471, +0.117810, -1.021017, +0.125082, -1.023926, +0.132354,
-1.032653, +0.138172, -1.041379, +0.143990, -1.051560, +0.149807, -1.064651, +0.146899,
-1.061741, +0.157080, -1.064651, +0.165806, -1.074831, +0.168715, -1.082104, +0.171624,
-1.087921, +0.170170, -1.093739, +0.177442, -1.099557, +0.183260, -1.085012, +0.186169,
-1.095194, +0.186169, -1.106829, +0.186169, -1.117010, +0.186169, -1.125736, +0.178896,
-1.134463, +0.175987, -1.144645, +0.177442, -1.151917, +0.180351, -1.154825, +0.184714,
-1.162098, +0.184714, -1.169370, +0.183260, -1.179551, +0.183260, -1.189732, +0.181805,
-1.192641, +0.187623, -1.194096, +0.194895, -1.201367, +0.199258, -1.210094, +0.200713,
-1.217366, +0.200713, -1.220275, +0.212348, -1.227548, +0.207985, -1.224639, +0.200713,
-1.231911, +0.196349, -1.239183, +0.193441, -1.246455, +0.190532, -1.246455, +0.180351,
-1.240638, +0.170170, -1.240638, +0.159988, -1.250818, +0.157080, -1.252274, +0.164352,
-1.256637, +0.170170, -1.252274, +0.178896, -1.247910, +0.184714, -1.250818, +0.191986,
-1.255182, +0.200713, -1.246455, +0.203622, -1.242092, +0.210894, -1.245001, +0.215257,
-1.250818, +0.216712, -1.256637, +0.212348, -1.261000, +0.206531, -1.268272, +0.203622,
-1.274090, +0.199258, -1.282816, +0.194895, -1.294452, +0.196349, -1.298816, +0.190532,
-1.306087, +0.191986, -1.313359, +0.189077, -1.317723, +0.183260, -1.319178, +0.174533,
-1.319178, +0.165806, -1.326449, +0.164352, -1.330812, +0.157080, -1.339540, +0.149807,
-1.339540, +0.136717, -1.346812, +0.145444, -1.352630, +0.151262, 
/* zone 78 with 10 points. */
-1.291543, -0.730129, -1.294452, -0.738856, -1.294452, -0.744674, -1.297360, -0.756309,
-1.287180, -0.757764, -1.282816, -0.750492, -1.285726, -0.744674, -1.279907, -0.738856,
-1.281363, -0.733038, -1.291543, -0.730129, 
/* zone 79 with 51 points. */
-1.199913, -0.917752, -1.207186, -0.919207, -1.213003, -0.917752, -1.217366, -0.922115,
-1.226093, -0.922115, -1.229002, -0.930842, -1.224639, -0.933751, -1.211549, -0.930842,
-1.210094, -0.933751, -1.223185, -0.938114, -1.221730, -0.946841, -1.227548, -0.945387,
-1.230456, -0.936660, -1.239183, -0.945387, -1.245001, -0.942478, -1.258091, -0.939569,
-1.265363, -0.935205, -1.279907, -0.929388, -1.291543, -0.925024, -1.303179, -0.920661,
-1.300270, -0.925024, -1.291543, -0.929388, -1.282816, -0.930842, -1.288634, -0.935205,
-1.279907, -0.939569, -1.279907, -0.943932, -1.268272, -0.943932, -1.265363, -0.949750,
-1.256637, -0.949750, -1.256637, -0.954113, -1.242092, -0.959931, -1.230456, -0.962840,
-1.221729, -0.959931, -1.218821, -0.965749, -1.210094, -0.968657, -1.198459, -0.967203,
-1.186823, -0.971567, -1.189733, -0.964294, -1.175187, -0.964294, -1.160644, -0.959931,
-1.146099, -0.959931, -1.138826, -0.958477, -1.137372, -0.954113, -1.149008, -0.954113,
-1.157734, -0.951204, -1.165007, -0.946841, -1.176642, -0.942478, -1.186823, -0.936660,
-1.189732, -0.930842, -1.191187, -0.925024, -1.199913, -0.917752, 
/* zone 80 with 16 points. */
-1.067559, -0.904662, -1.055923, -0.911934, -1.047197, -0.907571, -1.041379, -0.909025,
-1.038470, -0.913389, -1.026834, -0.911934, -1.021017, -0.907571, -1.007927, -0.904662,
-1.007927, -0.898844, -1.018108, -0.895935, -1.029743, -0.898844, -1.041379, -0.895935,
-1.055923, -0.897390, -1.050106, -0.903208, -1.055923, -0.907571, -1.067559, -0.904662, 
/* zone 81 with 8 points. */
-0.663225, -0.942478, -0.650135, -0.946841, -0.638499, -0.951204, -0.628318, -0.958476,
-0.625409, -0.952659, -0.632682, -0.948295, -0.645772, -0.943932, -0.663225, -0.942478, 
/* zone 82 with 8 points. */
-1.079194, +0.174533, -1.069014, +0.174533, -1.064651, +0.178896, -1.064651, +0.187623,
-1.076285, +0.186169, -1.073377, +0.184714, -1.073377, +0.177442, -1.079194, +0.174533, 
/* zone 83 with 4 points. */
-1.206604, +0.215548, -1.200786, +0.210603, -1.202531, +0.212930, -1.206604, +0.215548, 
/* zone 84 with 186 points. */
-1.274090, +1.364265, -1.250818, +1.359029, -1.227548, +1.359901, -1.221730, +1.354084,
-1.194096, +1.350012, -1.221729, +1.348266, -1.242092, +1.344193, -1.226093, +1.340412,
-1.199913, +1.336922, -1.213003, +1.333139, -1.195550, +1.328776, -1.162098, +1.324995,
-1.140281, +1.328776, -1.106829, +1.329358, -1.076285, +1.329358, -1.047197, +1.323250,
-1.018108, +1.320632, -1.018108, +1.314523, -1.003564, +1.308414, -0.986111, +1.300270,
-0.986111, +1.291543, -0.971566, +1.284271, -0.968657, +1.276999, -0.974475, +1.266818,
-0.965748, +1.259545, -0.973021, +1.251109, -0.964294, +1.246455, -0.942477, +1.246455,
-0.930842, +1.252274, -0.920661, +1.242092, -0.900299, +1.239183, -0.894481, +1.230456,
-0.922115, +1.235693, -0.946841, +1.236275, -0.952658, +1.226093, -0.957022, +1.215912,
-0.936660, +1.209513, -0.910480, +1.212421, -0.894481, +1.220276, -0.885754, +1.210094,
-0.890118, +1.197004, -0.917752, +1.197004, -0.930842, +1.189733, -0.936660, +1.179551,
-0.938114, +1.169370, -0.933751, +1.160644, -0.933751, +1.151917, -0.914843, +1.143190,
-0.907571, +1.133009, -0.907571, +1.122828, -0.895935, +1.117010, -0.894481, +1.109737,
-0.878482, +1.096648, -0.874119, +1.090830, -0.863938, +1.080649, -0.855211, +1.071922,
-0.837758, +1.061741, -0.814487, +1.060287, -0.798488, +1.057378, -0.788307, +1.050106,
-0.766491, +1.044288, -0.754855, +1.047197, -0.747583, +1.055923, -0.746128, +1.064651,
-0.741765, +1.073377, -0.733038, +1.082104, -0.740310, +1.093740, -0.724312, +1.099557,
-0.711222, +1.108283, -0.706858, +1.117010, -0.705404, +1.125737, -0.715585, +1.137372,
-0.698132, +1.135918, -0.692314, +1.143190, -0.671952, +1.146099, -0.645772, +1.146099,
-0.622501, +1.151917, -0.606502, +1.157734, -0.591958, +1.163552, -0.583231, +1.170824,
-0.575959, +1.178097, -0.561414, +1.185369, -0.546870, +1.189732, -0.523599, +1.189733,
-0.501782, +1.194096, -0.479965, +1.197004, -0.458149, +1.201367, -0.440696, +1.205731,
-0.423242, +1.211549, -0.404335, +1.217366, -0.392699, +1.223185, -0.414516, +1.224639,
-0.437787, +1.229002, -0.459603, +1.224639, -0.459603, +1.229002, -0.440696, +1.233365,
-0.445059, +1.242092, -0.427606, +1.245001, -0.423242, +1.239183, -0.418879, +1.231911,
-0.402880, +1.229002, -0.381064, +1.230456, -0.379609, +1.239183, -0.379609, +1.246455,
-0.394153, +1.253728, -0.413061, +1.259545, -0.429060, +1.265363, -0.407243, +1.261872,
-0.383972, +1.258091, -0.379609, +1.263909, -0.383972, +1.272635, -0.401426, +1.274962,
-0.386881, +1.278453, -0.376700, +1.281363, -0.354883, +1.282235, -0.354883, +1.288634,
-0.375246, +1.291543, -0.335976, +1.295907, -0.328704, +1.303179, -0.350520, +1.303179,
-0.338885, +1.312487, -0.338885, +1.321214, -0.349066, +1.329940, -0.375246, +1.331685,
-0.373791, +1.338085, -0.354884, +1.342448, -0.321431, +1.339540, -0.317068, +1.345357,
-0.328703, +1.354084, -0.343248, +1.359901, -0.334521, +1.368629, -0.340339, +1.375900,
-0.322886, +1.381137, -0.315614, +1.388118, -0.299615, +1.395681, -0.276344, +1.403535,
-0.250164, +1.409352, -0.203622, +1.419243, -0.231256, +1.425642, -0.286525, +1.427679,
-0.317068, +1.422152, -0.340339, +1.423897, -0.362156, +1.419243, -0.392699, +1.415171,
-0.433423, +1.412262, -0.413061, +1.420115, -0.383973, +1.424769, -0.372337, +1.427679,
-0.378155, +1.432624, -0.413061, +1.431751, -0.413061, +1.426805, -0.442150, +1.425642,
-0.442150, +1.432333, -0.520690, +1.432333, -0.493055, +1.435533, -0.446513, +1.434951,
-0.386882, +1.436696, -0.349066, +1.441059, -0.378155, +1.446005, -0.418879, +1.448332,
-0.433424, +1.452986, -0.477057, +1.458222, -0.549779, +1.458803, -0.628318, +1.459968,
-0.689405, +1.455894, -0.767945, +1.452113, -0.811578, +1.445714, -0.826122, +1.438441,
-0.881391, +1.439314, -0.894481, +1.431170, -0.951204, +1.436987, -1.035562, +1.432624,
-1.082104, +1.426805, -1.069014, +1.420988, -1.079195, +1.416043, -1.112647, +1.416916,
-1.134463, +1.412262, -1.165007, +1.405571, -1.181005, +1.397717, -1.134463, +1.397717,
-1.125737, +1.391899, -1.146099, +1.382300, -1.198459, +1.379101, -1.227548, +1.374446,
-1.262454, +1.371537, -1.274090, +1.364265, 
/* zone 85 with 4 points. */
-0.328703, +1.315978, -0.328703, +1.308996, -0.312705, +1.309869, -0.328703, +1.315978, 
/* zone 86 with 37 points. */
-0.424697, +1.143190, -0.411607, +1.141736, -0.397063, +1.144645, -0.385427, +1.141736,
-0.398517, +1.135918, -0.418879, +1.130100, -0.394154, +1.130100, -0.383972, +1.121373,
-0.397062, +1.114101, -0.366519, +1.114101, -0.349066, +1.109737, -0.327249, +1.106829,
-0.308342, +1.112647, -0.292343, +1.114101, -0.276344, +1.119919, -0.253073, +1.124282,
-0.238528, +1.133009, -0.238528, +1.143190, -0.255982, +1.147553, -0.257436, +1.157734,
-0.273435, +1.156280, -0.283616, +1.160644, -0.293797, +1.154825, -0.306887, +1.151917,
-0.318523, +1.154825, -0.335976, +1.153371, -0.343248, +1.149008, -0.353429, +1.153371,
-0.354884, +1.144645, -0.373791, +1.141736, -0.375246, +1.151917, -0.388336, +1.157734,
-0.401426, +1.159189, -0.401426, +1.154825, -0.413061, +1.154825, -0.414516, +1.149008,
-0.424697, +1.143190, 
/* zone 87 with 5 points. */
-0.129445, +1.083558, -0.120719, +1.082104, -0.110537, +1.088503, -0.126536, +1.087339,
-0.129445, +1.083558, 
/* zone 88 with 6 points. */
-0.126536, +1.005018, -0.111992, +1.012290, -0.107629, +1.021017, -0.122173, +1.015200,
-0.122173, +1.009381, -0.126536, +1.005018, 
/* zone 89 with 89 points. */
-0.097447, +0.874119, -0.088721, +0.872664, -0.078540, +0.878482, -0.063995, +0.875573,
-0.061087, +0.882845, -0.049451, +0.884300, -0.036361, +0.881391, -0.024726, +0.885755,
-0.011636, +0.884300, +0.001454, +0.884300, +0.015999, +0.887209, +0.024726, +0.894481,
+0.010181, +0.895935, +0.017453, +0.903208, +0.027634, +0.907571, +0.031998, +0.914843,
+0.027634, +0.920661, +0.017453, +0.923570, +0.010181, +0.923570, +0.004363, +0.919207,
+0.000000, +0.922115, +0.005818, +0.926479, +0.002909, +0.932297, -0.001454, +0.936660,
-0.004363, +0.942478, -0.008727, +0.949750, -0.020362, +0.952659, -0.026180, +0.959931,
-0.029089, +0.968657, -0.034907, +0.974475, -0.046542, +0.977384, -0.058178, +0.977384,
-0.049451, +0.981748, -0.042179, +0.987565, -0.036361, +0.994837, -0.031998, +1.000655,
-0.033452, +1.006473, -0.047997, +1.006473, -0.059632, +1.006473, -0.072722, +1.005018,
-0.066904, +1.012290, -0.052360, +1.018108, -0.055269, +1.022471, -0.071267, +1.021017,
-0.087266, +1.021017, -0.093084, +1.013744, -0.100356, +1.007927, -0.101811, +1.002110,
-0.110537, +1.005018, -0.116355, +1.002110, -0.109083, +0.997747, -0.097447, +0.997746,
-0.104720, +0.989020, -0.104720, +0.983202, -0.094539, +0.986111, -0.095993, +0.978838,
-0.107629, +0.973021, -0.097447, +0.973021, -0.097447, +0.967203, -0.088721, +0.974475,
-0.081449, +0.968657, -0.088721, +0.958476, -0.082903, +0.952659, -0.069813, +0.955567,
-0.056723, +0.958476, -0.062541, +0.951204, -0.055269, +0.945387, -0.046542, +0.945387,
-0.052360, +0.938114, -0.052360, +0.930842, -0.062541, +0.929388, -0.078540, +0.930842,
-0.075631, +0.926479, -0.081449, +0.920661, -0.071267, +0.920661, -0.071267, +0.911934,
-0.079994, +0.909025, -0.090175, +0.904662, -0.087266, +0.900299, -0.075631, +0.901753,
-0.066904, +0.900299, -0.058178, +0.895935, -0.046542, +0.900299, -0.052360, +0.893027,
-0.061087, +0.893027, -0.071267, +0.893027, -0.078540, +0.885755, -0.087266, +0.879936,
-0.097447, +0.874119, 
/* zone 90 with 30 points. */
-0.180350, +0.910480, -0.175987, +0.903208, -0.167260, +0.898844, -0.152716, +0.900299,
-0.139626, +0.903208, -0.126536, +0.909025, -0.110537, +0.910480, -0.107629, +0.917752,
-0.104720, +0.925024, -0.106174, +0.933751, -0.109083, +0.941023, -0.097447, +0.946841,
-0.100356, +0.955567, -0.106174, +0.961385, -0.117810, +0.962840, -0.130900, +0.964294,
-0.143990, +0.961385, -0.151262, +0.954113, -0.142535, +0.951204, -0.148353, +0.946841,
-0.158534, +0.946841, -0.170170, +0.946841, -0.174533, +0.941023, -0.165806, +0.938114,
-0.174533, +0.933751, -0.165806, +0.927933, -0.157080, +0.927933, -0.165806, +0.919207,
-0.170170, +0.910480, -0.180350, +0.910480, 
/* zone 91 with 6 points. */
-0.293797, +0.494510, -0.289434, +0.488692, -0.285070, +0.491601, -0.282162, +0.498873,
-0.287979, +0.495382, -0.293797, +0.494510, 
/* zone 92 with 6 points. */
-0.275762, +0.488692, -0.273435, +0.484329, -0.267617, +0.485783, -0.268199, +0.490146,
-0.273435, +0.491601, -0.275762, +0.488692, 
/* zone 93 with 9 points. */
-0.248709, +0.490146, -0.241437, +0.493055, -0.241437, +0.503236, -0.235619, +0.504691,
-0.234165, +0.509054, -0.238528, +0.507600, -0.241437, +0.503236, -0.248709, +0.494510,
-0.248709, +0.490146, 
/* zone 94 with 57 points. */
-0.029089, +0.757764, -0.037816, +0.756309, -0.047997, +0.757764, -0.062541, +0.759218,
-0.077085, +0.756309, -0.088721, +0.759218, -0.101811, +0.760673, -0.114901, +0.759218,
-0.126536, +0.759218, -0.139626, +0.763582, -0.145444, +0.756309, -0.155625, +0.754855,
-0.159988, +0.750492, -0.152716, +0.740310, -0.154171, +0.733038, -0.152716, +0.727220,
-0.149807, +0.718494, -0.151262, +0.711222, -0.154171, +0.702495, -0.155625, +0.692314,
-0.161443, +0.686496, -0.162897, +0.677769, -0.158534, +0.671952, -0.151262, +0.671952,
-0.152716, +0.663225, -0.152716, +0.654499, -0.155625, +0.647226, -0.145444, +0.648681,
-0.136717, +0.647226, -0.129445, +0.650135, -0.122173, +0.650135, -0.113446, +0.645772,
-0.110537, +0.641408, -0.104720, +0.632682, -0.095993, +0.629773, -0.087266, +0.637045,
-0.078540, +0.639954, -0.068359, +0.641408, -0.058178, +0.641408, -0.047997, +0.641408,
-0.037816, +0.641408, -0.031998, +0.648681, -0.023271, +0.657408, -0.014544, +0.657408,
-0.011636, +0.664679, -0.005818, +0.670497, +0.004363, +0.676315, -0.004363, +0.682133,
-0.005818, +0.689405, +0.000000, +0.696677, +0.008727, +0.705404, +0.017453, +0.715585,
+0.026180, +0.718494, +0.036361, +0.721403, +0.046542, +0.727220, +0.055269, +0.731584,
+0.053814, +0.741765, 
/* zone 95 with 6 points. */
+0.039270, +0.690859, +0.047706, +0.689405, +0.053814, +0.685333, +0.059632, +0.692314,
+0.050905, +0.696677, +0.039270, +0.690859, 
/* zone 96 with 171 points. */
+0.203680, +0.575959, +0.193382, +0.580322, +0.190590, +0.587652, +0.183260, +0.586081,
+0.175929, +0.589049, +0.174533, +0.596379, +0.180293, +0.600742, +0.187623, +0.606502,
+0.191986, +0.613832, +0.190590, +0.620988, +0.184656, +0.623955, +0.181863, +0.634078,
+0.187623, +0.637045, +0.191986, +0.644376, +0.180293, +0.640012, +0.175929, +0.648739,
+0.167203, +0.650135, +0.158476, +0.648739, +0.151320, +0.644376, +0.142593, +0.642805,
+0.129503, +0.645772, +0.122173, +0.642805, +0.109083, +0.645772, +0.101753, +0.641409,
+0.093026, +0.640012, +0.087266, +0.642805, +0.077143, +0.644376, +0.066846, +0.644376,
+0.059690, +0.642805, +0.050964, +0.642805, +0.042237, +0.640012, +0.030543, +0.638441,
+0.017453, +0.637045, +0.008727, +0.632682, +0.000000, +0.626922, -0.008727, +0.625351,
-0.017453, +0.623955, -0.021817, +0.618196, -0.033510, +0.613832, -0.042237, +0.612261,
-0.052360, +0.616625, -0.059690, +0.615229, -0.071209, +0.615229, -0.078540, +0.613832,
-0.090234, +0.619592, -0.094597, +0.625351, -0.103323, +0.623955, -0.107687, +0.615229,
-0.110479, +0.607898, -0.114843, +0.600742, -0.119206, +0.593412, -0.129503, +0.587652,
-0.139626, +0.584685, -0.148353, +0.580322, -0.154113, +0.572991, -0.161443, +0.567232,
-0.161443, +0.561472, -0.165806, +0.554142, -0.171566, +0.549779, -0.171566, +0.535292,
-0.167203, +0.529358, -0.171566, +0.519235, -0.177500, +0.511905, -0.184656, +0.504749,
-0.194953, +0.500386, -0.200713, +0.493055, -0.212407, +0.488692, -0.225497, +0.487296,
-0.231256, +0.479966, -0.234223, +0.471239, -0.238587, +0.465479, -0.247313, +0.461116,
-0.251676, +0.456753, -0.254469, +0.448026, -0.257436, +0.440696, -0.261799, +0.430573,
-0.269130, +0.423242, -0.274889, +0.415912, -0.279253, +0.408756, -0.283616, +0.397062,
-0.287979, +0.389732, -0.293739, +0.385368, -0.295310, +0.376642, -0.296706, +0.367915,
-0.289375, +0.362156, -0.282220, +0.354825, -0.282220, +0.346099, -0.287979, +0.340339,
-0.282220, +0.331613, -0.279253, +0.322886, -0.279253, +0.314159, -0.280649, +0.305433,
-0.283616, +0.296706, -0.286583, +0.287979, -0.286583, +0.276286, -0.292343, +0.269130,
-0.296706, +0.261799, -0.304036, +0.257436, -0.296706, +0.253073, -0.292343, +0.244346,
-0.290946, +0.234223, -0.292343, +0.225497, -0.292343, +0.215199, -0.285012, +0.210836,
-0.277856, +0.206473, -0.270526, +0.208043, -0.269130, +0.196350, -0.261799, +0.193382,
-0.256040, +0.186227, -0.251676, +0.178896, -0.244346, +0.174533, -0.237016, +0.167203,
-0.231256, +0.160047, -0.229860, +0.151320, -0.228289, +0.143990, -0.225497, +0.136659,
-0.216770, +0.127933, -0.208043, +0.123569, -0.199317, +0.119206, -0.191986, +0.112050,
-0.180293, +0.106116, -0.171566, +0.097389, -0.164410, +0.091630, -0.155683, +0.085870,
-0.145386, +0.078540, -0.136659, +0.075573, -0.129503, +0.074176, -0.120777, +0.079936,
-0.110479, +0.081507, -0.103323, +0.087266, -0.093026, +0.088663, -0.082903, +0.090234,
-0.075573, +0.091630, -0.066846, +0.091630, -0.053756, +0.088663, -0.045029, +0.087266,
-0.034907, +0.082903, -0.027576, +0.087266, -0.018850, +0.090234, -0.011694, +0.091630,
-0.004363, +0.095993, +0.005760, +0.101753, +0.017453, +0.101753, +0.021817, +0.107687,
+0.031940, +0.110479, +0.040666, +0.112050, +0.049393, +0.112050, +0.059690, +0.113446,
+0.069813, +0.113446, +0.078540, +0.110479, +0.087266, +0.103323, +0.091630, +0.091630,
+0.094597, +0.079936, +0.104720, +0.074176, +0.113446, +0.074176, +0.122173, +0.075573,
+0.130900, +0.077143, +0.139626, +0.077143, +0.146957, +0.078540, +0.154113, +0.078540,
+0.155683, +0.069813, +0.162839, +0.068417, +0.167203, +0.061087, +0.173137, +0.053756,
+0.170170, +0.043633, +0.168773, +0.033510, +0.165806, +0.026180, +0.161443, +0.018850,
+0.167203, +0.016057, +0.162839, +0.008727, +0.162839, +0.000000, 
/* zone 97 with 15 points. */
+0.228289, +0.245742, +0.232652, +0.239983, +0.235619, +0.232652, +0.241379, +0.228289,
+0.242950, +0.222530, +0.247313, +0.218166, +0.254469, +0.222530, +0.263196, +0.225497,
+0.266163, +0.234223, +0.257436, +0.234223, +0.247313, +0.235619, +0.247313, +0.241379,
+0.242950, +0.247313, +0.234223, +0.248709, +0.228289, +0.245742, 
/* zone 98 with 5 points. */
+0.148353, +0.058119, +0.152716, +0.056723, +0.155683, +0.062483, +0.151320, +0.065450,
+0.148353, +0.058119, 
/* zone 99 with 91 points. */
+0.375246, +1.226093, +0.351975, +1.223185, +0.330158, +1.223185, +0.315614, +1.214458,
+0.296706, +1.211549, +0.296706, +1.205731, +0.306887, +1.204277, +0.290888, +1.198459,
+0.289434, +1.204277, +0.277798, +1.199913, +0.282162, +1.208640, +0.267617, +1.202822,
+0.251618, +1.198459, +0.261799, +1.194096, +0.238528, +1.191187, +0.225438, +1.183914,
+0.244346, +1.189733, +0.261799, +1.191187, +0.282162, +1.192641, +0.261799, +1.183914,
+0.255982, +1.176642, +0.241437, +1.169370, +0.232710, +1.162098, +0.226893, +1.154825,
+0.219620, +1.147553, +0.212348, +1.138827, +0.197804, +1.133009, +0.186168, +1.122828,
+0.175987, +1.115556, +0.165806, +1.108283, +0.155625, +1.112647, +0.148353, +1.105374,
+0.139626, +1.099557, +0.122173, +1.098103, +0.110537, +1.090830, +0.098902, +1.085012,
+0.085812, +1.079194, +0.091630, +1.073377, +0.084358, +1.067559, +0.087266, +1.060287,
+0.088721, +1.053015, +0.097447, +1.045743, +0.091630, +1.039925, +0.094539, +1.034107,
+0.107629, +1.035562, +0.098902, +1.029743, +0.097447, +1.022471, +0.104720, +1.018108,
+0.119264, +1.013744, +0.133809, +1.012290, +0.148353, +1.016654, +0.157080, +1.022471,
+0.170170, +1.029744, +0.178896, +1.029744, +0.184714, +1.035562, +0.193441, +1.031198,
+0.197804, +1.021017, +0.203622, +1.012290, +0.209440, +1.002110, +0.215257, +0.993383,
+0.225438, +0.986111, +0.221075, +0.980293, +0.226893, +0.973021, +0.226893, +0.967203,
+0.238528, +0.967203, +0.248709, +0.967203, +0.247255, +0.973021, +0.255982, +0.980293,
+0.267617, +0.980293, +0.277798, +0.980293, +0.285070, +0.990474, +0.287979, +1.000655,
+0.290888, +1.007927, +0.290888, +1.016653, +0.293797, +1.022471, +0.306887, +1.028289,
+0.319977, +1.032653, +0.314159, +1.035562, +0.324340, +1.039925, +0.328704, +1.044288,
+0.324340, +1.050106, +0.312705, +1.055923, +0.301069, +1.061741, +0.299615, +1.069014,
+0.302524, +1.077741, +0.303978, +1.086467, +0.309796, +1.090830, +0.321431, +1.099557,
+0.334522, +1.105374, +0.346157, +1.109737, +0.360701, +1.114101, 
/* zone 100 with 98 points. */
+0.349066, +0.958477, +0.344703, +0.951204, +0.335976, +0.948295, +0.325795, +0.948295,
+0.319977, +0.957022, +0.305432, +0.955568, +0.290888, +0.952659, +0.279253, +0.946841,
+0.264708, +0.945387, +0.250164, +0.941023, +0.241437, +0.942478, +0.231256, +0.945387,
+0.238528, +0.948295, +0.232710, +0.954113, +0.225438, +0.949750, +0.213803, +0.948295,
+0.206530, +0.945387, +0.197804, +0.941023, +0.187623, +0.941023, +0.190532, +0.946841,
+0.174533, +0.951204, +0.174533, +0.955568, +0.164352, +0.959931, +0.170170, +0.968657,
+0.177442, +0.977384, +0.189077, +0.980293, +0.189077, +0.986111, +0.178896, +0.986111,
+0.178896, +0.991929, +0.183259, +0.999201, +0.183260, +1.005018, +0.171624, +1.003564,
+0.164352, +0.997747, +0.151262, +0.996292, +0.143990, +0.991929, +0.141081, +0.986111,
+0.141081, +0.977384, +0.142535, +0.970112, +0.151262, +0.965749, +0.151262, +0.957022,
+0.157080, +0.951204, +0.151262, +0.948295, +0.157080, +0.943932, +0.149807, +0.939569,
+0.148353, +0.933751, +0.139626, +0.936660, +0.127991, +0.936660, +0.122173, +0.932297,
+0.106174, +0.932297, +0.095993, +0.929388, +0.095993, +0.922115, +0.103265, +0.920661,
+0.103265, +0.916298, +0.095993, +0.911934, +0.088721, +0.914843, +0.088721, +0.923570,
+0.082903, +0.922115, +0.079994, +0.914843, +0.075631, +0.909025, +0.069813, +0.903208,
+0.062541, +0.897390, +0.052360, +0.894481, +0.040724, +0.890118, +0.030543, +0.887209,
+0.027634, +0.881391, +0.026180, +0.874119, +0.018908, +0.871210, +0.010181, +0.869755,
+0.002909, +0.866847, +0.000000, +0.859574, -0.010181, +0.861029, -0.018908, +0.859574,
-0.023271, +0.866847, -0.033452, +0.866847, -0.027634, +0.858120, -0.024726, +0.847939,
-0.034907, +0.847939, -0.046542, +0.846484, -0.052360, +0.852302, -0.063995, +0.850847,
-0.072722, +0.847939, -0.082903, +0.846484, -0.081449, +0.837758, -0.074176, +0.834849,
-0.065450, +0.834849, -0.055269, +0.830485, -0.043633, +0.829031, -0.040724, +0.826122,
-0.033452, +0.820305, -0.034907, +0.815941, -0.030543, +0.811578, -0.021817, +0.807214,
-0.017453, +0.799942, -0.018908, +0.789761, -0.020362, +0.779580, -0.021817, +0.772308,
-0.024726, +0.762127, -0.029089, +0.757764, 
/* zone 101 with 94 points. */
+0.053814, +0.741765, +0.052360, +0.750492, +0.062541, +0.754855, +0.069813, +0.759218,
+0.079994, +0.756309, +0.091630, +0.754855, +0.101811, +0.750492, +0.111992, +0.751946,
+0.119264, +0.757764, +0.129445, +0.762127, +0.139626, +0.765036, +0.143990, +0.770854,
+0.151262, +0.773763, +0.159988, +0.772308, +0.165806, +0.769399, +0.175987, +0.767945,
+0.177442, +0.759218, +0.181805, +0.751946, +0.190532, +0.744674, +0.191986, +0.738856,
+0.200713, +0.738856, +0.209440, +0.731584, +0.216712, +0.724312, +0.225438, +0.719948,
+0.237074, +0.719948, +0.244346, +0.714131, +0.251618, +0.709767, +0.257436, +0.708313,
+0.261799, +0.701041, +0.273435, +0.698132, +0.274889, +0.692314, +0.279253, +0.685042,
+0.280707, +0.677769, +0.276344, +0.673406, +0.273435, +0.666134, +0.273435, +0.661771,
+0.279253, +0.661771, +0.282162, +0.666134, +0.287979, +0.670497, +0.287979, +0.677769,
+0.296706, +0.680678, +0.296706, +0.687951, +0.287979, +0.692314, +0.290888, +0.701041,
+0.295252, +0.706858, +0.302524, +0.703950, +0.311250, +0.702495, +0.312705, +0.696677,
+0.318523, +0.695223, +0.321431, +0.701041, +0.312705, +0.708313, +0.303978, +0.712676,
+0.295252, +0.717040, +0.285070, +0.721403, +0.276344, +0.724312, +0.280707, +0.730129,
+0.266163, +0.730129, +0.255982, +0.734493, +0.247255, +0.738856, +0.242892, +0.743219,
+0.241437, +0.750492, +0.237074, +0.757764, +0.228347, +0.762127, +0.221075, +0.766490,
+0.213803, +0.772308, +0.212348, +0.778126, +0.215257, +0.783944, +0.210894, +0.788307,
+0.212348, +0.794124, +0.219620, +0.794124, +0.228347, +0.798488, +0.237074, +0.797033,
+0.234165, +0.792670, +0.235619, +0.786852, +0.239983, +0.782489, +0.245800, +0.785398,
+0.247255, +0.791216, +0.258890, +0.785398, +0.260345, +0.778126, +0.264708, +0.773763,
+0.264708, +0.767945, +0.274889, +0.763582, +0.279253, +0.759218, +0.289434, +0.757764,
+0.302524, +0.750492, +0.312705, +0.743219, +0.322886, +0.738856, +0.331612, +0.733038,
+0.340339, +0.728675, +0.338885, +0.721403, +0.337430, +0.711222, +0.337430, +0.702495,
+0.344703, +0.698132, +0.350520, +0.690859, 
/* zone 102 with 6 points. */
+0.170170, +0.968076, +0.175987, +0.960803, +0.186750, +0.960803, +0.187623, +0.966331,
+0.179478, +0.970112, +0.170170, +0.968076, 
/* zone 103 with 9 points. */
+0.193440, +0.972148, +0.196349, +0.963422, +0.206530, +0.962258, +0.216712, +0.964876,
+0.212348, +0.968076, +0.219620, +0.972148, +0.216712, +0.979129, +0.205076, +0.975639,
+0.193440, +0.972148, 
/* zone 104 with 10 points. */
+0.151262, +0.741765, +0.149807, +0.734493, +0.151262, +0.728675, +0.159988, +0.721403,
+0.162897, +0.730129, +0.165806, +0.735947, +0.164352, +0.741765, +0.164352, +0.750492,
+0.159988, +0.744674, +0.151262, +0.741765, 
/* zone 105 with 16 points. */
+0.142535, +0.714131, +0.142535, +0.708313, +0.146899, +0.701041, +0.146899, +0.692314,
+0.145444, +0.683587, +0.152716, +0.677769, +0.158534, +0.683587, +0.165806, +0.683587,
+0.168715, +0.690859, +0.170170, +0.698132, +0.170170, +0.705404, +0.168715, +0.712676,
+0.161443, +0.719948, +0.152716, +0.714131, +0.146899, +0.712676, +0.142535, +0.714131, 
/* zone 106 with 17 points. */
+0.215257, +0.661771, +0.221075, +0.654499, +0.226893, +0.654499, +0.238528, +0.648681,
+0.247255, +0.647226, +0.253073, +0.641408, +0.264708, +0.639954, +0.267617, +0.645772,
+0.264708, +0.651590, +0.267617, +0.660316, +0.270123, +0.667588, +0.261799, +0.664680,
+0.248709, +0.663225, +0.238528, +0.663225, +0.231256, +0.666134, +0.222529, +0.666134,
+0.215257, +0.661771, 
/* zone 107 with 45 points. */
+0.561414, +0.539598, +0.554142, +0.542507, +0.555596, +0.548324, +0.543961, +0.549779,
+0.533780, +0.548324, +0.523599, +0.543961, +0.514872, +0.539598, +0.506145, +0.538143,
+0.495964, +0.542507, +0.485783, +0.542507, +0.477057, +0.545415, +0.469784, +0.548324,
+0.459603, +0.549779, +0.449422, +0.551233, +0.439241, +0.549779, +0.434878, +0.557051,
+0.424697, +0.557051, +0.414516, +0.559960, +0.404335, +0.561414, +0.402880, +0.568686,
+0.392699, +0.571595, +0.381063, +0.573050, +0.370882, +0.571595, +0.360701, +0.568686,
+0.350520, +0.561414, +0.346157, +0.555596, +0.349066, +0.549779, +0.350520, +0.542507,
+0.347611, +0.535234, +0.341794, +0.530871, +0.334521, +0.527962, +0.325795, +0.529416,
+0.317068, +0.535234, +0.305433, +0.541052, +0.290888, +0.543961, +0.280707, +0.545415,
+0.271980, +0.549779, +0.267617, +0.554142, +0.267617, +0.562869, +0.257436, +0.565778,
+0.247255, +0.570141, +0.237074, +0.571595, +0.223984, +0.573050, +0.212348, +0.573050,
+0.203622, +0.575959, 
/* zone 108 with 103 points. */
+0.162897, +0.000000, +0.161443, -0.008727, +0.152716, -0.014544, +0.157080, -0.023271,
+0.159988, -0.031998, +0.165806, -0.039270, +0.171624, -0.047997, +0.180351, -0.053814,
+0.186169, -0.059632, +0.191986, -0.065450, +0.197804, -0.071267, +0.202167, -0.078540,
+0.207985, -0.085812, +0.212348, -0.093084, +0.212349, -0.100356, +0.215257, -0.104720,
+0.216712, -0.111992, +0.221075, -0.117810, +0.225438, -0.126536, +0.226893, -0.135263,
+0.231256, -0.142535, +0.234165, -0.151262, +0.226893, -0.159988, +0.229802, -0.164352,
+0.232710, -0.173079, +0.237074, -0.180351, +0.241437, -0.186169, +0.242892, -0.196349,
+0.241437, -0.206530, +0.238528, -0.213803, +0.234165, -0.221075, +0.226893, -0.225438,
+0.221075, -0.232710, +0.218166, -0.242892, +0.215257, -0.253073, +0.212348, -0.261799,
+0.210894, -0.270526, +0.206530, -0.279253, +0.206530, -0.287979, +0.205076, -0.296706,
+0.205076, -0.303978, +0.206530, -0.312705, +0.210894, -0.322886, +0.216712, -0.328704,
+0.221075, -0.335976, +0.225438, -0.344703, +0.231256, -0.353429, +0.234165, -0.363610,
+0.239983, -0.370883, +0.242892, -0.378155, +0.250164, -0.385427, +0.253073, -0.392699,
+0.251618, -0.399971, +0.253073, -0.410152, +0.253073, -0.418879, +0.254527, -0.426151,
+0.258890, -0.436332, +0.258890, -0.445059, +0.260345, -0.452331, +0.263254, -0.461058,
+0.266163, -0.471239, +0.267617, -0.479966, +0.273435, -0.485783, +0.277798, -0.493055,
+0.286525, -0.498873, +0.292343, -0.506145, +0.295251, -0.516326, +0.299615, -0.523599,
+0.302524, -0.533780, +0.306887, -0.541052, +0.312705, -0.548324, +0.318523, -0.558505,
+0.319977, -0.568686, +0.315614, -0.573050, +0.311250, -0.573050, +0.318523, -0.583231,
+0.321431, -0.590503, +0.321431, -0.597775, +0.327249, -0.594866, +0.334521, -0.600684,
+0.341794, -0.606502, +0.351975, -0.606502, +0.357792, -0.602139, +0.367974, -0.600684,
+0.379609, -0.600684, +0.385427, -0.596321, +0.395608, -0.594866, +0.405789, -0.596321,
+0.413061, -0.593412, +0.423242, -0.596321, +0.431969, -0.597775, +0.437787, -0.593412,
+0.449422, -0.593412, +0.453786, -0.589049, +0.463966, -0.589049, +0.472693, -0.587594,
+0.479966, -0.581776, +0.490146, -0.575959, +0.497419, -0.571595, +0.503236, -0.565778,
+0.510509, -0.558505, +0.516326, -0.552688, +0.523599, -0.546870, 
/* zone 109 with 23 points. */
+0.510509, -0.104720, +0.514872, -0.113446, +0.520690, -0.122173, +0.529416, -0.129445,
+0.533780, -0.141081, +0.532325, -0.149807, +0.542506, -0.152716, +0.541052, -0.143990,
+0.536689, -0.135263, +0.532325, -0.125082, +0.533780, -0.119264, +0.526508, -0.113446,
+0.519235, -0.107629, +0.523599, -0.100356, +0.520690, -0.090175, +0.517781, -0.079994,
+0.513418, -0.069813, +0.511963, -0.058178, +0.507600, -0.069813, +0.510509, -0.078540,
+0.507600, -0.087266, +0.511963, -0.097447, +0.510509, -0.104720, 
/* zone 110 with 46 points. */
+0.641408, +1.115556, +0.623955, +1.122828, +0.605048, +1.127192, +0.605048, +1.135918,
+0.605048, +1.143190, +0.605048, +1.151917, +0.587594, +1.159189, +0.573050, +1.163552,
+0.562869, +1.172279, +0.578867, +1.166461, +0.599230, +1.163552, +0.616683, +1.159189,
+0.632682, +1.157734, +0.650135, +1.156280, +0.669043, +1.153371, +0.689405, +1.154825,
+0.708313, +1.159189, +0.719948, +1.165007, +0.719948, +1.173734, +0.714131, +1.181005,
+0.698132, +1.186823, +0.680678, +1.191187, +0.663225, +1.197004, +0.645772, +1.202822,
+0.625409, +1.207186, +0.602139, +1.210094, +0.577413, +1.211549, +0.577413, +1.217366,
+0.559960, +1.220276, +0.545415, +1.217366, +0.523599, +1.218821, +0.501782, +1.224639,
+0.523599, +1.223185, +0.543961, +1.229002, +0.526508, +1.233365, +0.507600, +1.237729,
+0.484329, +1.240638, +0.468330, +1.230456, +0.463966, +1.237729, +0.446513, +1.231911,
+0.447968, +1.242092, +0.433423, +1.239183, +0.423242, +1.233365, +0.407243, +1.237729,
+0.389790, +1.233365, +0.375246, +1.226093, 
/* zone 111 with 39 points. */
+0.191986, +1.391899, +0.191986, +1.384627, +0.203622, +1.373573, +0.229802, +1.365138,
+0.263254, +1.365138, +0.238528, +1.360483, +0.244346, +1.352630, +0.264708, +1.344193,
+0.296706, +1.335176, +0.302524, +1.343903, +0.315613, +1.352630, +0.330158, +1.361938,
+0.331612, +1.368629, +0.353429, +1.372410, +0.360702, +1.364556, +0.378155, +1.359901,
+0.363610, +1.351175, +0.395608, +1.348266, +0.433423, +1.356993, +0.404334, +1.362810,
+0.386881, +1.368629, +0.375246, +1.375900, +0.331613, +1.381719, +0.327249, +1.391026,
+0.365065, +1.384627, +0.415970, +1.381719, +0.447968, +1.386082, +0.471239, +1.393936,
+0.471239, +1.399172, +0.433423, +1.400626, +0.401426, +1.403535, +0.366519, +1.399172,
+0.349066, +1.404989, +0.314159, +1.400626, +0.314159, +1.394809, +0.285070, +1.396845,
+0.270526, +1.390445, +0.241437, +1.393353, +0.191986, +1.391899, 
/* zone 112 with 58 points. */
+0.360701, +1.114101, +0.366519, +1.119919, +0.378155, +1.125737, +0.366519, +1.130100,
+0.375246, +1.135918, +0.373791, +1.140281, +0.383972, +1.143190, +0.391245, +1.149008,
+0.404335, +1.147553, +0.415970, +1.147553, +0.427606, +1.149008, +0.442150, +1.143190,
+0.442150, +1.134463, +0.430515, +1.131555, +0.420333, +1.122828, +0.405789, +1.115556,
+0.391245, +1.106829, +0.376700, +1.099557, +0.369428, +1.090830, +0.370882, +1.082104,
+0.378155, +1.073377, +0.372337, +1.064651, +0.372337, +1.058832, +0.385427, +1.054469,
+0.394153, +1.050106, +0.410152, +1.047197, +0.426151, +1.048651, +0.442150, +1.051560,
+0.458149, +1.054469, +0.474148, +1.057378, +0.494510, +1.057378, +0.507600, +1.050106,
+0.519235, +1.051560, +0.526508, +1.044288, +0.509054, +1.047197, +0.494510, +1.041379,
+0.487238, +1.037016, +0.468330, +1.037016, +0.452331, +1.039925, +0.436332, +1.038470,
+0.421788, +1.037016, +0.410152, +1.032653, +0.410152, +1.025380, +0.414516, +1.018108,
+0.424697, +1.016654, +0.424697, +1.007927, +0.424697, +0.999201, +0.415970, +0.994837,
+0.405789, +0.996292, +0.399971, +1.002110, +0.391245, +1.006473, +0.378155, +1.005018,
+0.372337, +0.996292, +0.366519, +0.990474, +0.366519, +0.980293, +0.367974, +0.971567,
+0.362156, +0.962840, +0.349066, +0.958477, 
/* zone 113 with 6 points. */
+0.191986, +0.957022, +0.197804, +0.952659, +0.206530, +0.954113, +0.210894, +0.957022,
+0.202167, +0.958476, +0.191986, +0.957022, 
/* zone 114 with 7 points. */
+0.315614, +1.003564, +0.318523, +0.996292, +0.327249, +0.999783, +0.327249, +1.007054,
+0.334521, +1.011127, +0.321431, +1.008509, +0.315614, +1.003564, 
/* zone 115 with 6 points. */
+0.381064, +1.018108, +0.386881, +1.014036, +0.395608, +1.017527, +0.404335, +1.021017,
+0.389790, +1.023053, +0.381064, +1.018108, 
/* zone 116 with 5 points. */
+0.389790, +1.027707, +0.391245, +1.024798, +0.401426, +1.026834, +0.392699, +1.031198,
+0.389790, +1.027707, 
/* zone 117 with 15 points. */
+0.523599, +1.066105, +0.533780, +1.060287, +0.539598, +1.053015, +0.542506, +1.045743,
+0.549779, +1.045743, +0.554142, +1.050106, +0.567232, +1.050106, +0.573050, +1.055923,
+0.573050, +1.061741, +0.567232, +1.067559, +0.555596, +1.070468, +0.548324, +1.074831,
+0.536689, +1.074831, +0.526508, +1.070468, +0.523599, +1.066105, 
/* zone 118 with 94 points. */
+0.350520, +0.690859, +0.354883, +0.685042, +0.360701, +0.676315, +0.367974, +0.669043,
+0.381063, +0.667588, +0.394153, +0.669043, +0.399971, +0.663225, +0.410152, +0.661771,
+0.418879, +0.655953, +0.418879, +0.666134, +0.429060, +0.663225, +0.421788, +0.666134,
+0.420333, +0.671952, +0.413061, +0.674861, +0.407243, +0.679224, +0.404335, +0.685042,
+0.398517, +0.690859, +0.392699, +0.698132, +0.394153, +0.708313, +0.402880, +0.701041,
+0.411607, +0.701041, +0.414516, +0.705404, +0.410152, +0.709767, +0.418879, +0.709767,
+0.423242, +0.714131, +0.431969, +0.712676, +0.439241, +0.714131, +0.449422, +0.712676,
+0.455240, +0.706858, +0.463966, +0.708313, +0.456695, +0.702495, +0.456695, +0.698132,
+0.463966, +0.703950, +0.472693, +0.709767, +0.478511, +0.714131, +0.491601, +0.715585,
+0.503236, +0.715585, +0.513418, +0.709767, +0.504691, +0.708313, +0.506145, +0.703950,
+0.495964, +0.703950, +0.484329, +0.703950, +0.474148, +0.703950, +0.463966, +0.703950,
+0.456695, +0.698132, +0.453786, +0.687951, +0.468330, +0.689405, +0.465421, +0.685042,
+0.466875, +0.674861, +0.469784, +0.670497, +0.465421, +0.669043, +0.459603, +0.673406,
+0.458149, +0.667588, +0.466875, +0.664680, +0.474148, +0.661771, +0.472693, +0.655953,
+0.479965, +0.651590, +0.474148, +0.645772, +0.482874, +0.645772, +0.491601, +0.645772,
+0.488692, +0.641408, +0.498873, +0.641408, +0.510509, +0.634136, +0.519235, +0.631227,
+0.532325, +0.635591, +0.535234, +0.642863, +0.545415, +0.641408, +0.558505, +0.637045,
+0.562869, +0.631227, +0.571595, +0.628318, +0.578868, +0.631227, +0.586140, +0.631227,
+0.594866, +0.637045, +0.602139, +0.642863, +0.613774, +0.638499, +0.619592, +0.638499,
+0.628318, +0.644317, +0.629773, +0.639954, +0.623955, +0.634136, +0.626864, +0.628318,
+0.623955, +0.622501, +0.623955, +0.610865, +0.625409, +0.602139, +0.619592, +0.594866,
+0.615228, +0.584685, +0.610865, +0.575958, +0.607956, +0.567232, +0.605048, +0.558505,
+0.599230, +0.549779, +0.593412, +0.543961, +0.580322, +0.542507, +0.570141, +0.541052,
+0.564323, +0.545415, +0.561414, +0.539598, 
/* zone 119 with 16 points. */
+0.367974, +0.658862, +0.376700, +0.653044, +0.375246, +0.645772, +0.378155, +0.641408,
+0.385427, +0.641408, +0.389790, +0.635591, +0.395608, +0.641408, +0.402880, +0.635591,
+0.398517, +0.645772, +0.395608, +0.653044, +0.404335, +0.651590, +0.398517, +0.660316,
+0.389790, +0.664680, +0.381063, +0.667588, +0.372337, +0.664680, +0.367974, +0.658862, 
/* zone 120 with 15 points. */
+0.410152, +0.613774, +0.418879, +0.613774, +0.427606, +0.612320, +0.433423, +0.609120,
+0.445059, +0.609702, +0.456695, +0.610283, +0.458149, +0.615228, +0.449422, +0.612320,
+0.449422, +0.616683, +0.439241, +0.616101, +0.431969, +0.618137, +0.423242, +0.616683,
+0.421788, +0.619592, +0.411607, +0.621046, +0.410152, +0.613774, 
/* zone 121 with 5 points. */
+0.482874, +0.631227, +0.484329, +0.626282, +0.490146, +0.629773, +0.493055, +0.636172,
+0.482874, +0.631227, 
/* zone 122 with 13 points. */
+0.562869, +0.610865, +0.565778, +0.605048, +0.575958, +0.603593, +0.584685, +0.605629,
+0.587594, +0.609411, +0.594866, +0.609411, +0.591957, +0.613774, +0.602139, +0.621046,
+0.591958, +0.618137, +0.583231, +0.616683, +0.575958, +0.615228, +0.571595, +0.612320,
+0.562869, +0.610865, 
/* zone 123 with 168 points. */
+0.523599, -0.546870, +0.530871, -0.539598, +0.535234, -0.532325, +0.539598, -0.523599,
+0.545415, -0.516326, +0.549779, -0.509054, +0.558505, -0.503236, +0.565777, -0.498873,
+0.568686, -0.490146, +0.571595, -0.479966, +0.574504, -0.471239, +0.574504, -0.463966,
+0.574504, -0.458149, +0.568686, -0.455240, +0.574504, -0.445059, +0.583231, -0.442150,
+0.589049, -0.439241, +0.600684, -0.434878, +0.609411, -0.431969, +0.615228, -0.427606,
+0.619592, -0.418879, +0.618137, -0.410152, +0.619592, -0.402880, +0.619592, -0.392699,
+0.616683, -0.385427, +0.613774, -0.373791, +0.610865, -0.363610, +0.605047, -0.357792,
+0.606502, -0.349066, +0.613774, -0.343248, +0.619592, -0.338885, +0.625409, -0.331612,
+0.632682, -0.328704, +0.639954, -0.319977, +0.645772, -0.312705, +0.651590, -0.305433,
+0.660316, -0.302524, +0.667588, -0.299615, +0.679224, -0.298160, +0.685042, -0.292343,
+0.693768, -0.285070, +0.699586, -0.279253, +0.705404, -0.271980, +0.709767, -0.264708,
+0.711222, -0.255982, +0.708313, -0.245800, +0.708313, -0.237074, +0.705404, -0.226893,
+0.706858, -0.216712, +0.706858, -0.209440, +0.705404, -0.218166, +0.706858, -0.191986,
+0.706858, -0.183260, +0.701041, -0.177442, +0.695223, -0.173079, +0.692314, -0.164352,
+0.687951, -0.154171, +0.686496, -0.142535, +0.686496, -0.132354, +0.690859, -0.123627,
+0.683587, -0.114901, +0.676315, -0.106174, +0.679224, -0.097447, +0.682133, -0.088721,
+0.686496, -0.079994, +0.690859, -0.072722, +0.696677, -0.062541, +0.702495, -0.052360,
+0.702495, -0.042179, +0.709767, -0.043633, +0.717039, -0.036361, +0.724312, -0.030543,
+0.728675, -0.021817, +0.734493, -0.015999, +0.740310, -0.007272, +0.749037, +0.000000,
+0.753400, +0.007272, +0.760673, +0.013090, +0.767945, +0.017453, +0.775217, +0.024726,
+0.782489, +0.030543, +0.791216, +0.033452, +0.798488, +0.039270, +0.805760, +0.045088,
+0.811578, +0.052360, +0.818850, +0.059632, +0.824668, +0.065450, +0.831940, +0.072722,
+0.836303, +0.079994, +0.840667, +0.088721, +0.846484, +0.094539, +0.853757, +0.100356,
+0.856665, +0.110537, +0.859574, +0.117810, +0.863938, +0.126536, +0.868301, +0.133809,
+0.871210, +0.142535, +0.875573, +0.148353, +0.879936, +0.155625, +0.885754, +0.164352,
+0.885754, +0.174533, +0.890118, +0.181805, +0.891572, +0.191986, +0.893027, +0.205076,
+0.882845, +0.207985, +0.875573, +0.200713, +0.865392, +0.197804, +0.855211, +0.194895,
+0.846484, +0.196349, +0.837758, +0.193441, +0.827576, +0.193441, +0.817395, +0.187623,
+0.808669, +0.186169, +0.798488, +0.187623, +0.789761, +0.183260, +0.781035, +0.180351,
+0.772308, +0.181805, +0.766490, +0.186169, +0.760673, +0.193441, +0.754855, +0.199258,
+0.749037, +0.203622, +0.757764, +0.207985, +0.754855, +0.216712, +0.747583, +0.223984,
+0.740310, +0.231256, +0.734493, +0.238528, +0.725766, +0.245800, +0.718494, +0.254527,
+0.709767, +0.257436, +0.699586, +0.261799, +0.695223, +0.270526, +0.689405, +0.271980,
+0.685042, +0.279253, +0.683587, +0.287979, +0.682133, +0.298160, +0.677769, +0.306887,
+0.673406, +0.314159, +0.664680, +0.321431, +0.655953, +0.325795, +0.651590, +0.335976,
+0.650135, +0.343248, +0.648681, +0.353429, +0.650135, +0.362156, +0.650135, +0.367974,
+0.644317, +0.375246, +0.644317, +0.385427, +0.638499, +0.388336, +0.631227, +0.392699,
+0.625409, +0.397063, +0.621046, +0.405789, +0.619592, +0.411607, +0.621046, +0.418879,
+0.615228, +0.424697, +0.610865, +0.433423, +0.606502, +0.440696, +0.602139, +0.449422,
+0.599230, +0.456695, +0.593412, +0.465421, +0.591958, +0.472693, +0.587594, +0.478511,
+0.586140, +0.485783, +0.580322, +0.491601, +0.574504, +0.498873, +0.570141, +0.506145,
+0.568686, +0.513418, +0.564323, +0.520690, +0.568686, +0.523599, +0.564090, +0.545764, 
/* zone 124 with 68 points. */
+0.754855, -0.382518, +0.754855, -0.389790, +0.756309, -0.398517, +0.760673, -0.405789,
+0.762127, -0.417425, +0.763582, -0.427606, +0.770854, -0.436332, +0.778126, -0.442150,
+0.785398, -0.446513, +0.794124, -0.445059, +0.801397, -0.440696, +0.810123, -0.437787,
+0.817395, -0.439241, +0.823213, -0.430515, +0.826122, -0.423242, +0.829031, -0.414516,
+0.831940, -0.408698, +0.833394, -0.401426, +0.834849, -0.394154, +0.836303, -0.386881,
+0.839212, -0.379609, +0.842121, -0.372337, +0.845030, -0.365065, +0.846484, -0.357792,
+0.849393, -0.350520, +0.852302, -0.341794, +0.855211, -0.333067, +0.859574, -0.322886,
+0.861029, -0.314159, +0.862483, -0.303978, +0.862483, -0.296706, +0.866847, -0.292343,
+0.868301, -0.285070, +0.866847, -0.270526, +0.874119, -0.277798, +0.879936, -0.269072,
+0.878482, -0.260345, +0.875573, -0.247255, +0.871210, -0.237074, +0.869755, -0.226893,
+0.865392, -0.218166, +0.859574, -0.209440, +0.852302, -0.216712, +0.852302, -0.225438,
+0.850847, -0.232710, +0.843575, -0.235619, +0.834849, -0.237074, +0.836303, -0.245800,
+0.830485, -0.250164, +0.831940, -0.257436, +0.824668, -0.257436, +0.817395, -0.266163,
+0.810123, -0.270526, +0.801397, -0.274889, +0.792670, -0.277798, +0.783944, -0.282162,
+0.776672, -0.282162, +0.772308, -0.295251, +0.766490, -0.303978, +0.767945, -0.314159,
+0.772308, -0.324340, +0.772308, -0.331612, +0.776672, -0.341794, +0.775217, -0.349066,
+0.769399, -0.357792, +0.766491, -0.365065, +0.760673, -0.372337, +0.754855, -0.382518, 
/* zone 125 with 20 points. */
+0.552688, -0.036361, +0.555596, -0.047997, +0.562869, -0.040724, +0.571595, -0.043633,
+0.583231, -0.043633, +0.590503, -0.037816, +0.580322, -0.036361, +0.586140, -0.030543,
+0.591958, -0.023271, +0.594866, -0.013090, +0.597775, -0.007272, +0.593412, +0.001454,
+0.584685, +0.004363, +0.575958, +0.004363, +0.565778, +0.002909, +0.555596, -0.002909,
+0.552688, -0.013090, +0.555596, -0.020362, +0.554142, -0.027634, +0.552688, -0.036361, 
/* zone 126 with 22 points. */
+0.594866, -0.212348, +0.596321, -0.219620, +0.599230, -0.226893, +0.599230, -0.234165,
+0.605048, -0.239983, +0.606502, -0.247255, +0.612320, -0.245800, +0.616683, -0.253073,
+0.615228, -0.241437, +0.609411, -0.234165, +0.607956, -0.223984, +0.607956, -0.213803,
+0.610865, -0.203622, +0.605048, -0.193441, +0.603593, -0.184714, +0.602139, -0.173079,
+0.594866, -0.167261, +0.593412, -0.171624, +0.597775, -0.189077, +0.597775, -0.191986,
+0.600684, -0.205076, +0.594866, -0.212348, 
/* zone 127 with 37 points. */
+0.890118, +1.192641, +0.875573, +1.188277, +0.856665, +1.183914, +0.840667, +1.181005,
+0.840667, +1.170824, +0.826122, +1.166461, +0.808669, +1.166461, +0.799942, +1.172279,
+0.783944, +1.175188, +0.794124, +1.182460, +0.814487, +1.183914, +0.807214, +1.191187,
+0.797033, +1.195550, +0.776672, +1.195550, +0.754855, +1.198459, +0.770854, +1.191187,
+0.770854, +1.181005, +0.765036, +1.172279, +0.776672, +1.169370, +0.776672, +1.160644,
+0.766490, +1.154825, +0.753401, +1.157734, +0.735947, +1.159189, +0.724312, +1.153371,
+0.706858, +1.149008, +0.692314, +1.143190, +0.701041, +1.135918, +0.709767, +1.127192,
+0.689405, +1.128646, +0.674861, +1.131555, +0.658862, +1.135918, +0.644317, +1.137372,
+0.637045, +1.131555, +0.650135, +1.124282, +0.663225, +1.124282, +0.663225, +1.115556,
+0.641408, +1.115556, 
/* zone 128 with 6 points. */
+0.850847, +1.199913, +0.872664, +1.202822, +0.878482, +1.208640, +0.858120, +1.214458,
+0.846484, +1.208640, +0.850847, +1.199913, 
/* zone 129 with 4 points. */
+0.927933, +1.400626, +0.959931, +1.401208, +0.942478, +1.404989, +0.927933, +1.400626, 
/* zone 130 with 13 points. */
+0.776672, +1.405862, +0.797033, +1.403535, +0.820304, +1.403535, +0.820305, +1.399172,
+0.845030, +1.397136, +0.872664, +1.398299, +0.872664, +1.403244, +0.893027, +1.407898,
+0.878482, +1.409934, +0.837758, +1.405862, +0.837758, +1.409352, +0.820305, +1.411971,
+0.776672, +1.405862, 
/* zone 131 with 17 points. */
+0.602139, +1.077741, +0.607956, +1.073377, +0.619592, +1.070468, +0.619592, +1.063195,
+0.628318, +1.063196, +0.635591, +1.066105, +0.635591, +1.071922, +0.628318, +1.076285,
+0.623955, +1.082104, +0.625409, +1.089375, +0.615228, +1.093739, +0.602139, +1.096648,
+0.607956, +1.092284, +0.616683, +1.090830, +0.616683, +1.085012, +0.605048, +1.085012,
+0.602139, +1.077741, 
/* zone 132 with 72 points. */
+0.479965, +0.741765, +0.487238, +0.734493, +0.490146, +0.727220, +0.498873, +0.721403,
+0.509054, +0.718494, +0.520690, +0.717040, +0.532325, +0.718494, +0.542507, +0.717040,
+0.551233, +0.721403, +0.559960, +0.725766, +0.568686, +0.730129, +0.580322, +0.733038,
+0.590503, +0.731584, +0.602139, +0.731584, +0.610865, +0.733038, +0.616683, +0.727221,
+0.628318, +0.727221, +0.634136, +0.719948, +0.641408, +0.719948, +0.650135, +0.715585,
+0.657407, +0.717039, +0.666134, +0.714131, +0.676315, +0.715585, +0.686496, +0.717039,
+0.696677, +0.715585, +0.706858, +0.717039, +0.717039, +0.722857, +0.725766, +0.727221,
+0.727220, +0.733038, +0.722857, +0.738856, +0.719948, +0.746128, +0.715585, +0.749037,
+0.703949, +0.753401, +0.695223, +0.757764, +0.689405, +0.762127, +0.680678, +0.769399,
+0.671952, +0.773763, +0.663225, +0.775217, +0.657407, +0.778126, +0.650135, +0.781035,
+0.645772, +0.786852, +0.639954, +0.786852, +0.629773, +0.785398, +0.621046, +0.786852,
+0.612320, +0.782489, +0.603593, +0.781035, +0.597775, +0.776672, +0.589049, +0.773763,
+0.583231, +0.778126, +0.586140, +0.785398, +0.580322, +0.788307, +0.570141, +0.791216,
+0.577413, +0.798488, +0.589049, +0.801397, +0.578868, +0.805760, +0.568686, +0.802851,
+0.555596, +0.807214, +0.559960, +0.813032, +0.548324, +0.813032, +0.538143, +0.813032,
+0.533780, +0.805760, +0.526508, +0.799942, +0.516326, +0.797033, +0.517781, +0.788307,
+0.514872, +0.782489, +0.506145, +0.779580, +0.500328, +0.773763, +0.500328, +0.766491,
+0.498873, +0.757764, +0.488692, +0.756309, +0.487238, +0.747583, +0.479965, +0.741765, 
/* zone 133 with 22 points. */
+0.600684, +0.801397, +0.606502, +0.798488, +0.610865, +0.792670, +0.619592, +0.789761,
+0.629773, +0.792670, +0.639954, +0.792670, +0.651590, +0.791216, +0.658862, +0.799942,
+0.667588, +0.807214, +0.661771, +0.810123, +0.657408, +0.814487, +0.666134, +0.814487,
+0.676315, +0.820305, +0.686496, +0.821759, +0.680678, +0.824668, +0.670497, +0.823213,
+0.655953, +0.821759, +0.642863, +0.815941, +0.629773, +0.814487, +0.618137, +0.810124,
+0.610865, +0.804306, +0.600684, +0.801397, 
/* zone 134 with 84 points. */
+0.814487, +0.781035, +0.814487, +0.775217, +0.821759, +0.772308, +0.827576, +0.763582,
+0.827576, +0.757764, +0.827576, +0.750492, +0.834849, +0.741765, +0.842121, +0.734493,
+0.849393, +0.730129, +0.855211, +0.722857, +0.858120, +0.715585, +0.866847, +0.708313,
+0.877028, +0.705404, +0.868301, +0.703950, +0.862483, +0.698132, +0.859574, +0.689405,
+0.858120, +0.683587, +0.850847, +0.683587, +0.852302, +0.673406, +0.853757, +0.664680,
+0.855211, +0.655953, +0.863938, +0.653044, +0.875573, +0.651590, +0.878482, +0.647226,
+0.890118, +0.641408, +0.900299, +0.638499, +0.914843, +0.641408, +0.927933, +0.644317,
+0.941023, +0.642863, +0.942478, +0.648681, +0.938114, +0.660316, +0.938114, +0.671952,
+0.942478, +0.682133, +0.935205, +0.683587, +0.932297, +0.690859, +0.933751, +0.698132,
+0.920661, +0.698132, +0.919207, +0.703950, +0.923570, +0.712676, +0.933751, +0.709767,
+0.945387, +0.709767, +0.955567, +0.715585, +0.948295, +0.721403, +0.941023, +0.727221,
+0.936660, +0.734493, +0.925024, +0.733038, +0.919206, +0.727220, +0.920661, +0.719948,
+0.914843, +0.728675, +0.913389, +0.735947, +0.919206, +0.743219, +0.916297, +0.747583,
+0.904662, +0.747583, +0.895935, +0.753401, +0.893027, +0.762127, +0.885754, +0.770854,
+0.875573, +0.773763, +0.877028, +0.778126, +0.888663, +0.778126, +0.897390, +0.776672,
+0.893027, +0.785398, +0.903208, +0.791216, +0.916297, +0.792670, +0.926479, +0.788307,
+0.936660, +0.789761, +0.946841, +0.789761, +0.941023, +0.794124, +0.939569, +0.801397,
+0.936660, +0.810123, +0.927933, +0.817395, +0.917752, +0.823213, +0.909025, +0.823213,
+0.897390, +0.823213, +0.888663, +0.824668, +0.875573, +0.817395, +0.863938, +0.815941,
+0.853757, +0.813032, +0.855211, +0.808669, +0.846484, +0.807214, +0.842121, +0.801397,
+0.830485, +0.804306, +0.826122, +0.797033, +0.820305, +0.788307, +0.814487, +0.781035, 
/* zone 135 with 24 points. */
+1.281362, +0.795579, +1.288634, +0.789761, +1.292997, +0.783944, +1.295906, +0.797033,
+1.294452, +0.802851, +1.304633, +0.805760, +1.311905, +0.810124, +1.326449, +0.813032,
+1.340994, +0.810123, +1.349720, +0.813032, +1.361356, +0.808669, +1.374446, +0.810123,
+1.383173, +0.815941, +1.374446, +0.815941, +1.367174, +0.813032, +1.358447, +0.814487,
+1.349720, +0.813032, +1.340994, +0.814487, +1.327904, +0.815941, +1.313359, +0.814487,
+1.304633, +0.815941, +1.294452, +0.810124, +1.285726, +0.805760, +1.281362, +0.795579, 
/* zone 136 with 68 points. */
+0.568686, +0.523599, +0.571595, +0.516326, +0.575959, +0.507600, +0.580322, +0.501782,
+0.583231, +0.495964, +0.589049, +0.490146, +0.596321, +0.484329, +0.600684, +0.487238,
+0.600684, +0.494510, +0.605048, +0.504691, +0.610865, +0.514872, +0.610865, +0.506145,
+0.607956, +0.497419, +0.605048, +0.488692, +0.613774, +0.488692, +0.619592, +0.481420,
+0.623955, +0.474148, +0.629773, +0.465421, +0.635591, +0.456695, +0.641408, +0.450877,
+0.647226, +0.442150, +0.650135, +0.433423, +0.654499, +0.424697, +0.663225, +0.420333,
+0.670497, +0.414516, +0.676315, +0.405789, +0.680678, +0.397063, +0.682133, +0.388336,
+0.680678, +0.382518, +0.682133, +0.375246, +0.683587, +0.365065, +0.689405, +0.359247,
+0.692314, +0.353429, +0.703949, +0.350520, +0.711222, +0.343248, +0.715585, +0.334521,
+0.719948, +0.325795, +0.724312, +0.317068, +0.728675, +0.309796, +0.734493, +0.305433,
+0.740310, +0.296706, +0.744674, +0.287979, +0.746128, +0.280707, +0.744674, +0.273435,
+0.746128, +0.264708, +0.749037, +0.254527, +0.751946, +0.244346, +0.754855, +0.239983,
+0.753400, +0.231256, +0.759218, +0.222530, +0.766491, +0.221075, +0.775217, +0.222530,
+0.783944, +0.223984, +0.792670, +0.226893, +0.797033, +0.232710, +0.804306, +0.232710,
+0.813032, +0.231256, +0.821759, +0.232710, +0.827576, +0.237074, +0.834849, +0.242892,
+0.843575, +0.242892, +0.852302, +0.245800, +0.858120, +0.253073, +0.866847, +0.257436,
+0.877028, +0.260345, +0.885754, +0.263254, +0.894481, +0.266163, +0.903208, +0.269072, 
/* zone 137 with 7 points. */
+0.930842, +0.216712, +0.936660, +0.213803, +0.943932, +0.213803, +0.952658, +0.218166,
+0.945387, +0.219620, +0.936660, +0.221075, +0.930842, +0.216712, 
/* zone 138 with 6 points. */
+0.962840, -0.366519, +0.965748, -0.372337, +0.973021, -0.372337, +0.974475, -0.369428,
+0.970112, -0.365065, +0.962840, -0.366519, 
/* zone 139 with 5 points. */
+1.000654, -0.357792, +1.007927, -0.357792, +1.007927, -0.351975, +1.003564, -0.349066,
+1.000654, -0.357792, 
/* zone 140 with 79 points. */
+1.310451, +1.268272, +1.311905, +1.262454, +1.303179, +1.256637, +1.287180, +1.253728,
+1.276999, +1.245001, +1.288634, +1.239183, +1.297360, +1.231911, +1.288634, +1.224639,
+1.285726, +1.215912, +1.290089, +1.205731, +1.317722, +1.204277, +1.301724, +1.199913,
+1.300270, +1.191187, +1.306087, +1.181005, +1.291543, +1.173734, +1.282816, +1.166461,
+1.265363, +1.160644, +1.249364, +1.156280, +1.230456, +1.163552, +1.253728, +1.169370,
+1.265363, +1.175188, +1.276999, +1.182460, +1.276999, +1.189733, +1.284270, +1.197004,
+1.266817, +1.204277, +1.266817, +1.213003, +1.268272, +1.223185, +1.268272, +1.231911,
+1.268272, +1.240638, +1.253728, +1.247910, +1.263908, +1.255182, +1.271181, +1.262454,
+1.271181, +1.268272, +1.245001, +1.272635, +1.250819, +1.276999, +1.242092, +1.282817,
+1.223185, +1.279907, +1.213003, +1.272635, +1.202822, +1.265364, +1.199913, +1.256637,
+1.191187, +1.249364, +1.169370, +1.243546, +1.166461, +1.236275, +1.175188, +1.229002,
+1.167915, +1.221730, +1.167915, +1.215912, +1.183914, +1.213003, +1.192641, +1.204277,
+1.205730, +1.199913, +1.197004, +1.191187, +1.182460, +1.195550, +1.170824, +1.201367,
+1.151917, +1.204277, +1.135918, +1.208640, +1.118464, +1.210094, +1.099557, +1.215912,
+1.077740, +1.217366, +1.050106, +1.223185, +1.031198, +1.230456, +1.022471, +1.224639,
+1.032653, +1.220276, +1.050106, +1.215912, +1.055923, +1.210094, +1.066105, +1.204277,
+1.055923, +1.199913, +1.044288, +1.198459, +1.044288, +1.192641, +1.031198, +1.194096,
+1.031198, +1.204277, +1.015200, +1.201367, +0.999201, +1.195550, +0.980293, +1.197004,
+0.962839, +1.195550, +0.957022, +1.189733, +0.942477, +1.195550, +0.941023, +1.204277,
+0.925024, +1.199913, +0.909025, +1.195550, +0.890118, +1.192641, 
/* zone 141 with 40 points. */
+0.901753, +1.249364, +0.922115, +1.242092, +0.939569, +1.236275, +0.965749, +1.233365,
+0.993383, +1.231911, +1.006473, +1.234819, +0.983202, +1.240638, +0.973021, +1.247910,
+0.968657, +1.256637, +0.970112, +1.265363, +0.980293, +1.272635, +0.994837, +1.279907,
+1.009381, +1.287180, +1.023926, +1.294452, +1.044288, +1.301724, +1.060287, +1.308996,
+1.086467, +1.314814, +1.114101, +1.320632, +1.143189, +1.323541, +1.173734, +1.327904,
+1.201367, +1.332267, +1.205730, +1.340994, +1.182460, +1.343903, +1.151917, +1.339540,
+1.137372, +1.333722, +1.102466, +1.330812, +1.067559, +1.330812, +1.034107, +1.324995,
+1.015200, +1.319178, +1.003564, +1.314814, +0.973021, +1.310451, +0.973021, +1.304633,
+0.958477, +1.294452, +0.939569, +1.287180, +0.948295, +1.281363, +0.929388, +1.276999,
+0.916298, +1.268272, +0.920661, +1.262454, +0.901753, +1.258091, +0.901753, +1.249364, 
/* zone 142 with 15 points. */
+0.977384, +1.398299, +1.007927, +1.398299, +1.034107, +1.403535, +1.073377, +1.402081,
+1.087921, +1.404408, +1.087921, +1.412262, +1.114101, +1.410807, +1.138826, +1.413716,
+1.127192, +1.420988, +1.096648, +1.416625, +1.087921, +1.412262, +1.041379, +1.409934,
+1.034107, +1.403535, +1.000654, +1.404117, +0.977384, +1.398299, 
/* zone 143 with 10 points. */
+0.946841, +1.410225, +0.983202, +1.407316, +1.021017, +1.410225, +1.006473, +1.413716,
+1.026834, +1.419534, +1.021017, +1.426806, +0.986111, +1.420988, +0.986111, +1.414298,
+0.957022, +1.414298, +0.946841, +1.410225, 
/* zone 144 with 27 points. */
+1.015200, +0.785398, +1.015200, +0.776672, +1.018108, +0.772308, +1.018108, +0.762127,
+1.029743, +0.762127, +1.041379, +0.762127, +1.044288, +0.759218, +1.055923, +0.762127,
+1.066105, +0.770854, +1.066105, +0.779580, +1.073377, +0.781035, +1.079194, +0.785398,
+1.073377, +0.791216, +1.064651, +0.798488, +1.064651, +0.802851, +1.070468, +0.810124,
+1.076285, +0.815941, +1.064651, +0.811578, +1.060287, +0.814487, +1.048651, +0.811578,
+1.048651, +0.805760, +1.042833, +0.808669, +1.038470, +0.801397, +1.029743, +0.801397,
+1.023926, +0.799942, +1.022471, +0.792670, +1.015200, +0.785398, 
/* zone 145 with 153 points. */
+0.903208, +0.269072, +0.911934, +0.271980, +0.911934, +0.277798, +0.914843, +0.283616,
+0.923570, +0.287979, +0.932297, +0.290888, +0.941023, +0.295251, +0.949750, +0.296706,
+0.957022, +0.295251, +0.964294, +0.299615, +0.967203, +0.308342, +0.975930, +0.311250,
+0.983202, +0.312705, +0.987565, +0.315614, +0.990474, +0.324340, +0.996292, +0.328704,
+1.003564, +0.330158, +1.010836, +0.333067, +1.007927, +0.340339, +1.009381, +0.349066,
+1.013744, +0.356338, +1.021017, +0.356338, +1.025380, +0.363610, +1.029743, +0.369428,
+1.035562, +0.373791, +1.039925, +0.382518, +1.044288, +0.391245, +1.037016, +0.395608,
+1.031198, +0.402880, +1.026834, +0.410152, +1.016654, +0.413061, +1.007927, +0.414516,
+0.999201, +0.418879, +0.991929, +0.424697, +0.984657, +0.431969, +0.984657, +0.442150,
+0.984657, +0.450877, +0.986111, +0.455240, +0.981747, +0.456695, +0.978838, +0.450877,
+0.971566, +0.446513, +0.965748, +0.440696, +0.959931, +0.434878, +0.951204, +0.429060,
+0.946841, +0.421788, +0.939569, +0.420333, +0.929388, +0.421788, +0.920661, +0.421788,
+0.914843, +0.417425, +0.904662, +0.418879, +0.901753, +0.423242, +0.894481, +0.423242,
+0.900299, +0.431969, +0.901753, +0.440696, +0.900299, +0.449422, +0.895935, +0.455240,
+0.891572, +0.453786, +0.890118, +0.446513, +0.884300, +0.439241, +0.881391, +0.443605,
+0.875573, +0.450877, +0.877028, +0.458149, +0.874119, +0.465421, +0.866847, +0.471239,
+0.859574, +0.478511, +0.852302, +0.485783, +0.847939, +0.493055, +0.843575, +0.501782,
+0.840667, +0.510509, +0.833394, +0.513418, +0.843575, +0.516326, +0.847939, +0.523599,
+0.853757, +0.532325, +0.859574, +0.527962, +0.865392, +0.523599, +0.872664, +0.526508,
+0.878482, +0.520690, +0.884300, +0.510509, +0.891572, +0.501782, +0.894481, +0.493055,
+0.898844, +0.485783, +0.910480, +0.482874, +0.917752, +0.478511, +0.925024, +0.471239,
+0.933751, +0.469784, +0.939569, +0.463966, +0.948295, +0.465421, +0.955567, +0.461058,
+0.965748, +0.465421, +0.973021, +0.468330, +0.981747, +0.471239, +0.990474, +0.471239,
+0.996292, +0.465421, +0.997746, +0.458149, +1.000654, +0.449422, +1.012290, +0.447968,
+1.022471, +0.446513, +1.032653, +0.443605, +1.041379, +0.442150, +1.050106, +0.442150,
+1.060287, +0.440696, +1.067559, +0.439241, +1.079194, +0.437787, +1.089375, +0.439241,
+1.098103, +0.440696, +1.108283, +0.440696, +1.114101, +0.443605, +1.121373, +0.440696,
+1.128646, +0.439241, +1.137372, +0.440696, +1.144645, +0.442150, +1.153371, +0.443605,
+1.162098, +0.442150, +1.166461, +0.436332, +1.172278, +0.431969, +1.175188, +0.424697,
+1.176642, +0.417425, +1.185369, +0.414516, +1.192641, +0.410152, +1.198459, +0.402880,
+1.207186, +0.397063, +1.217366, +0.397062, +1.227548, +0.399971, +1.224639, +0.391245,
+1.215912, +0.388336, +1.205730, +0.388336, +1.210094, +0.379609, +1.215912, +0.373791,
+1.223184, +0.366519, +1.231911, +0.362156, +1.242092, +0.362156, +1.250818, +0.365065,
+1.258091, +0.370882, +1.259545, +0.381064, +1.262454, +0.388336, +1.266817, +0.386881,
+1.265363, +0.378155, +1.266817, +0.370882, +1.271181, +0.363610, +1.269727, +0.353429,
+1.268272, +0.344703, +1.271181, +0.335976, +1.274090, +0.331612, +1.271181, +0.325795,
+1.274090, +0.315614, +1.276999, +0.305433, +1.278453, +0.296706, +1.279907, +0.286525,
+1.282816, +0.279253, +1.287180, +0.270526, +1.292997, +0.261799, +1.298816, +0.253073,
+1.300270, +0.244346, 
/* zone 146 with 13 points. */
+1.201367, -0.852302, +1.207186, -0.859574, +1.202822, -0.866847, +1.213003, -0.863938,
+1.218821, -0.866847, +1.221730, -0.862483, +1.229002, -0.862483, +1.231911, -0.856666,
+1.221729, -0.858120, +1.215912, -0.859574, +1.210094, -0.855211, +1.204277, -0.849393,
+1.201367, -0.852302, 
/* zone 147 with 49 points. */
+1.850050, +1.345357, +1.819507, +1.345357, +1.851504, +1.351175, +1.816598, +1.356993,
+1.788963, +1.351175, +1.762784, +1.343903, +1.762784, +1.335176, +1.727877, +1.335176,
+1.735149, +1.329358, +1.687153, +1.326449, +1.692970, +1.332267, +1.653701, +1.327904,
+1.627521, +1.327904, +1.608613, +1.322086, +1.580978, +1.319178, +1.547524, +1.314814,
+1.527163, +1.308996, +1.511164, +1.303179, +1.509709, +1.297360, +1.518435, +1.290089,
+1.487892, +1.288634, +1.461713, +1.285726, +1.431170, +1.284271, +1.402081, +1.282816,
+1.410807, +1.272635, +1.410807, +1.263908, +1.434078, +1.261000, +1.445714, +1.253728,
+1.423897, +1.250819, +1.406444, +1.258091, +1.387536, +1.262454, +1.370083, +1.262454,
+1.356993, +1.266818, +1.343903, +1.262454, +1.367174, +1.256637, +1.356993, +1.253728,
+1.342448, +1.258091, +1.327904, +1.255182, +1.336631, +1.247910, +1.361356, +1.243546,
+1.370083, +1.239183, +1.342448, +1.242092, +1.314814, +1.245001, +1.314814, +1.253728,
+1.322086, +1.261000, +1.317723, +1.269727, +1.300270, +1.275544, +1.294452, +1.272635,
+1.310451, +1.268272, 
/* zone 148 with 11 points. */
+1.733695, +1.359901, +1.762784, +1.364265, +1.800599, +1.364265, +1.832597, +1.367174,
+1.832597, +1.375900, +1.813689, +1.381719, +1.786055, +1.386082, +1.767147, +1.383173,
+1.755511, +1.375900, +1.742421, +1.367174, +1.733695, +1.359901, 
/* zone 149 with 18 points. */
+1.591160, +1.397717, +1.602795, +1.390445, +1.637702, +1.387536, +1.652246, +1.380264,
+1.688607, +1.377355, +1.716241, +1.374446, +1.742421, +1.375900, +1.736604, +1.383173,
+1.748240, +1.390445, +1.732241, +1.396263, +1.703152, +1.399172, +1.692970, +1.404989,
+1.701697, +1.409352, +1.682790, +1.413716, +1.668244, +1.418079, +1.626066, +1.412262,
+1.617339, +1.404989, +1.591160, +1.397717, 
/* zone 150 with 157 points. */
+1.300270, +0.244346, +1.303179, +0.235619, +1.306087, +0.226893, +1.308996, +0.216712,
+1.313359, +0.209440, +1.319177, +0.202167, +1.323541, +0.194895, +1.326449, +0.186169,
+1.329358, +0.177442, +1.332267, +0.167261, +1.335176, +0.157080, +1.340994, +0.149807,
+1.346811, +0.143990, +1.354084, +0.141081, +1.361356, +0.145444, +1.364265, +0.155625,
+1.371537, +0.159988, +1.378809, +0.161443, +1.378809, +0.170170, +1.384627, +0.178896,
+1.393353, +0.178896, +1.393353, +0.189077, +1.391899, +0.196349, +1.391899, +0.205076,
+1.396263, +0.212348, +1.400626, +0.221075, +1.402081, +0.231256, +1.400626, +0.241437,
+1.399172, +0.251618, +1.397717, +0.261799, +1.399172, +0.269072, +1.403535, +0.276344,
+1.413716, +0.274889, +1.416625, +0.282162, +1.422442, +0.283616, +1.431170, +0.285070,
+1.435533, +0.289434, +1.436987, +0.296706, +1.441350, +0.299615, +1.448623, +0.303978,
+1.454440, +0.311250, +1.460258, +0.315614, +1.467530, +0.318523, +1.474803, +0.324340,
+1.480620, +0.331612, +1.484983, +0.337430, +1.492256, +0.343248, +1.499528, +0.344703,
+1.508255, +0.347611, +1.514072, +0.354883, +1.518435, +0.362156, +1.516981, +0.367974,
+1.519890, +0.373791, +1.528617, +0.376700, +1.535889, +0.379609, +1.538798, +0.385427,
+1.541707, +0.375246, +1.548979, +0.376700, +1.557706, +0.378155, +1.566432, +0.379609,
+1.575161, +0.381064, +1.580978, +0.386881, +1.586796, +0.391245, +1.595523, +0.397063,
+1.601340, +0.389790, +1.604250, +0.382518, +1.605704, +0.375246, +1.608613, +0.367974,
+1.614430, +0.360701, +1.621703, +0.353429, +1.626066, +0.347611, +1.631884, +0.347611,
+1.636248, +0.340339, +1.633338, +0.335976, +1.637702, +0.328704, +1.643519, +0.328704,
+1.646428, +0.319977, +1.649337, +0.309796, +1.650791, +0.299615, +1.647882, +0.289434,
+1.644974, +0.280707, +1.653701, +0.276344, +1.659518, +0.274889, +1.666790, +0.274889,
+1.672608, +0.280707, +1.679880, +0.285070, +1.688607, +0.289434, +1.691516, +0.295252,
+1.697333, +0.292343, +1.703152, +0.285070, +1.706060, +0.276344, +1.707515, +0.267617,
+1.708969, +0.257436, +1.711878, +0.248709, +1.714787, +0.238528, +1.720605, +0.228347,
+1.723514, +0.218166, +1.719151, +0.207985, +1.723514, +0.199258, +1.723514, +0.191986,
+1.719151, +0.186169, +1.719151, +0.177442, +1.719151, +0.167261, +1.714787, +0.157080,
+1.714787, +0.148353, +1.717696, +0.141081, +1.722059, +0.143990, +1.729331, +0.136717,
+1.735149, +0.127991, +1.740967, +0.122173, +1.746784, +0.116355, +1.751148, +0.106174,
+1.751148, +0.098902, +1.752603, +0.088721, +1.756966, +0.082903, +1.755511, +0.074176,
+1.761330, +0.065450, +1.768601, +0.058178, +1.770056, +0.049451, +1.778783, +0.043633,
+1.784600, +0.037816, +1.793326, +0.033452, +1.800599, +0.029089, +1.806417, +0.024726,
+1.819507, +0.024726, +1.816598, +0.034907, +1.810781, +0.045088, +1.804962, +0.050906,
+1.804962, +0.059632, +1.804962, +0.068359, +1.804962, +0.077085, +1.804962, +0.085812,
+1.799145, +0.094539, +1.791872, +0.100356, +1.784600, +0.106174, +1.777328, +0.111992,
+1.771510, +0.119264, +1.761329, +0.120719, +1.755511, +0.125082, +1.752603, +0.135263,
+1.749694, +0.143990, +1.743876, +0.149807, +1.742421, +0.161443, +1.733695, +0.159988,
+1.730786, +0.168715, +1.730786, +0.178896, +1.733695, +0.189077, +1.738058, +0.194895,
+1.740967, +0.203622, +1.743876, +0.210894, +1.743876, +0.222530, +1.745330, +0.232710,
+1.752603, +0.235619, +1.761329, +0.232710, +1.761330, +0.222530, +1.770056, +0.221075,
+1.777328, +0.221075, 
/* zone 151 with 6 points. */
+1.723514, -0.017453, +1.724968, -0.026180, +1.729331, -0.030543, +1.735149, -0.029089,
+1.727877, -0.015999, +1.723514, -0.017453, 
/* zone 152 with 19 points. */
+1.391899, +0.141081, +1.391899, +0.130900, +1.393353, +0.123627, +1.396263, +0.111992,
+1.400626, +0.104720, +1.407898, +0.104720, +1.418079, +0.107629, +1.425351, +0.113446,
+1.428261, +0.122173, +1.428261, +0.132354, +1.422442, +0.139626, +1.418079, +0.148353,
+1.412262, +0.157080, +1.406444, +0.165806, +1.396263, +0.171624, +1.399172, +0.164352,
+1.394808, +0.157080, +1.393353, +0.148353, +1.391899, +0.141081, 
/* zone 153 with 67 points. */
+1.663881, +0.098902, +1.665336, +0.090175, +1.669700, +0.082903, +1.676971, +0.075631,
+1.685699, +0.066904, +1.691516, +0.065450, +1.697333, +0.058178, +1.704606, +0.050906,
+1.707515, +0.042179, +1.716241, +0.037816, +1.724968, +0.031998, +1.724968, +0.026180,
+1.729331, +0.017453, +1.732241, +0.005818, +1.742421, +0.001454, +1.745330, -0.004363,
+1.752603, -0.011636, +1.754057, -0.018908, +1.759874, -0.029089, +1.761329, -0.036361,
+1.768601, -0.045088, +1.775873, -0.055269, +1.784600, -0.061087, +1.787509, -0.066904,
+1.794781, -0.074176, +1.806417, -0.082903, +1.815144, -0.088721, +1.822415, -0.097447,
+1.828234, -0.100356, +1.831142, -0.095993, +1.838414, -0.095993, +1.845687, -0.100356,
+1.847141, -0.091630, +1.848596, -0.081449, +1.848596, -0.072722, +1.848596, -0.061087,
+1.852959, -0.052360, +1.848596, -0.046542, +1.842777, -0.040724, +1.834051, -0.040724,
+1.831142, -0.033452, +1.825324, -0.029089, +1.822415, -0.017453, +1.812235, -0.017453,
+1.806417, -0.011636, +1.810781, -0.004363, +1.812235, +0.002909, +1.804962, +0.010181,
+1.797690, +0.010181, +1.799145, +0.018908, +1.791872, +0.020362, +1.784600, +0.029089,
+1.775873, +0.030543, +1.767147, +0.039270, +1.758420, +0.037816, +1.751148, +0.046542,
+1.745330, +0.055269, +1.736604, +0.061087, +1.727877, +0.065450, +1.720605, +0.071267,
+1.714787, +0.078540, +1.710423, +0.085812, +1.703152, +0.091630, +1.691516, +0.093084,
+1.681334, +0.093084, +1.674063, +0.098902, +1.663881, +0.098902, 
/* zone 154 with 6 points. */
+1.697333, +0.023271, +1.703152, +0.017453, +1.710423, +0.010181, +1.710423, +0.017453,
+1.701697, +0.026180, +1.697333, +0.023271, 
/* zone 155 with 33 points. */
+2.023186, +1.287180, +2.004161, +1.285784, +1.983915, +1.282817, +1.969254, +1.292939,
+1.977982, +1.298874, +1.956164, +1.300270, +1.947438, +1.297302, +1.969254, +1.292939,
+1.972221, +1.285784, +1.954768, +1.285784, +1.940282, +1.288576, +1.922829, +1.291543,
+1.911136, +1.287180, +1.922829, +1.282817, +1.899442, +1.279849, +1.877625, +1.277057,
+1.858775, +1.277057, +1.870469, +1.284213, +1.890715, +1.287180, +1.914103, +1.294510,
+1.937315, +1.300270, +1.963495, +1.307600, +1.983915, +1.313360, +1.986708, +1.322086,
+1.980948, +1.329417, +1.962099, +1.335176, +1.940282, +1.338143, +1.912531, +1.339540,
+1.887922, +1.339540, +1.881988, +1.335176, +1.857379, +1.335176, +1.876228, +1.343904,
+1.850049, +1.345299, 
/* zone 156 with 69 points. */
+1.777268, +0.221133, +1.784599, +0.213803, +1.790359, +0.210836, +1.794722, +0.205076,
+1.797688, +0.197746, +1.802052, +0.190590, +1.809382, +0.184656, +1.819506, +0.184656,
+1.823869, +0.178896, +1.832596, +0.175929, +1.829628, +0.167203, +1.829628, +0.158476,
+1.832596, +0.151320, +1.839926, +0.157080, +1.847081, +0.162839, +1.855808, +0.164410,
+1.861742, +0.171566, +1.861742, +0.181863, +1.871865, +0.181863, +1.879195, +0.186227,
+1.886352, +0.190590, +1.893682, +0.194953, +1.902409, +0.199317, +1.905375, +0.205076,
+1.905375, +0.212407, +1.906772, +0.223926, +1.906772, +0.231256, +1.906772, +0.239983,
+1.905375, +0.248709, +1.902409, +0.257436, +1.899442, +0.267559, +1.892285, +0.274889,
+1.886352, +0.282220, +1.879195, +0.287979, +1.870469, +0.295310, +1.864534, +0.302465,
+1.857379, +0.309796, +1.855808, +0.315555, +1.848653, +0.321490, +1.842718, +0.331613,
+1.845685, +0.340339, +1.848653, +0.347670, +1.857379, +0.353429, +1.861742, +0.360760,
+1.868898, +0.366519, +1.877625, +0.370883, +1.884955, +0.375246, +1.893682, +0.378213,
+1.902409, +0.378213, +1.909739, +0.373850, +1.915499, +0.373850, +1.914103, +0.366519,
+1.915499, +0.362156, +1.918466, +0.354825, +1.924225, +0.354825, +1.928589, +0.357792,
+1.924225, +0.365123, +1.927193, +0.370883, +1.935919, +0.373850, +1.946042, +0.375246,
+1.954768, +0.379609, +1.963495, +0.381005, +1.972221, +0.383972, +1.973618, +0.392699,
+1.980948, +0.386939, +1.983915, +0.395666, +1.992642, +0.388336, +1.998402, +0.395666,
+2.007129, +0.395666, 
/* zone 157 with 27 points. */
+1.807812, +0.900241, +1.823869, +0.895877, +1.836959, +0.898845, +1.848653, +0.901812,
+1.854412, +0.910538, +1.867502, +0.916298, +1.881988, +0.919265, +1.890715, +0.925025,
+1.902409, +0.933751, +1.909739, +0.942478, +1.911136, +0.951204, +1.914103, +0.961327,
+1.918466, +0.970054, +1.911136, +0.973021, +1.906772, +0.968658, +1.905375, +0.962898,
+1.899442, +0.955568, +1.893682, +0.948237, +1.887922, +0.941082, +1.877625, +0.933751,
+1.867502, +0.926421, +1.860171, +0.920661, +1.851445, +0.916298, +1.844289, +0.910538,
+1.836959, +0.904604, +1.823869, +0.903208, +1.807812, +0.900241, 
/* zone 158 with 15 points. */
+1.896649, +0.337372, +1.896649, +0.330216, +1.898046, +0.322886, +1.906772, +0.318523,
+1.914103, +0.318523, +1.922829, +0.322886, +1.928589, +0.328645, +1.931556, +0.337372,
+1.937315, +0.343306, +1.937315, +0.349066, +1.928589, +0.349066, +1.919862, +0.349066,
+1.912531, +0.347670, +1.903805, +0.341735, +1.896649, +0.337372, 
/* zone 159 with 43 points. */
+1.841322, -0.116413, +1.850049, -0.117810, +1.860171, -0.122173, +1.858775, -0.126536,
+1.867502, -0.127933, +1.877625, -0.129503, +1.884955, -0.133867, +1.895078, -0.135263,
+1.902409, -0.133867, +1.912531, -0.133867, +1.919862, -0.135263, +1.928589, -0.139626,
+1.937315, -0.141023, +1.946042, -0.142593, +1.954768, -0.142593, +1.963495, -0.145386,
+1.973618, -0.142593, +1.982345, -0.145386, +1.989676, -0.148353, +1.997005, -0.149749,
+1.997005, -0.142593, +1.997005, -0.133867, +1.988278, -0.132296, +1.979552, -0.133867,
+1.969254, -0.130900, +1.967858, -0.123569, +1.962099, -0.119206, +1.953372, -0.117810,
+1.943074, -0.114843, +1.934348, -0.110479, +1.928589, -0.119206, +1.921258, -0.119206,
+1.912531, -0.117810, +1.903805, -0.117810, +1.896649, -0.116413, +1.892285, -0.109083,
+1.883559, -0.107687, +1.874832, -0.103323, +1.868898, -0.101753, +1.861742, -0.104720,
+1.851445, -0.101753, +1.847081, -0.110479, +1.841322, -0.116413, 
/* zone 160 with 33 points. */
+2.024582, -0.155683, +2.033308, -0.155683, +2.045002, -0.158476, +2.053729, -0.157080,
+2.060884, -0.154113, +2.068214, -0.152716, +2.076941, -0.151320, +2.085669, -0.149749,
+2.094395, -0.152716, +2.103122, -0.152716, +2.111848, -0.154113, +2.120575, -0.152716,
+2.129301, -0.154113, +2.136632, -0.151320, +2.146754, -0.148353, +2.158448, -0.145386,
+2.145358, -0.142593, +2.136632, -0.151320, +2.129301, -0.146957, +2.120575, -0.148353,
+2.111848, -0.145386, +2.103122, -0.142593, +2.094395, -0.145386, +2.085669, -0.149749,
+2.076941, -0.143990, +2.066818, -0.143990, +2.055125, -0.141023, +2.059488, -0.148353,
+2.052157, -0.146957, +2.042035, -0.146957, +2.033308, -0.143990, +2.025978, -0.146957,
+2.024582, -0.155683, 
/* zone 161 with 10 points. */
+2.076941, -0.164410, +2.079908, -0.170170, +2.088635, -0.170170, +2.094395, -0.173137,
+2.101726, -0.178896, +2.110452, -0.174533, +2.103122, -0.167203, +2.094395, -0.162839,
+2.085669, -0.162839, +2.076941, -0.164410, 
/* zone 162 with 11 points. */
+1.836959, -0.033510, +1.845685, -0.034907, +1.850049, -0.039270, +1.848653, -0.046600,
+1.861742, -0.052360, +1.863139, -0.043633, +1.857379, -0.042237, +1.854412, -0.034907,
+1.850049, -0.026180, +1.841322, -0.027576, +1.836959, -0.033510, 
/* zone 163 with 5 points. */
+1.879195, -0.053756, +1.886352, -0.055327, +1.890715, -0.046600, +1.880592, -0.043633,
+1.879195, -0.053756, 
/* zone 164 with 5 points. */
+1.972221, -0.122173, +1.980948, -0.122173, +1.989676, -0.122173, +1.980948, -0.127409,
+1.972221, -0.122173, 
/* zone 165 with 72 points. */
+1.901012, +0.017453, +1.902409, +0.007330, +1.906772, +0.001396, +1.906772, -0.007330,
+1.915499, -0.013090, +1.921258, -0.021817, +1.921258, -0.030543, +1.924225, -0.040666,
+1.925621, -0.050964, +1.935919, -0.052360, +1.944646, -0.050964, +1.950405, -0.047997,
+1.951801, -0.061087, +1.960527, -0.058119, +1.969254, -0.058119, +1.976585, -0.053756,
+1.986708, -0.059690, +1.995435, -0.058119, +2.001369, -0.064054, +2.002765, -0.071209,
+2.010096, -0.068417, +2.018822, -0.064054, +2.027549, -0.059690, +2.030341, -0.050964,
+2.036275, -0.039270, +2.030341, -0.030543, +2.037672, -0.023213, +2.045002, -0.017453,
+2.049365, -0.010123, +2.050761, +0.000000, +2.053729, +0.008727, +2.058092, +0.014486,
+2.066818, +0.014486, +2.076941, +0.016057, +2.071182, +0.021817, +2.063851, +0.027576,
+2.056521, +0.034907, +2.060884, +0.040666, +2.055125, +0.047997, +2.050761, +0.056723,
+2.056521, +0.064054, +2.058092, +0.074176, +2.069611, +0.077143, +2.063851, +0.084299,
+2.072578, +0.087266, +2.081305, +0.090234, +2.072578, +0.094597, +2.063851, +0.100356,
+2.055125, +0.103323, +2.055125, +0.112050, +2.046398, +0.117810, +2.042035, +0.122173,
+2.036275, +0.114843, +2.027549, +0.109083, +2.024582, +0.101753, +2.014459, +0.093026,
+2.014459, +0.085870, +2.002765, +0.085870, +1.994039, +0.081507, +1.985312, +0.071209,
+1.977982, +0.065450, +1.973618, +0.058119, +1.964891, +0.052360, +1.954768, +0.050964,
+1.946042, +0.049393, +1.943074, +0.039270, +1.938711, +0.027576, +1.929984, +0.029147,
+1.919862, +0.030543, +1.911136, +0.034907, +1.903805, +0.027576, +1.901012, +0.017453, 
/* zone 166 with 6 points. */
+1.997005, -0.142593, +2.004161, -0.145386, +2.010096, -0.151320, +2.018822, -0.143990,
+2.011492, -0.139626, +1.997005, -0.142593, 
/* zone 167 with 4 points. */
+2.169968, -0.146957, +2.184628, -0.143990, +2.172935, -0.141023, +2.169968, -0.146957, 
/* zone 168 with 5 points. */
+2.196147, -0.138230, +2.206445, -0.138230, +2.210808, -0.130900, +2.199115, -0.132296,
+2.196147, -0.138230, 
/* zone 169 with 17 points. */
+2.274746, +1.237729, +2.258747, +1.245001, +2.247111, +1.253728, +2.260201, +1.261000,
+2.266019, +1.269727, +2.244203, +1.278453, +2.215114, +1.281363, +2.178753, +1.285726,
+2.146755, +1.285726, +2.143846, +1.279907, +2.152573, +1.274090, +2.129303, +1.272635,
+2.094396, +1.274090, +2.068216, +1.276999, +2.071125, +1.284271, +2.046399, +1.284271,
+2.023129, +1.287180, 
/* zone 170 with 133 points. */
+2.007130, +0.395608, +2.015857, +0.397063, +2.024583, +0.398517, +2.033310, +0.402880,
+2.042036, +0.408698, +2.049309, +0.413061, +2.056581, +0.418879, +2.062399, +0.423242,
+2.062399, +0.429060, +2.071125, +0.429060, +2.074034, +0.436332, +2.079852, +0.440696,
+2.084215, +0.446513, +2.088578, +0.453786, +2.090033, +0.459603, +2.088578, +0.466875,
+2.094397, +0.465421, +2.100214, +0.471239, +2.104577, +0.478511, +2.108940, +0.485783,
+2.113304, +0.491601, +2.119122, +0.491601, +2.122030, +0.495964, +2.120576, +0.500328,
+2.123485, +0.509054, +2.127849, +0.509054, +2.129303, +0.519235, +2.130757, +0.523599,
+2.123485, +0.525053, +2.117667, +0.527962, +2.107486, +0.526508, +2.101668, +0.529416,
+2.110395, +0.530871, +2.114758, +0.535234, +2.120576, +0.538143, +2.127849, +0.539598,
+2.126393, +0.545415, +2.116213, +0.552688, +2.126393, +0.552688, +2.123485, +0.559960,
+2.116213, +0.565778, +2.110395, +0.568686, +2.108940, +0.575959, +2.106031, +0.583231,
+2.103123, +0.590503, +2.100214, +0.599230, +2.090033, +0.603593, +2.079852, +0.607956,
+2.084215, +0.615228, +2.088578, +0.621046, +2.097305, +0.626864, +2.106031, +0.631227,
+2.108940, +0.638500, +2.120576, +0.641408, +2.129303, +0.645772, +2.135120, +0.642863,
+2.139483, +0.651590, +2.130757, +0.653044, +2.122030, +0.653044, +2.114758, +0.654499,
+2.108940, +0.658862, +2.100214, +0.655953, +2.094396, +0.651590, +2.090033, +0.647226,
+2.082761, +0.647226, +2.075488, +0.651590, +2.074034, +0.658862, +2.065308, +0.663225,
+2.058035, +0.667588, +2.052217, +0.673406, +2.053672, +0.679224, +2.059489, +0.685042,
+2.066762, +0.682133, +2.076942, +0.683587, +2.081306, +0.687951, +2.084215, +0.693768,
+2.092942, +0.698132, +2.101668, +0.701041, +2.108940, +0.708313, +2.116213, +0.714131,
+2.127849, +0.712676, +2.133666, +0.705404, +2.127849, +0.698132, +2.120576, +0.693768,
+2.117667, +0.689405, +2.123485, +0.683587, +2.114758, +0.676315, +2.122030, +0.677769,
+2.130757, +0.682133, +2.136575, +0.687951, +2.146755, +0.690859, +2.155482, +0.693768,
+2.165663, +0.695223, +2.175844, +0.692314, +2.183116, +0.690859, +2.188934, +0.687951,
+2.184570, +0.679224, +2.181662, +0.671952, +2.177299, +0.664680, +2.187479, +0.657408,
+2.200569, +0.658862, +2.209296, +0.653044, +2.212205, +0.645772, +2.202024, +0.644317,
+2.207842, +0.634136, +2.212205, +0.623955, +2.204932, +0.616683, +2.204932, +0.607956,
+2.209296, +0.599230, +2.219478, +0.605048, +2.229658, +0.607956, +2.242748, +0.609411,
+2.252930, +0.613774, +2.257293, +0.621046, +2.258747, +0.628318, +2.258747, +0.637045,
+2.257293, +0.645772, +2.254384, +0.654499, +2.248566, +0.661771, +2.242748, +0.667588,
+2.238385, +0.674861, +2.231112, +0.680678, +2.222385, +0.685042, +2.225295, +0.690859,
+2.222385, +0.695223, +2.231112, +0.696677, +2.238385, +0.699586, +2.247111, +0.703950,
+2.255838, +0.709767, +2.263111, +0.712676, +2.263111, +0.721403, +2.261656, +0.725766,
+2.270383, +0.734493, 
/* zone 171 with 46 points. */
+2.091487, +0.283616, +2.092942, +0.273435, +2.094396, +0.266163, +2.095850, +0.257436,
+2.104577, +0.251618, +2.106031, +0.257436, +2.111850, +0.253073, +2.106031, +0.247255,
+2.106031, +0.239983, +2.116213, +0.237074, +2.124939, +0.242892, +2.132212, +0.238528,
+2.140939, +0.228347, +2.140938, +0.235619, +2.139483, +0.241437, +2.148210, +0.237074,
+2.154028, +0.226893, +2.161300, +0.223984, +2.167117, +0.225438, +2.159845, +0.232710,
+2.156936, +0.238528, +2.162754, +0.239983, +2.152573, +0.244346, +2.145301, +0.247255,
+2.139483, +0.247255, +2.133666, +0.242892, +2.126393, +0.245800, +2.123485, +0.254527,
+2.119122, +0.266163, +2.122030, +0.274889, +2.129303, +0.282162, +2.135120, +0.289434,
+2.138029, +0.298160, +2.132212, +0.303978, +2.132212, +0.312705, +2.135120, +0.322886,
+2.127849, +0.318523, +2.120576, +0.319977, +2.113304, +0.324340, +2.106031, +0.322886,
+2.103123, +0.314159, +2.100214, +0.306887, +2.103123, +0.299615, +2.100214, +0.289434,
+2.100214, +0.280707, +2.091487, +0.283616, 
/* zone 172 with 14 points. */
+2.046399, +0.146899, +2.058035, +0.152716, +2.062399, +0.158534, +2.069671, +0.164352,
+2.074034, +0.173079, +2.079852, +0.175987, +2.088578, +0.183260, +2.085670, +0.196349,
+2.079852, +0.183260, +2.072579, +0.174533, +2.066762, +0.168715, +2.058035, +0.161443,
+2.050763, +0.155625, +2.046399, +0.146899, 
/* zone 173 with 9 points. */
+2.101668, +0.234165, +2.107486, +0.226893, +2.110395, +0.218166, +2.114758, +0.212348,
+2.122030, +0.218166, +2.122030, +0.226893, +2.116213, +0.232710, +2.108940, +0.234165,
+2.101668, +0.234165, 
/* zone 174 with 17 points. */
+2.170026, +0.218166, +2.172935, +0.209440, +2.181662, +0.205076, +2.178753, +0.197804,
+2.171480, +0.199258, +2.171480, +0.189077, +2.177299, +0.187623, +2.177299, +0.177442,
+2.186026, +0.178896, +2.181662, +0.186169, +2.181662, +0.193441, +2.193297, +0.193441,
+2.190389, +0.203622, +2.190389, +0.210894, +2.186026, +0.218166, +2.177299, +0.216712,
+2.170026, +0.218166, 
/* zone 175 with 28 points. */
+2.127849, +0.183260, +2.138029, +0.184714, +2.143847, +0.181805, +2.143847, +0.174533,
+2.136575, +0.170170, +2.140938, +0.162897, +2.146755, +0.157080, +2.152573, +0.161443,
+2.149664, +0.170170, +2.155482, +0.167261, +2.159845, +0.173079, +2.164208, +0.167261,
+2.172935, +0.168715, +2.172935, +0.175987, +2.164208, +0.177442, +2.164208, +0.184714,
+2.164208, +0.193441, +2.161300, +0.186169, +2.154028, +0.181805, +2.155482, +0.189077,
+2.148210, +0.190532, +2.149664, +0.200713, +2.139483, +0.200713, +2.138029, +0.205076,
+2.127849, +0.206531, +2.130757, +0.199258, +2.129303, +0.190532, +2.127849, +0.183260, 
/* zone 176 with 43 points. */
+2.129303, +0.125082, +2.130757, +0.119264, +2.133666, +0.126536, +2.138029, +0.133809,
+2.143846, +0.135263, +2.145301, +0.127991, +2.151118, +0.129445, +2.156936, +0.135263,
+2.164208, +0.132354, +2.168571, +0.127991, +2.164208, +0.122173, +2.164208, +0.111992,
+2.170026, +0.107629, +2.177299, +0.103265, +2.183116, +0.103265, +2.188934, +0.097447,
+2.194752, +0.106174, +2.191843, +0.111992, +2.187480, +0.117810, +2.190389, +0.122173,
+2.194752, +0.127991, +2.199115, +0.120719, +2.202024, +0.110537, +2.204932, +0.119264,
+2.209296, +0.126536, +2.209296, +0.133809, +2.204932, +0.143990, +2.204932, +0.154171,
+2.199115, +0.162897, +2.188934, +0.170170, +2.190389, +0.158534, +2.184570, +0.154171,
+2.178753, +0.157080, +2.175844, +0.148353, +2.168571, +0.146899, +2.162754, +0.141081,
+2.161300, +0.148353, +2.155482, +0.151262, +2.148210, +0.148353, +2.143847, +0.142535,
+2.135120, +0.139626, +2.130757, +0.135263, +2.129303, +0.125082, 
/* zone 177 with 18 points. */
+2.155482, -0.180351, +2.164208, -0.178896, +2.172935, -0.175987, +2.180207, -0.167261,
+2.188934, -0.161443, +2.197660, -0.158534, +2.206388, -0.155625, +2.215114, -0.151262,
+2.220932, -0.145444, +2.212205, -0.145444, +2.203478, -0.146899, +2.193297, -0.148353,
+2.183116, -0.151262, +2.178753, -0.157080, +2.170026, -0.159988, +2.162754, -0.162897,
+2.158391, -0.168715, +2.155482, -0.180351, 
/* zone 178 with 79 points. */
+2.074034, -0.049451, +2.076942, -0.061087, +2.085670, -0.061087, +2.088578, -0.069813,
+2.087124, -0.079994, +2.084215, -0.090175, +2.085670, -0.097447, +2.092942, -0.097447,
+2.101668, -0.095993, +2.100214, -0.087266, +2.101668, -0.078540, +2.101668, -0.069813,
+2.101668, -0.061087, +2.098760, -0.052360, +2.106031, -0.046542, +2.113304, -0.046542,
+2.113304, -0.052360, +2.110395, -0.059632, +2.114758, -0.066904, +2.123485, -0.071267,
+2.122030, -0.081449, +2.129303, -0.084357, +2.135120, -0.079994, +2.135120, -0.093084,
+2.140938, -0.098902, +2.149664, -0.093084, +2.149664, -0.082903, +2.143847, -0.075631,
+2.138029, -0.066904, +2.130757, -0.061087, +2.136575, -0.055269, +2.132212, -0.047997,
+2.127849, -0.042179, +2.120576, -0.033452, +2.130757, -0.029089, +2.138029, -0.023271,
+2.145301, -0.015999, +2.155482, -0.015999, +2.149664, -0.010181, +2.139483, -0.013090,
+2.130757, -0.015999, +2.122030, -0.015999, +2.114758, -0.023271, +2.106031, -0.023271,
+2.104577, -0.015999, +2.095850, -0.011636, +2.095850, -0.001454, +2.100214, +0.007272,
+2.106031, +0.008727, +2.111850, +0.007272, +2.119122, +0.008727, +2.129303, +0.008727,
+2.138029, +0.008727, +2.146755, +0.008727, +2.155482, +0.005818, +2.164208, +0.007272,
+2.174390, +0.010181, +2.181662, +0.018908, +2.186026, +0.026180, +2.181662, +0.030543,
+2.177299, +0.026180, +2.171480, +0.020362, +2.162754, +0.015999, +2.152573, +0.015999,
+2.145301, +0.014544, +2.138029, +0.017453, +2.129303, +0.018908, +2.119122, +0.020362,
+2.110395, +0.023271, +2.106031, +0.013090, +2.094396, +0.013090, +2.092942, +0.007272,
+2.091487, -0.001454, +2.091487, -0.010181, +2.085670, -0.015999, +2.082761, -0.023271,
+2.082761, -0.033452, +2.079852, -0.042179, +2.074034, -0.049451, 
/* zone 179 with 16 points. */
+2.097305, +0.413061, +2.097305, +0.404335, +2.100214, +0.394154, +2.106031, +0.391245,
+2.108940, +0.383972, +2.111850, +0.394154, +2.117667, +0.401426, +2.120576, +0.410152,
+2.123485, +0.420334, +2.127849, +0.429060, +2.127849, +0.437787, +2.122030, +0.440696,
+2.113304, +0.436332, +2.107486, +0.429060, +2.103123, +0.421788, +2.097305, +0.413061, 
/* zone 180 with 291 points. */
+2.010038, -0.596321, +2.018765, -0.599230, +2.026037, -0.607956, +2.036219, -0.610865,
+2.044945, -0.610865, +2.055126, -0.610865, +2.065308, -0.610865, +2.069671, -0.606502,
+2.076942, -0.600684, +2.084215, -0.600684, +2.090033, -0.593412, +2.095850, -0.591958,
+2.107486, -0.590503, +2.117667, -0.590503, +2.127849, -0.590503, +2.139483, -0.590503,
+2.148210, -0.590503, +2.156936, -0.590503, +2.164208, -0.584685, +2.165663, -0.575959,
+2.177299, -0.573050, +2.186026, -0.570141, +2.196206, -0.564323, +2.203478, -0.561414,
+2.215114, -0.562869, +2.225295, -0.561414, +2.234021, -0.559960, +2.244203, -0.555596,
+2.252930, -0.552688, +2.263111, -0.551233, +2.274746, -0.551233, +2.283473, -0.551233,
+2.292199, -0.551233, +2.300926, -0.554142, +2.308198, -0.558505, +2.318379, -0.558505,
+2.328560, -0.561414, +2.337287, -0.564323, +2.344559, -0.568686, +2.341650, -0.575959,
+2.353286, -0.580322, +2.356194, -0.589049, +2.360558, -0.596321, +2.363466, -0.603593,
+2.367830, -0.610865, +2.372193, -0.603593, +2.379465, -0.597775, +2.386738, -0.591958,
+2.395464, -0.587594, +2.399828, -0.578868, +2.405645, -0.573050, +2.407100, -0.586140,
+2.401282, -0.593412, +2.399828, -0.602139, +2.398374, -0.607956, +2.391101, -0.610865,
+2.389647, -0.615228, +2.396918, -0.613774, +2.404191, -0.613774, +2.407100, -0.606502,
+2.410008, -0.597775, +2.415827, -0.605048, +2.418736, -0.610865, +2.415827, -0.618137,
+2.411463, -0.622501, +2.423099, -0.621046, +2.431825, -0.626864, +2.437643, -0.634136,
+2.442006, -0.641408, +2.439097, -0.645772, +2.442006, -0.651590, +2.447824, -0.657408,
+2.455096, -0.663225, +2.463823, -0.664680, +2.468186, -0.670497, +2.474004, -0.667588,
+2.482731, -0.669043, +2.490003, -0.670497, +2.497275, -0.674861, +2.504547, -0.677769,
+2.513274, -0.671952, +2.520546, -0.667588, +2.527819, -0.660316, +2.530727, -0.670497,
+2.539454, -0.667588, +2.540908, -0.674861, +2.548181, -0.679224, +2.555453, -0.683587,
+2.562725, -0.674861, +2.569997, -0.670497, +2.580178, -0.664680, +2.585996, -0.661771,
+2.596177, -0.660316, +2.607813, -0.660316, +2.616539, -0.655953, +2.617993, -0.648681,
+2.617993, -0.641409, +2.620903, -0.632682, +2.622357, -0.623955, +2.628175, -0.615228,
+2.632538, -0.609411, +2.636902, -0.599230, +2.641265, -0.590503, +2.644174, -0.583231,
+2.649991, -0.575959, +2.657264, -0.571595, +2.661627, -0.564323, +2.665991, -0.557051,
+2.668900, -0.549779, +2.671808, -0.541052, +2.671808, -0.533780, +2.676171, -0.523599,
+2.677626, -0.514872, +2.679080, -0.506145, +2.681989, -0.500328, +2.679080, -0.491601,
+2.676171, -0.481420, +2.673263, -0.472693, +2.671808, -0.462512, +2.671808, -0.455240,
+2.667444, -0.445059, +2.663081, -0.437787, +2.655809, -0.429060, +2.649991, -0.420334,
+2.641265, -0.417425, +2.635448, -0.411607, +2.632538, -0.404335, +2.632538, -0.395608,
+2.625266, -0.391245, +2.617993, -0.385427, +2.613630, -0.391245, +2.609267, -0.382518,
+2.606359, -0.373791, +2.603450, -0.367974, +2.597631, -0.363610, +2.597631, -0.356338,
+2.588904, -0.351975, +2.580178, -0.346157, +2.574361, -0.338885, +2.565634, -0.337430,
+2.555453, -0.331612, +2.553998, -0.325795, +2.549635, -0.319977, +2.551089, -0.311250,
+2.549635, -0.302524, +2.545272, -0.296706, +2.539454, -0.289434, +2.539454, -0.279253,
+2.536545, -0.270526, +2.536545, -0.261799, +2.529273, -0.255982, +2.523455, -0.250164,
+2.514729, -0.253073, +2.508911, -0.250164, +2.506001, -0.239983, +2.506001, -0.231256,
+2.501638, -0.221075, +2.497275, -0.212348, +2.494367, -0.203622, +2.492912, -0.193441,
+2.485640, -0.189077, +2.479822, -0.196349, +2.479822, -0.206531, +2.474004, -0.212348,
+2.474004, -0.221075, +2.474004, -0.226893, +2.472549, -0.237074, +2.471095, -0.245800,
+2.471095, -0.254527, +2.472549, -0.263254, +2.471095, -0.271980, +2.469641, -0.280707,
+2.465278, -0.289434, +2.460914, -0.296706, +2.460914, -0.305433, +2.452188, -0.309796,
+2.443460, -0.311250, +2.433280, -0.303978, +2.428917, -0.296706, +2.420190, -0.293797,
+2.410008, -0.289434, +2.404191, -0.285070, +2.396918, -0.279253, +2.383828, -0.279253,
+2.380919, -0.270526, +2.373648, -0.267617, +2.366375, -0.261799, +2.369285, -0.254527,
+2.373648, -0.248709, +2.373648, -0.241437, +2.373648, -0.232710, +2.383829, -0.232710,
+2.385283, -0.223984, +2.391101, -0.216712, +2.382374, -0.210894, +2.375102, -0.219620,
+2.370739, -0.212348, +2.360558, -0.215257, +2.350377, -0.212348, +2.340196, -0.209440,
+2.330015, -0.207985, +2.321288, -0.202167, +2.309652, -0.199258, +2.315471, -0.206531,
+2.311107, -0.215257, +2.299472, -0.215257, +2.287836, -0.215257, +2.277655, -0.222530,
+2.273292, -0.229802, +2.276200, -0.237074, +2.267474, -0.238528, +2.264565, -0.245800,
+2.257293, -0.253073, +2.266019, -0.258890, +2.263111, -0.266163, +2.252930, -0.260345,
+2.245657, -0.260345, +2.236931, -0.266163, +2.236931, -0.257436, +2.231112, -0.251618,
+2.223841, -0.244346, +2.213659, -0.242892, +2.209296, -0.248709, +2.200569, -0.250164,
+2.197660, -0.255982, +2.186026, -0.255982, +2.184570, -0.263254, +2.175844, -0.270526,
+2.174390, -0.279253, +2.170026, -0.286525, +2.159845, -0.282162, +2.156936, -0.290888,
+2.162754, -0.296706, +2.155482, -0.305433, +2.151118, -0.298160, +2.146755, -0.287979,
+2.139483, -0.296706, +2.132212, -0.303978, +2.133666, -0.311250, +2.135120, -0.317068,
+2.127849, -0.324340, +2.123485, -0.333067, +2.117667, -0.338885, +2.110395, -0.344703,
+2.100214, -0.346157, +2.090033, -0.349066, +2.079852, -0.349066, +2.072579, -0.354883,
+2.063852, -0.354883, +2.055126, -0.360701, +2.046399, -0.360701, +2.037673, -0.360701,
+2.028946, -0.363610, +2.021674, -0.367974, +2.015857, -0.375246, +2.008584, -0.378155,
+1.999857, -0.382518, +1.995494, -0.389790, +1.991131, -0.381064, +1.986768, -0.388336,
+1.983859, -0.395608, +1.986768, -0.402880, +1.986768, -0.410152, +1.979495, -0.417425,
+1.980949, -0.426151, +1.983859, -0.436332, +1.988222, -0.443605, +1.992585, -0.450877,
+1.992585, -0.461058, +1.985313, -0.455240, +1.980949, -0.447968, +1.986768, -0.463966,
+1.978041, -0.456695, +1.980949, -0.465421, +1.988222, -0.471239, +1.992585, -0.482874,
+1.992585, -0.490146, +1.999857, -0.498873, +2.005675, -0.507600, +2.007130, -0.514872,
+2.007130, -0.523599, +2.010038, -0.532325, +2.014401, -0.541052, +2.017311, -0.548324,
+2.021674, -0.554142, +2.021674, -0.564323, +2.020220, -0.574504, +2.021674, -0.580322,
+2.017311, -0.584685, +2.010038, -0.586140, +2.010038, -0.596321, 
/* zone 181 with 7 points. */
+2.383829, -0.626864, +2.388192, -0.631227, +2.401282, -0.631227, +2.410008, -0.626864,
+2.398374, -0.622501, +2.388192, -0.623955, +2.383829, -0.626864, 
/* zone 182 with 23 points. */
+2.527819, -0.709767, +2.527819, -0.718494, +2.530727, -0.728675, +2.535090, -0.735947,
+2.536545, -0.741765, +2.539454, -0.749037, +2.543818, -0.754855, +2.552544, -0.759218,
+2.562725, -0.760673, +2.568542, -0.753401, +2.574361, -0.747583, +2.581633, -0.751946,
+2.583087, -0.743219, +2.585997, -0.735947, +2.588904, -0.733038, +2.588904, -0.724312,
+2.588904, -0.715585, +2.583087, -0.712676, +2.571451, -0.715585, +2.561271, -0.718494,
+2.551089, -0.718494, +2.539454, -0.712676, +2.527819, -0.709767, 
/* zone 183 with 121 points. */
+2.283473, -0.023271, +2.293653, -0.026180, +2.300926, -0.027634, +2.300926, -0.034907,
+2.308198, -0.039270, +2.316925, -0.039270, +2.325651, -0.037816, +2.335833, -0.034907,
+2.332924, -0.043633, +2.322742, -0.043633, +2.315471, -0.047997, +2.306744, -0.046542,
+2.302381, -0.049451, +2.308198, -0.050906, +2.315471, -0.056723, +2.316925, -0.062541,
+2.318379, -0.069813, +2.325651, -0.069813, +2.332924, -0.061087, +2.340196, -0.066904,
+2.348923, -0.071267, +2.356194, -0.075631, +2.366375, -0.077085, +2.376556, -0.079994,
+2.386738, -0.084357, +2.396918, -0.087266, +2.405645, -0.091630, +2.411463, -0.097447,
+2.415827, -0.107629, +2.418736, -0.117810, +2.421644, -0.126536, +2.412917, -0.127991,
+2.408554, -0.135263, +2.402737, -0.145444, +2.412917, -0.145444, +2.423099, -0.141081,
+2.433280, -0.141081, +2.443460, -0.139626, +2.447824, -0.145444, +2.453642, -0.151262,
+2.460915, -0.157080, +2.469641, -0.158534, +2.478368, -0.158534, +2.488548, -0.161443,
+2.498730, -0.157080, +2.501638, -0.152716, +2.498730, -0.145444, +2.506001, -0.142535,
+2.510365, -0.138172, +2.516183, -0.130900, +2.524910, -0.130900, +2.530727, -0.133809,
+2.540908, -0.138172, +2.548181, -0.139626, +2.552544, -0.148353, +2.556908, -0.155625,
+2.565634, -0.162897, +2.572906, -0.168715, +2.575815, -0.174533, +2.584541, -0.175987,
+2.594723, -0.177442, +2.604904, -0.178896, +2.613630, -0.180351, +2.617993, -0.186169,
+2.628175, -0.184714, +2.631083, -0.177442, +2.620903, -0.175987, +2.613630, -0.173079,
+2.617993, -0.167261, +2.610722, -0.167261, +2.601995, -0.164352, +2.604904, -0.157080,
+2.593268, -0.158534, +2.587450, -0.149807, +2.585996, -0.139626, +2.577270, -0.135263,
+2.568542, -0.126536, +2.565634, -0.119264, +2.572906, -0.117810, +2.580178, -0.116355,
+2.580178, -0.107629, +2.572906, -0.101811, +2.562725, -0.103265, +2.552544, -0.097447,
+2.543818, -0.095993, +2.543818, -0.085812, +2.537999, -0.078540, +2.530727, -0.074176,
+2.522000, -0.068359, +2.513274, -0.063995, +2.504547, -0.059632, +2.495821, -0.058178,
+2.485640, -0.053814, +2.478368, -0.050906, +2.469641, -0.047997, +2.460914, -0.045088,
+2.450733, -0.040724, +2.443460, -0.040724, +2.434734, -0.037816, +2.426007, -0.034907,
+2.415827, -0.029089, +2.407100, -0.024726, +2.395464, -0.029089, +2.391101, -0.036361,
+2.382375, -0.037816, +2.375102, -0.045088, +2.370739, -0.050906, +2.366375, -0.058178,
+2.359103, -0.058178, +2.351831, -0.052360, +2.348923, -0.043633, +2.341650, -0.040724,
+2.338741, -0.031998, +2.341650, -0.023271, +2.337287, -0.011636, +2.325651, -0.011636,
+2.318379, -0.005818, +2.306744, -0.005818, +2.300926, -0.011636, +2.290745, -0.014544,
+2.283473, -0.023271, 
/* zone 184 with 8 points. */
+2.270383, -0.206531, +2.280564, -0.206531, +2.286382, -0.209440, +2.295108, -0.202167,
+2.292199, -0.197804, +2.282018, -0.200713, +2.274746, -0.197804, +2.270383, -0.206531, 
/* zone 185 with 5 points. */
+2.289290, -0.138172, +2.296562, -0.132354, +2.296562, -0.123627, +2.290745, -0.129445,
+2.289290, -0.138172, 
/* zone 186 with 7 points. */
+2.340196, -0.120719, +2.347468, -0.113446, +2.350377, -0.103265, +2.347468, -0.094539,
+2.343104, -0.101811, +2.340196, -0.110537, +2.340196, -0.120719, 
/* zone 187 with 24 points. */
+2.617993, +1.250819, +2.615085, +1.259545, +2.591814, +1.262454, +2.562725, +1.262454,
+2.535090, +1.266818, +2.510365, +1.268272, +2.485640, +1.269727, +2.455096, +1.271181,
+2.463823, +1.265363, +2.439097, +1.265363, +2.431825, +1.261000, +2.437643, +1.255182,
+2.446370, +1.247910, +2.418736, +1.249364, +2.385283, +1.247910, +2.370739, +1.250819,
+2.356194, +1.249364, +2.346014, +1.245001, +2.330015, +1.247910, +2.314015, +1.255182,
+2.308198, +1.247910, +2.303835, +1.240638, +2.290745, +1.234819, +2.274746, +1.237729, 
/* zone 188 with 7 points. */
+2.453642, +1.282817, +2.471095, +1.278453, +2.504547, +1.276999, +2.504547, +1.282817,
+2.482731, +1.290089, +2.460915, +1.288634, +2.453642, +1.282817, 
/* zone 189 with 5 points. */
+2.446370, +1.295906, +2.449279, +1.290089, +2.460915, +1.291543, +2.460915, +1.295906,
+2.446370, +1.295906, 
/* zone 190 with 8 points. */
+2.556908, +1.319178, +2.569997, +1.310451, +2.604904, +1.304633, +2.626720, +1.304633,
+2.635448, +1.311905, +2.604904, +1.314814, +2.571451, +1.316269, +2.556908, +1.319178, 
/* zone 191 with 16 points. */
+2.394010, +1.313359, +2.410008, +1.304633, +2.430371, +1.303179, +2.452188, +1.306087,
+2.478367, +1.308996, +2.492912, +1.306087, +2.513274, +1.310451, +2.530727, +1.316269,
+2.530727, +1.320632, +2.513274, +1.323541, +2.500184, +1.323541, +2.478368, +1.329358,
+2.460915, +1.322086, +2.426007, +1.329358, +2.399828, +1.324995, +2.394010, +1.313359, 
/* zone 192 with 74 points. */
+2.270383, +0.734493, +2.280564, +0.737402, +2.283473, +0.743219, +2.289290, +0.743219,
+2.295108, +0.750492, +2.299472, +0.754855, +2.309652, +0.754855, +2.309652, +0.749037,
+2.322742, +0.744674, +2.334378, +0.747583, +2.344559, +0.753401, +2.356194, +0.757764,
+2.364921, +0.766490, +2.367830, +0.773763, +2.379465, +0.781035, +2.389647, +0.789761,
+2.399828, +0.797033, +2.407100, +0.804306, +2.412917, +0.811578, +2.417281, +0.821759,
+2.426007, +0.829031, +2.434734, +0.837758, +2.446370, +0.846484, +2.449279, +0.855211,
+2.452188, +0.862483, +2.452188, +0.872664, +2.450733, +0.881391, +2.452188, +0.890118,
+2.456551, +0.897390, +2.462369, +0.904662, +2.466732, +0.910480, +2.462369, +0.914843,
+2.462368, +0.922115, +2.466732, +0.929388, +2.456551, +0.933751, +2.447824, +0.938114,
+2.446370, +0.942478, +2.434734, +0.945387, +2.423099, +0.945387, +2.412917, +0.936660,
+2.396918, +0.933751, +2.402737, +0.939569, +2.402737, +0.946841, +2.392555, +0.945387,
+2.385283, +0.938114, +2.385283, +0.945387, +2.385283, +0.952659, +2.372193, +0.951204,
+2.360558, +0.954113, +2.359103, +0.958477, +2.372193, +0.962840, +2.383828, +0.970112,
+2.395464, +0.975930, +2.407100, +0.983202, +2.417281, +0.991929, +2.426007, +0.997747,
+2.437643, +1.003564, +2.447824, +1.007927, +2.453642, +1.013744, +2.460914, +1.019563,
+2.472549, +1.023926, +2.478368, +1.029744, +2.490003, +1.034107, +2.507457, +1.035562,
+2.524910, +1.035562, +2.540909, +1.035562, +2.546726, +1.032653, +2.556908, +1.037016,
+2.572906, +1.034107, +2.585996, +1.035562, +2.597631, +1.034107, +2.599086, +1.037016,
+2.600540, +1.041379, +2.609267, +1.042833, 
/* zone 193 with 21 points. */
+2.260201, +0.580322, +2.264565, +0.571595, +2.271837, +0.571595, +2.273292, +0.577413,
+2.277655, +0.571595, +2.277655, +0.564323, +2.271837, +0.559960, +2.271837, +0.552688,
+2.271837, +0.545415, +2.282018, +0.542507, +2.292199, +0.548324, +2.293653, +0.557051,
+2.298018, +0.565778, +2.302381, +0.573050, +2.298018, +0.580322, +2.296562, +0.587594,
+2.287836, +0.587594, +2.284927, +0.591958, +2.276200, +0.590503, +2.268929, +0.584685,
+2.260201, +0.580322, 
/* zone 194 with 16 points. */
+2.308198, +0.583231, +2.311107, +0.574504, +2.319834, +0.571595, +2.322742, +0.577413,
+2.325651, +0.581776, +2.334378, +0.584685, +2.340196, +0.580322, +2.344559, +0.586140,
+2.350377, +0.590503, +2.348923, +0.596321, +2.340196, +0.599230, +2.331469, +0.597775,
+2.327106, +0.591958, +2.318379, +0.593412, +2.315471, +0.587594, +2.308198, +0.583231, 
/* zone 195 with 79 points. */
+2.284927, +0.599230, +2.284927, +0.591958, +2.295108, +0.593412, +2.303835, +0.591958,
+2.309652, +0.597775, +2.319834, +0.599230, +2.330015, +0.602139, +2.337287, +0.603593,
+2.347468, +0.607956, +2.354740, +0.606502, +2.364921, +0.606502, +2.359103, +0.599230,
+2.359103, +0.591958, +2.363466, +0.584685, +2.369285, +0.583231, +2.376556, +0.591958,
+2.386738, +0.599230, +2.382374, +0.605048, +2.386738, +0.610865, +2.395464, +0.603593,
+2.410008, +0.603593, +2.420190, +0.612320, +2.423099, +0.603593, +2.427462, +0.615228,
+2.436189, +0.615228, +2.440552, +0.619592, +2.439097, +0.609411, +2.449279, +0.613774,
+2.450733, +0.619592, +2.456551, +0.623955, +2.453642, +0.631227, +2.455096, +0.641408,
+2.459459, +0.645772, +2.460914, +0.655953, +2.459459, +0.664680, +2.462369, +0.669043,
+2.469641, +0.669043, +2.469641, +0.676315, +2.475458, +0.682133, +2.476913, +0.692314,
+2.474004, +0.701041, +2.468186, +0.708313, +2.466732, +0.715585, +2.468186, +0.721403,
+2.458005, +0.724312, +2.456551, +0.718494, +2.462369, +0.718494, +2.462369, +0.714131,
+2.455096, +0.714131, +2.449279, +0.718494, +2.443460, +0.709767, +2.443460, +0.703950,
+2.443460, +0.696677, +2.443460, +0.687951, +2.440552, +0.680678, +2.434734, +0.673406,
+2.431826, +0.664680, +2.423099, +0.660316, +2.418736, +0.653044, +2.411463, +0.648681,
+2.401282, +0.645772, +2.391101, +0.641408, +2.391101, +0.647226, +2.394010, +0.654499,
+2.386738, +0.650135, +2.385283, +0.642863, +2.379465, +0.635591, +2.373648, +0.629773,
+2.373648, +0.622501, +2.367830, +0.619592, +2.360558, +0.623955, +2.350377, +0.622501,
+2.338741, +0.621046, +2.325651, +0.619592, +2.316925, +0.619592, +2.309652, +0.612320,
+2.300926, +0.606502, +2.293653, +0.602139, +2.284927, +0.599230, 
/* zone 196 with 43 points. */
+2.440552, +0.743219, +2.439097, +0.737402, +2.443460, +0.733038, +2.443460, +0.722857,
+2.452188, +0.727221, +2.462369, +0.730129, +2.455096, +0.734493, +2.447824, +0.737402,
+2.449279, +0.741765, +2.455096, +0.741765, +2.459459, +0.738856, +2.466732, +0.741765,
+2.475458, +0.743219, +2.487094, +0.737402, +2.500184, +0.733038, +2.501638, +0.738856,
+2.507457, +0.744674, +2.516183, +0.750492, +2.526364, +0.749037, +2.536545, +0.753401,
+2.545272, +0.757764, +2.535090, +0.756309, +2.535090, +0.760673, +2.530727, +0.763582,
+2.536545, +0.772308, +2.524910, +0.766490, +2.516183, +0.767945, +2.506001, +0.770854,
+2.495821, +0.776672, +2.490003, +0.781035, +2.484185, +0.788307, +2.476913, +0.794124,
+2.469641, +0.789761, +2.474004, +0.781035, +2.472549, +0.773763, +2.471095, +0.767945,
+2.465278, +0.763582, +2.466732, +0.757764, +2.465278, +0.753401, +2.456551, +0.753401,
+2.449279, +0.754855, +2.450733, +0.749037, +2.440552, +0.743219, 
/* zone 197 with 8 points. */
+2.564179, +0.775217, +2.574361, +0.781035, +2.585996, +0.786852, +2.597631, +0.794124,
+2.588904, +0.789761, +2.581633, +0.791216, +2.572906, +0.785398, +2.564179, +0.775217, 
/* zone 198 with 5 points. */
+2.609267, +0.797033, +2.615085, +0.798488, +2.626720, +0.807214, +2.617993, +0.804306,
+2.609267, +0.797033, 
/* zone 199 with 7 points. */
+2.708169, +0.877319, +2.708169, +0.872664, +2.719805, +0.876155, +2.724168, +0.881391,
+2.724168, +0.885755, +2.716896, +0.879936, +2.708169, +0.877319, 
/* zone 200 with 47 points. */
+2.474004, +0.930842, +2.475458, +0.920661, +2.472549, +0.911934, +2.472549, +0.903208,
+2.478368, +0.897390, +2.479822, +0.890118, +2.478368, +0.881391, +2.479822, +0.872664,
+2.479822, +0.863938, +2.478368, +0.856666, +2.475458, +0.850847, +2.478368, +0.846484,
+2.481277, +0.837758, +2.478368, +0.830485, +2.478368, +0.820305, +2.474004, +0.813032,
+2.478368, +0.801397, +2.482731, +0.810124, +2.488548, +0.814487, +2.495821, +0.813032,
+2.503093, +0.807214, +2.503093, +0.815941, +2.497275, +0.818850, +2.495821, +0.824668,
+2.490003, +0.829031, +2.487094, +0.834849, +2.488548, +0.843575, +2.492911, +0.850847,
+2.494367, +0.856665, +2.500184, +0.861029, +2.508911, +0.861029, +2.519092, +0.856666,
+2.516183, +0.863938, +2.511820, +0.872664, +2.507456, +0.881391, +2.504547, +0.890118,
+2.501638, +0.898844, +2.497275, +0.907571, +2.498730, +0.916298, +2.498730, +0.925024,
+2.495821, +0.933751, +2.494367, +0.942478, +2.490003, +0.948295, +2.482731, +0.946841,
+2.487094, +0.939569, +2.482731, +0.935205, +2.474004, +0.930842, 
/* zone 201 with 5 points. */
+2.395464, +0.957022, +2.401282, +0.952659, +2.410008, +0.959931, +2.399828, +0.962840,
+2.395464, +0.957022, 
/* zone 202 with 19 points. */
+2.222385, +0.018908, +2.226749, +0.011636, +2.228204, +0.004363, +2.226749, -0.002909,
+2.232567, -0.010181, +2.241294, -0.015999, +2.234021, -0.007272, +2.232567, +0.000000,
+2.234021, +0.008727, +2.242748, +0.008727, +2.238385, +0.014544, +2.245657, +0.018908,
+2.245657, +0.027634, +2.235476, +0.023271, +2.231112, +0.030543, +2.234021, +0.037816,
+2.226749, +0.033452, +2.225295, +0.026180, +2.222385, +0.018908, 
/* zone 203 with 7 points. */
+2.199115, -0.056723, +2.204932, -0.063995, +2.213659, -0.066904, +2.219477, -0.062541,
+2.216568, -0.055269, +2.207842, -0.053814, +2.199115, -0.056723, 
/* zone 204 with 13 points. */
+2.232567, -0.055269, +2.242748, -0.059632, +2.250020, -0.058178, +2.258747, -0.059632,
+2.273292, -0.062541, +2.282018, -0.066904, +2.282018, -0.059632, +2.276200, -0.052360,
+2.267474, -0.052360, +2.260201, -0.047997, +2.250020, -0.049451, +2.238385, -0.049451,
+2.232567, -0.055269, 
/* zone 205 with 4 points. */
+2.222385, -0.029089, +2.236931, -0.029089, +2.226749, -0.023271, +2.222385, -0.029089, 
/* zone 206 with 5 points. */
+2.274746, -0.002909, +2.282018, -0.007272, +2.290745, -0.004363, +2.282018, +0.000000,
+2.274746, -0.002909, 
/* zone 207 with 5 points. */
+2.362012, -0.011636, +2.370739, -0.020362, +2.378011, -0.018908, +2.372193, -0.011636,
+2.362012, -0.011636, 
/* zone 208 with 5 points. */
+2.523746, +0.233874, +2.525491, +0.232129, +2.528981, +0.237365, +2.527236, +0.239110,
+2.523746, +0.233874, 
/* zone 209 with 190 points. */
+2.609267, +1.042833, +2.620903, +1.039925, +2.632538, +1.038470, +2.641265, +1.039925,
+2.647082, +1.035562, +2.636902, +1.031198, +2.641265, +1.026834, +2.652901, +1.026834,
+2.668900, +1.029743, +2.676171, +1.032653, +2.687807, +1.031198, +2.708169, +1.032653,
+2.702352, +1.037016, +2.690716, +1.038470, +2.696534, +1.047197, +2.705260, +1.054469,
+2.718350, +1.060287, +2.728531, +1.067559, +2.738712, +1.074831, +2.756166, +1.077741,
+2.772164, +1.079194, +2.783800, +1.076285, +2.798345, +1.079194, +2.789618, +1.069014,
+2.791072, +1.063196, +2.795436, +1.057378, +2.809980, +1.063196, +2.821615, +1.069014,
+2.831797, +1.074831, +2.843432, +1.076285, +2.843432, +1.083558, +2.849250, +1.090830,
+2.869612, +1.093740, +2.875430, +1.090830, +2.863794, +1.086467, +2.860886, +1.077741,
+2.857977, +1.067559, +2.853613, +1.061741, +2.839068, +1.058832, +2.825979, +1.054469,
+2.820161, +1.048651, +2.808526, +1.041379, +2.793981, +1.034107, +2.786709, +1.026834,
+2.775073, +1.019563, +2.761983, +1.012290, +2.748894, +1.007927, +2.737258, +1.007927,
+2.740167, +1.002110, +2.734349, +0.994837, +2.722713, +0.991929, +2.718350, +0.983202,
+2.713987, +0.974475, +2.712532, +0.964294, +2.713986, +0.957022, +2.716896, +0.948295,
+2.719805, +0.941023, +2.722713, +0.930842, +2.724168, +0.920661, +2.729986, +0.910480,
+2.731441, +0.901753, +2.731441, +0.894481, +2.734349, +0.888663, +2.745984, +0.894481,
+2.756166, +0.901753, +2.764893, +0.911934, +2.767801, +0.922116, +2.777983, +0.927933,
+2.791072, +0.927933, +2.789618, +0.935205, +2.791072, +0.943932, +2.799799, +0.949750,
+2.812889, +0.952659, +2.821615, +0.951204, +2.828888, +0.955568, +2.821615, +0.962840,
+2.820161, +0.971567, +2.825979, +0.978838, +2.834705, +0.981748, +2.841978, +0.977384,
+2.849250, +0.980293, +2.846341, +0.989020, +2.839068, +0.991929, +2.839068, +0.999201,
+2.847795, +1.006473, +2.837614, +1.010836, +2.828888, +1.007927, +2.825979, +1.015200,
+2.833251, +1.022471, +2.843432, +1.029743, +2.847795, +1.037016, +2.850704, +1.044288,
+2.865249, +1.047197, +2.875430, +1.044288, +2.885611, +1.050106, +2.900155, +1.053015,
+2.900155, +1.042833, +2.911791, +1.050106, +2.923427, +1.054469, +2.936517, +1.057378,
+2.952516, +1.055923, +2.964150, +1.051560, +2.972878, +1.045743, +2.978695, +1.054469,
+2.993239, +1.058832, +3.007784, +1.064651, +3.020874, +1.070468, +3.033964, +1.076285,
+3.047053, +1.077741, +3.060143, +1.083558, +3.076142, +1.086467, +3.089232, +1.090830,
+3.109595, +1.090830, +3.124139, +1.086467, +3.135775, +1.093740, +3.128503, +1.099557,
+3.121230, +1.108283, +3.116867, +1.117010, +3.112504, +1.122828, +3.097960, +1.122828,
+3.097960, +1.130100, +3.118321, +1.128646, +3.134320, +1.133009, +3.141593, +1.135336,
+3.135775, +1.137372, +3.154682, +1.146099, +3.143046, +1.151917, +3.159046, +1.157734,
+3.161955, +1.150462, +3.167772, +1.143190, +3.182317, +1.141736, +3.193953, +1.144645,
+3.211406, +1.141736, +3.214314, +1.134463, +3.227405, +1.130100, +3.246312, +1.124282,
+3.263765, +1.121373, +3.268128, +1.128646, +3.278310, +1.134463, +3.278310, +1.143190,
+3.297217, +1.143190, +3.305944, +1.149008, +3.319035, +1.153371, +3.301581, +1.160644,
+3.287037, +1.167915, +3.260857, +1.170824, +3.237586, +1.170824, +3.228859, +1.178097,
+3.214314, +1.183914, +3.195407, +1.189733, +3.173590, +1.194096, +3.157592, +1.199913,
+3.141593, +1.205731, +3.137229, +1.207186, +3.118321, +1.211549, +3.096505, +1.214458,
+3.074688, +1.218821, +3.048509, +1.218821, +3.025237, +1.220276, +3.001966, +1.221730,
+2.977241, +1.223185, +2.977241, +1.213003, +2.984513, +1.205731, +2.974332, +1.201367,
+2.959787, +1.199913, +2.955424, +1.205731, +2.937971, +1.208640, +2.936517, +1.214458,
+2.952516, +1.214458, +2.956879, +1.218821, +2.936517, +1.221730, +2.926335, +1.215912,
+2.914700, +1.211549, +2.891429, +1.214458, +2.862340, +1.215912, +2.831797, +1.214458,
+2.804162, +1.214458, +2.783800, +1.218821, +2.792526, +1.226093, +2.786709, +1.233365,
+2.772164, +1.237729, +2.748894, +1.239183, +2.722713, +1.240638, +2.697988, +1.237729,
+2.679080, +1.237729, +2.660172, +1.236275, +2.660172, +1.242092, +2.645628, +1.246455,
+2.629629, +1.246455, +2.617993, +1.250819, 
/* zone 210 with 5 points. */
+2.850704, +1.021017, +2.869612, +1.028289, +2.866703, +1.032653, +2.856523, +1.029744,
+2.850704, +1.021017, 
/* zone 211 with 8 points. */
+3.141593, +1.248491, +3.118321, +1.241220, +3.121230, +1.236275, +3.141593, +1.239183,
+3.156137, +1.237438, +3.186680, +1.242092, +3.172135, +1.248491, +3.141593, +1.248491, 
/* zone 212 with 53 points. */
+3.032510, -0.686496, +3.041236, -0.692314, +3.048509, -0.695223, +3.055780, -0.698132,
+3.058689, -0.703950, +3.055780, -0.714131, +3.051417, -0.721403, +3.058689, -0.725766,
+3.068871, -0.722857, +3.074688, -0.715585, +3.079052, -0.709767, +3.084869, -0.702495,
+3.089232, -0.693768, +3.087778, -0.689405, +3.090687, -0.685042, +3.097960, -0.682133,
+3.105231, -0.682133, +3.106686, -0.676315, +3.112504, -0.673406, +3.112504, -0.666134,
+3.115413, -0.657408, +3.108140, -0.654499, +3.102323, -0.658862, +3.093596, -0.663225,
+3.083415, -0.660316, +3.073234, -0.657408, +3.070325, -0.650135, +3.068871, -0.641408,
+3.061599, -0.638500, +3.063053, -0.650135, +3.058689, -0.645772, +3.052872, -0.645772,
+3.051417, -0.635591, +3.047053, -0.629773, +3.047054, -0.623955, +3.042690, -0.618137,
+3.036873, -0.612320, +3.025237, -0.610865, +3.016511, -0.602139, +3.020874, -0.609411,
+3.022328, -0.616683, +3.028146, -0.622501, +3.033964, -0.629773, +3.039782, -0.637045,
+3.044145, -0.644317, +3.052872, -0.645772, +3.048509, -0.650135, +3.051417, -0.655953,
+3.052872, -0.663225, +3.048509, -0.670497, +3.047053, -0.679224, +3.038327, -0.682133,
+3.032510, -0.686496, 
/* zone 213 with 46 points. */
+2.905973, -0.801397, +2.910336, -0.805760, +2.919064, -0.807214, +2.924881, -0.805760,
+2.929244, -0.810124, +2.937971, -0.811578, +2.949607, -0.814487, +2.961242, -0.811578,
+2.969969, -0.807214, +2.977241, -0.801397, +2.983059, -0.794124, +2.985968, -0.786852,
+2.988876, -0.779580, +2.991785, -0.773763, +3.001966, -0.769399, +3.009238, -0.763582,
+3.020874, -0.763582, +3.015057, -0.759218, +3.016511, -0.753401, +3.023783, -0.750492,
+3.029600, -0.743219, +3.036873, -0.735947, +3.042690, -0.730129, +3.042690, -0.721403,
+3.035419, -0.719948, +3.033964, -0.714131, +3.028146, -0.718494, +3.022328, -0.721403,
+3.020874, -0.714131, +3.012147, -0.709767, +3.004875, -0.714131, +3.004875, -0.721403,
+3.001966, -0.727221, +2.993239, -0.730129, +2.990331, -0.737402, +2.985968, -0.744674,
+2.975786, -0.750492, +2.967060, -0.756309, +2.958333, -0.762127, +2.946697, -0.767945,
+2.937971, -0.769399, +2.930698, -0.775217, +2.924881, -0.781035, +2.916154, -0.786852,
+2.911791, -0.792670, +2.905973, -0.801397, 
/* zone 214 with 4 points. */
+2.924881, -0.826122, +2.936517, -0.820305, +2.932153, -0.814487, +2.924881, -0.826122, 
/* zone 215 with 5 points. */
+3.010693, +0.923570, +3.017965, +0.920661, +3.025237, +0.922115, +3.016511, +0.925024,
+3.010693, +0.923570, 
/* zone 216 with 22 points. */
+2.587451, -0.095993, +2.588904, -0.100356, +2.597631, -0.101811, +2.603450, -0.107629,
+2.612176, -0.109083, +2.620903, -0.109083, +2.629629, -0.109083, +2.638356, -0.104720,
+2.645628, -0.097447, +2.652901, -0.097447, +2.654355, -0.087266, +2.660172, -0.081449,
+2.657264, -0.072722, +2.644174, -0.072722, +2.647082, -0.085812, +2.639811, -0.085812,
+2.632538, -0.095993, +2.625266, -0.095993, +2.617993, -0.095993, +2.607813, -0.097447,
+2.597631, -0.097447, +2.587451, -0.095993, 
/* zone 217 with 12 points. */
+2.632538, -0.045088, +2.642719, -0.052360, +2.652901, -0.059632, +2.658718, -0.061087,
+2.664536, -0.072722, +2.668900, -0.084357, +2.673263, -0.075631, +2.670354, -0.068359,
+2.658718, -0.061087, +2.652901, -0.056723, +2.642719, -0.050615, +2.632538, -0.045088, 
/* zone 218 with 8 points. */
+2.699443, -0.094539, +2.702352, -0.104720, +2.708169, -0.113446, +2.713986, -0.119264,
+2.722713, -0.114901, +2.715441, -0.107629, +2.706715, -0.095993, +2.699443, -0.094539, 
/* zone 219 with 8 points. */
+2.783800, -0.161443, +2.782346, -0.165806, +2.786709, -0.171624, +2.793981, -0.171624,
+2.801253, -0.173079, +2.807071, -0.168715, +2.796890, -0.162897, +2.783800, -0.161443, 
/* zone 220 with 5 points. */
+2.814343, -0.177442, +2.823070, -0.186169, +2.833251, -0.187623, +2.827434, -0.180351,
+2.814343, -0.177442, 
/* zone 221 with 7 points. */
+2.910336, -0.257436, +2.911791, -0.266163, +2.911791, -0.273435, +2.920517, -0.270526,
+2.917608, -0.261799, +2.914700, -0.266163, +2.910336, -0.257436, 
/* zone 222 with 4 points. */
+2.920517, -0.277798, +2.923427, -0.287979, +2.930698, -0.286525, +2.920517, -0.277798, 
/* zone 223 with 15 points. */
+2.866703, -0.353429, +2.872520, -0.363610, +2.879793, -0.370883, +2.887066, -0.375246,
+2.892883, -0.379609, +2.900155, -0.383972, +2.908882, -0.389790, +2.917608, -0.389790,
+2.911791, -0.383972, +2.905973, -0.378155, +2.897246, -0.375246, +2.891429, -0.369428,
+2.885611, -0.362156, +2.875430, -0.357792, +2.866703, -0.353429, 
/* zone 224 with 5 points. */
-3.086324, -0.763873, -3.080506, -0.766200, -3.081961, -0.770854, -3.074688, -0.764454,
-3.086324, -0.763873, 
/* zone 225 with 9 points. */
+3.095050, -0.314159, +3.102323, -0.317068, +3.109595, -0.317068, +3.118321, -0.314159,
+3.118321, -0.306887, +3.111050, -0.302524, +3.102323, -0.302524, +3.096505, -0.306887,
+3.095050, -0.314159, 
/* zone 226 with 8 points. */
+3.116867, -0.289434, +3.119776, -0.295251, +3.129957, -0.290888, +3.140139, -0.290888,
+3.135775, -0.287979, +3.138683, -0.282162, +3.127048, -0.286525, +3.116867, -0.289434, 
/* zone 227 with 9 points. */
-3.017965, -0.234165, -3.013602, -0.239983, -3.004293, -0.239983, -3.000512, -0.244346,
-2.990331, -0.244346, -2.996148, -0.241437, -3.004293, -0.239983, -3.005457, -0.235619,
-3.017965, -0.234165, 
/* zone 228 with 5 points. */
-2.610722, -0.304851, -2.609267, -0.309505, -2.603450, -0.311250, -2.606359, -0.306014,
-2.610722, -0.304851, 
/* zone 229 with 480 points. */
-3.141593, -1.463167, -3.106686, -1.471893, -3.036873, -1.474803, -2.967059, -1.477712,
-2.897246, -1.482075, -2.844887, -1.490802, -2.757620, -1.490802, -2.652901, -1.493711,
-2.548181, -1.489347, -2.565634, -1.480620, -2.635447, -1.474803, -2.679080, -1.466076,
-2.670354, -1.457349, -2.687807, -1.448623, -2.687807, -1.439896, -2.687807, -1.431170,
-2.696534, -1.422442, -2.670354, -1.416625, -2.617993, -1.413716, -2.556907, -1.412262,
-2.539454, -1.407898, -2.583087, -1.402081, -2.617994, -1.396263, -2.661627, -1.390445,
-2.705260, -1.383173, -2.740167, -1.375900, -2.757620, -1.370083, -2.734349, -1.368629,
-2.696533, -1.370083, -2.696533, -1.364265, -2.734349, -1.362810, -2.757620, -1.358447,
-2.763438, -1.352630, -2.769256, -1.346812, -2.740167, -1.343903, -2.687807, -1.346812,
-2.670354, -1.354084, -2.626720, -1.358447, -2.583087, -1.355538, -2.548181, -1.348267,
-2.548181, -1.339540, -2.553998, -1.332267, -2.559816, -1.324995, -2.513274, -1.323541,
-2.478367, -1.319178, -2.455096, -1.322086, -2.443460, -1.316269, -2.414372, -1.313359,
-2.385283, -1.308996, -2.364921, -1.304633, -2.321288, -1.304633, -2.303835, -1.308996,
-2.283473, -1.316269, -2.263111, -1.322086, -2.234021, -1.326449, -2.216568, -1.326449,
-2.213659, -1.320632, -2.204932, -1.311905, -2.190389, -1.303179, -2.172935, -1.297360,
-2.152573, -1.288634, -2.158391, -1.278453, -2.135120, -1.278453, -2.117667, -1.287180,
-2.094396, -1.291543, -2.094397, -1.284271, -2.065308, -1.285726, -2.036219, -1.285726,
-2.030400, -1.288634, -2.053672, -1.294452, -2.053672, -1.303179, -2.030401, -1.311905,
-1.983859, -1.313359, -1.960588, -1.308996, -1.963496, -1.300270, -1.966405, -1.291543,
-1.954770, -1.285726, -1.946043, -1.291543, -1.937316, -1.300270, -1.925681, -1.308996,
-1.896592, -1.311905, -1.893683, -1.303179, -1.911137, -1.300270, -1.911137, -1.291543,
-1.890775, -1.291543, -1.884956, -1.297360, -1.893683, -1.303179, -1.876229, -1.310451,
-1.850050, -1.310451, -1.823870, -1.307542, -1.823870, -1.301724, -1.791873, -1.301724,
-1.768601, -1.304633, -1.745330, -1.308996, -1.736604, -1.304633, -1.768601, -1.297360,
-1.756966, -1.291543, -1.771510, -1.287180, -1.771510, -1.282817, -1.745330, -1.284271,
-1.727877, -1.281363, -1.745330, -1.275544, -1.768601, -1.278453, -1.788963, -1.269727,
-1.768601, -1.268272, -1.771510, -1.274090, -1.739512, -1.272635, -1.719151, -1.279907,
-1.710423, -1.275544, -1.701697, -1.281363, -1.701697, -1.287180, -1.681334, -1.287180,
-1.675517, -1.281363, -1.675517, -1.275544, -1.701697, -1.272635, -1.719151, -1.265363,
-1.739512, -1.259545, -1.762784, -1.255182, -1.742421, -1.252274, -1.716242, -1.256637,
-1.692970, -1.253728, -1.669700, -1.258091, -1.669700, -1.263909, -1.640611, -1.266817,
-1.610067, -1.269727, -1.579524, -1.272635, -1.548979, -1.272635, -1.518435, -1.272635,
-1.492256, -1.275544, -1.471893, -1.272635, -1.448623, -1.271181, -1.418079, -1.272635,
-1.387536, -1.274090, -1.370083, -1.278453, -1.372992, -1.271181, -1.361356, -1.263909,
-1.335176, -1.266818, -1.308996, -1.271181, -1.291543, -1.274090, -1.300270, -1.282817,
-1.274090, -1.281363, -1.247910, -1.279907, -1.221730, -1.276999, -1.195550, -1.275544,
-1.178097, -1.271181, -1.169370, -1.262454, -1.169370, -1.253728, -1.178097, -1.247910,
-1.178097, -1.237729, -1.186823, -1.229002, -1.195550, -1.221730, -1.195550, -1.211549,
-1.175188, -1.211549, -1.163552, -1.205731, -1.175188, -1.201367, -1.166461, -1.195550,
-1.166461, -1.188277, -1.178097, -1.182460, -1.178097, -1.176642, -1.195550, -1.182460,
-1.208640, -1.182460, -1.210094, -1.175188, -1.198459, -1.167915, -1.183914, -1.163552,
-1.181005, -1.170824, -1.169370, -1.169370, -1.157734, -1.175188, -1.157734, -1.166461,
-1.143190, -1.162098, -1.149008, -1.156280, -1.134463, -1.150462, -1.117010, -1.143190,
-1.117010, -1.135918, -1.099557, -1.137372, -1.093739, -1.130100, -1.076285, -1.128646,
-1.073377, -1.121373, -1.064651, -1.117010, -1.041379, -1.114101, -1.026834, -1.109737,
-1.012290, -1.105374, -0.997746, -1.103920, -0.989020, -1.109737, -1.000654, -1.109737,
-1.015200, -1.114101, -0.999201, -1.114101, -1.000654, -1.124282, -1.015200, -1.122828,
-1.023926, -1.117010, -1.029743, -1.125737, -1.041379, -1.122828, -1.055923, -1.128646,
-1.070468, -1.134463, -1.082104, -1.141736, -1.085012, -1.147553, -1.087921, -1.153371,
-1.093739, -1.160644, -1.108283, -1.156280, -1.117010, -1.160644, -1.111193, -1.167915,
-1.128646, -1.167915, -1.140281, -1.175188, -1.143190, -1.183914, -1.131555, -1.188277,
-1.140281, -1.192641, -1.131555, -1.199913, -1.111192, -1.199913, -1.093739, -1.205731,
-1.087921, -1.215912, -1.082104, -1.224639, -1.073377, -1.231911, -1.076285, -1.237729,
-1.064651, -1.242092, -1.061741, -1.249364, -1.076285, -1.256637, -1.061741, -1.262454,
-1.064651, -1.268272, -1.044288, -1.274090, -1.050106, -1.279907, -1.073377, -1.281363,
-1.064651, -1.287180, -1.058832, -1.297360, -1.076285, -1.303179, -1.076285, -1.310451,
-1.099557, -1.311905, -1.099557, -1.320632, -1.111192, -1.327904, -1.143189, -1.335176,
-1.175187, -1.343903, -1.134463, -1.346812, -1.090830, -1.345357, -1.047197, -1.345357,
-1.006473, -1.348267, -0.977384, -1.354084, -0.936660, -1.359901, -0.901753, -1.365720,
-0.861029, -1.370083, -0.831940, -1.374446, -0.767945, -1.375900, -0.715585, -1.375900,
-0.671952, -1.374446, -0.634136, -1.367174, -0.610865, -1.358447, -0.581776, -1.352630,
-0.552688, -1.346812, -0.523599, -1.340994, -0.494510, -1.335176, -0.471239, -1.327904,
-0.453786, -1.320632, -0.418879, -1.314814, -0.413061, -1.304633, -0.389790, -1.298816,
-0.360701, -1.292997, -0.337430, -1.287180, -0.308342, -1.281363, -0.285070, -1.275544,
-0.255981, -1.272635, -0.235619, -1.271181, -0.215257, -1.266818, -0.197804, -1.261000,
-0.194895, -1.255182, -0.209440, -1.250819, -0.212348, -1.245001, -0.200713, -1.243546,
-0.191986, -1.249364, -0.183260, -1.243546, -0.170170, -1.239183, -0.157080, -1.242092,
-0.151262, -1.246455, -0.148353, -1.253728, -0.127991, -1.250819, -0.133809, -1.246455,
-0.127991, -1.240638, -0.133809, -1.236275, -0.119264, -1.234819, -0.101811, -1.234819,
-0.101811, -1.239183, -0.104720, -1.245001, -0.078540, -1.245001, -0.052360, -1.243546,
-0.052360, -1.233365, -0.058178, -1.229002, -0.043633, -1.226093, -0.029089, -1.229002,
-0.017453, -1.233365, -0.026180, -1.239183, -0.011636, -1.243546, +0.000000, -1.247910,
+0.023271, -1.243546, +0.046542, -1.237729, +0.061087, -1.231911, +0.081449, -1.227548,
+0.110537, -1.227548, +0.127991, -1.223185, +0.151262, -1.223185, +0.174533, -1.224639,
+0.197804, -1.223185, +0.221075, -1.223185, +0.250164, -1.224639, +0.273435, -1.224639,
+0.296706, -1.224639, +0.319977, -1.224639, +0.349066, -1.227548, +0.375246, -1.229002,
+0.401426, -1.231911, +0.430515, -1.229002, +0.442150, -1.224639, +0.471239, -1.224639,
+0.494510, -1.220276, +0.523599, -1.218821, +0.546870, -1.214458, +0.558505, -1.213003,
+0.584685, -1.213003, +0.581776, -1.204277, +0.584685, -1.198459, +0.599230, -1.197004,
+0.610865, -1.202822, +0.628318, -1.210094, +0.645772, -1.213003, +0.669043, -1.214458,
+0.674861, -1.223185, +0.686496, -1.215912, +0.695223, -1.213003, +0.695223, -1.207186,
+0.698132, -1.201367, +0.721403, -1.195550, +0.733038, -1.189732, +0.756309, -1.183914,
+0.776672, -1.182460, +0.802851, -1.182460, +0.820305, -1.179551, +0.840667, -1.181005,
+0.846484, -1.176642, +0.861029, -1.176642, +0.869755, -1.183914, +0.881391, -1.179551,
+0.875573, -1.169370, +0.881391, -1.160644, +0.898844, -1.156280, +0.910480, -1.150462,
+0.936660, -1.149008, +0.962839, -1.150462, +0.977384, -1.156280, +0.997746, -1.159189,
+0.997746, -1.163552, +0.983202, -1.165007, +0.994837, -1.167915, +1.012290, -1.169370,
+1.029743, -1.172279, +1.035562, -1.178097, +1.058832, -1.175188, +1.076285, -1.179551,
+1.093739, -1.181005, +1.111193, -1.178097, +1.134463, -1.179551, +1.157734, -1.182460,
+1.181005, -1.183914, +1.198459, -1.183914, +1.213003, -1.181005, +1.213003, -1.189732,
+1.221730, -1.197004, +1.230456, -1.204277, +1.213003, -1.207186, +1.218821, -1.214458,
+1.218821, -1.223185, +1.233365, -1.230456, +1.250818, -1.229002, +1.239183, -1.223185,
+1.262454, -1.217366, +1.282817, -1.214458, +1.300270, -1.215912, +1.317723, -1.218821,
+1.329358, -1.213003, +1.346812, -1.207186, +1.361356, -1.205731, +1.367174, -1.195550,
+1.378810, -1.191187, +1.404989, -1.186823, +1.425351, -1.183914, +1.439896, -1.175188,
+1.460258, -1.172278, +1.483529, -1.169370, +1.506800, -1.166461, +1.530071, -1.163552,
+1.544616, -1.165007, +1.564978, -1.165007, +1.588251, -1.163552, +1.605704, -1.160644,
+1.623158, -1.162098, +1.640611, -1.162098, +1.658064, -1.160644, +1.675517, -1.163552,
+1.692970, -1.160644, +1.704606, -1.163552, +1.719151, -1.160644, +1.733695, -1.162098,
+1.745330, -1.159189, +1.756966, -1.159189, +1.771510, -1.153371, +1.791872, -1.149008,
+1.815144, -1.150462, +1.832597, -1.153371, +1.850050, -1.156280, +1.867503, -1.160644,
+1.884956, -1.162098, +1.902410, -1.166461, +1.911137, -1.162098, +1.925681, -1.163552,
+1.931499, -1.159189, +1.931499, -1.153371, +1.948952, -1.150462, +1.966405, -1.149008,
+1.983859, -1.147553, +1.998403, -1.151917, +2.015857, -1.157734, +2.033310, -1.160644,
+2.053672, -1.165007, +2.076942, -1.166461, +2.100214, -1.166461, +2.120576, -1.163552,
+2.138029, -1.159189, +2.152573, -1.165007, +2.170026, -1.165007, +2.178753, -1.160644,
+2.196206, -1.162098, +2.207842, -1.156280, +2.216568, -1.156280, +2.228204, -1.160644,
+2.239840, -1.167915, +2.251475, -1.169370, +2.260201, -1.172279, +2.268929, -1.167915,
+2.268929, -1.157734, +2.283473, -1.153371, +2.303835, -1.154825, +2.327106, -1.153371,
+2.344559, -1.154825, +2.362012, -1.153371, +2.379465, -1.157734, +2.396918, -1.157734,
+2.414371, -1.160644, +2.431825, -1.162098, +2.452188, -1.163552, +2.478368, -1.165007,
+2.487094, -1.169370, +2.501638, -1.166461, +2.519092, -1.169370, +2.519092, -1.178097,
+2.530727, -1.179551, +2.548181, -1.178097, +2.562725, -1.183914, +2.565634, -1.191187,
+2.588904, -1.194096, +2.600540, -1.191187, +2.623812, -1.195550, +2.635448, -1.192641,
+2.644174, -1.198459, +2.664536, -1.197004, +2.693624, -1.197004, +2.705260, -1.205731,
+2.722713, -1.210094, +2.731441, -1.204277, +2.748894, -1.205731, +2.769256, -1.208640,
+2.792526, -1.213003, +2.809980, -1.215912, +2.809980, -1.223185, +2.812889, -1.230456,
+2.821615, -1.236275, +2.830342, -1.231911, +2.833251, -1.224639, +2.850704, -1.223185,
+2.847795, -1.231911, +2.873976, -1.231911, +2.897246, -1.230456, +2.920518, -1.236275,
+2.943789, -1.242092, +2.967060, -1.247910, +2.969969, -1.242092, +2.984513, -1.252274, 
/* zone 230 with 35 points. */
+2.984513, -1.252274, +2.969969, -1.256637, +2.975786, -1.265364, +2.961242, -1.271181,
+2.940880, -1.276999, +2.914700, -1.278453, +2.914700, -1.285726, +2.908882, -1.292997,
+2.885611, -1.294452, +2.885611, -1.300270, +2.868157, -1.306087, +2.844887, -1.311905,
+2.839068, -1.320632, +2.839069, -1.327904, +2.844887, -1.335176, +2.850704, -1.342448,
+2.856523, -1.349721, +2.856523, -1.356993, +2.873976, -1.361356, +2.897246, -1.368629,
+2.862340, -1.370083, +2.818707, -1.374446, +2.792526, -1.381719, +2.792526, -1.390445,
+2.792526, -1.396263, +2.798345, -1.404989, +2.798345, -1.413716, +2.809979, -1.422442,
+2.833251, -1.429715, +2.862340, -1.438441, +2.897246, -1.445714, +2.940880, -1.452986,
+2.993239, -1.457349, +3.071779, -1.457349, +3.141593, -1.463167, 
/* zone 231 with 6 points. */
+2.903064, -1.354084, +2.935062, -1.355538, +2.961242, -1.351175, +2.935062, -1.349721,
+2.908882, -1.345357, +2.903064, -1.354084, 
/* zone 232 with 10 points. */
-2.862340, -1.374446, -2.844887, -1.380263, -2.856523, -1.384627, -2.856523, -1.393353,
-2.821615, -1.400626, -2.792526, -1.394809, -2.792526, -1.387536, -2.804163, -1.380264,
-2.821615, -1.374446, -2.862340, -1.374446, 
/* zone 233 with 5 points. */
-2.620903, -1.336631, -2.591814, -1.339540, -2.568542, -1.333722, -2.585997, -1.329358,
-2.620903, -1.336631, 
/* zone 234 with 27 points. */
-1.329358, -1.240638, -1.335176, -1.245001, -1.326449, -1.250819, -1.308996, -1.253728,
-1.297360, -1.259545, -1.279907, -1.261000, -1.274090, -1.266818, -1.247910, -1.268272,
-1.221730, -1.266818, -1.201367, -1.262454, -1.195550, -1.255182, -1.192640, -1.247910,
-1.195550, -1.239183, -1.201367, -1.230456, -1.210094, -1.221730, -1.215912, -1.211549,
-1.227548, -1.201367, -1.242092, -1.202823, -1.250818, -1.205731, -1.247910, -1.214458,
-1.239183, -1.223185, -1.233365, -1.231911, -1.239183, -1.236275, -1.253728, -1.237729,
-1.274090, -1.239183, -1.303179, -1.240638, -1.329358, -1.240638, 
/* zone 235 with 9 points. */
-1.329358, -1.231911, -1.308996, -1.231911, -1.291543, -1.230456, -1.287180, -1.226093,
-1.285726, -1.220276, -1.300270, -1.217366, -1.322086, -1.221730, -1.320632, -1.226093,
-1.329358, -1.231911, 
/* zone 236 with 8 points. */
-1.122828, -1.128646, -1.108283, -1.131555, -1.099557, -1.127192, -1.082104, -1.122828,
-1.090830, -1.117010, -1.099557, -1.127192, -1.108283, -1.121373, -1.122828, -1.128646, 
/* zone 237 with 5 points. */
-0.986111, -1.103920, -0.977384, -1.108283, -0.959931, -1.106829, -0.974475, -1.099557,
-0.986111, -1.103920, 
/* zone 238 with 9 points. */
-1.064651, -1.093740, -1.053015, -1.095194, -1.035562, -1.087921, -1.023926, -1.086467,
-1.006473, -1.082104, -1.026834, -1.082104, -1.035562, -1.087921, -1.053015, -1.090830,
-1.064651, -1.093740, 
/* zone 239 with 4 points. */
-0.808669, -1.058250, -0.785398, -1.059414, -0.802851, -1.053015, -0.808669, -1.058250  
};

/*
 * Number of points per frontier zones (polygons).
 */
static unsigned int
gdisp_nbPointsPerFrontierZones[] = { 
 19,   6,  18,  14,  19,  12,   6,   4,   4,   8,
  5,   4,   3,   3,  47,  16,  28,   3,  48,  31,
 29,  10,  10,  24,   9,   6,  17,   9,  16,   8,
 14,   8,  10,  17,  17,  25,   5,   5,  12,   4,
 22,   3,   6,  17,  12,   8,  13,  18,   8,  29,
 11,  25,   5,   8,   6,  11,   6,  12,   2,  14,
 11,  26,  24,  13,  13,   3,  19,  20,   4,  43,
 16,  39,  12,  17,  23,  37,   9,  16,   9,  18,
 29,   5,  16,  11,   6,   8,  10,  19,   3,   9,
  4,  13,   8,   6,  14,  10,   6,   6,   6,   7,
 13,   8,  13,  14,  22,   7,   6,  20,  15,   5,
  8,   8,   5,   6,   5,   5,  11,  10,   2,   2,
  3,   9,   3,   2,  16,  29,  23,  23,  21,   5,
 29,  25,   3,  23,  30,  43,   6,  20,  30,  24,
 13,  11,  15,  24,  15,  35,   5,   5,  61,   9,
  2,  10,   2,  28,  11,  24,  16,  10,  11,   6,
 37,  19,   3,  16,  12,   9  };

/*
 * Frontier point coordinates (longitude,latitude).
 */
static float
gdisp_frontierZoneLonLatCoordinates[] = { 
/* zone 1 with 19 points. */
-2.274163, +0.956440, -2.263691, +0.973893, -2.295107, +0.989601, -2.324778, +1.019272,
-2.352703, +1.034980, -2.356194, +1.041961, -2.363175, +1.043706, -2.373647, +1.038470,
-2.378882, +1.031488, -2.396337, +1.027998, -2.405063, +1.036725, -2.422516, +1.047197,
-2.429498, +1.052433, -2.457422, +1.052433, -2.457422, +1.082104, -2.457422, +1.117010,
-2.457422, +1.151917, -2.457422, +1.186823, -2.457422, +1.216494, 
/* zone 2 with 6 points. */
-2.176425, +0.842994, -2.158972, +0.841249, -2.148499, +0.841249, -2.148499, +0.855211,
-2.117084, +0.855211, -2.094395, +0.855211, 
/* zone 3 with 18 points. */
-2.094395, +0.855211, -2.050761, +0.855211, -2.007128, +0.855211, -1.963494, +0.855211,
-1.919862, +0.855211, -1.876228, +0.855211, -1.832595, +0.855211, -1.788961, +0.855211,
-1.745329, +0.855211, -1.701695, +0.855211, -1.661552, +0.862192, -1.654572, +0.860447,
-1.651081, +0.851720, -1.635373, +0.846484, -1.623156, +0.846484, -1.600466, +0.841249,
-1.570796, +0.839503, -1.563814, +0.837758, 
/* zone 4 with 14 points. */
-1.327904, +0.773763, -1.308996, +0.783653, -1.274090, +0.783653, -1.249655, +0.785398,
-1.235692, +0.788889, -1.223475, +0.808087, -1.209513, +0.825540, -1.206021, +0.822050,
-1.192060, +0.825540, -1.183332, +0.820305, -1.183332, +0.795870, -1.179842, +0.792379,
-1.179842, +0.785398, -1.169370, +0.781907, 
/* zone 5 with 19 points. */
-2.036798, +0.565486, -2.001892, +0.568977, -1.973967, +0.558505, -1.933824, +0.546288,
-1.888446, +0.546288, -1.888446, +0.555014, -1.862266, +0.555014, -1.841322, +0.541052,
-1.827359, +0.532325, -1.823869, +0.518363, -1.797688, +0.506145, -1.785471, +0.518363,
-1.769763, +0.518363, -1.759291, +0.511381, -1.748819, +0.495673, -1.734857, +0.476475,
-1.727876, +0.460767, -1.713913, +0.455531, -1.692968, +0.450295, 
/* zone 6 with 12 points. */
-1.610938, +0.258309, -1.609193, +0.265290, -1.600466, +0.279253, -1.583013, +0.282743,
-1.581267, +0.284488, -1.593485, +0.300196, -1.588249, +0.300196, -1.588249, +0.312414,
-1.570796, +0.310668, -1.556833, +0.310668, -1.549851, +0.314159, -1.541125, +0.322886, 
/* zone 7 with 6 points. */
-1.572541, +0.242601, -1.576032, +0.247837, -1.558578, +0.253073, -1.558578, +0.261799,
-1.546361, +0.268781, -1.544616, +0.274017, 
/* zone 8 with 4 points. */
-1.555087, +0.275762, -1.558578, +0.275762, -1.558578, +0.294960, -1.558578, +0.308923, 
/* zone 9 with 4 points. */
-1.532398, +0.232129, -1.539380, +0.242601, -1.549851, +0.242601, -1.558578, +0.249582, 
/* zone 10 with 8 points. */
-1.523671, +0.226893, -1.518435, +0.230383, -1.513200, +0.237365, -1.500982, +0.244346,
-1.488765, +0.249582, -1.483529, +0.256563, -1.471312, +0.254818, -1.460840, +0.260054, 
/* zone 11 with 5 points. */
-1.495747, +0.195477, -1.485274, +0.191986, -1.476548, +0.190241, -1.466076, +0.188496,
-1.460840, +0.190241, 
/* zone 12 with 4 points. */
-1.448623, +0.148353, -1.446877, +0.157080, -1.446877, +0.164061, -1.443387, +0.164061, 
/* zone 13 with 3 points. */
-1.361356, +0.127409, -1.350884, +0.136136, -1.354375, +0.150098, 
/* zone 14 with 3 points. */
-1.254891, +0.319395, -1.253145, +0.331612, -1.253145, +0.343830, 
/* zone 15 with 47 points. */
-1.373573, +0.022689, -1.366592, +0.017453, -1.354375, +0.013963, -1.349138, +0.008727,
-1.338667, +0.003491, -1.328195, +0.005236, -1.312487, -0.001745, -1.298524, -0.008727,
-1.293288, -0.019199, -1.284561, -0.027925, -1.274090, -0.041888, -1.256637, -0.040143,
-1.239183, -0.038397, -1.225221, -0.050615, -1.235692, -0.069813, -1.228711, -0.069813,
-1.221730, -0.076794, -1.214748, -0.047124, -1.209513, -0.022689, -1.219984, -0.006981,
-1.219984, +0.008727, -1.207767, +0.012217, -1.207767, +0.019199, -1.218239, +0.020944,
-1.216494, +0.029671, -1.193805, +0.031416, -1.183332, +0.029671, -1.181587, +0.033161,
-1.167624, +0.019199, -1.169370, +0.029671, -1.172860, +0.036652, -1.185078, +0.048869,
-1.176352, +0.059341, -1.183332, +0.085521, -1.179842, +0.106465, -1.209513, +0.108210,
-1.204277, +0.122173, -1.244419, +0.122173, -1.263618, +0.127409, -1.261872, +0.143117,
-1.270598, +0.153589, -1.282816, +0.155334, -1.275835, +0.162316, -1.270598, +0.179769,
-1.260127, +0.195477, -1.256637, +0.200713, -1.251400, +0.207694, 
/* zone 16 with 16 points. */
-1.399754, -0.064577, -1.398008, -0.069813, -1.408480, -0.075049, -1.399754, -0.078540,
-1.391026, -0.080285, -1.385791, -0.087266, -1.377064, -0.087266, -1.373573, -0.078540,
-1.368338, -0.061087, -1.357865, -0.052360, -1.342157, -0.045379, -1.326449, -0.034907,
-1.315977, -0.026180, -1.315977, -0.019199, -1.319468, -0.006981, -1.312487, -0.001745, 
/* zone 17 with 28 points. */
-1.226966, -0.328122, -1.219984, -0.324631, -1.219984, -0.315904, -1.214748, -0.310668,
-1.206021, -0.293215, -1.214748, -0.279253, -1.211258, -0.272271, -1.213003, -0.265290,
-1.204277, -0.249582, -1.206021, -0.242601, -1.200786, -0.221657, -1.214748, -0.191986,
-1.233947, -0.191986, -1.235692, -0.162316, -1.244419, -0.176278, -1.261872, -0.178024,
-1.267108, -0.171042, -1.279325, -0.171042, -1.275835, -0.157080, -1.289798, -0.141372,
-1.291543, -0.134390, -1.286307, -0.118682, -1.277580, -0.113446, -1.279325, -0.106465,
-1.274090, -0.090757, -1.253145, -0.080285, -1.240929, -0.078540, -1.221730, -0.076794, 
/* zone 18 with 3 points. */
-1.197295, -0.967203, -1.199040, -0.937242, -1.200786, -0.921534, 
/* zone 19 with 48 points. */
-1.204277, -0.912807, -1.219984, -0.907571, -1.253145, -0.907571, -1.263618, -0.900590,
-1.261872, -0.883136, -1.279325, -0.884882, -1.279325, -0.872665, -1.275835, -0.855211,
-1.261872, -0.842994, -1.267108, -0.832522, -1.254891, -0.804596, -1.253145, -0.811578,
-1.254891, -0.797615, -1.246164, -0.788889, -1.256637, -0.780162, -1.254891, -0.760963,
-1.258382, -0.747001, -1.253145, -0.731293, -1.254891, -0.705113, -1.253145, -0.684169,
-1.237437, -0.675442, -1.244419, -0.640536, -1.232202, -0.631809, -1.233947, -0.617846,
-1.223475, -0.600393, -1.219984, -0.581194, -1.226966, -0.560251, -1.233947, -0.553269,
-1.226966, -0.535816, -1.221730, -0.528835, -1.223475, -0.516617, -1.216494, -0.500909,
-1.207767, -0.486947, -1.195550, -0.471239, -1.199040, -0.450295, -1.193805, -0.432841,
-1.178097, -0.422370, -1.172860, -0.415388, -1.174605, -0.399680, -1.186823, -0.397935,
-1.186823, -0.389208, -1.193805, -0.373500, -1.197295, -0.366519, -1.200786, -0.354302,
-1.197295, -0.338594, -1.204277, -0.331612, -1.207767, -0.324631, -1.214748, -0.310668, 
/* zone 20 with 31 points. */
-1.019272, -0.595157, -1.022762, -0.588176, -1.015781, -0.575958, -1.017526, -0.556760,
-1.005309, -0.528835, -0.998328, -0.520108, -0.987856, -0.511381, -0.975639, -0.495673,
-0.958185, -0.483456, -0.937242, -0.476475, -0.940732, -0.450295, -0.954695, -0.448550,
-0.960732, -0.464257, -0.972148, -0.476475, -0.996583, -0.476475, -1.022762, -0.474729,
-1.015781, -0.459021, -1.005309, -0.443313, -1.026253, -0.431096, -1.041961, -0.424115,
-1.054178, -0.424115, -1.069886, -0.410152, -1.083849, -0.401426, -1.094321, -0.387463,
-1.101302, -0.383972, -1.117010, -0.383972, -1.127481, -0.397935, -1.132718, -0.389208,
-1.144936, -0.383972, -1.157152, -0.383972, -1.174605, -0.399680, 
/* zone 21 with 29 points. */
-1.094321, -0.387463, -1.085594, -0.363028, -1.076867, -0.343830, -1.050688, -0.338594,
-1.026253, -0.342084, -1.014035, -0.354302, -1.008800, -0.352556, -1.012290, -0.345575,
-1.005309, -0.322886, -1.010545, -0.310668, -1.017526, -0.303687, -1.017526, -0.289724,
-1.029743, -0.286234, -1.047197, -0.289724, -1.057669, -0.268781, -1.055923, -0.246091,
-1.062904, -0.239110, -1.080359, -0.237365, -1.097812, -0.225147, -1.120501, -0.216421,
-1.130973, -0.211185, -1.137954, -0.202458, -1.139699, -0.190241, -1.139699, -0.174533,
-1.157152, -0.174533, -1.172860, -0.179769, -1.186823, -0.188496, -1.193805, -0.195477,
-1.214748, -0.191986, 
/* zone 22 with 10 points. */
-1.005309, -0.528835, -0.993092, -0.528835, -0.980875, -0.539307, -0.977384, -0.544543,
-0.970403, -0.542797, -0.956440, -0.549779, -0.940732, -0.560251, -0.928515, -0.572468,
-0.932006, -0.581194, -0.932006, -0.588176, 
/* zone 23 with 10 points. */
-0.954695, -0.448550, -0.949459, -0.436332, -0.945968, -0.418879, -0.972148, -0.417134,
-0.976912, -0.418879, -0.972148, -0.389208, -0.989601, -0.389208, -1.010545, -0.389208,
-1.008800, -0.370010, -1.014035, -0.354302, 
/* zone 24 with 24 points. */
-1.042197, +0.144626, -1.061159, +0.127409, -1.052433, +0.122173, -1.059414, +0.118682,
-1.068141, +0.115192, -1.069886, +0.102974, -1.059414, +0.090757, -1.047197, +0.090757,
-1.050688, +0.076794, -1.041961, +0.071558, -1.047197, +0.052360, -1.040215, +0.036652,
-1.034980, +0.024435, -1.026253, +0.019199, -1.018942, +0.029671, -1.005309, +0.031416,
-0.987856, +0.031416, -0.994838, +0.038397, -1.000072, +0.057596, -1.007054, +0.061087,
-1.014035, +0.069813, -1.008800, +0.085521, -1.000072, +0.089012, -0.998328, +0.097738, 
/* zone 25 with 9 points. */
-0.987856, +0.031416, -0.977384, +0.033161, -0.979129, +0.040143, -0.965167, +0.040143,
-0.954695, +0.040143, -0.945968, +0.055851, -0.949459, +0.071558, -0.952950, +0.083776,
-0.947713, +0.090757, 
/* zone 26 with 6 points. */
-0.954695, +0.040143, -0.942478, +0.033161, -0.928515, +0.036652, -0.921534, +0.041888,
-0.916298, +0.057596, -0.904080, +0.073304, 
/* zone 27 with 17 points. */
-1.167624, +0.019199, -1.160644, +0.013963, -1.144936, +0.017453, -1.123991, +0.026180,
-1.117010, +0.033161, -1.104793, +0.038397, -1.118755, +0.040143, -1.120501, +0.052360,
-1.115265, +0.064577, -1.129228, +0.071558, -1.118755, +0.069813, -1.099557, +0.066322,
-1.089085, +0.071558, -1.076867, +0.073304, -1.069886, +0.078540, -1.061159, +0.083776,
-1.059414, +0.090757, 
/* zone 28 with 9 points. */
-0.109956, +0.944223, -0.116937, +0.945968, -0.118682, +0.947713, -0.123918, +0.947713,
-0.125664, +0.944223, -0.134390, +0.945968, -0.137881, +0.949459, -0.132645, +0.954695,
-0.125664, +0.958185, 
/* zone 29 with 16 points. */
-0.129154, +0.651007, -0.125664, +0.659734, -0.120428, +0.666716, -0.123918, +0.670206,
-0.122173, +0.677187, -0.122173, +0.682423, -0.125664, +0.689405, -0.118682, +0.698132,
-0.116937, +0.708603, -0.120428, +0.715585, -0.108210, +0.724311, -0.116937, +0.731293,
-0.127409, +0.731293, -0.141372, +0.731293, -0.139626, +0.734783, -0.150098, +0.733038, 
/* zone 30 with 8 points. */
+0.052360, +0.736529, +0.040143, +0.740019, +0.027925, +0.745255, +0.017453, +0.747001,
+0.003491, +0.745255, -0.008727, +0.748746, -0.019199, +0.752237, -0.029671, +0.755727, 
/* zone 31 with 14 points. */
+0.200713, +0.577704, +0.202458, +0.568977, +0.178024, +0.553269, +0.176278, +0.535816,
+0.160570, +0.527089, +0.171042, +0.514872, +0.172788, +0.502655, +0.172788, +0.479966,
+0.172788, +0.466003, +0.164061, +0.459021, +0.174533, +0.445059, +0.181514, +0.427606,
+0.190241, +0.429351, +0.211185, +0.410152, 
/* zone 32 with 8 points. */
+0.148353, +0.644026, +0.144862, +0.637045, +0.144862, +0.617846, +0.143117, +0.603884,
+0.132645, +0.595157, +0.132645, +0.588176, +0.141372, +0.577704, +0.160570, +0.527089, 
/* zone 33 with 10 points. */
-0.034907, +0.610865, -0.031416, +0.603884, -0.029671, +0.589921, -0.024435, +0.575959,
-0.019199, +0.570723, -0.020944, +0.561996, -0.034907, +0.558505, -0.047124, +0.555014,
-0.050615, +0.544543, -0.038397, +0.528835, 
/* zone 34 with 17 points. */
-0.151844, +0.478220, -0.127409, +0.464257, -0.108210, +0.450295, -0.085521, +0.436332,
-0.061087, +0.420624, -0.036652, +0.404916, +0.013963, +0.373500, +0.031416, +0.354302,
+0.055851, +0.347320, +0.057596, +0.331613, +0.073304, +0.335103, +0.099484, +0.343830,
+0.122173, +0.357792, +0.144862, +0.375246, +0.167552, +0.387463, +0.188496, +0.399680,
+0.211185, +0.410152, 
/* zone 35 with 17 points. */
-0.226893, +0.483456, -0.200713, +0.483456, -0.174533, +0.483456, -0.151844, +0.483456,
-0.151844, +0.467748, -0.151844, +0.453786, -0.179769, +0.453786, -0.207694, +0.453786,
-0.207694, +0.431096, -0.207694, +0.410152, -0.219912, +0.408407, -0.225148, +0.387463,
-0.228638, +0.387463, -0.228638, +0.387463, -0.226893, +0.373500, -0.253073, +0.373500,
-0.292507, +0.373500, 
/* zone 36 with 25 points. */
-0.286234, +0.282743, -0.280998, +0.287979, -0.261799, +0.291470, -0.246091, +0.287979,
-0.242601, +0.282743, -0.237365, +0.280998, -0.228638, +0.272271, -0.219912, +0.261799,
-0.211185, +0.258309, -0.204204, +0.261799, -0.198968, +0.279253, -0.190241, +0.267035,
-0.179769, +0.270526, -0.153589, +0.270526, -0.125664, +0.270526, -0.099484, +0.270526,
-0.087266, +0.282743, -0.089012, +0.310668, -0.092502, +0.336848, -0.095993, +0.363028,
-0.102974, +0.389208, -0.109956, +0.403171, -0.109956, +0.422370, -0.109956, +0.436332,
-0.085521, +0.436332, 
/* zone 37 with 5 points. */
-0.289724, +0.216421, -0.272271, +0.216421, -0.261799, +0.221657, -0.246091, +0.221657,
-0.230384, +0.221657, 
/* zone 38 with 5 points. */
-0.198968, +0.216421, -0.197222, +0.226893, -0.204204, +0.233874, -0.209440, +0.244346,
-0.211185, +0.258309, 
/* zone 39 with 12 points. */
-0.289724, +0.228638, -0.275762, +0.230384, -0.268781, +0.233874, -0.265290, +0.235619,
-0.258309, +0.233874, -0.246091, +0.230384, -0.242601, +0.233874, -0.247837, +0.235619,
-0.258309, +0.239110, -0.265290, +0.240855, -0.274017, +0.237365, -0.284488, +0.237365, 
/* zone 40 with 4 points. */
-0.258309, +0.197222, -0.251327, +0.204204, -0.240855, +0.207694, -0.239110, +0.221657, 
/* zone 41 with 22 points. */
-0.225148, +0.158825, -0.216421, +0.174533, -0.205949, +0.176278, -0.193732, +0.176278,
-0.186750, +0.160570, -0.185005, +0.146608, -0.174533, +0.148353, -0.167552, +0.150098,
-0.160570, +0.125664, -0.146608, +0.134390, -0.137881, +0.143117, -0.134390, +0.153589,
-0.137881, +0.164061, -0.141372, +0.176278, -0.134390, +0.181514, -0.146608, +0.191986,
-0.153589, +0.204204, -0.158825, +0.218166, -0.169297, +0.218166, -0.176278, +0.209440,
-0.188496, +0.209440, -0.198968, +0.216421, 
/* zone 42 with 3 points. */
-0.195477, +0.125664, -0.188496, +0.134390, -0.179769, +0.144862, 
/* zone 43 with 6 points. */
-0.132645, +0.076794, -0.130900, +0.101229, -0.137881, +0.108210, -0.150098, +0.111701,
-0.144862, +0.122173, -0.146608, +0.134390, 
/* zone 44 with 17 points. */
-0.047124, +0.092502, -0.048869, +0.099484, -0.055851, +0.116937, -0.050615, +0.132645,
-0.043633, +0.143117, -0.047124, +0.158825, -0.048869, +0.171042, -0.057596, +0.174533,
-0.069813, +0.174533, -0.076794, +0.171042, -0.085521, +0.172788, -0.094248, +0.183260,
-0.108210, +0.178024, -0.109956, +0.188496, -0.116937, +0.188496, -0.123918, +0.179769,
-0.134390, +0.181514, 
/* zone 45 with 12 points. */
+0.022689, +0.108210, +0.013963, +0.116937, +0.008727, +0.132645, +0.008727, +0.151844,
+0.005236, +0.167552, +0.003491, +0.181514, -0.001745, +0.188496, +0.000000, +0.195477,
-0.010472, +0.193732, -0.026180, +0.193732, -0.048869, +0.191986, -0.048869, +0.171042, 
/* zone 46 with 8 points. */
+0.031416, +0.111701, +0.029671, +0.125664, +0.031416, +0.143117, +0.031416, +0.158825,
+0.024435, +0.169297, +0.013963, +0.183260, +0.017453, +0.193732, +0.000000, +0.195477, 
/* zone 47 with 13 points. */
+0.050615, +0.116937, +0.048869, +0.127409, +0.048869, +0.143117, +0.050615, +0.158825,
+0.064577, +0.174533, +0.066322, +0.183260, +0.064577, +0.197222, +0.062832, +0.207694,
+0.050615, +0.218166, +0.041888, +0.211185, +0.034907, +0.200713, +0.022689, +0.197222,
+0.017453, +0.193732, 
/* zone 48 with 18 points. */
+0.041888, +0.211185, +0.034907, +0.221657, +0.022689, +0.225148, +0.019199, +0.233874,
+0.012217, +0.237365, +0.003491, +0.247837, +0.001745, +0.263545, -0.017453, +0.261799,
-0.029671, +0.254818, -0.043633, +0.244346, -0.064577, +0.232129, -0.069813, +0.233874,
-0.075049, +0.230384, -0.075049, +0.221657, -0.082030, +0.211185, -0.092502, +0.207694,
-0.094248, +0.193732, -0.094248, +0.183260, 
/* zone 49 with 8 points. */
-0.001745, +0.263545, -0.013963, +0.261799, +0.022689, +0.263545, +0.047124, +0.267035,
+0.064577, +0.275762, +0.069813, +0.294961, +0.073304, +0.300197, +0.073304, +0.335103, 
/* zone 50 with 29 points. */
+0.151844, +0.087266, +0.155334, +0.101229, +0.165806, +0.111701, +0.179769, +0.122173,
+0.197222, +0.113446, +0.205949, +0.129154, +0.214676, +0.148353, +0.223402, +0.155334,
+0.228638, +0.169297, +0.233874, +0.179769, +0.240855, +0.195477, +0.253073, +0.205949,
+0.247837, +0.216421, +0.244346, +0.230384, +0.237365, +0.240855, +0.216421, +0.232129,
+0.200713, +0.233874, +0.179769, +0.232129, +0.169297, +0.225148, +0.153589, +0.225148,
+0.136136, +0.233874, +0.122173, +0.230384, +0.113446, +0.237365, +0.095993, +0.240855,
+0.080285, +0.239110, +0.071558, +0.233874, +0.069813, +0.226893, +0.064577, +0.218166,
+0.062832, +0.207694, 
/* zone 51 with 11 points. */
+0.237365, +0.240855, +0.232129, +0.249582, +0.242601, +0.261799, +0.251327, +0.272271,
+0.268781, +0.293215, +0.270526, +0.319395, +0.272271, +0.342084, +0.275762, +0.354302,
+0.265290, +0.373500, +0.267035, +0.387463, +0.265290, +0.403171, 
/* zone 52 with 25 points. */
+0.139626, +0.764454, +0.136136, +0.773180, +0.125664, +0.773180, +0.125664, +0.778417,
+0.122173, +0.785398, +0.125664, +0.790634, +0.123918, +0.799361, +0.125664, +0.802851,
+0.123918, +0.806342, +0.118682, +0.809833, +0.108210, +0.804596, +0.104720, +0.808087,
+0.109956, +0.816814, +0.125664, +0.825540, +0.134390, +0.830777, +0.134390, +0.834267,
+0.137881, +0.849975, +0.144862, +0.856956, +0.111701, +0.862192, +0.102974, +0.863938,
+0.102974, +0.863938, +0.102974, +0.863938, +0.075049, +0.872665, +0.068068, +0.881391,
+0.048869, +0.890118, 
/* zone 53 with 5 points. */
+0.111701, +0.862192, +0.113446, +0.870919, +0.109956, +0.874410, +0.104720, +0.870919,
+0.102974, +0.863938, 
/* zone 54 with 8 points. */
+0.109956, +0.874410, +0.115192, +0.883136, +0.108210, +0.886627, +0.099484, +0.886627,
+0.102974, +0.895354, +0.083776, +0.895354, +0.071558, +0.891863, +0.061087, +0.893608, 
/* zone 55 with 6 points. */
+0.108210, +0.886627, +0.109956, +0.897099, +0.108210, +0.905826, +0.120428, +0.909316,
+0.125664, +0.916298, +0.127409, +0.928515, 
/* zone 56 with 11 points. */
+0.235619, +0.801106, +0.235619, +0.811578, +0.219911, +0.816814, +0.212930, +0.822050,
+0.188496, +0.816814, +0.162316, +0.808087, +0.160570, +0.801106, +0.150098, +0.809833,
+0.143117, +0.808087, +0.139626, +0.802851, +0.125664, +0.802851, 
/* zone 57 with 6 points. */
+0.188496, +0.816814, +0.167552, +0.822050, +0.171042, +0.830777, +0.155334, +0.834267,
+0.144862, +0.832522, +0.134390, +0.830777, 
/* zone 58 with 12 points. */
+0.171042, +0.830777, +0.181514, +0.825540, +0.185005, +0.832522, +0.202458, +0.830777,
+0.214675, +0.834267, +0.226893, +0.832522, +0.226893, +0.841249, +0.233874, +0.842994,
+0.240855, +0.851720, +0.232129, +0.858702, +0.221657, +0.863938, +0.212930, +0.876155, 
/* zone 59 with 2 points. */
+0.151844, +0.958185, +0.171042, +0.956440, 
/* zone 60 with 14 points. */
+0.235619, +0.811578, +0.254818, +0.809833, +0.261799, +0.815069, +0.280998, +0.815069,
+0.280998, +0.820305, +0.286234, +0.825540, +0.289724, +0.834267, +0.300196, +0.839503,
+0.294960, +0.848230, +0.289724, +0.853466, +0.277507, +0.853466, +0.261799, +0.853466,
+0.251327, +0.848230, +0.240855, +0.851720, 
/* zone 61 with 11 points. */
+0.212930, +0.876155, +0.228638, +0.879646, +0.246091, +0.886627, +0.246091, +0.890118,
+0.260054, +0.888372, +0.263545, +0.895354, +0.258309, +0.904080, +0.254818, +0.918043,
+0.247837, +0.923279, +0.253073, +0.930260, +0.247837, +0.938987, 
/* zone 62 with 26 points. */
+0.195477, +1.031488, +0.202458, +1.027998, +0.205949, +1.040215, +0.216421, +1.047197,
+0.219911, +1.057669, +0.216421, +1.064651, +0.223402, +1.071631, +0.212930, +1.078612,
+0.216421, +1.087339, +0.209440, +1.103047, +0.225147, +1.120501, +0.244346, +1.118755,
+0.246091, +1.122246, +0.237365, +1.129228, +0.256563, +1.150171, +0.254818, +1.155407,
+0.268781, +1.155407, +0.274017, +1.162389, +0.284488, +1.171115, +0.282743, +1.178097,
+0.294960, +1.186823, +0.315904, +1.190314, +0.322886, +1.197295, +0.349066, +1.195550,
+0.352556, +1.202531, +0.359538, +1.206021, 
/* zone 63 with 24 points. */
+0.172788, +0.036652, +0.197222, +0.038397, +0.216421, +0.038397, +0.232129, +0.034907,
+0.254818, +0.036652, +0.279253, +0.029671, +0.280998, +0.040143, +0.274017, +0.055851,
+0.263545, +0.066322, +0.260054, +0.076794, +0.254818, +0.099484, +0.249582, +0.104720,
+0.258309, +0.116937, +0.267035, +0.134390, +0.267035, +0.139626, +0.261799, +0.153589,
+0.244346, +0.167552, +0.247837, +0.174533, +0.268781, +0.176278, +0.261799, +0.190241,
+0.261799, +0.205949, +0.258309, +0.218166, +0.249582, +0.230383, +0.244346, +0.230383, 
/* zone 64 with 13 points. */
+0.438077, +0.551524, +0.432841, +0.523599, +0.436332, +0.506145, +0.436332, +0.462512,
+0.436332, +0.418879, +0.436332, +0.410152, +0.436332, +0.383972, +0.471239, +0.383972,
+0.506145, +0.383972, +0.541052, +0.383972, +0.575958, +0.383972, +0.610865, +0.383972,
+0.642281, +0.383972, 
/* zone 65 with 13 points. */
+0.211185, +0.410152, +0.246091, +0.410152, +0.260054, +0.401426, +0.265290, +0.403171,
+0.279253, +0.410152, +0.307178, +0.397935, +0.335103, +0.380482, +0.364774, +0.368264,
+0.389208, +0.356047, +0.418879, +0.338594, +0.418879, +0.350811, +0.436332, +0.350811,
+0.436332, +0.383972, 
/* zone 66 with 3 points. */
+0.169297, +0.015708, +0.197222, +0.017453, +0.197222, +0.038397, 
/* zone 67 with 19 points. */
+0.197222, -0.068068, +0.202458, -0.059341, +0.209440, -0.062832, +0.207694, -0.052360,
+0.202458, -0.050615, +0.204204, -0.041888, +0.219911, -0.040143, +0.218166, -0.033161,
+0.232129, -0.040143, +0.244346, -0.040143, +0.249582, -0.034907, +0.253073, -0.008727,
+0.244346, -0.003491, +0.249582, +0.012217, +0.251327, +0.022689, +0.244346, +0.022689,
+0.232129, +0.020944, +0.230383, +0.027925, +0.232129, +0.034907, 
/* zone 68 with 20 points. */
+0.209440, -0.085521, +0.223402, -0.076794, +0.228638, -0.082030, +0.233874, -0.083776,
+0.240855, -0.076794, +0.251327, -0.075049, +0.253073, -0.083776, +0.272271, -0.071558,
+0.280998, -0.061087, +0.282743, -0.038397, +0.293215, -0.022689, +0.308923, -0.008727,
+0.310668, +0.013963, +0.315904, +0.033161, +0.321140, +0.052360, +0.324631, +0.064577,
+0.310668, +0.064577, +0.298451, +0.059341, +0.291470, +0.052360, +0.280998, +0.040143, 
/* zone 69 with 4 points. */
+0.212930, -0.099484, +0.218166, -0.101229, +0.219911, -0.089012, +0.228638, -0.082030, 
/* zone 70 with 43 points. */
+0.216421, -0.104720, +0.223402, -0.102974, +0.233874, -0.097738, +0.239110, -0.101229,
+0.261799, -0.101229, +0.286234, -0.101229, +0.294960, -0.122173, +0.294960, -0.127409,
+0.300196, -0.130900, +0.305433, -0.139626, +0.324631, -0.139626, +0.335103, -0.139626,
+0.338594, -0.132645, +0.342084, -0.122173, +0.354302, -0.120428, +0.359538, -0.120428,
+0.356047, -0.132645, +0.380482, -0.130900, +0.380482, -0.148353, +0.378736, -0.169297,
+0.387463, -0.179769, +0.387463, -0.191986, +0.404916, -0.193732, +0.418879, -0.193732,
+0.424115, -0.195477, +0.424115, -0.204204, +0.439823, -0.195477, +0.445059, -0.205949,
+0.467748, -0.209440, +0.471239, -0.204204, +0.478220, -0.214675, +0.493928, -0.219911,
+0.506145, -0.233874, +0.518363, -0.232129, +0.520108, -0.212930, +0.509636, -0.216421,
+0.504400, -0.216421, +0.493928, -0.207694, +0.492183, -0.195477, +0.497419, -0.185005,
+0.497419, -0.171042, +0.502655, -0.151844, +0.534070, -0.144862, 
/* zone 71 with 16 points. */
+0.509636, -0.059341, +0.507891, -0.050615, +0.502655, -0.045379, +0.509636, -0.031416,
+0.514872, -0.024435, +0.516617, +0.000000, +0.523599, +0.017453, +0.530580, +0.022689,
+0.544543, +0.036652, +0.534070, +0.041888, +0.535816, +0.061087, +0.520108, +0.080285,
+0.509636, +0.076794, +0.499164, +0.078540, +0.492183, +0.076794, +0.478220, +0.090757, 
/* zone 72 with 39 points. */
+0.324631, +0.064577, +0.326376, +0.076794, +0.340339, +0.090757, +0.359538, +0.083776,
+0.389208, +0.075049, +0.397935, +0.085521, +0.408407, +0.083776, +0.422370, +0.087266,
+0.432841, +0.085521, +0.439823, +0.089012, +0.448550, +0.090757, +0.459021, +0.089012,
+0.478220, +0.090757, +0.476475, +0.099484, +0.464257, +0.106465, +0.459021, +0.116937,
+0.441568, +0.129154, +0.439823, +0.136136, +0.431096, +0.143117, +0.422370, +0.144862,
+0.420624, +0.153589, +0.410152, +0.155334, +0.413643, +0.171042, +0.403171, +0.185005,
+0.401426, +0.193732, +0.387463, +0.193732, +0.380482, +0.186750, +0.375246, +0.178024,
+0.370010, +0.176278, +0.366519, +0.167552, +0.354302, +0.158825, +0.331612, +0.157080,
+0.333358, +0.151844, +0.319395, +0.141372, +0.301942, +0.132645, +0.291470, +0.130900,
+0.289724, +0.136136, +0.284488, +0.130900, +0.267035, +0.134390, 
/* zone 73 with 12 points. */
+0.401426, +0.193732, +0.396190, +0.200713, +0.389208, +0.212930, +0.382227, +0.225147,
+0.387463, +0.233874, +0.385718, +0.240855, +0.390954, +0.249582, +0.396190, +0.261799,
+0.401426, +0.275762, +0.418879, +0.275762, +0.418879, +0.298451, +0.418879, +0.338594, 
/* zone 74 with 17 points. */
+0.207694, -0.301942, +0.230383, -0.298451, +0.244346, -0.307178, +0.249582, -0.303687,
+0.284488, -0.303687, +0.319395, -0.303687, +0.329867, -0.310668, +0.357792, -0.314159,
+0.383972, -0.314159, +0.404916, -0.307178, +0.394444, -0.296706, +0.383972, -0.287979,
+0.383972, -0.258309, +0.383972, -0.226893, +0.415388, -0.226893, +0.417134, -0.216421,
+0.418879, -0.193732, 
/* zone 75 with 23 points. */
+0.404916, -0.307178, +0.424115, -0.303687, +0.434587, -0.307178, +0.439823, -0.312414,
+0.455531, -0.312414, +0.464257, -0.315904, +0.479965, -0.307178, +0.486947, -0.296706,
+0.500909, -0.291470, +0.504400, -0.279253, +0.513127, -0.275762, +0.528835, -0.272271,
+0.527089, -0.261799, +0.551524, -0.254818, +0.577704, -0.246091, +0.572468, -0.235619,
+0.577704, -0.221657, +0.579449, -0.214675, +0.577704, -0.202458, +0.588176, -0.188496,
+0.575958, -0.169297, +0.561996, -0.160570, +0.542797, -0.153589, 
/* zone 76 with 37 points. */
+0.439823, -0.312414, +0.427606, -0.317650, +0.411898, -0.324631, +0.404916, -0.317650,
+0.378736, -0.321140, +0.366519, -0.322886, +0.366519, -0.354302, +0.366519, -0.383972,
+0.349066, -0.383972, +0.349066, -0.410152, +0.349066, -0.436332, +0.361283, -0.443313,
+0.363028, -0.457276, +0.359538, -0.467748, +0.385718, -0.466003, +0.390954, -0.459021,
+0.397935, -0.455531, +0.397935, -0.446804, +0.406662, -0.441568, +0.417134, -0.446804,
+0.431096, -0.450295, +0.445059, -0.446804, +0.452040, -0.432841, +0.462512, -0.431096,
+0.467748, -0.415388, +0.493928, -0.394444, +0.502655, -0.389208, +0.511381, -0.385718,
+0.502655, -0.378736, +0.488692, -0.375246, +0.483456, -0.368264, +0.483456, -0.357792,
+0.476475, -0.352556, +0.471239, -0.349066, +0.457276, -0.343830, +0.450295, -0.331612,
+0.439823, -0.312414, 
/* zone 77 with 9 points. */
+0.472984, -0.518363, +0.483456, -0.537561, +0.492183, -0.530580, +0.495673, -0.527089,
+0.507891, -0.523599, +0.513127, -0.511381, +0.500909, -0.499164, +0.485201, -0.506145,
+0.472984, -0.518363, 
/* zone 78 with 16 points. */
+0.359538, +1.206021, +0.373500, +1.209513, +0.389208, +1.200786, +0.411898, +1.197295,
+0.422370, +1.200786, +0.438077, +1.197295, +0.450295, +1.204277, +0.455531, +1.216494,
+0.467748, +1.221730, +0.488692, +1.223475, +0.509636, +1.216494, +0.500909, +1.206021,
+0.507891, +1.206021, +0.527089, +1.216494, +0.535816, +1.213003, +0.539307, +1.218239, 
/* zone 79 with 9 points. */
+0.420624, +1.150171, +0.413643, +1.158898, +0.418879, +1.165879, +0.413643, +1.174605,
+0.415388, +1.185078, +0.408407, +1.190314, +0.401426, +1.195550, +0.385718, +1.197295,
+0.359538, +1.206021, 
/* zone 80 with 18 points. */
+0.485201, +1.057669, +0.493928, +1.064651, +0.509636, +1.069886, +0.516617, +1.078612,
+0.537561, +1.087339, +0.551524, +1.099557, +0.542797, +1.106538, +0.523599, +1.113520,
+0.530580, +1.118755, +0.527089, +1.122246, +0.525344, +1.127481, +0.520108, +1.130973,
+0.516617, +1.141444, +0.525344, +1.148426, +0.506145, +1.171115, +0.525344, +1.183332,
+0.492183, +1.197295, +0.500909, +1.206021, 
/* zone 81 with 29 points. */
+0.260054, +0.888372, +0.265290, +0.890118, +0.267035, +0.884882, +0.284488, +0.881391,
+0.293215, +0.874410, +0.294960, +0.883136, +0.307178, +0.879646, +0.322886, +0.869174,
+0.333358, +0.862192, +0.340339, +0.867428, +0.349066, +0.860447, +0.359538, +0.862192,
+0.378736, +0.863938, +0.389208, +0.858702, +0.406662, +0.872665, +0.420624, +0.879646,
+0.420624, +0.890118, +0.413643, +0.900590, +0.415388, +0.909316, +0.406662, +0.912807,
+0.415388, +0.918043, +0.418879, +0.925024, +0.413643, +0.937242, +0.410152, +0.945968,
+0.399680, +0.949459, +0.392699, +0.945968, +0.382227, +0.947713, +0.363028, +0.949459,
+0.343830, +0.951204, 
/* zone 82 with 5 points. */
+0.396190, +0.949459, +0.401426, +0.958186, +0.394444, +0.961676, +0.380482, +0.961676,
+0.370010, +0.965167, 
/* zone 83 with 16 points. */
+0.411898, +0.944223, +0.427606, +0.942478, +0.434587, +0.942478, +0.434587, +0.945969,
+0.446804, +0.947714, +0.452040, +0.945969, +0.450295, +0.949459, +0.452040, +0.958186,
+0.467748, +0.965167, +0.462512, +0.970403, +0.464258, +0.972148, +0.441568, +0.980875,
+0.432842, +0.986111, +0.420624, +0.982620, +0.387463, +0.984366, +0.366519, +0.977384, 
/* zone 84 with 11 points. */
+0.464258, +0.972148, +0.472984, +0.975639, +0.485202, +0.977384, +0.492183, +0.980875,
+0.486947, +0.993092, +0.483456, +0.993092, +0.485202, +1.001819, +0.478220, +1.005310,
+0.462512, +1.005310, +0.441568, +1.014036, +0.425860, +1.008800, 
/* zone 85 with 6 points. */
+0.478220, +1.005310, +0.485202, +1.010546, +0.478220, +1.017527, +0.479966, +1.027999,
+0.488692, +1.034980, +0.488692, +1.038471, 
/* zone 86 with 8 points. */
+0.300196, +0.839503, +0.308923, +0.834267, +0.324631, +0.834267, +0.328122, +0.837758,
+0.349066, +0.841249, +0.363028, +0.848230, +0.387463, +0.846484, +0.389208, +0.858702, 
/* zone 87 with 10 points. */
+0.280998, +0.815069, +0.296706, +0.808087, +0.312414, +0.799361, +0.328122, +0.801106,
+0.338594, +0.804596, +0.354302, +0.806342, +0.370010, +0.809833, +0.380482, +0.823795,
+0.394444, +0.834267, +0.387463, +0.846484, 
/* zone 88 with 19 points. */
+0.338594, +0.733038, +0.343830, +0.745255, +0.357792, +0.736529, +0.359538, +0.720821,
+0.366519, +0.712094, +0.383972, +0.717330, +0.397935, +0.719076, +0.403171, +0.729547,
+0.394444, +0.736529, +0.396190, +0.748746, +0.401426, +0.755727, +0.392699, +0.764454,
+0.397935, +0.771435, +0.396190, +0.781907, +0.385718, +0.778417, +0.371755, +0.783653,
+0.371755, +0.790634, +0.364774, +0.792379, +0.354302, +0.806342, 
/* zone 89 with 3 points. */
+0.352556, +0.692895, +0.361283, +0.699877, +0.366519, +0.712094, 
/* zone 90 with 9 points. */
+0.397935, +0.719076, +0.422370, +0.727802, +0.441568, +0.720821, +0.455531, +0.722566,
+0.455531, +0.729547, +0.464257, +0.729547, +0.474729, +0.733038, +0.479965, +0.731293,
+0.490437, +0.731293, 
/* zone 91 with 4 points. */
+0.455531, +0.712094, +0.460767, +0.719076, +0.466003, +0.726057, +0.464257, +0.729547, 
/* zone 92 with 13 points. */
+0.516617, +0.794125, +0.499164, +0.790634, +0.492183, +0.795870, +0.490437, +0.804596,
+0.492183, +0.815069, +0.488692, +0.823795, +0.471239, +0.841249, +0.453786, +0.837758,
+0.441568, +0.836012, +0.431096, +0.834267, +0.418879, +0.836012, +0.404916, +0.839503,
+0.394444, +0.834267, 
/* zone 93 with 8 points. */
+0.397935, +0.771435, +0.403171, +0.764454, +0.424115, +0.762709, +0.445059, +0.762709,
+0.455531, +0.767945, +0.471239, +0.769690, +0.486947, +0.767945, +0.495673, +0.764454, 
/* zone 94 with 6 points. */
-0.146608, +0.483456, -0.123918, +0.492183, -0.104720, +0.499164, -0.090757, +0.506145,
-0.075049, +0.513127, -0.038397, +0.530580, 
/* zone 95 with 14 points. */
+0.511381, -0.385718, +0.523599, -0.387463, +0.534070, -0.389208, +0.546288, -0.389208,
+0.567232, -0.371755, +0.568977, -0.357792, +0.574213, -0.345575, +0.572468, -0.328122,
+0.574213, -0.314159, +0.572468, -0.294960, +0.555014, -0.284488, +0.542797, -0.279253,
+0.530580, -0.280998, +0.528835, -0.272271, 
/* zone 96 with 10 points. */
+0.514872, -0.078540, +0.523599, -0.075049, +0.528835, -0.066322, +0.537561, -0.055851,
+0.527089, -0.052360, +0.532325, -0.041888, +0.523599, -0.041888, +0.518363, -0.052360,
+0.511381, -0.048869, +0.507891, -0.050615, 
/* zone 97 with 6 points. */
+0.532325, -0.041888, +0.534070, -0.040143, +0.535816, -0.029671, +0.532325, -0.019199,
+0.521853, -0.026180, +0.514872, -0.024435, 
/* zone 98 with 6 points. */
+0.546288, -0.389208, +0.551524, -0.410152, +0.558505, -0.425860, +0.558505, -0.452040,
+0.560251, -0.469493, +0.572468, -0.467748, 
/* zone 99 with 6 points. */
+0.558505, -0.452040, +0.546288, -0.450295, +0.520108, -0.460767, +0.541052, -0.472984,
+0.558505, -0.476475, +0.560251, -0.469493, 
/* zone 100 with 7 points. */
+0.703367, -0.183260, +0.694641, -0.188496, +0.671952, -0.197222, +0.657989, -0.204204,
+0.638790, -0.205949, +0.628318, -0.200713, +0.609120, -0.204204, 
/* zone 101 with 13 points. */
+0.607374, -0.235619, +0.614356, -0.246091, +0.624828, -0.258309, +0.624828, -0.279253,
+0.614356, -0.284488, +0.616101, -0.294960, +0.610865, -0.296706, +0.610865, -0.293215,
+0.598648, -0.275762, +0.603884, -0.261799, +0.596902, -0.253073, +0.586430, -0.254818,
+0.577704, -0.246091, 
/* zone 102 with 8 points. */
+0.682423, -0.082030, +0.659734, -0.064577, +0.659734, -0.055851, +0.631809, -0.036652,
+0.598648, -0.020944, +0.591666, -0.017453, +0.561996, -0.017453, +0.532325, -0.019199, 
/* zone 103 with 13 points. */
+0.591666, -0.017453, +0.591666, +0.003491, +0.605629, +0.022689, +0.610865, +0.031416,
+0.607374, +0.045379, +0.600393, +0.052360, +0.598648, +0.062832, +0.593412, +0.071558,
+0.581194, +0.064577, +0.572468, +0.066322, +0.560251, +0.061087, +0.542797, +0.066322,
+0.535816, +0.061087, 
/* zone 104 with 14 points. */
+0.722566, -0.027925, +0.715585, -0.013963, +0.715585, +0.017453, +0.715585, +0.050615,
+0.729547, +0.068068, +0.719076, +0.069813, +0.712094, +0.075049, +0.694641, +0.069813,
+0.689405, +0.061087, +0.663225, +0.062832, +0.645772, +0.076794, +0.626573, +0.080285,
+0.600393, +0.080285, +0.593412, +0.071558, 
/* zone 105 with 22 points. */
+0.626573, +0.080285, +0.623082, +0.092502, +0.617846, +0.094248, +0.612610, +0.099484,
+0.607374, +0.111701, +0.595157, +0.123918, +0.586430, +0.134390, +0.575958, +0.134390,
+0.579449, +0.148353, +0.591666, +0.148353, +0.595157, +0.169297, +0.598648, +0.188496,
+0.607374, +0.188496, +0.612610, +0.205949, +0.621337, +0.221657, +0.630064, +0.223402,
+0.635300, +0.246091, +0.633554, +0.267035, +0.642281, +0.282743, +0.644026, +0.296706,
+0.657989, +0.307178, +0.668461, +0.315904, 
/* zone 106 with 7 points. */
+0.753982, +0.199260, +0.748746, +0.191986, +0.745255, +0.188496, +0.755727, +0.167552,
+0.767945, +0.157080, +0.792379, +0.148353, +0.836012, +0.139626, 
/* zone 107 with 6 points. */
+0.750491, +0.223402, +0.743510, +0.216421, +0.740019, +0.218166, +0.729547, +0.204204,
+0.733038, +0.191986, +0.748746, +0.191986, 
/* zone 108 with 20 points. */
+0.617846, +0.572468, +0.638790, +0.563741, +0.659734, +0.572468, +0.677187, +0.581194,
+0.694641, +0.589921, +0.713839, +0.602139, +0.720821, +0.609120, +0.724311, +0.624828,
+0.722566, +0.633554, +0.740019, +0.647517, +0.736529, +0.651007, +0.722566, +0.647517,
+0.713839, +0.647517, +0.685914, +0.640536, +0.673697, +0.645772, +0.652753, +0.640536,
+0.645772, +0.644026, +0.640536, +0.640536, +0.637045, +0.631809, +0.626573, +0.624828, 
/* zone 109 with 15 points. */
+0.740019, +0.647517, +0.748746, +0.652753, +0.764454, +0.652753, +0.771435, +0.649262,
+0.776671, +0.654498, +0.773180, +0.659734, +0.774926, +0.675442, +0.769690, +0.689405,
+0.778417, +0.696386, +0.773180, +0.699877, +0.762709, +0.701622, +0.762709, +0.715585,
+0.748746, +0.724311, +0.743510, +0.729547, +0.724311, +0.727802, 
/* zone 110 with 5 points. */
+0.619592, +0.581194, +0.628318, +0.586430, +0.633554, +0.595157, +0.633554, +0.602139,
+0.624828, +0.602139, 
/* zone 111 with 8 points. */
+0.609120, +0.509636, +0.628318, +0.507891, +0.664970, +0.513127, +0.664970, +0.523599,
+0.645772, +0.546288, +0.649262, +0.553269, +0.682423, +0.561996, +0.677187, +0.582921, 
/* zone 112 with 8 points. */
+0.853466, +0.671952, +0.837758, +0.675442, +0.841249, +0.691150, +0.836012, +0.694641,
+0.806342, +0.678933, +0.797615, +0.678933, +0.783653, +0.687660, +0.778417, +0.696386, 
/* zone 113 with 5 points. */
+0.773180, +0.303687, +0.755727, +0.307178, +0.752237, +0.300196, +0.750491, +0.287979,
+0.747001, +0.284488, 
/* zone 114 with 6 points. */
+0.836012, +0.139626, +0.813323, +0.115192, +0.785398, +0.089012, +0.755727, +0.083776,
+0.747001, +0.075049, +0.727802, +0.068068, 
/* zone 115 with 5 points. */
+0.799361, +0.261799, +0.785540, +0.303687, +0.785398, +0.301942, +0.776671, +0.303687,
+0.760963, +0.303687, 
/* zone 116 with 5 points. */
+0.921534, +0.307178, +0.914552, +0.317650, +0.905826, +0.326376, +0.900590, +0.333358,
+0.897099, +0.338594, 
/* zone 117 with 11 points. */
+0.593412, +0.546288, +0.600393, +0.523599, +0.605629, +0.511381, +0.617846, +0.549779,
+0.609120, +0.548033, +0.610865, +0.555014, +0.607374, +0.567232, +0.609120, +0.565486,
+0.619592, +0.570723, +0.619592, +0.579449, +0.612610, +0.575958, 
/* zone 118 with 10 points. */
+0.848230, +0.490437, +0.834267, +0.493928, +0.825540, +0.506145, +0.809833, +0.507891,
+0.794125, +0.500909, +0.780162, +0.507891, +0.794125, +0.513127, +0.809833, +0.507891,
+0.827286, +0.523599, +0.834267, +0.523599, 
/* zone 119 with 2 points. */
+0.930260, +0.293215, +0.921534, +0.307178, 
/* zone 120 with 2 points. */
+0.989601, +0.429351, +0.966912, +0.410152, 
/* zone 121 with 3 points. */
+0.902335, +0.410152, +0.893608, +0.425860, +0.886627, +0.439841, 
/* zone 122 with 9 points. */
+0.682423, +0.561996, +0.699877, +0.558505, +0.722566, +0.551524, +0.733038, +0.542797,
+0.750491, +0.535816, +0.750491, +0.530580, +0.760963, +0.530580, +0.760963, +0.518363,
+0.781907, +0.509636, 
/* zone 123 with 3 points. */
+0.808087, +0.509636, +0.823795, +0.523599, +0.834267, +0.523599, 
/* zone 124 with 2 points. */
+0.808087, +0.509636, +0.823795, +0.507891, 
/* zone 125 with 16 points. */
+0.776671, +0.654498, +0.785398, +0.644026, +0.790634, +0.630064, +0.802851, +0.626573,
+0.806342, +0.616101, +0.794125, +0.600393, +0.795870, +0.599120, +0.802851, +0.582940,
+0.806342, +0.575958, +0.820305, +0.572468, +0.832522, +0.558505, +0.830777, +0.549779,
+0.830777, +0.542797, +0.836012, +0.542797, +0.837758, +0.530580, +0.844739, +0.523599, 
/* zone 126 with 29 points. */
+1.069886, +0.443313, +1.075122, +0.457276, +1.101302, +0.469493, +1.101302, +0.476475,
+1.092575, +0.476475, +1.092575, +0.492183, +1.073377, +0.500909, +1.062904, +0.520108,
+1.071631, +0.534070, +1.075122, +0.546288, +1.062904, +0.549779, +1.054178, +0.575958,
+1.061159, +0.586430, +1.052433, +0.589921, +1.059414, +0.605629, +1.064651, +0.610865,
+1.066396, +0.623082, +1.064651, +0.640536, +1.050688, +0.642281, +1.041961, +0.649262,
+1.027998, +0.657989, +1.017526, +0.657989, +0.998328, +0.666716, +0.982620, +0.666716,
+0.975639, +0.663225, +0.965167, +0.663225, +0.954695, +0.659734, +0.949459, +0.652753,
+0.938987, +0.651007, 
/* zone 127 with 23 points. */
+1.062904, +0.520108, +1.089085, +0.513127, +1.104793, +0.514872, +1.118755, +0.511381,
+1.153662, +0.521853, +1.155407, +0.535816, +1.164134, +0.544543, +1.179842, +0.548033,
+1.188568, +0.555014, +1.195550, +0.556760, +1.200786, +0.553269, +1.207767, +0.558505,
+1.209513, +0.575958, +1.223475, +0.579449, +1.218239, +0.593412, +1.235692, +0.591666,
+1.239183, +0.596902, +1.240929, +0.605629, +1.247910, +0.616101, +1.244419, +0.630064,
+1.268854, +0.642281, +1.288053, +0.644026, +1.303761, +0.647517, 
/* zone 128 with 23 points. */
+1.066396, +0.623082, +1.083849, +0.617846, +1.085594, +0.612610, +1.096066, +0.616101,
+1.101302, +0.624828, +1.125737, +0.635300, +1.134463, +0.649262, +1.143190, +0.651007,
+1.165879, +0.651007, +1.188568, +0.647517, +1.199040, +0.651007, +1.209513, +0.649262,
+1.213003, +0.652753, +1.223475, +0.657989, +1.226966, +0.663225, +1.233947, +0.668461,
+1.242674, +0.664970, +1.247910, +0.657989, +1.246164, +0.647517, +1.251400, +0.642281,
+1.279325, +0.651007, +1.295033, +0.651007, +1.308996, +0.651007, 
/* zone 129 with 21 points. */
+1.188568, +0.417134, +1.200786, +0.420624, +1.225221, +0.424115, +1.235692, +0.422370,
+1.239183, +0.431096, +1.230456, +0.450295, +1.221730, +0.452040, +1.221730, +0.464257,
+1.209513, +0.471239, +1.226966, +0.492183, +1.235692, +0.485201, +1.253145, +0.490437,
+1.256637, +0.495673, +1.261872, +0.502655, +1.274090, +0.511381, +1.282816, +0.525344,
+1.289798, +0.527089, +1.289798, +0.537561, +1.300270, +0.544543, +1.302015, +0.555014,
+1.312487, +0.563741, 
/* zone 130 with 5 points. */
+1.308996, +0.651007, +1.305506, +0.666716, +1.296779, +0.673697, +1.288053, +0.670206,
+1.286306, +0.685914, 
/* zone 131 with 29 points. */
+1.286307, +0.685914, +1.296779, +0.698132, +1.307251, +0.703367, +1.319468, +0.706858,
+1.321214, +0.701622, +1.333431, +0.705113, +1.343903, +0.713839, +1.364847, +0.717330,
+1.371828, +0.722566, +1.389281, +0.729547, +1.399754, +0.734783, +1.399754, +0.745255,
+1.406734, +0.753982, +1.401499, +0.769690, +1.396263, +0.783653, +1.429424, +0.790634,
+1.441641, +0.788889, +1.443387, +0.792379, +1.436405, +0.799361, +1.443387, +0.808087,
+1.452113, +0.825540, +1.467821, +0.822050, +1.483529, +0.822050, +1.497492, +0.825540,
+1.494001, +0.834267, +1.495747, +0.846484, +1.513200, +0.851720, +1.514945, +0.860447,
+1.534143, +0.862192, 
/* zone 132 with 25 points. */
+1.413716, +0.528835, +1.398008, +0.504400, +1.415462, +0.499164, +1.429424, +0.486947,
+1.450368, +0.479965, +1.466076, +0.479965, +1.480039, +0.474729, +1.497492, +0.466003,
+1.516690, +0.462512, +1.535889, +0.460767, +1.535889, +0.469493, +1.534143, +0.476475,
+1.537634, +0.488692, +1.521927, +0.486947, +1.504473, +0.497419, +1.490510, +0.493928,
+1.483529, +0.506145, +1.476548, +0.504400, +1.469566, +0.511381, +1.464331, +0.511381,
+1.459094, +0.507891, +1.453858, +0.514872, +1.441641, +0.523599, +1.427678, +0.528835,
+1.413716, +0.528835, 
/* zone 133 with 3 points. */
+1.553343, +0.479965, +1.548106, +0.490437, +1.537634, +0.488692, 
/* zone 134 with 23 points. */
+1.609193, +0.366519, +1.607448, +0.373500, +1.617920, +0.370010, +1.616174, +0.382227,
+1.609193, +0.410152, +1.603957, +0.415388, +1.598721, +0.399680, +1.589994, +0.410152,
+1.593485, +0.418879, +1.603957, +0.424115, +1.610938, +0.436332, +1.576032, +0.436332,
+1.567305, +0.446804, +1.563814, +0.459021, +1.556833, +0.455531, +1.546361, +0.462512,
+1.537634, +0.453786, +1.551597, +0.441568, +1.537634, +0.432841, +1.549851, +0.422370,
+1.548106, +0.415388, +1.551597, +0.404916, +1.553343, +0.382227, 
/* zone 135 with 30 points. */
+1.616174, +0.382227, +1.623156, +0.389208, +1.623156, +0.401426, +1.626646, +0.410152,
+1.623156, +0.422370, +1.640609, +0.418879, +1.651081, +0.436332, +1.656317, +0.450295,
+1.659807, +0.467748, +1.682497, +0.476475, +1.692968, +0.476475, +1.692968, +0.488692,
+1.699950, +0.495673, +1.677260, +0.495673, +1.680751, +0.502655, +1.675515, +0.507891,
+1.675515, +0.511381, +1.652826, +0.511381, +1.630136, +0.500909, +1.609193, +0.486947,
+1.600466, +0.485201, +1.603957, +0.467748, +1.588249, +0.467748, +1.567305, +0.466003,
+1.551597, +0.472984, +1.553343, +0.479965, +1.558578, +0.490437, +1.570796, +0.493928,
+1.584758, +0.490437, +1.600466, +0.485201, 
/* zone 136 with 43 points. */
+1.722639, +0.178024, +1.724384, +0.188496, +1.740092, +0.204204, +1.740092, +0.214675,
+1.731366, +0.228638, +1.731366, +0.244346, +1.717403, +0.260054, +1.715658, +0.268781,
+1.722639, +0.274017, +1.726130, +0.286234, +1.724384, +0.293215, +1.715658, +0.300196,
+1.708676, +0.308923, +1.705186, +0.319395, +1.696460, +0.329867, +1.705186, +0.333358,
+1.710422, +0.343830, +1.724384, +0.345575, +1.727876, +0.352556, +1.747074, +0.359538,
+1.748819, +0.370010, +1.759291, +0.373500, +1.762782, +0.380482, +1.748819, +0.378736,
+1.740092, +0.387463, +1.731366, +0.389208, +1.731366, +0.399680, +1.734857, +0.403171,
+1.727876, +0.404916, +1.724384, +0.417134, +1.726130, +0.424115, +1.701695, +0.418879,
+1.705186, +0.425860, +1.699950, +0.429351, +1.708676, +0.441568, +1.719149, +0.450295,
+1.720894, +0.459021, +1.720894, +0.471239, +1.717403, +0.479965, +1.713913, +0.478220,
+1.712167, +0.486947, +1.708676, +0.493928, +1.699950, +0.495673, 
/* zone 137 with 6 points. */
+1.745329, +0.116937, +1.748819, +0.122173, +1.766273, +0.111701, +1.764527, +0.104720,
+1.781981, +0.106465, +1.783726, +0.113446, 
/* zone 138 with 20 points. */
+1.795943, +0.207694, +1.785471, +0.239110, +1.799434, +0.249582, +1.829104, +0.249582,
+1.837831, +0.251327, +1.841322, +0.261799, +1.841322, +0.275762, +1.829104, +0.286234,
+1.827359, +0.301942, +1.813396, +0.319395, +1.801180, +0.322886, +1.792453, +0.314159,
+1.778490, +0.317650, +1.761037, +0.308923, +1.762782, +0.319395, +1.766273, +0.343830,
+1.755801, +0.342084, +1.752310, +0.347320, +1.755801, +0.354302, +1.747074, +0.359538, 
/* zone 139 with 30 points. */
+1.726129, +0.907571, +1.750565, +0.905826, +1.768018, +0.902335, +1.781981, +0.898845,
+1.790708, +0.886627, +1.802924, +0.877900, +1.820378, +0.877900, +1.825614, +0.879646,
+1.832596, +0.879646, +1.853539, +0.877900, +1.865757, +0.877900, +1.874483, +0.872665,
+1.884955, +0.872665, +1.897173, +0.863938, +1.921607, +0.860447, +1.933825, +0.862193,
+1.940805, +0.862193, +1.960004, +0.865683, +1.968731, +0.867429, +1.975713, +0.872665,
+1.993166, +0.879646, +2.001892, +0.881391, +2.008874, +0.879646, +2.021091, +0.872665,
+2.028072, +0.874410, +2.042035, +0.869174, +2.061234, +0.865683, +2.073451, +0.874410,
+2.082177, +0.879646, +2.094395, +0.898844, 
/* zone 140 with 24 points. */
+1.837831, +0.251327, +1.846558, +0.247837, +1.855285, +0.256563, +1.867502, +0.251327,
+1.874483, +0.258309, +1.872738, +0.272271, +1.870993, +0.282743, +1.862266, +0.293215,
+1.851794, +0.298451, +1.843067, +0.310668, +1.829104, +0.328122, +1.813396, +0.336848,
+1.811651, +0.343830, +1.829104, +0.349066, +1.820378, +0.359538, +1.818633, +0.364774,
+1.801180, +0.364774, +1.794198, +0.371755, +1.795943, +0.378736, +1.781981, +0.390954,
+1.775000, +0.389208, +1.776745, +0.370010, +1.762782, +0.370010, +1.762782, +0.380482, 
/* zone 141 with 13 points. */
+1.877974, +0.378736, +1.860520, +0.383972, +1.860520, +0.396190, +1.864011, +0.399680,
+1.844812, +0.401426, +1.836086, +0.410152, +1.818633, +0.397935, +1.815142, +0.399680,
+1.811651, +0.396190, +1.802924, +0.399680, +1.797688, +0.392699, +1.787217, +0.397935,
+1.781981, +0.390954, 
/* zone 142 with 11 points. */
+1.811651, +0.185005, +1.827359, +0.185005, +1.834341, +0.193732, +1.853539, +0.190241,
+1.848303, +0.198968, +1.850049, +0.205949, +1.860520, +0.205949, +1.870993, +0.212930,
+1.877974, +0.239110, +1.872738, +0.247837, +1.874483, +0.258309, 
/* zone 143 with 15 points. */
+2.014110, +0.089012, +2.014110, +0.066322, +2.010619, +0.055851, +2.005383, +0.048869,
+2.001892, +0.034907, +1.991420, +0.027925, +1.982694, +0.026180, +1.970476, +0.029671,
+1.958259, +0.026180, +1.956513, +0.022689, +1.944297, +0.017453, +1.937315, +0.019199,
+1.930334, +0.013963, +1.919862, +0.020944, +1.911136, +0.034907, 
/* zone 144 with 24 points. */
+1.408480, +0.530580, +1.392772, +0.539307, +1.361356, +0.541052, +1.375319, +0.556760,
+1.370083, +0.563741, +1.382300, +0.563741, +1.380554, +0.577704, +1.373573, +0.591666,
+1.385791, +0.593412, +1.399754, +0.616101, +1.375319, +0.628318, +1.338667, +0.638790,
+1.308996, +0.644026, +1.288053, +0.642281, +1.267108, +0.624828, +1.288053, +0.617846,
+1.291543, +0.610865, +1.284561, +0.602139, +1.286307, +0.575958, +1.317723, +0.563741,
+1.324704, +0.572468, +1.338667, +0.575958, +1.356120, +0.574213, +1.370083, +0.563741, 
/* zone 145 with 15 points. */
+2.167698, +0.694641, +2.179915, +0.708603, +2.192133, +0.713839, +2.204350, +0.719076,
+2.213077, +0.729547, +2.218312, +0.731293, +2.221804, +0.727802, +2.237512, +0.726057,
+2.237512, +0.731293, +2.247983, +0.733038, +2.263691, +0.741765, +2.265436, +0.748746,
+2.270673, +0.750491, +2.277654, +0.745255, +2.279399, +0.738274, 
/* zone 146 with 35 points. */
+2.277654, +0.745255, +2.288126, +0.750491, +2.289871, +0.762709, +2.289871, +0.771435,
+2.286381, +0.785398, +2.302089, +0.790634, +2.323032, +0.788889, +2.328268, +0.797615,
+2.336995, +0.808087, +2.340486, +0.822050, +2.352703, +0.832522, +2.349213, +0.839503,
+2.356194, +0.846484, +2.319542, +0.839503, +2.309070, +0.834267, +2.286381, +0.834267,
+2.281144, +0.841249, +2.277654, +0.853466, +2.268928, +0.856956, +2.258455, +0.867428,
+2.246238, +0.867428, +2.232275, +0.869174, +2.225294, +0.872665, +2.225294, +0.881391,
+2.214822, +0.895354, +2.207841, +0.905826, +2.200859, +0.919788, +2.188643, +0.928515,
+2.158972, +0.937242, +2.132792, +0.932006, +2.111848, +0.930260, +2.096140, +0.921534,
+2.110103, +0.914552, +2.108356, +0.905826, +2.094395, +0.898844, 
/* zone 147 with 5 points. */
+2.206096, +0.657989, +2.209586, +0.666716, +2.216567, +0.670206, +2.225294, +0.671952,
+2.228785, +0.677187, 
/* zone 148 with 5 points. */
+2.455677, -0.043633, +2.455677, -0.078540, +2.455677, -0.115192, +2.460914, -0.122173,
+2.462659, -0.158825, 
/* zone 149 with 61 points. */
+2.042034, +0.869174, +2.038544, +0.839503, +2.028071, +0.834267, +2.038544, +0.836012,
+2.049016, +0.834267, +2.064724, +0.822050, +2.092649, +0.818559, +2.083922, +0.813323,
+2.066469, +0.815069, +2.043779, +0.809833, +2.031563, +0.804596, +2.028071, +0.797615,
+2.007128, +0.792379, +1.984439, +0.781907, +1.958259, +0.788889, +1.966986, +0.776671,
+1.953023, +0.764454, +1.928588, +0.748746, +1.909389, +0.743510, +1.853539, +0.734783,
+1.832595, +0.727802, +1.811651, +0.730944, +1.799434, +0.734783, +1.781981, +0.740019,
+1.776744, +0.743510, +1.708676, +0.747001, +1.684242, +0.748746, +1.668534, +0.774926,
+1.638864, +0.785398, +1.586504, +0.790634, +1.593485, +0.806342, +1.595230, +0.818559,
+1.583013, +0.829031, +1.570796, +0.839503, +1.565559, +0.837758, +1.562069, +0.839503,
+1.553343, +0.837758, +1.542871, +0.848230, +1.537634, +0.849975, +1.535889, +0.853466,
+1.534143, +0.856956, +1.535889, +0.858702, +1.534143, +0.862192, +1.541125, +0.867428,
+1.556833, +0.867428, +1.565559, +0.870919, +1.562069, +0.872665, +1.570796, +0.874410,
+1.584758, +0.881391, +1.602211, +0.886627, +1.623156, +0.886627, +1.628391, +0.881391,
+1.649336, +0.879646, +1.663298, +0.870919, +1.679006, +0.872665, +1.698204, +0.869174,
+1.719149, +0.872665, +1.717403, +0.883136, +1.708676, +0.888372, +1.712167, +0.898844,
+1.726130, +0.907571, 
/* zone 150 with 9 points. */
+0.349066, -0.436332, +0.349066, -0.462182, +0.349066, -0.488326, +0.349066, -0.514490,
+0.336883, -0.521303, +0.318442, -0.521303, +0.319828, -0.508259, +0.305689, -0.505898,
+0.299104, -0.518765, 
/* zone 151 with 2 points. */
+0.575958, -0.169297, +0.593412, -0.171624, 
/* zone 152 with 10 points. */
+0.799360, +0.261799, +0.826040, +0.308687, +0.897099, +0.338594, +0.937099, +0.353594,
+0.966912, +0.368594, +0.973211, +0.390594, +0.966912, +0.410152, +0.945912, +0.400152,
+0.924912, +0.400152, +0.902335, +0.410152, 
/* zone 153 with 2 points. */
+1.534143, +0.476474, +1.551596, +0.472984, 
/* zone 154 with 28 points. */
+0.488692, +0.980875, +0.500910, +0.977384, +0.507891, +0.979130, +0.513127, +0.973894,
+0.523599, +0.975639, +0.539307, +0.970403, +0.537561, +0.956441, +0.551524, +0.947714,
+0.556760, +0.945968, +0.555015, +0.940732, +0.563741, +0.940732, +0.572468, +0.932006,
+0.561996, +0.928515, +0.551524, +0.930260, +0.546288, +0.925025, +0.555015, +0.909316,
+0.541052, +0.907571, +0.535816, +0.902335, +0.534071, +0.895354, +0.527089, +0.900590,
+0.514872, +0.898845, +0.509636, +0.902335, +0.495674, +0.902335, +0.486947, +0.898845,
+0.455531, +0.905826, +0.432842, +0.907571, +0.422370, +0.900590, +0.413643, +0.900590, 
/* zone 155 with 11 points. */
+0.466003, +0.842994, +0.469494, +0.846485, +0.481711, +0.846485, +0.497419, +0.839503,
+0.509636, +0.837758, +0.509636, +0.830777, +0.521853, +0.820305, +0.525344, +0.809833,
+0.509636, +0.811578, +0.506145, +0.801106, +0.493928, +0.794125, 
/* zone 156 with 24 points. */
+0.555015, +0.909316, +0.561996, +0.907571, +0.570723, +0.914553, +0.591667, +0.914553,
+0.603884, +0.904081, +0.598648, +0.900590, +0.600393, +0.895354, +0.610865, +0.895354,
+0.621337, +0.890118, +0.623083, +0.883137, +0.626573, +0.877901, +0.640536, +0.877901,
+0.654499, +0.879646, +0.664971, +0.870919, +0.671952, +0.872665, +0.682424, +0.867429,
+0.703368, +0.865683, +0.699877, +0.856957, +0.696386, +0.849975, +0.698132, +0.844739,
+0.698132, +0.834267, +0.682424, +0.834267, +0.670206, +0.829032, +0.668461, +0.822050, 
/* zone 157 with 16 points. */
+0.699877, +0.757473, +0.705113, +0.760963, +0.722566, +0.757473, +0.747001, +0.753982,
+0.760963, +0.747001, +0.769690, +0.745256, +0.778417, +0.748746, +0.797616, +0.740020,
+0.794125, +0.736529, +0.797616, +0.734784, +0.809833, +0.731293, +0.816814, +0.729548,
+0.825541, +0.722566, +0.829032, +0.719076, +0.836013, +0.720821, +0.848230, +0.729548, 
/* zone 158 with 10 points. */
+0.809833, +0.731293, +0.806342, +0.726057, +0.815069, +0.720821, +0.809833, +0.717330,
+0.801106, +0.719076, +0.788889, +0.724312, +0.785398, +0.722566, +0.781907, +0.720821,
+0.771435, +0.720821, +0.757473, +0.719076, 
/* zone 159 with 11 points. */
+0.785398, +0.722566, +0.787144, +0.717330, +0.797616, +0.713840, +0.792379, +0.710349,
+0.795870, +0.706858, +0.804597, +0.703368, +0.797616, +0.698132, +0.799361, +0.694641,
+0.804597, +0.691150, +0.813323, +0.691150, +0.813323, +0.684169, 
/* zone 160 with 6 points. */
+0.780162, +0.691150, +0.785398, +0.692896, +0.794125, +0.691150, +0.799361, +0.692896,
+0.799361, +0.687660, +0.804597, +0.678933, 
/* zone 161 with 37 points. */
+0.858702, +0.808087, +0.844739, +0.813323, +0.853466, +0.816814, +0.834267, +0.830777,
+0.808087, +0.844739, +0.811578, +0.860447, +0.829032, +0.876155, +0.844739, +0.872665,
+0.849975, +0.881391, +0.883137, +0.900590, +0.930260, +0.897099, +0.970403, +0.881391,
+0.991347, +0.890118, +1.021018, +0.888373, +1.057670, +0.883137, +1.073377, +0.891863,
+1.047198, +0.905826, +1.061160, +0.911062, +1.057670, +0.921534, +1.080359, +0.925025,
+1.064651, +0.930260, +1.073377, +0.942478, +1.172861, +0.954695, +1.200787, +0.965167,
+1.233948, +0.961676, +1.235693, +0.944223, +1.284562, +0.938987, +1.295034, +0.930260,
+1.336922, +0.945968, +1.336922, +0.937242, +1.396263, +0.888373, +1.406735, +0.891863,
+1.422443, +0.890118, +1.450369, +0.890118, +1.485275, +0.867429, +1.511455, +0.872665,
+1.525418, +0.860447, 
/* zone 162 with 19 points. */
+1.401500, +0.738274, +1.384046, +0.741765, +1.375319, +0.748746, +1.314233, +0.747001,
+1.298525, +0.753982, +1.288053, +0.750492, +1.282817, +0.741765, +1.256637, +0.745256,
+1.239184, +0.743510, +1.237439, +0.736529, +1.183333, +0.715585, +1.165880, +0.717330,
+1.165880, +0.729548, +1.153663, +0.729548, +1.153663, +0.747001, +1.136209, +0.764454,
+1.108284, +0.760963, +1.085595, +0.757473, +1.068141, +0.771436, 
/* zone 163 with 3 points. */
+1.026254, +0.794125, +0.977384, +0.783653, +0.977384, +0.715585, 
/* zone 164 with 16 points. */
+0.914553, +0.727802, +0.925025, +0.738274, +0.951204, +0.738274, +0.961676, +0.717330,
+0.977384, +0.715585, +0.998328, +0.715585, +1.000074, +0.733038, +1.021018, +0.740020,
+1.014036, +0.745256, +1.047198, +0.738274, +1.054179, +0.717330, +1.076868, +0.717330,
+1.101303, +0.691150, +1.150172, +0.664971, +1.164135, +0.659734, +1.164135, +0.652753, 
/* zone 165 with 12 points. */
+1.237439, +0.736529, +1.228712, +0.724312, +1.251401, +0.720821, +1.275836, +0.712094,
+1.253147, +0.698132, +1.240929, +0.701622, +1.221731, +0.701622, +1.213004, +0.698132,
+1.213004, +0.691150, +1.240929, +0.687660, +1.256637, +0.685914, +1.286308, +0.684169, 
/* zone 166 with 9 points. */
+1.240929, +0.701622, +1.232203, +0.713840, +1.213004, +0.713840, +1.199041, +0.691150,
+1.178097, +0.691150, +1.178097, +0.682424, +1.188569, +0.678933, +1.192060, +0.663225,
+1.181588, +0.649262  
};


/*
 * ----------------------------------------------------------------------------
 */

void
gdisp_getEarthData ( float        **earthBoundingBox,
		     unsigned int  *nbEarthZones,
		     unsigned int **nbPointsPerEarthZones,
		     float        **earthZoneLonLatCoordinates,
		     unsigned int  *nbFrontierZones,
		     unsigned int **nbPointsPerFrontierZones,
		     float        **frontierZoneLonLatCoordinates )
{

  /*
   * Earth Bounding Box.
   *  as a table of 4 floats : lonMin, lonMax, latMin, latMax.
   */
  *earthBoundingBox = gdisp_earthZoneBoundingBox;

  /*
   * Number of zones that define the entire Earth.
   */
  *nbEarthZones = sizeof(gdisp_nbPointsPerEarthZones) /
                  sizeof(gdisp_nbPointsPerEarthZones[0]);

  /*
   * Number of points for each zone.
   *  as a table of unsigned integers.
   */
  *nbPointsPerEarthZones = gdisp_nbPointsPerEarthZones;

  /*
   * Earth Zone Coordinates.
   *  as a table of longitude and latitude informations.
   *         table[] = { lon1, lat1, lon2, lat2, ..., lonN, latN };
   */
  *earthZoneLonLatCoordinates = gdisp_earthZoneLonLatCoordinates;

  /*
   * Number of zones that define all the country boundaries.
   */
  *nbFrontierZones = sizeof(gdisp_nbPointsPerFrontierZones) /
                     sizeof(gdisp_nbPointsPerFrontierZones[0]);

  /*
   * Number of points for each boundary.
   *  as a table of unsigned integers.
   */
  *nbPointsPerFrontierZones = gdisp_nbPointsPerFrontierZones;

  /*
   * Earth Boundary Coordinates.
   *  as a table of longitude and latitude informations.
   *         table[] = { lon1, lat1, lon2, lat2, ..., lonN, latN };
   */
  *frontierZoneLonLatCoordinates = gdisp_frontierZoneLonLatCoordinates;

}
		     
