/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gtk/gtkhscale.h>

#include <math.h>
#include <pthread.h>

#include "interface.h"
#include "support.h"
#include "page.h"
#include "tsp_consumer.h"
#include "tsp_abs_types.h"
#include "plotwindow.h"

#include "tnt_rotate.xpm"
#include "animation.h"


#define LABEL_DOUBLE_FORMAT "%17s : %-14.8lg"
#define LABEL_HEXA_FORMAT "%17s : 0x%08x"
#define LABEL_BIN_FORMAT "%17s : 0b%8s\n                      %8s\n                      %8s\n                      %8s"

extern display_page* pages;
extern TSP_provider_t tsp;
extern variable*** index2vars;

static anim_data_t* anim_data = 0;
static guint timeout_id=-1;

static GtkStyle* X_style_variable;
static GtkStyle* X_style_title;


#define MAX_REFRESH_FREQUENCY_HZ 10.0 
#define MIN_REFRESH_FREQUENCY_HZ 0.1

#define FREQUENCY_TO_GUI_SCALE(frequency) log10(frequency)
#define GUI_SCALE_TO_FREQUENCY(gui_value) pow(10, gui_value)

static void init_style(void)
{
  GdkColor col_bg;
  GdkColor col_fg;
  GdkFont* font;

  font = gdk_font_load ("-misc-fixed-*-*-normal-*-*-*-*-*-*-*-*-*");
  
  /* Variables */
  gdk_color_parse("yellow", &col_fg);
  gdk_color_parse("black", &col_bg);
  X_style_variable  = gtk_style_new();
  X_style_variable->bg[GTK_STATE_NORMAL] = col_bg;
  X_style_variable->fg[GTK_STATE_NORMAL] = col_fg;
  X_style_variable->font = font;

  /* Titles */
  gdk_color_parse("white", &col_fg);
  gdk_color_parse("#444444", &col_bg);
  X_style_title  = gtk_style_new();
  X_style_title->bg[GTK_STATE_NORMAL] = col_bg;
  X_style_title->fg[GTK_STATE_NORMAL] = col_fg;
  X_style_title->font = font;
  gdk_font_ref(font);


}


static void on_button_quit_clicked                 (GtkButton       *button,
						    gpointer         user_data)
{
  gtk_exit(0);

}

static void on_togglebutton_toggled                (GtkToggleButton *togglebutton,
						    gpointer         user_data)
{
  GtkWindow *current;
  int i;

  i = (gint)user_data-1;

  if (i < 0 || i >= conf_data.nb_page) return;
  
  current = pages[i].window;

  /*
   * Update window position and size, sync it with the pages structure
   */
  if (is_visible(GTK_WIDGET(pages[i].window)))
    {
      gtk_widget_hide(GTK_WIDGET(pages[i].window));
    }
  else
    {
      gtk_widget_show(GTK_WIDGET(pages[i].window));

    }
      
}

void convert_to_bin(uint32_t anuint32, uint8_t binstr[4][9]) {
  int i;
  static uint8_t mask[8] = {0x01,0x02,0x04,0x08,
			    0x10,0x20,0x40,0x80};

  for (i=0;i<8;++i) {
    binstr[0][7-i] = ((anuint32 & 0xFF000000) >> 24) & mask[i] ? '1' : '0';
    binstr[1][7-i] = ((anuint32 & 0x00FF0000) >> 16) & mask[i] ? '1' : '0';
    binstr[2][7-i] = ((anuint32 & 0x0000FF00) >> 8) & mask[i] ? '1' : '0';
    binstr[3][7-i] = ((anuint32 & 0x000000FF) >> 0) & mask[i] ? '1' : '0';
  }
  binstr[0][8] = '\0';
  binstr[1][8] = '\0';
  binstr[2][8] = '\0';
  binstr[3][8] = '\0';
}

gint
redraw_widgets (gpointer data)
{
  GtkLabel *label;
  char buffer[512];

  int i, j;
  TSP_sample_t sample;
  int new_sample;
  DoublePoint pt;

  variable** ptr_var;
  variable* var;

  
  const TSP_answer_sample_t*  tsp_info;

  /* Get the TSP information structure to retreive the base frequency */
  tsp_info = TSP_consumer_get_information(tsp);

  /* Animate arrows to say we're alive */
  animation_next(anim_data); 

  /* now get variables from TSP and refresh data for all widget for each variables */
  while(TSP_STATUS_OK==TSP_consumer_read_sample(tsp, &sample, &new_sample) && new_sample ) {
    
    for( ptr_var = index2vars[sample.provider_global_index]; 
	 (*ptr_var) != 0 ; 
	 ptr_var++) {

      var = *ptr_var;
      
      if(var->widget_type == WIDGET_VIEW) {
	var->sample = sample;
      }
      else {
	assert( var->widget_type == WIDGET_DRAW );
	pt.x = ((gdouble)sample.time)/(tsp_info->base_frequency ? tsp_info->base_frequency : 1);
	pt.y = TSP_sample2double(sample);
	add_point(PLOTWINDOW(var->widget),&pt);
      }
    }		       
  }
  
  /* Refresh all variables in all the windows */
  for (i=0; i < conf_data.nb_page; i++) {
    for (j=0; j < pages[i].variables->len; j++) {
      uint32_t myuint32;
      uint8_t myuint32str[4][9];
      var = g_ptr_array_index(pages[i].variables, j);

      switch (var->type) {
      case VAR_DOUBLE:
	/*TODO*/
	if(IS_PLOTWINDOW(var->widget))
	  {
	    gtk_widget_draw (var->widget, NULL);
	  }
	else
	  {
	    label = GTK_LABEL(var->widget);
	    if(var->legend)
	      sprintf(buffer, LABEL_DOUBLE_FORMAT, var->legend, TSP_sample2double(var->sample));
	    else
	      sprintf(buffer, LABEL_DOUBLE_FORMAT, var->text, TSP_sample2double(var->sample));
	    gtk_label_set_text(label, buffer);
	       
	  }
	break;
      case VAR_TITLE:
	label = GTK_LABEL(var->widget);
	gtk_label_set_text(label, var->text);
	break;
      case VAR_STRING:
	label = GTK_LABEL(var->widget);
	gtk_label_set_text(label, "FIXME : VAR_STRING");
	break;
      case VAR_HEXA:
	label = GTK_LABEL(var->widget);
	sprintf(buffer, LABEL_HEXA_FORMAT, var->legend == NULL ? var->text : var->legend, (unsigned int) rint(TSP_sample2double(var->sample)));
	gtk_label_set_text(label, buffer);
	break;
      case VAR_BIN:
	/*TODO*/
	myuint32 = (unsigned long) rint(TSP_sample2double(var->sample));	
        convert_to_bin(myuint32,myuint32str);
	label = GTK_LABEL(var->widget);
	sprintf(buffer, LABEL_BIN_FORMAT, var->legend == NULL ? var->text : var->legend, 
		myuint32str[0],myuint32str[1],myuint32str[2],myuint32str[3]);
	gtk_label_set_text(label, buffer);
	break;	
      default:
	g_warning("update_variables: unknown variable type : %d", var->type);
	continue;
      }
      /*TODO*/
#if 0
      {
      int color_index;
      color_index = bstable_get_color_index(var->text);
	if (color_index<0 || color_index > MAX_COLORS )
      color_index = DEFAULT_COLOR_INDEX;
	gdk_color_parse(colors[color_index], &yellow);
      /* Apply the desired color */
      set_style_recursively(GTK_WIDGET(GTK_WIDGET(var->widget)->parent)->parent, style);
      }
#endif

    }

    /* gtk_style_unref(*/

  }

 
  
  
  
  return TRUE;
}



static void  page_variables_add (int page) {

  GtkWidget *event_box;
  variable *var;
  guint row, col;
  GtkTable *table;
  int i;
  const TSP_answer_sample_t*  tsp_info;

  /* Get the TSP information structure to retreive the base frequency */
  tsp_info = TSP_consumer_get_information(tsp);

  /* Get the table from the window (we know its the only container) */
  table = GTK_TABLE(GTK_BIN(pages[page].window)->child);

  for (i=0; i < pages[page].variables->len; i++)
    {
      
      var = g_ptr_array_index(pages[page].variables, i);

      /* Set up the label, justification seems to have problems ... */
      switch(var->widget_type)
	{
	case WIDGET_VIEW :
	  var->widget = gtk_label_new("");
	  gtk_misc_set_alignment(GTK_MISC(var->widget), 0.5f, 0.5f);	  
	  break;
	case WIDGET_DRAW :
	  var->widget = plotwindow_new ();
	  if(var->legend)
	    {
	      set_title(PLOTWINDOW(var->widget),var->legend );	  
	    }
	  else
	    {
	    set_title(PLOTWINDOW(var->widget),var->text );	  
	    }
	  /* Set time mode with frequency and number of points */
	  set_time_mode(PLOTWINDOW(var->widget),var->duration, tsp_info->base_frequency/var->period);
	  break;

	default:
	  assert(0);
	}

      gtk_widget_show(var->widget);

      event_box = gtk_event_box_new ();
      gtk_container_add(GTK_CONTAINER(event_box), var->widget);
      gtk_widget_show(GTK_WIDGET(event_box));

      /* Set colors */
      if(var->type == VAR_TITLE )
	{
	  gtk_widget_set_style(var->widget, X_style_title);
	  gtk_widget_set_style(event_box, X_style_title);
	}
      else
	{
	  gtk_widget_set_style(var->widget, X_style_variable);
	  gtk_widget_set_style(event_box, X_style_variable);
	}

      /* Compute the cell where we're going to put the widget */
      row = i % pages[page].rows;
      col = floor(i / pages[page].rows);

      gtk_table_attach (GTK_TABLE (table), GTK_WIDGET(event_box), col, col+1, row, row+1, 
			(GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
			(GtkAttachOptions) (GTK_FILL | GTK_EXPAND), 3, 3);
    }

}


GtkWidget*
create_page_window (int page_number) 
{
  GtkWidget *window;
  GtkWidget *table;
  gchar *title;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  title = g_strdup_printf("Page %d", page_number);
  gtk_window_set_title (GTK_WINDOW (window), title);
			   

  table = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (window), table);

  gtk_widget_set_events(window, gtk_widget_get_events(window ) |
			GDK_BUTTON_PRESS_MASK |
			GDK_POINTER_MOTION_MASK |
			GDK_BUTTON_RELEASE_MASK |
			GDK_KEY_PRESS_MASK
			);
  GTK_WIDGET_SET_FLAGS(window, GTK_CAN_FOCUS);


  /* Borders or not */
  if(pages[page_number].no_border)
    {
      gtk_widget_realize (window);
      
      gdk_window_set_decorations (window->window, 0);
    }

  /* Set colors */
  gtk_widget_set_style(GTK_WIDGET(window), X_style_variable);
  gtk_widget_set_style(GTK_WIDGET(table), X_style_variable);

  return window;
}


static void initialize_display_timer(GtkAdjustment* adj_freq, gfloat display_frequency)
{
  /* This line will start the refresh timer, as the
     callback for the adjustment will be called */
  gtk_adjustment_set_value(adj_freq, FREQUENCY_TO_GUI_SCALE(display_frequency));
  /* We must force a signal (the frequency  could have been the same) */
  gtk_adjustment_value_changed(adj_freq);
}


static void cb_timer_frequency_changed(GtkAdjustment* adj_freq, GtkLabel* label_freq)
{
  gchar buf[256];
  gfloat frequency;
  frequency = GUI_SCALE_TO_FREQUENCY(adj_freq->value);
  sprintf(buf, "%.2g Hz", frequency);
  gtk_label_set_text(label_freq, buf);

  if (timeout_id != -1) {
    gtk_timeout_remove(timeout_id);
  }

  timeout_id = gtk_timeout_add((1000/frequency), (GtkFunction)redraw_widgets, NULL);
  

}


GtkWidget*
create_mainwin (conf_data_t* conf_data, const gchar* conf_file_name)
{



  GtkWidget *displayer_button_box;
  GtkWidget *frame;
  GtkWidget *mainvbox;
  GtkWidget *vbox;
  GtkWidget *button_hbox;
  GtkWidget *hbox;

  GtkAdjustment *adj_freq;
  GtkWidget *scale_freq;
  GtkWidget *label_freq;

  GtkWidget *mainwin;
  GtkWidget *button_quit;
  GtkWidget *statusbar;
  GtkWidget *label;
  GtkWidget *separator;

  GdkPixmap *img_tnt;
  GdkBitmap *mask_tnt;
  GtkWidget *pixmap_tnt;
  gchar mainwin_title[1024];

  /* initialize global style */
  init_style();

  /* Create mainwin */
  mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mainwin), "mainwin", mainwin);
  gtk_window_set_title (GTK_WINDOW (mainwin), "Generic Draw");
  /*gtk_window_set_default_size (GTK_WINDOW (mainwin), 522, 217);*/

  /*--------------------*/
  
  mainvbox = gtk_vbox_new(FALSE, 6);
  gtk_container_add (GTK_CONTAINER (mainwin), mainvbox);
  gtk_widget_show (mainvbox);

  button_hbox = gtk_hbox_new(FALSE, 3);
  gtk_container_add (GTK_CONTAINER (mainvbox), button_hbox);
  gtk_widget_show (button_hbox);

  /*-----------------------*/
  /*     Quit Button       */
  /*-----------------------*/  

  button_quit = gtk_button_new();
  gtk_container_add (GTK_CONTAINER (button_hbox), button_quit); 
  gtk_widget_show (button_quit);
  gtk_widget_set_usize (button_quit, 57, 57);  

  vbox = gtk_vbox_new(FALSE, 3);
  gtk_container_add (GTK_CONTAINER (button_quit), vbox);
  gtk_widget_show (vbox);

  /* TNT logo */
  img_tnt = gdk_pixmap_colormap_create_from_xpm_d(NULL, 
						  gtk_widget_get_colormap(GTK_WIDGET(mainvbox)),
						  &mask_tnt,
						  NULL, 
						  tnt_rotate_xpm);  
  pixmap_tnt = gtk_pixmap_new(img_tnt, mask_tnt);
  gtk_container_add (GTK_CONTAINER (vbox), pixmap_tnt); 
  gtk_widget_show (pixmap_tnt);  

  label = gtk_label_new ("Quit");
  gtk_container_add (GTK_CONTAINER (vbox), label); 
  gtk_widget_show (label);  
  
  /*-----------------------*/
  /* Displayer button frame */
  /*-----------------------*/
  frame = gtk_frame_new("Displayed pages");
  gtk_frame_set_label_align(GTK_FRAME(frame),0.05, 0);
  gtk_container_add (GTK_CONTAINER (button_hbox), frame); 
  gtk_frame_set_label_align(GTK_FRAME(frame),0.05, 0);
  gtk_widget_show (frame);

  displayer_button_box = gtk_hbox_new(FALSE, 3);
  gtk_container_set_border_width(GTK_CONTAINER(displayer_button_box), 3);  
  gtk_container_add (GTK_CONTAINER (frame), displayer_button_box); 
  gtk_widget_show (displayer_button_box);  
  
  separator = gtk_hseparator_new();
  gtk_container_add (GTK_CONTAINER (mainvbox), separator);
  gtk_widget_show (separator);

  /*-----------------------*/
  /* Refresh Frequency */
  /*-----------------------*/

  hbox = gtk_hbox_new(FALSE, 3);
  gtk_container_add (GTK_CONTAINER (mainvbox), hbox);
  gtk_widget_show (hbox);

  label = gtk_label_new ("Refresh frequency :");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0); 
  gtk_widget_show (label);  

  label_freq = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (hbox), label_freq, FALSE, FALSE, 0); 
  gtk_widget_show (label_freq);  

  adj_freq = GTK_ADJUSTMENT(gtk_adjustment_new (0,
						FREQUENCY_TO_GUI_SCALE(MIN_REFRESH_FREQUENCY_HZ),
						FREQUENCY_TO_GUI_SCALE(MAX_REFRESH_FREQUENCY_HZ),
						0.1, 1, 0.0));
  scale_freq = gtk_hscale_new (adj_freq);  
  gtk_range_set_update_policy (GTK_RANGE (scale_freq),
			       GTK_UPDATE_CONTINUOUS);
  gtk_scale_set_draw_value (GTK_SCALE(scale_freq), FALSE);

  gtk_container_add (GTK_CONTAINER (mainvbox), scale_freq);
  gtk_widget_show (scale_freq);

  gtk_signal_connect(GTK_OBJECT(adj_freq), "value_changed",
		     GTK_SIGNAL_FUNC (cb_timer_frequency_changed), label_freq);


  separator = gtk_hseparator_new();
  gtk_container_add (GTK_CONTAINER (mainvbox), separator);
  gtk_widget_show (separator);

  
  /*-----------------------*/
  /* Bottom bare */
  /*-----------------------*/
  hbox = gtk_hbox_new(FALSE, 3);
  gtk_container_add (GTK_CONTAINER (mainvbox), hbox);
  gtk_widget_show (hbox);

  /* animation */
  anim_data = animation_create(gtk_widget_get_colormap(GTK_WIDGET(mainvbox)));
  gtk_widget_show(GTK_WIDGET( anim_data->pixmap));
  gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET( anim_data->pixmap), FALSE, FALSE, 0);


  /* status bar */
  statusbar = gtk_statusbar_new ();
  gtk_widget_show (statusbar);
  gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(statusbar), TRUE, TRUE, 0);


  /* ----------------------- */
  /* Create pages for display */
  /* ----------------------- */
  {
    GtkWidget* togglebutton;
    int i;
    gchar slabel[256];
    for(i = 0 ; i< conf_data->nb_page ; i++)
      {
	/* Create window */
	pages[i].window = GTK_WINDOW(create_page_window(i));
	gtk_window_set_title(GTK_WINDOW (pages[i].window), pages[i].title);
      
	/* Create button */
	sprintf(slabel, "%d", i+1);
	togglebutton = gtk_toggle_button_new_with_label (slabel);
	gtk_widget_show (togglebutton);
	gtk_container_add( GTK_CONTAINER(displayer_button_box), togglebutton);
	gtk_widget_set_usize (togglebutton, 27, 24);
	gtk_signal_connect (GTK_OBJECT (togglebutton), "toggled",
			    GTK_SIGNAL_FUNC (on_togglebutton_toggled),
			    (gpointer)(i+1));


	/* Add variables in page */
	page_variables_add(i);

	/* Manage window */
	if(pages[i].default_is_visible)
	  {


	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(togglebutton), TRUE);
	    gtk_widget_set_uposition(GTK_WIDGET(pages[i].window), 
				     pages[i].position.x, 
				     pages[i].position.y);
	    gtk_window_set_default_size (GTK_WINDOW (pages[i].window),
					 pages[i].position.width, 
					 pages[i].position.height);


	  

	  }
      
      }
  }


 

  gtk_signal_connect (GTK_OBJECT (button_quit), "clicked",
                      GTK_SIGNAL_FUNC (on_button_quit_clicked),
                      NULL);

  /*-------------*/
  /* FIXME */
  sprintf(mainwin_title, "TSP GDISP (%s)", conf_file_name);
  gtk_window_set_title(GTK_WINDOW(mainwin), mainwin_title);

  /*--------------------------------*/
  /* Initialise display timer value */
  /*--------------------------------*/
  initialize_display_timer(adj_freq, conf_data->display_frequency);

  gtk_widget_show(mainwin);
  return mainwin;
}

