/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class LogarithmicAxis
extends NumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    protected boolean allowNegativesFlag = false;
    protected boolean strictValuesFlag = true;
    protected final NumberFormat numberFormatterObj = NumberFormat.getInstance();
    protected boolean expTickLabelsFlag = false;
    protected boolean log10TickLabelsFlag = true;
    protected boolean smallLogFlag = false;

    public LogarithmicAxis(String string) {
        super(string);
        this.setupNumberFmtObj();
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setStrictValuesFlag(boolean bl) {
        this.strictValuesFlag = bl;
    }

    public boolean getStrictValuesFlag() {
        return this.strictValuesFlag;
    }

    public void setExpTickLabelsFlag(boolean bl) {
        this.expTickLabelsFlag = bl;
        this.setupNumberFmtObj();
    }

    public boolean getExpTickLabelsFlag() {
        return this.expTickLabelsFlag;
    }

    public void setLog10TickLabelsFlag(boolean bl) {
        this.log10TickLabelsFlag = bl;
    }

    public boolean getLog10TickLabelsFlag() {
        return this.log10TickLabelsFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    protected void setupNumberFmtObj() {
        if (this.numberFormatterObj instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormatterObj).applyPattern(this.expTickLabelsFlag ? "0E0" : "0.###");
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }

    protected double computeLogFloor(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.floor(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.floor(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.floor(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    protected double computeLogCeil(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.ceil(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.ceil(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.ceil(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d;
            double d2;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
                d2 = range.getLowerBound();
            } else {
                d2 = range.getLowerBound();
                if (this.strictValuesFlag && !this.allowNegativesFlag && d2 <= 0.0) {
                    throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
                }
            }
            d2 = this.computeLogFloor(d2);
            if (!this.allowNegativesFlag && d2 >= 0.0 && d2 < 1.0E-100) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.allowNegativesFlag && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = this.computeLogCeil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d && (d3 = (d3 + d2 + d) / 2.0) - (d2 = (d3 + d2 - d) / 2.0) < d) {
                double d4 = Math.abs(d3);
                double d5 = d4 > 1.0E-100 ? d4 / 100.0 : 0.01;
                d3 = (d3 + d2 + d5) / 2.0;
                d2 = (d3 + d2 - d5) / 2.0;
            }
            this.setRange(new Range(d2, d3), false, false);
            this.setupSmallLogFlag();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMinX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        if (this.isInverted()) {
            return Math.pow(10.0, d3 - (d - d4) / (d5 - d4) * (d3 - d2));
        }
        return Math.pow(10.0, d2 + (d - d4) / (d5 - d4) * (d3 - d2));
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, axisState.getCursor(), rectangle2D, rectangle2D2, rectangleEdge);
        }
        return list;
    }

    public List refreshTicksHorizontal(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        int n;
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        if (this.smallLogFlag && d2 < 1.0E-100) {
            d2 = 1.0E-100;
        }
        double d3 = range.getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d2));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d3))) && n2 > 0 && Math.pow(10.0, n2) > d2) {
            --n2;
        }
        boolean bl = false;
        for (int i = n2; i <= n; ++i) {
            for (int j = 0; j < 10; ++j) {
                String string;
                double d4;
                if (this.smallLogFlag) {
                    d4 = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (this.expTickLabelsFlag || i < 0 && d4 > 0.0 && d4 < 1.0) {
                        if (j == 0 || i > -4 && j < 2 || d4 >= d3) {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            string = this.makeTickLabel(d4, true);
                        } else {
                            string = "";
                        }
                    } else {
                        string = j < 1 || i < 1 && j < 5 || j < 4 - i || d4 >= d3 ? this.makeTickLabel(d4) : "";
                    }
                } else {
                    if (bl) {
                        --j;
                    }
                    double d5 = d4 = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (!bl) {
                        if (Math.abs(d4 - 1.0) < 1.0E-4 && d2 <= 0.0 && d3 >= 0.0) {
                            d4 = 0.0;
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    String string2 = string = this.expTickLabelsFlag && j < 2 || j < 1 || i < 1 && j < 5 || j < 4 - i || d4 >= d3 ? this.makeTickLabel(d4) : "";
                }
                if (d4 > d3) {
                    return arrayList;
                }
                if (!(d4 >= d2 - 1.0E-100)) continue;
                double d6 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
                float f = (float)d6;
                float f2 = 0.0f;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d7 = 0.0;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    if (rectangleEdge == RectangleEdge.TOP) {
                        f2 = (float)(d - (double)insets.right);
                        d7 = 1.5707963267948966;
                    } else {
                        f2 = (float)(d + (double)insets.right);
                        d7 = -1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    f2 = (float)(d - (double)insets.bottom);
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    f2 = (float)(d + (double)insets.top);
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d4), string, f, f2, textAnchor, textAnchor2, d7);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    public List refreshTicksVertical(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        int n;
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d2 = this.getRange().getLowerBound();
        if (this.smallLogFlag && d2 < 1.0E-100) {
            d2 = 1.0E-100;
        }
        double d3 = this.getRange().getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d2));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d3))) && n2 > 0 && Math.pow(10.0, n2) > d2) {
            --n2;
        }
        boolean bl = false;
        for (int i = n2; i <= n; ++i) {
            int n3 = 10;
            if (i == n) {
                n3 = 1;
            }
            for (int j = 0; j < n3; ++j) {
                String string;
                double d4;
                if (this.smallLogFlag) {
                    d4 = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (j == 0) {
                        if (this.log10TickLabelsFlag) {
                            string = "10^" + i;
                        } else if (this.expTickLabelsFlag) {
                            string = "1e" + i;
                        } else if (i >= 0) {
                            string = Long.toString((long)Math.rint(d4));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            string = this.numberFormatterObj.format(d4);
                        }
                    } else {
                        string = "";
                    }
                } else {
                    if (bl) {
                        --j;
                    }
                    double d5 = d4 = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (j == 0) {
                        if (!bl) {
                            if (i > n2 && i < n && Math.abs(d4 - 1.0) < 1.0E-4) {
                                d4 = 0.0;
                                bl = true;
                                string = "0";
                            } else {
                                string = this.log10TickLabelsFlag ? (i < 0 ? "-" : "") + "10^" + Math.abs(i) : (this.expTickLabelsFlag ? (i < 0 ? "-" : "") + "1e" + Math.abs(i) : Long.toString((long)Math.rint(d4)));
                            }
                        } else {
                            string = "";
                            bl = false;
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                }
                if (d4 > d3) {
                    return arrayList;
                }
                if (!(d4 >= d2 - 1.0E-100)) continue;
                double d6 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
                float f = 0.0f;
                float f2 = (float)d6;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d7 = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        f = (float)(d - (double)this.getTickLabelInsets().bottom);
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        d7 = -1.5707963267948966;
                    } else {
                        f = (float)(d + (double)this.getTickLabelInsets().top);
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        d7 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    f = (float)(d - (double)this.getTickLabelInsets().right);
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    f = (float)(d + (double)this.getTickLabelInsets().left);
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                arrayList.add(new NumberTick(new Double(d4), string, f, f2, textAnchor, textAnchor2, d7));
            }
        }
        return arrayList;
    }

    protected String makeTickLabel(double d, boolean bl) {
        if (this.expTickLabelsFlag || bl) {
            return this.numberFormatterObj.format(d).toLowerCase();
        }
        return this.getTickUnit().valueToString(d);
    }

    protected String makeTickLabel(double d) {
        return this.makeTickLabel(d, false);
    }
}

