/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.IntervalCategoryDataset;

public class IntervalCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
Cloneable,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public IntervalCategoryItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public IntervalCategoryItemLabelGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public IntervalCategoryItemLabelGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number;
        Number number2 = number = categoryDataset.getValue(n, n2);
        Number number3 = number;
        if (categoryDataset instanceof IntervalCategoryDataset) {
            object = (IntervalCategoryDataset)categoryDataset;
            number2 = object.getStartValue(n, n2);
            number3 = object.getEndValue(n, n2);
        }
        object = null;
        if (number2 != null && number3 != null) {
            Comparable comparable = categoryDataset.getRowKey(n);
            object = comparable != null ? comparable.toString() + ", " : "";
            String string = categoryDataset.getColumnKey(n2).toString();
            String string2 = null;
            String string3 = null;
            if (this.numberFormat != null) {
                string2 = this.numberFormat.format(number2);
                string3 = this.numberFormat.format(number3);
            } else if (this.dateFormat != null) {
                string2 = this.dateFormat.format(number2);
                string3 = this.dateFormat.format(number3);
            }
            object = (String)object + string + " : " + string2 + " to " + string3;
        }
        return object;
    }

    public String generateItemLabel(CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number;
        Number number2 = number = categoryDataset.getValue(n, n2);
        Number number3 = number;
        if (categoryDataset instanceof IntervalCategoryDataset) {
            object = (IntervalCategoryDataset)categoryDataset;
            number2 = object.getStartValue(n, n2);
            number3 = object.getEndValue(n, n2);
        }
        object = null;
        if (number2 != null && number3 != null) {
            String string = null;
            String string2 = null;
            if (this.numberFormat != null) {
                string = this.numberFormat.format(number2);
                string2 = this.numberFormat.format(number3);
            } else if (this.dateFormat != null) {
                string = this.dateFormat.format(number2);
                string2 = this.dateFormat.format(number3);
            }
            object = string + " - " + string2;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof IntervalCategoryItemLabelGenerator) {
            IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = (IntervalCategoryItemLabelGenerator)object;
            if (this.dateFormat != null) {
                return this.dateFormat.equals(intervalCategoryItemLabelGenerator.dateFormat);
            }
            return this.numberFormat.equals(intervalCategoryItemLabelGenerator.numberFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = (IntervalCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            intervalCategoryItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            intervalCategoryItemLabelGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return intervalCategoryItemLabelGenerator;
    }
}

