/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;

public class Range
implements Serializable {
    private double lower;
    private double upper;

    public Range(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("Range(double, double): require lower<=upper.");
        }
        this.lower = d;
        this.upper = d2;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double d) {
        return d >= this.lower && d <= this.upper;
    }

    public static Range combine(Range range, Range range2) {
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        double d = Math.min(range.getLowerBound(), range2.getLowerBound());
        double d2 = Math.max(range.getUpperBound(), range2.getUpperBound());
        return new Range(d, d2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Range) {
            Range range = (Range)object;
            boolean bl = this.lower == range.lower;
            boolean bl2 = this.upper == range.upper;
            return bl && bl2;
        }
        return false;
    }

    public String toString() {
        return "Range[" + this.lower + "," + this.upper + "]";
    }
}

