/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.SourceTree;
import simtools.data.AsciiFileDataSourceCollection;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.ui.ActionCheckBox;
import simtools.ui.ColorMapper;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;

public class DynamicColorChooser
extends JPanel {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$DynamicColorChooser == null ? (class$jsynoptic$ui$DynamicColorChooser = DynamicColorChooser.class$("jsynoptic.ui.DynamicColorChooser")) : class$jsynoptic$ui$DynamicColorChooser);
    protected JColorChooser chooser;
    protected JLabel cmLabel;
    protected JLabel dsLabel;
    protected JList cmlist;
    protected JButton cmNew;
    protected JButton cmDelete;
    protected SourceTree dstree;
    protected ActionCheckBox cbDyna;
    static boolean dialogOK = false;
    static ColorMapper lastMapper = null;
    static DataSource lastSource = null;
    static Color lastColor = null;
    static /* synthetic */ Class class$jsynoptic$ui$DynamicColorChooser;

    DynamicColorChooser() {
        this(null, null);
    }

    DynamicColorChooser(Color color) {
        this(null, color);
    }

    DynamicColorChooser(JPanel jPanel) {
        this(jPanel, null);
    }

    DynamicColorChooser(DataSource dataSource) {
        this(null, null, dataSource);
    }

    DynamicColorChooser(JPanel jPanel, Color color) {
        this(jPanel, color, null);
    }

    DynamicColorChooser(JPanel jPanel, Color color, DataSource dataSource) {
        this(jPanel, color, dataSource, null);
    }

    DynamicColorChooser(JPanel jPanel, Color color, DataSource dataSource, ColorMapper colorMapper) {
        this.setLayout(new BoxLayout(this, 1));
        if (color == null) {
            this.chooser = new JColorChooser();
            this.add(this.chooser);
        } else {
            this.chooser = new JColorChooser(color);
            this.add(this.chooser);
        }
        this.chooser.setBorder(BorderFactory.createTitledBorder(resources.getString("ChooseAStaticColor")));
        this.chooser.setPreviewPanel(jPanel);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.cbDyna = new ActionCheckBox(resources.getString("AllowDynamicColors"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                DynamicColorChooser.this.cmLabel.setEnabled(this.isSelected());
                DynamicColorChooser.this.dsLabel.setEnabled(this.isSelected());
                DynamicColorChooser.this.cmlist.setEnabled(this.isSelected());
                DynamicColorChooser.this.cmNew.setEnabled(this.isSelected());
                DynamicColorChooser.this.cmDelete.setEnabled(this.isSelected() && DynamicColorChooser.this.cmlist.getSelectedValue() != null);
                DynamicColorChooser.this.dstree.setEnabled(this.isSelected());
            }
        };
        this.cbDyna.setAlignmentX(0.0f);
        Box box = Box.createHorizontalBox();
        box.add(this.cbDyna);
        box.add(Box.createHorizontalGlue());
        jPanel2.add(box);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        Box box2 = Box.createVerticalBox();
        this.cmLabel = new JLabel(resources.getString("ChooseAColorMapper"));
        this.cmLabel.setAlignmentX(0.0f);
        Box box3 = Box.createHorizontalBox();
        box3.add(this.cmLabel);
        box3.add(Box.createHorizontalGlue());
        box2.add(box3);
        final ColorMapperListModel colorMapperListModel = new ColorMapperListModel();
        this.cmlist = new JList(colorMapperListModel);
        this.cmlist.setSelectionMode(0);
        this.cmlist.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.cmlist);
        box2.add(jScrollPane);
        Box box4 = Box.createHorizontalBox();
        this.cmNew = new JButton(resources.getString("New"));
        box4.add(this.cmNew);
        this.cmDelete = new JButton(resources.getString("Delete"));
        box4.add(this.cmDelete);
        box4.add(Box.createHorizontalGlue());
        box2.add(box4);
        jPanel3.add(box2);
        Box box5 = Box.createVerticalBox();
        this.dsLabel = new JLabel(resources.getString("ChooseADataSource"));
        this.dsLabel.setAlignmentX(0.0f);
        Box box6 = Box.createHorizontalBox();
        box6.add(this.dsLabel);
        box6.add(Box.createHorizontalGlue());
        box5.add(box6);
        this.dstree = new SourceTree(DataSourcePool.global);
        this.dstree.setVisibleRowCount(5);
        JScrollPane jScrollPane2 = new JScrollPane(this.dstree);
        box5.add(jScrollPane2);
        jPanel3.add(box5);
        jPanel2.add(jPanel3);
        if (colorMapper == null) {
            String string = DataInfo.getId(dataSource);
            if (string != null) {
                this.dstree.setSelectedValueById(string);
            } else {
                this.dstree.setSelectedValue(dataSource);
            }
            this.cbDyna.setSelected(false);
        } else {
            this.cmlist.setSelectedValue(colorMapper, true);
            this.dstree.setSelectedValue(dataSource);
            this.cbDyna.setSelected(true);
        }
        this.cbDyna.apply();
        this.add(jPanel2);
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapper colorMapper = ColorMapper.createColorMapperDialog(null);
                if (colorMapper == null) {
                    return;
                }
                if (JSynoptic.colorMappers == null) {
                    JSynoptic.colorMappers = new Vector();
                }
                if (JSynoptic.colorMappers.contains(colorMapper)) {
                    String[] stringArray = new String[]{"Replace existing Color Mapper named ", colorMapper.toString()};
                    int n = JOptionPane.showConfirmDialog(DynamicColorChooser.this, stringArray, "Color mapper already exists!", 0);
                    if (n == 0) {
                        int n2 = JSynoptic.colorMappers.indexOf(colorMapper);
                        JSynoptic.colorMappers.set(n2, colorMapper);
                        colorMapperListModel.update();
                        DynamicColorChooser.this.cmlist.setSelectedValue(colorMapper, true);
                    }
                    return;
                }
                JSynoptic.colorMappers.add(colorMapper);
                colorMapperListModel.update();
                DynamicColorChooser.this.cmlist.setSelectedValue(colorMapper, true);
            }
        });
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = DynamicColorChooser.this.cmlist.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (JSynoptic.colorMappers != null) {
                    JSynoptic.colorMappers.remove(e);
                }
                colorMapperListModel.update();
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DynamicColorChooser.this.cmDelete.setEnabled(DynamicColorChooser.this.cmlist.getSelectedValue() != null);
            }
        });
        this.cmlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = DynamicColorChooser.this.cmlist.locationToIndex(mouseEvent.getPoint());
                    ((ColorMapper)JSynoptic.colorMappers.get(n)).editDialog(null);
                }
            }
        });
    }

    public static Color showDialog(String string) {
        return DynamicColorChooser.showDialog(string, null, null);
    }

    public static Color showDialog(String string, JPanel jPanel) {
        return DynamicColorChooser.showDialog(string, jPanel, null);
    }

    public static Color showDialog(String string, Color color) {
        return DynamicColorChooser.showDialog(string, null, color);
    }

    public static Color showDialog(String string, JPanel jPanel, Color color) {
        return DynamicColorChooser.showDialog(null, string, jPanel, color);
    }

    public static Color showDialog(Frame frame, String string, JPanel jPanel, Color color) {
        return DynamicColorChooser.showDialog(frame, string, jPanel, color, null);
    }

    public static Color showDialog(Frame frame, String string, JPanel jPanel, Color color, DataSource dataSource) {
        return DynamicColorChooser.showDialog(frame, string, jPanel, color, dataSource, null);
    }

    public static Color showDialog(Frame frame, String string, JPanel jPanel, Color color, DataSource dataSource, ColorMapper colorMapper) {
        final JDialog jDialog = new JDialog(frame, true);
        jDialog.setTitle(string);
        final DynamicColorChooser dynamicColorChooser = new DynamicColorChooser(jPanel, color, dataSource, colorMapper);
        jDialog.getContentPane().add(dynamicColorChooser);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(resources.getString("OK"));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(resources.getString("Cancel"));
        jPanel2.add(jButton2);
        dialogOK = false;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (dynamicColorChooser.cbDyna.isSelected()) {
                    Object object;
                    Object e = dynamicColorChooser.cmlist.getSelectedValue();
                    if (e == null) {
                        if (dynamicColorChooser.cmlist.getModel().getSize() == 1) {
                            dynamicColorChooser.cmlist.setSelectedIndex(0);
                            e = dynamicColorChooser.cmlist.getSelectedValue();
                        }
                        if (e == null) {
                            JOptionPane.showMessageDialog(jDialog, resources.getString("PleaseChooseAColorMapper"), "No color mapper selected!", 0);
                            return;
                        }
                    }
                    if ((object = dynamicColorChooser.dstree.getSelectedSourceOrCollection()) == null) {
                        JOptionPane.showMessageDialog(jDialog, resources.getString("PleaseChooseADataSource"), "No data source selected!", 0);
                        return;
                    }
                    if (!(object instanceof DataSource)) {
                        JOptionPane.showMessageDialog(jDialog, resources.getString("PleaseChooseADataSource,NotACollection"), "No data source selected!", 0);
                        return;
                    }
                }
                dialogOK = true;
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add((Component)jPanel2, "South");
        jDialog.pack();
        jDialog.show();
        if (!dialogOK) {
            lastMapper = null;
            lastSource = null;
            lastColor = null;
            return null;
        }
        if (dynamicColorChooser.cbDyna.isSelected()) {
            lastMapper = (ColorMapper)dynamicColorChooser.cmlist.getSelectedValue();
            lastSource = (DataSource)dynamicColorChooser.dstree.getSelectedSourceOrCollection();
        } else {
            lastMapper = null;
            lastSource = null;
        }
        lastColor = dynamicColorChooser.chooser.getColor();
        return lastColor;
    }

    public static boolean isDialogOK() {
        return dialogOK;
    }

    public static Color getColor() {
        return lastColor;
    }

    public static ColorMapper getMapper() {
        return lastMapper;
    }

    public static DataSource getSource() {
        return lastSource;
    }

    public static void main(String[] stringArray) {
        try {
            DataSourcePool.global.addDataSourceCollection(new AsciiFileDataSourceCollection(new File("/home/nbrodu/low_earth_orbit.txt")));
        }
        catch (AsciiFileDataSourceCollection.InvalidFormatException invalidFormatException) {
            invalidFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Color color = DynamicColorChooser.showDialog("Test");
        System.out.println(color);
        System.out.println(DynamicColorChooser.getMapper());
        System.out.println(DynamicColorChooser.getSource());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ColorMapperListModel
    extends DefaultListModel {
        ColorMapperListModel() {
            this.fillFromMainList();
        }

        public void update() {
            this.clear();
            this.fillFromMainList();
        }

        protected void fillFromMainList() {
            if (JSynoptic.colorMappers != null) {
                Iterator iterator = JSynoptic.colorMappers.iterator();
                while (iterator.hasNext()) {
                    this.addElement(iterator.next());
                }
            }
        }
    }
}

