/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram;

import java.util.Vector;
import simtools.diagram.DiagramClipboardListener;
import simtools.util.ListenerManager;

public class DiagramClipboard
extends Vector {
    protected static DiagramClipboard _instance;
    private ListenerManager _listeners = new ListenerManager();

    public static DiagramClipboard get() {
        return _instance;
    }

    public static void reset() {
        _instance.clear();
    }

    public static boolean empty() {
        return _instance.isEmpty();
    }

    public static void set(Vector vector) {
        _instance.setAll(vector);
    }

    public static void create() {
        _instance = new DiagramClipboard();
    }

    public void clear() {
        super.clear();
        this.propagate();
    }

    public void setAll(Vector vector) {
        super.clear();
        this.addAll(vector);
        this.propagate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagate() {
        ListenerManager listenerManager = this._listeners;
        synchronized (listenerManager) {
            int n = this._listeners.size();
            for (int i = 0; i < n; ++i) {
                DiagramClipboardListener diagramClipboardListener = (DiagramClipboardListener)this._listeners.get(i);
                if (diagramClipboardListener == null) continue;
                diagramClipboardListener.clipboardChanged(this);
            }
        }
    }

    public void addListener(DiagramClipboardListener diagramClipboardListener) {
        this._listeners.add(diagramClipboardListener);
    }

    public void removeListener(DiagramClipboardListener diagramClipboardListener) {
        this._listeners.remove(diagramClipboardListener);
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }
}

