/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.Timer;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DynamicDataSourceCollection;
import simtools.data.UnsupportedOperation;
import simtools.data.buffer.DelayedBuffer;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.shapes.CurveShape;
import simtools.shapes.PlotShape;
import simtools.shapes.ShapesContainer;
import simtools.ui.DesktopCardPanel;
import simtools.ui.PrintDialog;

public class TestDynamic
extends JFrame
implements ActionListener {
    private static Font _sFont = new Font("TimesRoman", 0, 10);
    private DesktopCardPanel _editorPanel = new DesktopCardPanel(true);
    private JButton _bPrint;
    private JButton _bAdjust;
    private JButton _bAlign;
    private JButton _bStart;
    DynaTestDSC dsc;
    private JComboBox _cbZoom;
    private JComboBox _cbGrid;
    private JCheckBox _cbGridDisplay;

    public TestDynamic(String[] stringArray) {
        super("DesktopCardPanel Test");
        Object object;
        Object object2;
        DataSource dataSource;
        CurveShape curveShape;
        int n;
        this.getContentPane().add("Center", this._editorPanel);
        this.getContentPane().add("North", this.createToolBar());
        this.setJMenuBar(this.createMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ShapesContainer shapesContainer = new ShapesContainer("plots");
        this.dsc = new DynaTestDSC();
        DataSource dataSource2 = (DataSource)this.dsc.get(0);
        String string = DataInfo.getLabel(dataSource2);
        PlotShape[] plotShapeArray = new PlotShape[this.dsc.size() + 1];
        plotShapeArray[0] = new PlotShape(80, 250, 400, 200);
        plotShapeArray[0].setX(0.0, 50.0, 5.0);
        plotShapeArray[0].setY(0.0, 100.0, 10.0);
        plotShapeArray[0].setXLabel(string);
        plotShapeArray[0].setAutoUpdate(true);
        for (n = 1; n < this.dsc.size(); ++n) {
            plotShapeArray[n] = new PlotShape(80 + (n & 1) * 490, ((n >> 1) + 1) * 250, 400, 200);
            plotShapeArray[n].setX(0.0, 50.0, 5.0);
            plotShapeArray[n].setY(0.0, 100.0, 10.0);
            plotShapeArray[n].setAutoUpdate(true);
            curveShape = new CurveShape();
            dataSource = (DataSource)this.dsc.get(n);
            curveShape.setData(dataSource2, dataSource);
            plotShapeArray[n].insertCurve(curveShape);
            object2 = DataInfo.getLabel(dataSource);
            plotShapeArray[n].setYLabel((String)object2);
            plotShapeArray[n].setXLabel(string);
            object = new Color(255 - n * 30, n * 100 % 255, (n * 50 + 128) % 255);
            plotShapeArray[n].setCurveColor(curveShape, (Color)object);
            plotShapeArray[0].insertCurve(curveShape);
            plotShapeArray[0].setCurveColor(curveShape, (Color)object);
            plotShapeArray[0].setCurveLabel(curveShape, (String)object2);
            shapesContainer.addElement(plotShapeArray[n]);
        }
        shapesContainer.addElement(plotShapeArray[0]);
        plotShapeArray[n] = new PlotShape(80 + (n & 1) * 490, ((n >> 1) + 1) * 250, 400, 200);
        plotShapeArray[n].setX(0.0, 50.0, 5.0);
        plotShapeArray[n].setY(0.0, 100.0, 10.0);
        plotShapeArray[n].setAutoUpdate(true);
        curveShape = new CurveShape();
        dataSource = (DataSource)this.dsc.get(n - 1);
        object2 = (DataSource)this.dsc.get(n - 2);
        curveShape.setData((DataSource)object2, dataSource);
        plotShapeArray[n].insertCurve(curveShape);
        object = DataInfo.getLabel(dataSource);
        String string2 = DataInfo.getLabel(object2);
        plotShapeArray[n].setYLabel((String)object);
        plotShapeArray[n].setXLabel(string2);
        Color color = new Color(255 - n * 30, n * 100 % 255, (n * 50 + 128) % 255);
        plotShapeArray[n].setCurveColor(curveShape, color);
        shapesContainer.addElement(plotShapeArray[n]);
        this._editorPanel.addComponent(shapesContainer.getComponent());
        DiagramClipboard.create();
        this.pack();
        this.setSize(1024, 700);
        this.show();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this._editorPanel.createMenu(null));
        return jMenuBar;
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMargin(new Insets(1, 1, 1, 1));
        this._bPrint = new JButton("Print");
        this._bPrint.addActionListener(this);
        jToolBar.add(this._bPrint);
        this._bAdjust = new JButton("Adjust");
        this._bAdjust.addActionListener(this);
        jToolBar.add(this._bAdjust);
        this._bAlign = new JButton("Align");
        this._bAlign.addActionListener(this);
        jToolBar.add(this._bAlign);
        this._bStart = new JButton("Start");
        this._bStart.addActionListener(this);
        jToolBar.add(this._bStart);
        JLabel jLabel = new JLabel("Zoom", 4);
        jLabel.setAlignmentY(0.0f);
        jToolBar.add(jLabel);
        this._cbZoom = new JComboBox();
        this._cbZoom.setAlignmentY(0.0f);
        this._cbZoom.addItem("500%");
        this._cbZoom.addItem("200%");
        this._cbZoom.addItem("150%");
        this._cbZoom.addItem("100%");
        this._cbZoom.addItem("75%");
        this._cbZoom.addItem("50%");
        this._cbZoom.addItem("25%");
        this._cbZoom.addItem("10%");
        this._cbZoom.setSelectedItem("100%");
        this._cbZoom.setEditable(true);
        this._cbZoom.addActionListener(this);
        jToolBar.add(this._cbZoom);
        JLabel jLabel2 = new JLabel("Grid", 4);
        jLabel2.setAlignmentY(0.0f);
        jToolBar.add(jLabel2);
        this._cbGrid = new JComboBox();
        this._cbGrid.setAlignmentY(0.0f);
        this._cbGrid.addItem("0");
        this._cbGrid.addItem("5");
        this._cbGrid.addItem("10");
        this._cbGrid.addItem("20");
        this._cbGrid.addItem("40");
        this._cbGrid.setSelectedItem("0");
        this._cbGrid.setEditable(true);
        this._cbGrid.addActionListener(this);
        jToolBar.add(this._cbGrid);
        this._cbGridDisplay = new JCheckBox("Grid Display");
        this._cbGridDisplay.addActionListener(this);
        jToolBar.add(this._cbGridDisplay);
        return jToolBar;
    }

    private double getZoomValue() {
        try {
            String string = (String)this._cbZoom.getSelectedItem();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            Double d = new Double(string);
            return d / 100.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private DiagramComponent getDiagram() {
        JComponent jComponent = this._editorPanel.getSelectedComponent();
        if (jComponent instanceof DiagramComponent) {
            return (DiagramComponent)jComponent;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bPrint) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            PrintDialog printDialog = new PrintDialog("Hello");
            printDialog.show();
            if (!printDialog.getResult()) {
                return;
            }
            PrinterJob printerJob = printDialog.getPrinterJob();
            diagramComponent.setSelectionPrintMode(printDialog.printSelection());
            printerJob.setPrintable(diagramComponent, printDialog.getPageFormat());
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource() == this._bAdjust) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.adjust();
        } else if (actionEvent.getSource() == this._bAlign) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.align();
        } else if (actionEvent.getSource() == this._bStart) {
            new Timer(100, this.dsc).start();
        } else if (actionEvent.getSource() == this._cbZoom) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setZoom(this.getZoomValue());
        } else if (actionEvent.getSource() == this._cbGridDisplay) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setGridDisplay(this._cbGridDisplay.isSelected());
        } else if (actionEvent.getSource() == this._cbGrid) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            try {
                String string = (String)this._cbGrid.getSelectedItem();
                Integer n = new Integer(string);
                diagramComponent.setGrid(n);
            }
            catch (Exception exception) {
                diagramComponent.setGrid(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        new TestDynamic(stringArray);
    }

    class DynaTestDSC
    extends DynamicDataSourceCollection
    implements ActionListener {
        DynaTestDSC() {
            this.createDataSource(new DataInfo("time"), 6);
            this.createDataSource(new DataInfo("foo"), 6);
            this.createDataSource(new DataInfo("bar"), 6);
            try {
                this.bufferize(new DelayedBuffer(6, 100));
            }
            catch (UnsupportedOperation unsupportedOperation) {
                unsupportedOperation.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = this.lastIndex + 1L;
            this.setDoubleValue(0, l);
            this.setDoubleValue(1, Math.sin((double)l * 2.0 * Math.PI / 10.0) * 50.0 + 50.0);
            this.setDoubleValue(2, Math.cos(Math.pow((double)l - 13.0 * Math.floor(l / 13L), 2.5) * 2.0 * Math.PI / 13.0) * (50.0 - 2.0 * ((double)l - 13.0 * Math.floor(l / 13L))) + 50.0);
            this.registerNewValues();
        }

        public int sortedOrder(int n) {
            if (n == 0) {
                return 1;
            }
            return 0;
        }
    }
}

