/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.io.Serializable;
import java.util.Vector;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.UnsupportedOperation;

public class SinusSource
extends DataSource
implements Serializable {
    protected double _freq;
    protected double _phase;
    protected double _amplitude;
    protected double _ofst;
    protected long _start;
    protected long _end;
    private static DataInfo info = new DataInfo(null, "SinusSource");
    static /* synthetic */ Class class$java$lang$Double;

    public SinusSource(double d, double d2, double d3, double d4, long l, long l2) {
        this._freq = d;
        this._phase = d2;
        this._amplitude = d3;
        this._ofst = d4;
        this._start = l;
        this._end = l2;
    }

    public DataInfo getInformation() {
        return info;
    }

    public Object getMin() throws UnsupportedOperation {
        return new Double(-this._amplitude + this._ofst);
    }

    public Object getMax() throws UnsupportedOperation {
        return new Double(this._amplitude + this._ofst);
    }

    public long getStartIndex() throws UnsupportedOperation {
        return this._start;
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this._end;
    }

    public Object computeMin() throws UnsupportedOperation {
        return this.getMin();
    }

    public Object computeMax() throws UnsupportedOperation {
        return this.getMax();
    }

    public long computeStartIndex() throws UnsupportedOperation {
        return this.getStartIndex();
    }

    public long computeLastIndex() throws UnsupportedOperation {
        return this.getLastIndex();
    }

    public void setSlice(long l, long l2) {
    }

    public double getDoubleValue(long l) {
        if (l < this._start) {
            l = 0L;
        }
        return this._amplitude * Math.sin((double)(l - this._start) * this._freq * Math.PI + this._phase) + this._ofst;
    }

    public Object getValue(long l) throws DataException {
        return new Double(this.getDoubleValue(l));
    }

    public Class valueClass() {
        return class$java$lang$Double == null ? (class$java$lang$Double = SinusSource.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public int sortedOrder() {
        return 0;
    }

    public void update() throws UnsupportedOperation {
    }

    Object getInternalParameters() {
        Vector<Number> vector = new Vector<Number>(6);
        vector.add(new Double(this._freq));
        vector.add(new Double(this._phase));
        vector.add(new Double(this._amplitude));
        vector.add(new Double(this._ofst));
        vector.add(new Long(this._start));
        vector.add(new Long(this._end));
        return vector;
    }

    SinusSource(Vector vector) {
        this((Double)vector.get(0), (Double)vector.get(1), (Double)vector.get(2), (Double)vector.get(3), (Long)vector.get(4), (Long)vector.get(5));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

