/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public StackedBarRenderer() {
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, Integer n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaxBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d3 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d4 / (double)n2, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d4, d2));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        double d2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d4 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            d2 = number2.doubleValue();
            if (d2 > 0.0) {
                d5 += d2;
                continue;
            }
            d6 += d2;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d = valueAxis.translateValueToJava2D(d5, rectangle2D, rectangleEdge);
            d2 = valueAxis.translateValueToJava2D(d5 + d3, rectangle2D, rectangleEdge);
        } else {
            d = valueAxis.translateValueToJava2D(d6, rectangle2D, rectangleEdge);
            d2 = valueAxis.translateValueToJava2D(d6 + d3, rectangle2D, rectangleEdge);
        }
        double d7 = Math.min(d, d2);
        double d8 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d7, d4, d8, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d4, d7, categoryItemRendererState.getBarWidth(), d8);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d3 < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            if (categoryItemLabelGenerator != null) {
                string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.addEntity(categoryItemEntity);
        }
    }
}

