/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.ui.ActionCheckBox;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public abstract class RandomSource
extends DataSource {
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$RandomSource == null ? (class$jsynoptic$builtin$RandomSource = RandomSource.class$("jsynoptic.builtin.RandomSource")) : class$jsynoptic$builtin$RandomSource);
    protected long maxIndex;
    protected Long seed = null;
    protected Random generator;
    protected double param1;
    protected double param2;
    protected double minValue;
    protected double maxValue;
    protected double[] values;
    protected DataInfo info;
    static /* synthetic */ Class class$jsynoptic$builtin$RandomSource;

    public DataInfo getInformation() {
        return this.info;
    }

    protected void fillValues() {
        if (this.maxIndex >= 0L) {
            this.values = new double[(int)this.maxIndex + 1];
            this.minValue = Double.POSITIVE_INFINITY;
            this.maxValue = Double.NEGATIVE_INFINITY;
            int n = 0;
            while ((long)n <= this.maxIndex) {
                this.values[n] = this.nextRandomValue();
                this.minValue = Math.min(this.minValue, this.values[n]);
                this.maxValue = Math.max(this.maxValue, this.values[n]);
                ++n;
            }
        } else {
            this.values = new double[1];
            this.values[0] = Double.NaN;
        }
    }

    public RandomSource(String string, double d, double d2) {
        this(string, d, d2, 0L);
    }

    public RandomSource(String string, double d, double d2, long l) {
        this.param1 = d;
        this.param2 = d2;
        this.maxIndex = l - 1L;
        this.generator = new Random();
        this.seed = null;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.info = new DataInfo(string);
        this.fillValues();
    }

    public RandomSource(String string, long l, double d, double d2) {
        this(string, l, d, d2, 0L);
    }

    public RandomSource(String string, long l, double d, double d2, long l2) {
        this.param1 = d;
        this.param2 = d2;
        this.maxIndex = l2 - 1L;
        this.generator = new Random(l);
        this.seed = new Long(l);
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.info = new DataInfo(string);
        this.fillValues();
    }

    protected abstract double nextRandomValue();

    public Object getValue(long l) throws DataException {
        return new Double(this.getDoubleValue(l));
    }

    public double getDoubleValue(long l) throws DataException {
        if (this.maxIndex == -1L) {
            this.values[0] = this.nextRandomValue();
            this.minValue = this.values[0];
            this.maxValue = this.values[0];
            return this.values[0];
        }
        if (l > this.maxIndex) {
            throw new NoSuchIndex(l);
        }
        return this.values[(int)l];
    }

    public long computeLastIndex() throws UnsupportedOperation {
        if (this.maxIndex == -1L) {
            throw new UnsupportedOperation();
        }
        return this.maxIndex;
    }

    public long computeStartIndex() throws UnsupportedOperation {
        return 0L;
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this.maxIndex;
    }

    public long getStartIndex() throws UnsupportedOperation {
        return 0L;
    }

    public Object computeMax() {
        return this.getMax();
    }

    public Object computeMin() {
        return this.getMin();
    }

    public double getDoubleMax() {
        return this.maxValue;
    }

    public double getDoubleMin() {
        return this.minValue;
    }

    public Object getMax() {
        return new Double(this.getDoubleMax());
    }

    public Object getMin() {
        return new Double(this.getDoubleMin());
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class OptionPanel
    extends JPanel {
        protected JRadioButton rbStatic;
        protected JRadioButton rbDynamic;
        protected NumberField nfParam1;
        protected NumberField nfParam2;
        protected NumberField nfSize;
        protected JLabel bufferLabel;
        protected NumberField nfDynamicSize;
        protected JTextField tfPeriod;
        protected ActionCheckBox cbSeed;
        protected JTextField tfSeed;

        public OptionPanel() {
            this.setLayout(new BoxLayout(this, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.param1Name()));
            box.add(Box.createHorizontalGlue());
            this.nfParam1 = new NumberField(0.0);
            box.add(this.nfParam1);
            this.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel(this.param2Name()));
            box.add(Box.createHorizontalGlue());
            this.nfParam2 = new NumberField(1.0);
            box.add(this.nfParam2);
            this.add(box);
            box = Box.createHorizontalBox();
            this.rbStatic = new JRadioButton(resources.getString("static"), true);
            box.add(this.rbStatic);
            box.add(Box.createHorizontalGlue());
            this.add(box);
            box = Box.createHorizontalBox();
            this.rbDynamic = new JRadioButton(resources.getString("dynamic"), false);
            box.add(this.rbDynamic);
            box.add(Box.createHorizontalGlue());
            this.add(box);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbStatic);
            buttonGroup.add(this.rbDynamic);
            JPanel jPanel = new JPanel(new CardLayout());
            box = Box.createHorizontalBox();
            this.bufferLabel = new JLabel(resources.getString("staticBufferLabel"));
            box.add(this.bufferLabel);
            box.add(Box.createHorizontalGlue());
            this.nfSize = new NumberField(100L, 5);
            box.add(this.nfSize);
            jPanel.add((Component)box, "s");
            Box box2 = Box.createVerticalBox();
            box = Box.createHorizontalBox();
            this.bufferLabel = new JLabel(resources.getString("dynamicBufferLabel"));
            box.add(this.bufferLabel);
            box.add(Box.createHorizontalGlue());
            this.nfDynamicSize = new NumberField(100L, 5);
            box.add(this.nfDynamicSize);
            box2.add(box);
            box = Box.createHorizontalBox();
            this.bufferLabel = new JLabel(resources.getString("period"));
            box.add(this.bufferLabel);
            box.add(Box.createHorizontalGlue());
            this.tfPeriod = new JTextField("1000");
            box.add(this.tfPeriod);
            box2.add(box);
            jPanel.add((Component)box2, "d");
            this.add(jPanel);
            this.rbDynamic.addChangeListener(new ChangeListener(this, jPanel){
                private final /* synthetic */ JPanel val$cardPane;
                private final /* synthetic */ OptionPanel this$0;
                {
                    this.this$0 = optionPanel;
                    this.val$cardPane = jPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    ((CardLayout)this.val$cardPane.getLayout()).show(this.val$cardPane, this.this$0.rbDynamic.isSelected() ? "d" : "s");
                }
            });
            box = Box.createHorizontalBox();
            this.cbSeed = new ActionCheckBox(this, resources.getString("seed"), false){
                private final /* synthetic */ OptionPanel this$0;
                {
                    this.this$0 = optionPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.tfSeed.setEditable(this.this$0.cbSeed.isSelected());
                    this.this$0.tfSeed.setEnabled(this.this$0.cbSeed.isSelected());
                }
            };
            box.add(this.cbSeed);
            box.add(Box.createHorizontalGlue());
            this.tfSeed = new JTextField();
            box.add(this.tfSeed);
            this.add(box);
            this.cbSeed.apply();
        }

        protected abstract String param1Name();

        protected abstract String param2Name();

        public abstract DataSource createSource(String var1);
    }
}

