/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import simtools.data.CollectiveDataSource;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceCollectionListener;
import simtools.data.DynamicDataSourceCollection;
import simtools.data.NoSuchIndex;

public class DataSourceCollectionAnimator
extends DynamicDataSourceCollection
implements DataSourceCollectionListener {
    public static final String MARKER = "AnimatedCollection:";
    protected DataSourceCollection target;
    protected long period = 1000L;
    protected Timer timer;
    protected boolean finished;
    protected boolean autoStop;

    public boolean isFinished() {
        return this.finished;
    }

    public DataSourceCollectionAnimator(DataSourceCollection dataSourceCollection) {
        if (dataSourceCollection instanceof DataSourceCollectionAnimator) {
            this.target = ((DataSourceCollectionAnimator)dataSourceCollection).target;
        }
        this.target = dataSourceCollection;
        this.sourceInfo = new DynamicDataSourceCollection.SourceInfo[this.target.size()];
        for (int i = 0; i < this.target.size(); ++i) {
            CollectiveDataSource collectiveDataSource = (CollectiveDataSource)this.target.get(i);
            this.sourceInfo[i] = new DynamicDataSourceCollection.SourceInfo(this);
            this.sourceInfo[i].info = this.target.getInformation(i);
            this.sourceInfo[i].kind = this.target.getKind(i);
            collectiveDataSource.collection = this;
        }
        this.ourInfo = this.target.getInformation();
        this.ourInfo.id = MARKER + this.ourInfo.id;
        this.target.addListener(this);
    }

    public void step() throws DataException {
        try {
            for (int i = 0; i < this.target.size(); ++i) {
                switch (this.sourceInfo[i].kind) {
                    case 1: {
                        super.setByteValue(i, this.target.getByteValue(i, this.lastIndex + 1L));
                    }
                    case 2: {
                        super.setShortValue(i, this.target.getShortValue(i, this.lastIndex + 1L));
                    }
                    case 3: {
                        super.setIntegerValue(i, this.target.getIntegerValue(i, this.lastIndex + 1L));
                    }
                    case 4: {
                        super.setLongValue(i, this.target.getLongValue(i, this.lastIndex + 1L));
                    }
                    case 5: {
                        super.setFloatValue(i, this.target.getFloatValue(i, this.lastIndex + 1L));
                    }
                    case 6: {
                        super.setDoubleValue(i, this.target.getDoubleValue(i, this.lastIndex + 1L));
                    }
                    case 7: {
                        super.setObjectValue(i, this.target.getValue(i, this.lastIndex + 1L));
                    }
                }
            }
            this.finished = false;
        }
        catch (DataException dataException) {
            if (this.autoStop && dataException instanceof NoSuchIndex) {
                this.finished = true;
            }
            throw dataException;
        }
        super.registerNewValues();
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long l) {
        if (this.isRunning()) {
            this.stop();
            this.period = l;
            this.start();
        } else {
            this.period = l;
        }
    }

    public boolean isRunning() {
        return this.timer != null;
    }

    public void start(long l) {
        if (this.isRunning()) {
            return;
        }
        this.period = l;
        this.start();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                block2: {
                    try {
                        DataSourceCollectionAnimator.this.step();
                    }
                    catch (DataException dataException) {
                        if (!DataSourceCollectionAnimator.this.autoStop || !(dataException instanceof NoSuchIndex)) break block2;
                        DataSourceCollectionAnimator.this.stop();
                    }
                }
            }
        }, 0L, this.period);
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DataSourceCollectionAnimator dataSourceCollectionAnimator = this;
        synchronized (dataSourceCollectionAnimator) {
            if (this.buffers != null) {
                for (int i = 0; i < this.buffers.length; ++i) {
                    if (this.buffers[i] == null) continue;
                    this.buffers[i].clear();
                }
            }
            this.lastIndex = -1L;
            this.finished = false;
        }
        for (int i = 0; i < this.size(); ++i) {
            DataSource dataSource = (DataSource)this.get(i);
            dataSource.notifyListenersForIndexRangeChange(this.getStartIndex(i), this.getLastIndex(i));
        }
    }

    public boolean isAutoStop() {
        return this.autoStop;
    }

    public void setAutoStop(boolean bl) {
        this.autoStop = bl;
    }

    protected DataSource createDataSource(DataInfo dataInfo, int n) {
        throw new UnsupportedOperationException();
    }

    protected DataSource createDataSource(DataInfo dataInfo) {
        throw new UnsupportedOperationException();
    }

    public void DataSourceCollectionInfoChanged(DataSourceCollection dataSourceCollection, DataInfo dataInfo) {
        this.ourInfo = this.target.getInformation();
        this.notifyListenersForInfoChange(dataInfo);
    }

    public void DataSourceCollectionDataSourceAdded(DataSourceCollection dataSourceCollection, DataSource dataSource) {
        throw new UnsupportedOperationException();
    }

    public void DataSourceCollectionDataSourceRemoved(DataSourceCollection dataSourceCollection, DataSource dataSource) {
        throw new UnsupportedOperationException();
    }

    public DataSource get(String string) {
        return this.target.get(string);
    }

    public synchronized void copyInto(Object[] objectArray) {
        this.target.copyInto(objectArray);
    }

    public synchronized void trimToSize() {
        this.target.trimToSize();
    }

    public synchronized void ensureCapacity(int n) {
        this.target.ensureCapacity(n);
    }

    public synchronized void setSize(int n) {
        this.target.setSize(n);
    }

    public synchronized int capacity() {
        return this.target.capacity();
    }

    public synchronized int size() {
        return this.target.size();
    }

    public synchronized boolean isEmpty() {
        return this.target.isEmpty();
    }

    public Enumeration elements() {
        return this.target.elements();
    }

    public boolean contains(Object object) {
        return this.target.contains(object);
    }

    public int indexOf(Object object) {
        return this.target.indexOf(object);
    }

    public synchronized int indexOf(Object object, int n) {
        return this.target.indexOf(object, n);
    }

    public synchronized int lastIndexOf(Object object) {
        return this.target.lastIndexOf(object);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        return this.target.lastIndexOf(object, n);
    }

    public synchronized Object elementAt(int n) {
        return this.target.elementAt(n);
    }

    public synchronized Object firstElement() {
        return this.target.firstElement();
    }

    public synchronized Object lastElement() {
        return this.target.lastElement();
    }

    public synchronized void setElementAt(Object object, int n) {
        this.target.setElementAt(object, n);
    }

    public synchronized void removeElementAt(int n) {
        this.target.removeElementAt(n);
    }

    public synchronized void insertElementAt(Object object, int n) {
        this.target.insertElementAt(object, n);
    }

    public synchronized void addElement(Object object) {
        this.target.addElement(object);
    }

    public synchronized boolean removeElement(Object object) {
        return this.target.removeElement(object);
    }

    public synchronized void removeAllElements() {
        this.target.removeAllElements();
    }

    public synchronized Object clone() {
        return this.target.clone();
    }

    public synchronized Object[] toArray() {
        return this.target.toArray();
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        return this.target.toArray(objectArray);
    }

    public synchronized Object get(int n) {
        return this.target.get(n);
    }

    public synchronized Object set(int n, Object object) {
        return this.target.set(n, object);
    }

    public synchronized boolean add(Object object) {
        return this.target.add(object);
    }

    public boolean remove(Object object) {
        return this.target.remove(object);
    }

    public void add(int n, Object object) {
        this.target.add(n, object);
    }

    public synchronized Object remove(int n) {
        return this.target.remove(n);
    }

    public void clear() {
        this.target.clear();
    }

    public synchronized boolean containsAll(Collection collection) {
        return this.target.containsAll(collection);
    }

    public synchronized boolean addAll(Collection collection) {
        return this.target.addAll(collection);
    }

    public synchronized boolean removeAll(Collection collection) {
        return this.target.removeAll(collection);
    }

    public synchronized boolean retainAll(Collection collection) {
        return this.target.retainAll(collection);
    }

    public synchronized boolean addAll(int n, Collection collection) {
        return this.target.addAll(n, collection);
    }

    public synchronized boolean equals(Object object) {
        return this.target.equals(object);
    }

    public synchronized int hashCode() {
        return this.target.hashCode();
    }

    public synchronized String toString() {
        return this.target.toString();
    }

    public synchronized List subList(int n, int n2) {
        return this.target.subList(n, n2);
    }

    public Iterator iterator() {
        return this.target.iterator();
    }

    public ListIterator listIterator() {
        return this.target.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.target.listIterator(n);
    }

    public DataSourceCollection getTargetCollection() {
        return this.target;
    }
}

