/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.PieDataset;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.util.NumberStringComparator;

public class SourcePieDataset
extends AbstractDataset
implements DataSourceListener,
PieDataset {
    static final long serialVersionUID = -8753520808697463640L;
    protected transient Vector sources = new Vector();
    protected boolean notifySourceChange = false;
    protected DataInfo info = null;

    public SourcePieDataset() {
        this.notifySourceChange = true;
    }

    public SourcePieDataset(DataSourceCollection dataSourceCollection) {
        this.setDataSourceCollection(dataSourceCollection);
        this.notifySourceChange = true;
    }

    public void setDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        this.clear();
        this.info = dataSourceCollection.getInformation();
        for (int i = 0; i < dataSourceCollection.size(); ++i) {
            this.addSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void addDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        for (int i = 0; i < dataSourceCollection.size(); ++i) {
            this.addSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public DataSource getSource(int n) {
        return ((SourceHolder)this.sources.get((int)n)).source;
    }

    public void addSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        this.sources.add(new SourceHolder(dataSource));
        dataSource.addListener((DataSourceListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void addSource(DataSource dataSource, long l) {
        if (dataSource == null) {
            return;
        }
        this.sources.add(new SourceHolder(dataSource, l));
        dataSource.addListener((DataSourceListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        dataSource.removeListener((DataSourceListener)this);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (sourceHolder.source == null || !sourceHolder.source.equals((Object)dataSource)) continue;
            sourceHolder.source.removeListener((DataSourceListener)this);
            iterator.remove();
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeSource(int n) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        if (sourceHolder.source != null) {
            sourceHolder.source.removeListener((DataSourceListener)this);
        }
        this.sources.remove(n);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void clear() {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (sourceHolder.source != null) {
                sourceHolder.source.removeListener((DataSourceListener)this);
            }
            iterator.remove();
        }
        this.info = null;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void setName(int n, String string) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        sourceHolder.name = string;
    }

    public String getName(int n) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        return sourceHolder.toString();
    }

    public void setName(String string) {
        if (this.info == null) {
            this.info = new DataInfo(string);
        } else {
            this.info.label = string;
        }
    }

    public String getName() {
        if (this.info == null) {
            return "";
        }
        return this.info.label;
    }

    public Comparable getKey(int n) {
        return (Comparable)this.sources.get(n);
    }

    public int getIndex(Comparable comparable) {
        return this.sources.indexOf(comparable);
    }

    public List getKeys() {
        return this.sources;
    }

    public Number getValue(Comparable comparable) {
        SourceHolder sourceHolder = (SourceHolder)comparable;
        Object object = null;
        try {
            object = sourceHolder.source.getValue(sourceHolder.index);
        }
        catch (DataException dataException) {
            try {
                sourceHolder.index = sourceHolder.source.getLastIndex();
                object = sourceHolder.source.getValue(sourceHolder.index);
            }
            catch (DataException dataException2) {
                return null;
            }
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return null;
            }
            if (Double.isInfinite(d)) {
                return null;
            }
            return (Double)object;
        }
        if (object instanceof Float) {
            float f = ((Number)object).floatValue();
            if (Float.isNaN(f)) {
                return null;
            }
            if (Float.isInfinite(f)) {
                return null;
            }
            return (Float)object;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            return NumberStringComparator.stringToNumber((String)((String)object));
        }
        return null;
    }

    public int getItemCount() {
        return this.sources.size();
    }

    public Number getValue(int n) {
        return this.getValue((Comparable)this.sources.get(n));
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (!dataSource.equals((Object)sourceHolder.source)) continue;
            sourceHolder.index = l2;
        }
        this.fireDatasetChanged();
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (!dataSource.equals((Object)sourceHolder.source)) continue;
            sourceHolder.index = l2;
        }
        this.fireDatasetChanged();
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
        this.fireDatasetChanged();
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.sources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            SourceHolder sourceHolder = (SourceHolder)this.sources.get(i);
            DataSourcePool.global.writeDataSource(objectOutputStream, sourceHolder.source);
            objectOutputStream.writeLong(sourceHolder.index);
            objectOutputStream.writeObject(sourceHolder.name);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.sources = new Vector();
        for (int i = 0; i < n; ++i) {
            SourceHolder sourceHolder = new SourceHolder(DataSourcePool.global.readDataSource(objectInputStream), objectInputStream.readLong());
            this.sources.add(sourceHolder);
            sourceHolder.name = (String)objectInputStream.readObject();
            if (sourceHolder.source == null) continue;
            sourceHolder.source.addListener((DataSourceListener)this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SourcePieDataset sourcePieDataset = (SourcePieDataset)((Object)super.clone());
        sourcePieDataset.sources = new Vector();
        sourcePieDataset.info = DataInfo.clone((DataInfo)this.info);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            Vector vector = sourcePieDataset.sources;
            SourcePieDataset sourcePieDataset2 = sourcePieDataset;
            ((Object)((Object)sourcePieDataset2)).getClass();
            vector.add(sourcePieDataset2.new SourceHolder(sourceHolder.source, sourceHolder.index, sourceHolder.name));
            if (sourceHolder.source == null) continue;
            sourceHolder.source.addListener((DataSourceListener)sourcePieDataset);
        }
        return sourcePieDataset;
    }

    public SourcePieDataset cloneSet() {
        try {
            return (SourcePieDataset)((Object)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public class SourceHolder
    implements Comparable {
        public DataSource source;
        public long index;
        public String name;

        public SourceHolder(DataSource dataSource) {
            this.source = dataSource;
            try {
                this.index = dataSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    this.index = dataSource.computeLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation2) {
                    this.index = 0L;
                }
            }
        }

        public SourceHolder(DataSource dataSource, long l) {
            this(dataSource, l, null);
        }

        public SourceHolder(DataSource dataSource, long l, String string) {
            this.source = dataSource;
            this.index = l;
            this.name = string;
        }

        public int compareTo(Object object) {
            SourceHolder sourceHolder = (SourceHolder)object;
            return SourcePieDataset.this.sources.indexOf(this) - SourcePieDataset.this.sources.indexOf(object);
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            String string = DataInfo.getLabel((Object)this.source);
            if (string != null) {
                return string;
            }
            return super.toString();
        }
    }
}

