/*
 * Automatically generated by jrpcgen 1.0.3 on 27/02/05 23:30
 * jrpcgen is part of the "Remote Tea" ONC/RPC package for Java
 * See http://acplt.org/ks/remotetea.html for details
 */
package tsp.core.rpc;
import org.acplt.oncrpc.*;
import java.io.IOException;

import java.net.InetAddress;

/**
 * The class <code>TSP_rpcClientStub</code> implements the client stub proxy
 * for the TSP_RPC remote program. It provides method stubs
 * which, when called, in turn call the appropriate remote method (procedure).
 */
public class TSP_rpcClientStub extends OncRpcClientStub {

    /**
     * Constructs a <code>TSP_rpcClientStub</code> client stub proxy object
     * from which the TSP_RPC remote program can be accessed.
     * @param host Internet address of host where to contact the remote program.
     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be
     *   used for ONC/RPC calls.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_rpcClientStub(InetAddress host, int protocol)
           throws OncRpcException, IOException {
        super(host, TSP_rpc.TSP_RPC, 1, 0, protocol);
    }

    /**
     * Constructs a <code>TSP_rpcClientStub</code> client stub proxy object
     * from which the TSP_RPC remote program can be accessed.
     * @param host Internet address of host where to contact the remote program.
     * @param port Port number at host where the remote program can be reached.
     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be
     *   used for ONC/RPC calls.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_rpcClientStub(InetAddress host, int port, int protocol)
           throws OncRpcException, IOException {
        super(host, TSP_rpc.TSP_RPC, 1, port, protocol);
    }

    /**
     * Constructs a <code>TSP_rpcClientStub</code> client stub proxy object
     * from which the TSP_RPC remote program can be accessed.
     * @param client ONC/RPC client connection object implementing a particular
     *   protocol.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_rpcClientStub(OncRpcClient client)
           throws OncRpcException, IOException {
        super(client);
    }

    /**
     * Constructs a <code>TSP_rpcClientStub</code> client stub proxy object
     * from which the TSP_RPC remote program can be accessed.
     * @param host Internet address of host where to contact the remote program.
     * @param program Remote program number.
     * @param version Remote program version number.
     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be
     *   used for ONC/RPC calls.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_rpcClientStub(InetAddress host, int program, int version, int protocol)
           throws OncRpcException, IOException {
        super(host, program, version, 0, protocol);
    }

    /**
     * Constructs a <code>TSP_rpcClientStub</code> client stub proxy object
     * from which the TSP_RPC remote program can be accessed.
     * @param host Internet address of host where to contact the remote program.
     * @param program Remote program number.
     * @param version Remote program version number.
     * @param port Port number at host where the remote program can be reached.
     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be
     *   used for ONC/RPC calls.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_rpcClientStub(InetAddress host, int program, int version, int port, int protocol)
           throws OncRpcException, IOException {
        super(host, program, version, port, protocol);
    }

    /**
     * Call remote procedure TSP_PROVIDER_INFORMATION_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_provider_info_t TSP_PROVIDER_INFORMATION_1()
           throws OncRpcException, IOException {
        XdrVoid args$ = XdrVoid.XDR_VOID;
        TSP_provider_info_t result$ = new TSP_provider_info_t();
        client.call(TSP_rpc.TSP_PROVIDER_INFORMATION_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, args$, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_OPEN_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_open_t TSP_REQUEST_OPEN_1(TSP_request_open_t req_open)
           throws OncRpcException, IOException {
        TSP_answer_open_t result$ = new TSP_answer_open_t();
        client.call(TSP_rpc.TSP_REQUEST_OPEN_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_open, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_CLOSE_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public void TSP_REQUEST_CLOSE_1(TSP_request_close_t req_close)
           throws OncRpcException, IOException {
        XdrVoid result$ = XdrVoid.XDR_VOID;
        client.call(TSP_rpc.TSP_REQUEST_CLOSE_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_close, result$);
    }

    /**
     * Call remote procedure TSP_REQUEST_INFORMATION_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_sample_t TSP_REQUEST_INFORMATION_1(TSP_request_information_t req_info)
           throws OncRpcException, IOException {
        TSP_answer_sample_t result$ = new TSP_answer_sample_t();
        client.call(TSP_rpc.TSP_REQUEST_INFORMATION_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_info, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_FEATURE_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_feature_t TSP_REQUEST_FEATURE_1(TSP_request_feature_t req_feature)
           throws OncRpcException, IOException {
        TSP_answer_feature_t result$ = new TSP_answer_feature_t();
        client.call(TSP_rpc.TSP_REQUEST_FEATURE_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_feature, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_SAMPLE_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_sample_t TSP_REQUEST_SAMPLE_1(TSP_request_sample_t req_sample)
           throws OncRpcException, IOException {
        TSP_answer_sample_t result$ = new TSP_answer_sample_t();
        client.call(TSP_rpc.TSP_REQUEST_SAMPLE_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_sample, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_SAMPLE_INIT_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_sample_init_t TSP_REQUEST_SAMPLE_INIT_1(TSP_request_sample_init_t req_sample)
           throws OncRpcException, IOException {
        TSP_answer_sample_init_t result$ = new TSP_answer_sample_init_t();
        client.call(TSP_rpc.TSP_REQUEST_SAMPLE_INIT_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_sample, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_REQUEST_SAMPLE_DESTROY_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public TSP_answer_sample_destroy_t TSP_REQUEST_SAMPLE_DESTROY_1(TSP_request_sample_destroy_t req_destroy)
           throws OncRpcException, IOException {
        TSP_answer_sample_destroy_t result$ = new TSP_answer_sample_destroy_t();
        client.call(TSP_rpc.TSP_REQUEST_SAMPLE_DESTROY_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, req_destroy, result$);
        return result$;
    }

    /**
     * Call remote procedure TSP_EXEC_FEATURE_1.
     * @return Result from remote procedure call.
     * @throws OncRpcException if an ONC/RPC error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public void TSP_EXEC_FEATURE_1(TSP_exec_feature_t exec_feature)
           throws OncRpcException, IOException {
        XdrVoid result$ = XdrVoid.XDR_VOID;
        client.call(TSP_rpc.TSP_EXEC_FEATURE_1, TSP_rpc.TSP_RPC_VERSION_INITIAL, exec_feature, result$);
    }

}
// End of TSP_rpcClientStub.java
