/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.MatrixSeries;
import org.jfree.data.XYZDataset;
import org.jfree.util.ObjectUtils;

public class MatrixSeriesCollection
extends AbstractSeriesDataset
implements XYZDataset,
Serializable {
    private List m_data = new ArrayList();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries matrixSeries) {
        if (matrixSeries != null) {
            this.m_data.add(matrixSeries);
            matrixSeries.addChangeListener(this);
        }
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public MatrixSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("MatrixSeriesCollection.getSeries(...): index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(n);
        return matrixSeries;
    }

    public int getSeriesCount() {
        return this.m_data.size();
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public Number getXValue(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(n);
        int n3 = matrixSeries.getItemColumn(n2);
        return new Integer(n3);
    }

    public Number getYValue(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(n);
        int n3 = matrixSeries.getItemRow(n2);
        return new Integer(n3);
    }

    public Number getZValue(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(n);
        Number number = matrixSeries.getItem(n2);
        return number;
    }

    public void addSeries(MatrixSeries matrixSeries) {
        if (matrixSeries == null) {
            throw new IllegalArgumentException("MatrixSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.m_data.add(matrixSeries);
        matrixSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection matrixSeriesCollection = (MatrixSeriesCollection)object;
            return ObjectUtils.equal((Object)this.m_data, (Object)matrixSeriesCollection.m_data);
        }
        return false;
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.m_data.size(); ++i) {
            MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(i);
            matrixSeries.removeChangeListener(this);
        }
        this.m_data.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries matrixSeries) {
        if (matrixSeries == null) {
            throw new IllegalArgumentException("MatrixSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.m_data.contains(matrixSeries)) {
            matrixSeries.removeChangeListener(this);
            this.m_data.remove(matrixSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("MatrixSeriesCollection.removeSeries(...): index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.m_data.get(n);
        matrixSeries.removeChangeListener(this);
        this.m_data.remove(n);
        this.fireDatasetChanged();
    }
}

