/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnDecodingInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnum;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParamInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParser;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParserException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProgramInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenScanner;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnion;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenVersionInfo;
import org.acplt.oncrpc.apps.jrpcgen.cup_runtime.Symbol;

public class jrpcgen {
    public static final String VERSION = "1.0.3";
    public static final int PARAMS_VOID = 0;
    public static final int PARAMS_SINGLE = 1;
    public static final int PARAMS_SINGLE_BASETYPE = 2;
    public static final int PARAMS_MORE = 3;
    public static final String startDate;
    public static Hashtable globalIdentifiers;
    public static boolean noBackups;
    public static Vector programInfos;
    public static boolean debug;
    public static boolean verbose;
    public static boolean parseOnly;
    public static File xFile;
    public static File destinationDir;
    public static Writer currentFileWriter;
    public static PrintWriter currentPrintWriter;
    public static String currentFilename;
    public static String packageName;
    public static String baseClassname;
    public static boolean noClient;
    public static boolean noServer;
    public static String serverClass;
    public static String clientClass;
    public static boolean makeSerializable;
    public static boolean initStrings;
    private static String[] baseTypes;

    public static void printHelp() {
        System.out.println("Usage: jrpcgen [-options] x-file");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("  -c <classname>  specify class name of client proxy stub");
        System.out.println("  -d <dir>        specify directory where to place generated source code files");
        System.out.println("  -p <package>    specify package name for generated source code files");
        System.out.println("  -s <classname>  specify class name of server proxy stub");
        System.out.println("  -ser            tag generated XDR classes as serializable");
        System.out.println("  -initstrings    initialize all strings to be empty instead of null");
        System.out.println("  -nobackup       do not make backups of old source code files");
        System.out.println("  -noclient       do not create client proxy stub");
        System.out.println("  -noserver       do not create server proxy stub");
        System.out.println("  -parseonly      parse x-file only but do not create source code files");
        System.out.println("  -verbose        enable verbose output about what jrpcgen is doing");
        System.out.println("  -version        print jrpcgen version and exit");
        System.out.println("  -debug          enables printing of diagnostic messages");
        System.out.println("  -? -help        print this help message and exit");
        System.out.println("  --              end options");
        System.out.println();
    }

    public static PrintWriter createJavaSourceFile(String classname) {
        PrintWriter out;
        File file;
        String filename = String.valueOf(String.valueOf(classname)).concat(".java");
        if (debug) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Generating source code for \"").append(filename).append("\" in \"").append(destinationDir).append("\""))));
        }
        if ((file = new File(destinationDir, filename)).exists() && !noBackups) {
            File oldBackup;
            if (!file.isFile()) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("error: source file \"").append(filename).append("\"already exists and is not a regular file"))));
                System.exit(1);
            }
            if ((oldBackup = new File(destinationDir, String.valueOf(String.valueOf(filename)).concat("~"))).isFile()) {
                oldBackup.delete();
            } else if (oldBackup.exists()) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("error: backup source file \"").append(filename).append("~\" is not a regular file"))));
                System.exit(1);
            }
            if (!file.renameTo(new File(destinationDir, String.valueOf(String.valueOf(filename)).concat("~")))) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("error: can not rename old source code file \"").append(filename).append("\""))));
                System.exit(1);
            }
            if (verbose) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Saved old source code file as \"").append(filename).append("~\""))));
            }
        }
        try {
            currentFileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("error: can not create \"").append(filename).append("\": ").append(e.getLocalizedMessage()))));
            System.exit(1);
        }
        if (verbose) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("Creating source code file \"").append(filename).append("\"..."))));
        }
        currentFilename = filename;
        currentPrintWriter = out = new PrintWriter(currentFileWriter, true);
        out.println("/*");
        out.println(String.valueOf(String.valueOf(new StringBuffer(" * Automatically generated by jrpcgen 1.0.3 on ").append(startDate))));
        out.println(" * jrpcgen is part of the \"Remote Tea\" ONC/RPC package for Java");
        out.println(" * See http://acplt.org/ks/remotetea.html for details");
        out.println(" */");
        if (packageName != null && packageName.length() > 0) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("package ").append(packageName).append(";"))));
        }
        out.println("import org.acplt.oncrpc.*;");
        out.println("import java.io.IOException;");
        out.println();
        return out;
    }

    public static JrpcgenSHA createSHA(String classname) {
        JrpcgenSHA hash = new JrpcgenSHA();
        if (packageName != null && packageName.length() > 0) {
            hash.update(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(packageName))).append(".").append(classname))));
        } else {
            hash.update(classname);
        }
        return hash;
    }

    public static void closeJavaSourceFile() {
        currentPrintWriter.println("// End of ".concat(String.valueOf(String.valueOf(currentFilename))));
        if (verbose) {
            System.out.println();
        }
        try {
            currentPrintWriter.close();
            currentFileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Can not close source code file: ".concat(String.valueOf(String.valueOf(e.getLocalizedMessage()))));
        }
    }

    public static void dumpConstantAndDependency(PrintWriter out, JrpcgenConst c) {
        JrpcgenConst dc;
        if (c.dontTraverseAnyMore) {
            return;
        }
        c.dontTraverseAnyMore = true;
        String dependencyIdentifier = c.getDependencyIdentifier();
        if (dependencyIdentifier != null && (dc = (JrpcgenConst)globalIdentifiers.get(dependencyIdentifier)) != null) {
            if (!c.enclosure.equalsIgnoreCase(dc.enclosure)) {
                out.println(String.valueOf(String.valueOf(new StringBuffer("    public static final int ").append(c.identifier).append(" = ").append(dc.enclosure).append(".").append(c.value).append(";"))));
                return;
            }
            jrpcgen.dumpConstantAndDependency(out, dc);
        }
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public static final int ").append(c.identifier).append(" = ").append(c.value).append(";"))));
    }

    public static void dumpConstants() {
        PrintWriter out = jrpcgen.createJavaSourceFile(baseClassname);
        out.println("/**");
        out.println(String.valueOf(String.valueOf(new StringBuffer(" * A collection of constants used by the \"").append(baseClassname).append("\" ONC/RPC program."))));
        out.println(" */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("public interface ").append(baseClassname).append(" {"))));
        Enumeration globals = globalIdentifiers.elements();
        while (globals.hasMoreElements()) {
            Object o = globals.nextElement();
            if (!(o instanceof JrpcgenConst)) continue;
            JrpcgenConst c = (JrpcgenConst)o;
            if (!baseClassname.equals(c.enclosure)) continue;
            jrpcgen.dumpConstantAndDependency(out, c);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpEnum(JrpcgenEnum e) {
        PrintWriter out = jrpcgen.createJavaSourceFile(e.identifier);
        out.println("/**");
        out.println(" * Enumeration (collection of constants).");
        out.println(" */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("public interface ").append(e.identifier).append(" {"))));
        out.println();
        Enumeration enums = e.enums.elements();
        while (enums.hasMoreElements()) {
            JrpcgenConst c = (JrpcgenConst)enums.nextElement();
            jrpcgen.dumpConstantAndDependency(out, c);
        }
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static String xdrBaseType(String type) {
        int size = baseTypes.length;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            return String.valueOf(String.valueOf(new StringBuffer("Xdr").append(type.substring(0, 1).toUpperCase()).append(type.substring(1))));
        }
        return null;
    }

    public static JrpcgenEnDecodingInfo baseEnDecodingSyllable(JrpcgenDeclaration decl) {
        Object o;
        String syllable = decl.type;
        boolean isBase = false;
        int size = baseTypes.length;
        String type = decl.type;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            isBase = true;
            syllable = String.valueOf(String.valueOf(syllable.substring(0, 1).toUpperCase())).concat(String.valueOf(String.valueOf(syllable.substring(1))));
            break;
        }
        if (!isBase && (o = globalIdentifiers.get(decl.type)) instanceof JrpcgenEnum) {
            isBase = true;
            syllable = "Int";
        }
        if (isBase) {
            String encodingOpts = null;
            String decodingOpts = null;
            if (decl.kind == 1 || decl.kind == 2) {
                if ("opaque".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = "Opaque";
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    } else {
                        syllable = "DynamicOpaque";
                        encodingOpts = null;
                        decodingOpts = null;
                    }
                } else if (!"String".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = String.valueOf(String.valueOf(syllable)).concat("Fixed");
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    }
                    syllable = String.valueOf(String.valueOf(syllable)).concat("Vector");
                }
            }
            JrpcgenEnDecodingInfo result = new JrpcgenEnDecodingInfo(syllable, encodingOpts, decodingOpts);
            return result;
        }
        return null;
    }

    public static String codingMethod(JrpcgenDeclaration decl, boolean encode) {
        return jrpcgen.codingMethod(decl, encode, null);
    }

    public static String codingMethod(JrpcgenDeclaration decl, boolean encode, String oref) {
        if (decl.identifier == null) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        JrpcgenEnDecodingInfo data = jrpcgen.baseEnDecodingSyllable(decl);
        oref = oref == null ? "" : String.valueOf(String.valueOf(oref)).concat(".");
        if (data != null) {
            if (encode) {
                code.append("        xdr.xdrEncode");
                code.append(data.syllable);
                code.append("(");
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                if (data.encodingOptions != null) {
                    code.append(", ");
                    code.append(data.encodingOptions);
                }
                code.append(");\n");
            } else {
                code.append("        ");
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(" = xdr.xdrDecode");
                code.append(data.syllable);
                code.append("(");
                if (data.decodingOptions != null) {
                    code.append(data.decodingOptions);
                }
                code.append(");\n");
            }
            return code.toString();
        }
        if (decl.kind == 0) {
            code.append("        ");
            if (encode) {
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(".xdrEncode(xdr);\n");
            } else {
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(" = new ");
                code.append(decl.type);
                code.append("(xdr);\n");
            }
            return code.toString();
        }
        if (decl.kind == 3) {
            code.append("        ");
            if (encode) {
                code.append("if ( ");
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(" != null ) { ");
                code.append("xdr.xdrEncodeBoolean(true); ");
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(".xdrEncode(xdr);");
                code.append(" } else { ");
                code.append("xdr.xdrEncodeBoolean(false);");
                code.append(" };\n");
            } else {
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(" = xdr.xdrDecodeBoolean() ? new ");
                code.append(decl.type);
                code.append("(xdr) : null;\n");
            }
            return code.toString();
        }
        if (encode) {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
                code.append(".length");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            if (decl.kind == 2) {
                code.append("xdr.xdrEncodeInt($size); ");
            }
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
            code.append("[$idx].xdrEncode(xdr); ");
            code.append("} }\n");
        } else {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append("xdr.xdrDecodeInt()");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
            code.append(" = new ");
            code.append(decl.type);
            code.append("[$size]; ");
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(String.valueOf(String.valueOf(oref)).concat(String.valueOf(String.valueOf(decl.identifier))));
            code.append("[$idx] = new ");
            code.append(decl.type);
            code.append("(xdr); ");
            code.append("} }\n");
        }
        return code.toString();
    }

    public static String checkForSpecials(String dataType) {
        if (globalIdentifiers.get(dataType) instanceof JrpcgenEnum) {
            return "int";
        }
        if ("opaque".equals(dataType)) {
            return "byte";
        }
        return dataType;
    }

    public static String checkForEnumValue(String value) {
        if (value.length() > 0) {
            if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '-') {
                return value;
            }
            Object id = globalIdentifiers.get(value);
            if (id != null && id instanceof JrpcgenConst) {
                JrpcgenConst c = (JrpcgenConst)id;
                if (c.enclosure == null) {
                    return c.value;
                }
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(c.enclosure))).append(".").append(c.identifier)));
            }
        }
        return value;
    }

    public static void dumpStruct(JrpcgenStruct s) {
        int size;
        JrpcgenDeclaration decl;
        PrintWriter out = jrpcgen.createJavaSourceFile(s.identifier);
        out.print(String.valueOf(String.valueOf(new StringBuffer("public class ").append(s.identifier).append(" implements XdrAble"))));
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        out.println(" {");
        boolean useIteration = false;
        JrpcgenSHA hash = jrpcgen.createSHA(s.identifier);
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            JrpcgenDeclaration d = (JrpcgenDeclaration)decls.nextElement();
            hash.update(d.type);
            hash.update(d.kind);
            hash.update(d.identifier);
            out.print(String.valueOf(String.valueOf(new StringBuffer("    public ").append(jrpcgen.checkForSpecials(d.type)).append(" "))));
            if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
                out.print("[] ");
            }
            if (initStrings && d.type.equals("String")) {
                out.println(String.valueOf(String.valueOf(d.identifier)).concat(" = \"\"; "));
            } else {
                out.println(String.valueOf(String.valueOf(d.identifier)).concat(";"));
            }
            if (decls.hasMoreElements() || d.kind != 3 || !d.type.equals(s.identifier)) continue;
            useIteration = true;
        }
        if (makeSerializable) {
            out.println();
            out.println(String.valueOf(String.valueOf(new StringBuffer("    private static final long serialVersionUID = ").append(hash.getHash()).append("L;"))));
        }
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(s.identifier).append("() {"))));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(s.identifier).append("(XdrDecodingStream xdr)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        if (useIteration) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(s.identifier).append(" $this = this;"))));
            out.println("        do {");
            decl = null;
            for (size = s.elements.size(); size > 1; --size) {
                decl = (JrpcgenDeclaration)decls.nextElement();
                out.print("    ".concat(String.valueOf(String.valueOf(jrpcgen.codingMethod(decl, true, "$this")))));
            }
            decl = (JrpcgenDeclaration)decls.nextElement();
            out.println(String.valueOf(String.valueOf(new StringBuffer("            $this = $this.").append(decl.identifier).append(";"))));
            out.println("            xdr.xdrEncodeBoolean($this != null);");
            out.println("        } while ( $this != null );");
        } else {
            while (decls.hasMoreElements()) {
                out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), true));
            }
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        if (useIteration) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(s.identifier).append(" $this = this;"))));
            out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(s.identifier).append(" $next;"))));
            out.println("        do {");
            decl = null;
            for (size = s.elements.size(); size > 1; --size) {
                decl = (JrpcgenDeclaration)decls.nextElement();
                out.print("    ".concat(String.valueOf(String.valueOf(jrpcgen.codingMethod(decl, false, "$this")))));
            }
            decl = (JrpcgenDeclaration)decls.nextElement();
            out.println(String.valueOf(String.valueOf(new StringBuffer("            $next = xdr.xdrDecodeBoolean() ? new ").append(s.identifier).append("() : null;"))));
            out.println(String.valueOf(String.valueOf(new StringBuffer("            $this.").append(decl.identifier).append(" = $next;"))));
            out.println("            $this = $next;");
            out.println("        } while ( $this != null );");
        } else {
            while (decls.hasMoreElements()) {
                out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), false));
            }
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpUnion(JrpcgenUnion u) {
        JrpcgenUnionArm a;
        JrpcgenUnionArm a2;
        PrintWriter out = jrpcgen.createJavaSourceFile(u.identifier);
        out.print(String.valueOf(String.valueOf(new StringBuffer("public class ").append(u.identifier).append(" implements XdrAble"))));
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        out.println(" {");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(jrpcgen.checkForSpecials(u.descriminant.type)).append(" ").append(u.descriminant.identifier).append(";"))));
        boolean boolDescriminant = u.descriminant.type.equals("boolean");
        JrpcgenSHA hash = jrpcgen.createSHA(u.identifier);
        Enumeration arms = u.elements.elements();
        while (arms.hasMoreElements()) {
            a2 = (JrpcgenUnionArm)arms.nextElement();
            if (a2.element == null || a2.element.identifier == null) continue;
            if (a2.value != null) {
                hash.update(a2.value);
            } else {
                hash.update("default");
            }
            hash.update(a2.element.type);
            hash.update(a2.element.kind);
            hash.update(a2.element.identifier);
            out.print(String.valueOf(String.valueOf(new StringBuffer("    public ").append(jrpcgen.checkForSpecials(a2.element.type)).append(" "))));
            if (!(a2.element.kind != 1 && a2.element.kind != 2 || a2.element.type.equals("String"))) {
                out.print("[] ");
            }
            out.println(String.valueOf(String.valueOf(a2.element.identifier)).concat(";"));
        }
        if (makeSerializable) {
            out.println();
            out.println(String.valueOf(String.valueOf(new StringBuffer("    private static final long serialVersionUID = ").append(hash.getHash()).append("L;"))));
        }
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(u.identifier).append("() {"))));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(u.identifier).append("(XdrDecodingStream xdr)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, true));
        if (!boolDescriminant) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("        switch ( ").append(u.descriminant.identifier).append(" ) {"))));
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a2 = (JrpcgenUnionArm)arms.nextElement();
                if (a2.value != null) {
                    out.println(String.valueOf(String.valueOf(new StringBuffer("        case ").append(jrpcgen.checkForEnumValue(a2.value)).append(":"))));
                } else {
                    out.println("        default:");
                }
                if (a2.element == null) continue;
                if (a2.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a2.element, true));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println(String.valueOf(String.valueOf(new StringBuffer("if ( ").append(u.descriminant.identifier).append(" == ").append(jrpcgen.checkForEnumValue(a.value)).append(" ) {"))));
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, false));
        if (!boolDescriminant) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("        switch ( ").append(u.descriminant.identifier).append(" ) {"))));
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                JrpcgenUnionArm a3 = (JrpcgenUnionArm)arms.nextElement();
                if (a3.value != null) {
                    out.println(String.valueOf(String.valueOf(new StringBuffer("        case ").append(jrpcgen.checkForEnumValue(a3.value)).append(":"))));
                } else {
                    out.println("        default:");
                }
                if (a3.element == null) continue;
                if (a3.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a3.element, false));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println(String.valueOf(String.valueOf(new StringBuffer("if ( ").append(u.descriminant.identifier).append(" == ").append(jrpcgen.checkForEnumValue(a.value)).append(" ) {"))));
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpTypedef(JrpcgenDeclaration d) {
        PrintWriter out = jrpcgen.createJavaSourceFile(d.identifier);
        out.print(String.valueOf(String.valueOf(new StringBuffer("public class ").append(d.identifier).append(" implements XdrAble"))));
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        out.println(" {");
        out.println();
        String paramType = jrpcgen.checkForSpecials(d.type);
        if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
            paramType = String.valueOf(String.valueOf(paramType)).concat(" []");
        }
        out.print(String.valueOf(String.valueOf(new StringBuffer("    public ").append(paramType).append(" value;"))));
        out.println();
        if (makeSerializable) {
            JrpcgenSHA hash = jrpcgen.createSHA(d.identifier);
            hash.update(d.type);
            hash.update(d.kind);
            out.println();
            out.println(String.valueOf(String.valueOf(new StringBuffer("    private static final long serialVersionUID = ").append(hash.getHash()).append("L;"))));
        }
        JrpcgenDeclaration dstar = null;
        try {
            dstar = (JrpcgenDeclaration)d.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("fatal: can not clone JrpcgenDeclaration");
        }
        dstar.identifier = "value";
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(d.identifier).append("() {"))));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(d.identifier).append("(").append(paramType).append(" value) {"))));
        out.println("        this.value = value;");
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(d.identifier).append("(XdrDecodingStream xdr)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, true));
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, false));
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpClasses() {
        Enumeration globals = globalIdentifiers.elements();
        while (globals.hasMoreElements()) {
            Object o = globals.nextElement();
            if (o instanceof JrpcgenEnum) {
                jrpcgen.dumpEnum((JrpcgenEnum)o);
                continue;
            }
            if (o instanceof JrpcgenStruct) {
                jrpcgen.dumpStruct((JrpcgenStruct)o);
                continue;
            }
            if (o instanceof JrpcgenUnion) {
                jrpcgen.dumpUnion((JrpcgenUnion)o);
                continue;
            }
            if (!(o instanceof JrpcgenDeclaration)) continue;
            jrpcgen.dumpTypedef((JrpcgenDeclaration)o);
        }
    }

    public static void dumpClientStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int size = versionInfo.procedures.size();
        for (int idx = 0; idx < size; ++idx) {
            int paramsKind;
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            String resultType = jrpcgen.checkForSpecials(proc.resultType);
            out.println("    /**");
            out.println(String.valueOf(String.valueOf(new StringBuffer("     * Call remote procedure ").append(proc.procedureId).append("."))));
            out.println("     * @return Result from remote procedure call.");
            out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
            out.println("     * @throws IOException if an I/O error occurs.");
            out.println("     */");
            out.print(String.valueOf(String.valueOf(new StringBuffer("    public ").append(resultType).append(" ").append(proc.procedureId).append("("))));
            if (proc.parameters != null) {
                String firstParamType;
                int psize = proc.parameters.size();
                for (int pidx = 0; pidx < psize; ++pidx) {
                    JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    if (pidx > 0) {
                        out.print(", ");
                    }
                    out.print(jrpcgen.checkForSpecials(paramInfo.parameterType));
                    out.print(" ");
                    out.print(paramInfo.parameterName);
                }
                paramsKind = psize > 1 ? 3 : (jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(firstParamType = ((JrpcgenParamInfo)proc.parameters.elementAt((int)0)).parameterType)) == null ? 1 : 2);
            } else {
                paramsKind = 0;
            }
            out.println(")");
            out.println("           throws OncRpcException, IOException {");
            String xdrParamsName = null;
            switch (paramsKind) {
                case 0: {
                    xdrParamsName = "args$";
                    out.println("        XdrVoid args$ = XdrVoid.XDR_VOID;");
                    break;
                }
                case 1: {
                    JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                    xdrParamsName = paramInfo.parameterName;
                    break;
                }
                case 2: {
                    JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                    xdrParamsName = "args$";
                    String xdrParamsType = jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(paramInfo.parameterType));
                    out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(xdrParamsType).append(" args$ = new ").append(xdrParamsType).append("(").append(paramInfo.parameterName).append(");"))));
                    break;
                }
                case 3: {
                    JrpcgenParamInfo pinfo;
                    int pidx;
                    xdrParamsName = "args$";
                    out.println("        class XdrAble$ implements XdrAble {");
                    int psize = proc.parameters.size();
                    for (int pidx2 = 0; pidx2 < psize; ++pidx2) {
                        JrpcgenParamInfo pinfo2 = (JrpcgenParamInfo)proc.parameters.elementAt(pidx2);
                        out.println(String.valueOf(String.valueOf(new StringBuffer("            public ").append(jrpcgen.checkForSpecials(pinfo2.parameterType)).append(" ").append(pinfo2.parameterName).append(";"))));
                    }
                    out.println("            public void xdrEncode(XdrEncodingStream xdr)");
                    out.println("                throws OncRpcException, IOException {");
                    JrpcgenDeclaration decl = new JrpcgenDeclaration(null, null);
                    for (pidx = 0; pidx < psize; ++pidx) {
                        pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                        decl.kind = 0;
                        decl.identifier = pinfo.parameterName;
                        decl.type = pinfo.parameterType;
                        out.print("        ");
                        out.print(jrpcgen.codingMethod(decl, true));
                    }
                    out.println("            }");
                    out.println("            public void xdrDecode(XdrDecodingStream xdr)");
                    out.println("                throws OncRpcException, IOException {");
                    out.println("            }");
                    out.println("        };");
                    out.println("        XdrAble$ args$ = new XdrAble$();");
                    for (pidx = 0; pidx < psize; ++pidx) {
                        pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                        out.println(String.valueOf(String.valueOf(new StringBuffer("        args$.").append(pinfo.parameterName).append(" = ").append(pinfo.parameterName).append(";"))));
                    }
                    break;
                }
            }
            String xdrResultType = jrpcgen.xdrBaseType(resultType);
            if (resultType.equals("void")) {
                out.println("        XdrVoid result$ = XdrVoid.XDR_VOID;");
            } else if (xdrResultType != null) {
                out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(xdrResultType).append(" result$ = new ").append(xdrResultType).append("();"))));
            } else {
                out.println(String.valueOf(String.valueOf(new StringBuffer("        ").append(resultType).append(" result$ = new ").append(resultType).append("();"))));
            }
            out.println(String.valueOf(String.valueOf(new StringBuffer("        client.call(").append(baseClassname).append(".").append(proc.procedureId).append(", ").append(baseClassname).append(".").append(versionInfo.versionId).append(", ").append(xdrParamsName).append(", result$);"))));
            if (xdrResultType != null) {
                if (!resultType.equals("void")) {
                    out.println(String.valueOf(String.valueOf(new StringBuffer("        return result$.").append(resultType.toLowerCase()).append("Value();"))));
                }
            } else {
                out.println("        return result$;");
            }
            out.println("    }");
            out.println();
        }
    }

    public static void dumpClient(JrpcgenProgramInfo programInfo) {
        int version = Integer.parseInt(((JrpcgenVersionInfo)programInfo.versions.elementAt((int)0)).versionNumber);
        int versionSize = programInfo.versions.size();
        for (int idx = 1; idx < versionSize; ++idx) {
            int anotherVersion = Integer.parseInt(((JrpcgenVersionInfo)programInfo.versions.elementAt((int)idx)).versionNumber);
            if (anotherVersion <= version) continue;
            version = anotherVersion;
        }
        String clientClass = jrpcgen.clientClass;
        if (clientClass == null) {
            clientClass = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(baseClassname))).append("_").append(programInfo.programId).append("_Client")));
            System.out.println("CLIENT: ".concat(String.valueOf(String.valueOf(clientClass))));
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(clientClass);
        out.println("import java.net.InetAddress;");
        out.println();
        out.println("/**");
        out.println(String.valueOf(String.valueOf(new StringBuffer(" * The class <code>").append(clientClass).append("</code> implements the client stub proxy"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer(" * for the ").append(programInfo.programId).append(" remote program. It provides method stubs"))));
        out.println(" * which, when called, in turn call the appropriate remote method (procedure).");
        out.println(" */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("public class ").append(clientClass).append(" extends OncRpcClientStub {"))));
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * Constructs a <code>").append(clientClass).append("</code> client stub proxy object"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * from which the ").append(programInfo.programId).append(" remote program can be accessed."))));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(clientClass).append("(InetAddress host, int protocol)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println(String.valueOf(String.valueOf(new StringBuffer("        super(host, ").append(baseClassname).append(".").append(programInfo.programId).append(", ").append(version).append(", 0, protocol);"))));
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * Constructs a <code>").append(clientClass).append("</code> client stub proxy object"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * from which the ").append(programInfo.programId).append(" remote program can be accessed."))));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param port Port number at host where the remote program can be reached.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(clientClass).append("(InetAddress host, int port, int protocol)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println(String.valueOf(String.valueOf(new StringBuffer("        super(host, ").append(baseClassname).append(".").append(programInfo.programId).append(", ").append(version).append(", port, protocol);"))));
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * Constructs a <code>").append(clientClass).append("</code> client stub proxy object"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * from which the ").append(programInfo.programId).append(" remote program can be accessed."))));
        out.println("     * @param client ONC/RPC client connection object implementing a particular");
        out.println("     *   protocol.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(clientClass).append("(OncRpcClient client)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(client);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * Constructs a <code>").append(clientClass).append("</code> client stub proxy object"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * from which the ").append(programInfo.programId).append(" remote program can be accessed."))));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param program Remote program number.");
        out.println("     * @param version Remote program version number.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(clientClass).append("(InetAddress host, int program, int version, int protocol)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(host, program, version, 0, protocol);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * Constructs a <code>").append(clientClass).append("</code> client stub proxy object"))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("     * from which the ").append(programInfo.programId).append(" remote program can be accessed."))));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param program Remote program number.");
        out.println("     * @param version Remote program version number.");
        out.println("     * @param port Port number at host where the remote program can be reached.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(clientClass).append("(InetAddress host, int program, int version, int port, int protocol)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(host, program, version, port, protocol);");
        out.println("    }");
        out.println();
        for (int versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            JrpcgenVersionInfo versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpClientStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpServerStubMethodCall(PrintWriter out, JrpcgenProcedureInfo proc) {
        String firstParamType;
        int psize;
        String resultType = jrpcgen.checkForSpecials(proc.resultType);
        int paramsKind = proc.parameters != null ? ((psize = proc.parameters.size()) > 1 ? 3 : (jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(firstParamType = ((JrpcgenParamInfo)proc.parameters.elementAt((int)0)).parameterType)) == null ? 1 : 2)) : 0;
        String params = "";
        switch (paramsKind) {
            case 0: {
                out.println("                call.retrieveCall(XdrVoid.XDR_VOID);");
                break;
            }
            case 1: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                out.println(String.valueOf(String.valueOf(new StringBuffer("                ").append(paramInfo.parameterType).append(" args$ = new ").append(paramInfo.parameterType).append("();"))));
                out.println("                call.retrieveCall(args$);");
                params = "args$";
                break;
            }
            case 2: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                String paramsType = jrpcgen.checkForSpecials(paramInfo.parameterType);
                String xdrParamsType = jrpcgen.xdrBaseType(paramsType);
                out.println(String.valueOf(String.valueOf(new StringBuffer("                ").append(xdrParamsType).append(" args$ = new ").append(xdrParamsType).append("();"))));
                out.println("                call.retrieveCall(args$);");
                params = String.valueOf(String.valueOf(new StringBuffer("args$.").append(paramsType.toLowerCase()).append("Value()")));
                break;
            }
            case 3: {
                JrpcgenParamInfo pinfo;
                int pidx;
                StringBuffer paramsBuff = new StringBuffer();
                out.println("                class XdrAble$ implements XdrAble {");
                int psize2 = proc.parameters.size();
                for (int pidx2 = 0; pidx2 < psize2; ++pidx2) {
                    JrpcgenParamInfo pinfo2 = (JrpcgenParamInfo)proc.parameters.elementAt(pidx2);
                    out.println(String.valueOf(String.valueOf(new StringBuffer("                    public ").append(jrpcgen.checkForSpecials(pinfo2.parameterType)).append(" ").append(pinfo2.parameterName).append(";"))));
                }
                out.println("                    public void xdrEncode(XdrEncodingStream xdr)");
                out.println("                        throws OncRpcException, IOException {");
                out.println("                    }");
                out.println("                    public void xdrDecode(XdrDecodingStream xdr)");
                out.println("                        throws OncRpcException, IOException {");
                JrpcgenDeclaration decl = new JrpcgenDeclaration(null, null);
                for (pidx = 0; pidx < psize2; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    decl.kind = 0;
                    decl.identifier = pinfo.parameterName;
                    decl.type = pinfo.parameterType;
                    out.print("                ");
                    out.print(jrpcgen.codingMethod(decl, false));
                }
                out.println("                    }");
                out.println("                };");
                out.println("                XdrAble$ args$ = new XdrAble$();");
                out.println("                call.retrieveCall(args$);");
                for (pidx = 0; pidx < psize2; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    if (pidx > 0) {
                        paramsBuff.append(", ");
                    }
                    paramsBuff.append("args$.");
                    paramsBuff.append(pinfo.parameterName);
                }
                params = paramsBuff.toString();
                break;
            }
        }
        String xdrResultType = jrpcgen.xdrBaseType(resultType);
        if (resultType.equals("void")) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("                ").append(proc.procedureId).append("(").append(params).append(");"))));
            out.println("                call.reply(XdrVoid.XDR_VOID);");
        } else if (xdrResultType != null) {
            out.println(String.valueOf(String.valueOf(new StringBuffer("                ").append(xdrResultType).append(" result$ = new ").append(xdrResultType).append("(").append(proc.procedureId).append("(").append(params).append("));"))));
            out.println("                call.reply(result$);");
        } else {
            out.println(String.valueOf(String.valueOf(new StringBuffer("                ").append(resultType).append(" result$ = ").append(proc.procedureId).append("(").append(params).append(");"))));
            out.println("                call.reply(result$);");
        }
    }

    public static void dumpServerStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int procSize = versionInfo.procedures.size();
        for (int idx = 0; idx < procSize; ++idx) {
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            String resultType = jrpcgen.checkForSpecials(proc.resultType);
            out.print(String.valueOf(String.valueOf(new StringBuffer("    public abstract ").append(resultType).append(" ").append(proc.procedureId).append("("))));
            if (proc.parameters != null) {
                int psize = proc.parameters.size();
                for (int pidx = 0; pidx < psize; ++pidx) {
                    JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    if (pidx > 0) {
                        out.print(", ");
                    }
                    out.print(jrpcgen.checkForSpecials(paramInfo.parameterType));
                    out.print(" ");
                    out.print(paramInfo.parameterName);
                }
            }
            out.println(");");
            out.println();
        }
    }

    public static void dumpServer(JrpcgenProgramInfo programInfo) {
        JrpcgenVersionInfo versionInfo;
        int versionIdx;
        String serverClass = jrpcgen.serverClass;
        if (serverClass == null) {
            serverClass = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(baseClassname))).append("_").append(programInfo.programId).append("_ServerStub")));
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(serverClass);
        out.println("import java.net.InetAddress;");
        out.println();
        out.println("import org.acplt.oncrpc.server.*;");
        out.println();
        out.println("/**");
        out.println(" */");
        out.println(String.valueOf(String.valueOf(new StringBuffer("public abstract class ").append(serverClass).append(" extends OncRpcServerStub implements OncRpcDispatchable {"))));
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(serverClass).append("()"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(0);");
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(serverClass).append("(int port)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(null, 0);");
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(new StringBuffer("    public ").append(serverClass).append("(InetAddress bindAddr, int port)"))));
        out.println("           throws OncRpcException, IOException {");
        out.println("        info = new OncRpcServerTransportRegistrationInfo [] {");
        int versionSize = programInfo.versions.size();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            out.println(String.valueOf(String.valueOf(new StringBuffer("            new OncRpcServerTransportRegistrationInfo(").append(baseClassname).append(".").append(programInfo.programId).append(", ").append(versionInfo.versionNumber).append("),"))));
        }
        out.println("        };");
        out.println("        transports = new OncRpcServerTransport [] {");
        out.println("            new OncRpcUdpServerTransport(this, bindAddr, port, info, 32768),");
        out.println("            new OncRpcTcpServerTransport(this, bindAddr, port, info, 32768)");
        out.println("        };");
        out.println("    }");
        out.println();
        out.println("    public void dispatchOncRpcCall(OncRpcCallInformation call, int program, int version, int procedure)");
        out.println("           throws OncRpcException, IOException {");
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            out.print(versionIdx == 0 ? "        " : "        } else ");
            out.println(String.valueOf(String.valueOf(new StringBuffer("if ( version == ").append(versionInfo.versionNumber).append(" ) {"))));
            int procSize = versionInfo.procedures.size();
            out.println("            switch ( procedure ) {");
            for (int procIdx = 0; procIdx < procSize; ++procIdx) {
                JrpcgenProcedureInfo procInfo = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(procIdx);
                out.println(String.valueOf(String.valueOf(new StringBuffer("            case ").append(procInfo.procedureNumber).append(": {"))));
                jrpcgen.dumpServerStubMethodCall(out, procInfo);
                out.println("                break;");
                out.println("            }");
            }
            out.println("            default:");
            out.println("                call.failProcedureUnavailable();");
            out.println("            }");
        }
        out.println("        } else {");
        out.println("            call.failProcedureUnavailable();");
        out.println("        }");
        out.println("    }");
        out.println();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpServerStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpFiles() {
        jrpcgen.dumpConstants();
        jrpcgen.dumpClasses();
        for (int i = 0; i < programInfos.size(); ++i) {
            JrpcgenProgramInfo progInfo = (JrpcgenProgramInfo)programInfos.elementAt(i);
            if (!noClient) {
                jrpcgen.dumpClient(progInfo);
            }
            if (noServer) continue;
            jrpcgen.dumpServer(progInfo);
        }
    }

    public static void main(String[] args) {
        String arg;
        int argIdx;
        int argc = args.length;
        for (argIdx = 0; argIdx < argc && ((arg = args[argIdx]).length() <= 0 || arg.charAt(0) == '-'); ++argIdx) {
            if (arg.equals("-d")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing directory");
                    System.exit(1);
                }
                destinationDir = new File(args[argIdx]);
                continue;
            }
            if (arg.equals("-package") || arg.equals("-p")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing package name");
                    System.exit(1);
                }
                packageName = args[argIdx];
                continue;
            }
            if (arg.equals("-c")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing client class name");
                    System.exit(1);
                }
                clientClass = args[argIdx];
                continue;
            }
            if (arg.equals("-s")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing server class name");
                    System.exit(1);
                }
                serverClass = args[argIdx];
                continue;
            }
            if (arg.equals("-ser")) {
                makeSerializable = true;
                continue;
            }
            if (arg.equals("-initstrings")) {
                initStrings = true;
                continue;
            }
            if (arg.equals("-debug")) {
                debug = true;
                continue;
            }
            if (arg.equals("-nobackup")) {
                noBackups = true;
                continue;
            }
            if (arg.equals("-noclient")) {
                noClient = true;
                continue;
            }
            if (arg.equals("-noserver")) {
                noServer = true;
                continue;
            }
            if (arg.equals("-parseonly")) {
                parseOnly = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("jrpcgen version \"1.0.3\"");
                System.exit(1);
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                jrpcgen.printHelp();
                System.exit(1);
                continue;
            }
            if (arg.equals("--")) {
                ++argIdx;
                break;
            }
            System.out.println("Unrecognized option: ".concat(String.valueOf(String.valueOf(arg))));
            System.exit(1);
        }
        if (argIdx >= argc || argIdx < argc - 1) {
            jrpcgen.printHelp();
            System.exit(1);
        }
        String xfilename = args[argIdx];
        xFile = new File(".", xfilename);
        try {
            jrpcgen.doParse();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            System.exit(1);
        }
    }

    public static void doParse() throws Exception, FileNotFoundException {
        if (baseClassname == null) {
            String name = xFile.getName();
            int dotIdx = name.lastIndexOf(46);
            baseClassname = dotIdx < 0 ? name : name.substring(0, dotIdx);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(xFile.getCanonicalPath());
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(String.valueOf(String.valueOf(new StringBuffer("jrpcgen: can not open source x-file \"").append(xFile.getCanonicalPath()).append("\""))));
        }
        JrpcgenScanner scanner = new JrpcgenScanner(in);
        JrpcgenParser parser = new JrpcgenParser(scanner);
        globalIdentifiers.put("TRUE", new JrpcgenConst("TRUE", "true"));
        globalIdentifiers.put("FALSE", new JrpcgenConst("FALSE", "false"));
        try {
            Symbol sym = parser.parse();
            if (!parseOnly) {
                if (programInfos.size() <= 1) {
                    if (clientClass == null) {
                        clientClass = String.valueOf(String.valueOf(baseClassname)).concat("Client");
                    }
                    if (serverClass == null) {
                        serverClass = String.valueOf(String.valueOf(baseClassname)).concat("ServerStub");
                    }
                }
                jrpcgen.dumpFiles();
            }
        }
        catch (JrpcgenParserException pe) {
            throw new Exception(String.valueOf(String.valueOf(new StringBuffer("jrpcgen: compilation aborted (").append(pe.getMessage()).append(")"))));
        }
    }

    static {
        VERSION = VERSION;
        PARAMS_VOID = 0;
        PARAMS_SINGLE = 1;
        PARAMS_SINGLE_BASETYPE = 2;
        PARAMS_MORE = 3;
        startDate = new SimpleDateFormat().format(new Date());
        globalIdentifiers = new Hashtable();
        noBackups = false;
        programInfos = null;
        debug = false;
        verbose = false;
        parseOnly = false;
        xFile = null;
        destinationDir = new File(".");
        currentFileWriter = null;
        currentPrintWriter = null;
        currentFilename = null;
        packageName = null;
        baseClassname = null;
        noClient = false;
        noServer = false;
        serverClass = null;
        clientClass = null;
        makeSerializable = false;
        initStrings = false;
        baseTypes = new String[]{"void", "boolean", "byte", "short", "int", "long", "float", "double", "String"};
    }
}

