/* $Id: SpecSample.java,v 1.1 2005/03/31 05:40:03 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */

package tsp.consumer.util.configuration;

import tsp.util.ToStringHelper;

public class SpecSample implements Consolidatable {

	private String name;

	private String reNamed;

	private VarTypeEnum type;

	private String providerName;

	private SpecProvider provider;

	private SpecSampleList sampleList;

	private Integer ownPeriod;

	private String description;

	private final SpecSamplingConfig root;

	public SpecSample(final SpecSamplingConfig root) {
		super();
		this.root = root;
	}

	public SpecSampleList getSampleList() {
		return sampleList;
	}

	void setSampleList(SpecSampleList sampleList) {
		this.sampleList = sampleList;
		sampleList.getSamples().add(this);
	}

	public String getName() {
		return name;
	}

	void setName(String name) {
		this.name = name;
	}

	public String getReNamed() {
		return reNamed;
	}

	void setReNamed(String reNamed) {
		this.reNamed = reNamed;
	}

	public VarTypeEnum getType() {
		return type;
	}

	void setType(VarTypeEnum type) {
		this.type = type;
	}

	String getProviderName() {
		return providerName;
	}

	void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	Integer getOwnPeriod() {
		return ownPeriod;
	}

	void setOwnPeriod(Integer period) {
		this.ownPeriod = period;
	}

	public String getDescription() {
		return description;
	}

	void setDescription(String description) {
		this.description = description;
	}

	public SpecProvider getProvider() {
		return provider;
	}

	void setProvider(SpecProvider provider) {
		this.provider = provider;
	}

	public String toString() {
		return ToStringHelper.toString(this);
	}

	public int getPeriod() {
		if (ownPeriod != null) {
			return ownPeriod.intValue();
		} else {
			return sampleList.getImplicitPeriod().intValue();
		}

	}

	public void consolidate() throws SpecException {
		setProvider(root.getProviderByName(getProviderName()));
		// get ride of duplicated data
		setProviderName(null);

		if (ownPeriod == null && sampleList.getImplicitPeriod() == null) {
			throw new SpecException("No period for sample " + getName());
		}

	}

}