
#$Id: Makefile.PL,v 1.2 2005/08/14 23:43:19 erk Exp $
#
#-----------------------------------------------------------------------
#
#TSP Library - core components for a generic Transport Sampling Protocol.
#
#Copyright (c) 2005 Pierre Mallard
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : pmallard@silicom.fr
#Component  : Root Directories for project
#
#-----------------------------------------------------------------------
#
#Purpose   :
# Configuration File for ExtUtils::MakeMaker Makefile construction
# usage : perl Makefile.PL; make;make install 
# see man pages for further options of ExtUtils::MakeMaker
#
# author : Pierre Mallard <pmallard@silicom.fr>

use ExtUtils::MakeMaker;
$VERSION = 0.0001;

#default ARG
$TSP_LIB_PATH = "/opt/tsp/lib";
$TSP_INC_PATH = "/opt/tsp/include/";

#because MakeMaker warn about unknow argument and 
#get them with our ARGV, need to remove our proper arg from ARGV
foreach (@ARGV) {
  if (/^TSP_LIB_PATH=([^\s]+)/) {
    $TSP_LIB_PATH = $1;
  }
  elsif (/^TSP_INC_PATH=([^\s]+)/) {
    $TSP_INC_PATH = $1;
  }
  else {
     push (@new_ARGV,$_);
  }
}
@ARGV = @new_ARGV;

print <<EOP;
The path to libtsp_consumer.a and libtsp_services.a  has been set to $TSP_LIB_PATH.
The path to tsp_consumer.h has been set to $TSP_INC_PATH
Pass TSP_LIB_PATH=... and TSP_INC_PATH=... for user defined path
EOP


WriteMakefile(
	      'NAME'      => "TSP",
	      'DIR'       => ["tsp_consumer","simple"],
	      'AUTHOR'    => "Pierre Mallard <pmallard@silicom.fr>"
);
