%module "TSP::tsp_consumer"
%{
#include "tsp_consumer.h"
TSP_sample_t my_sample;
%}

%include "typemaps.i"
%include "constraints.i"

%apply int *INOUT { int *argc };

%apply int *OUTPUT {int* new_sample};

%typemap(perl5,in) TSP_sample_callback_t{
  $1 = NULL;
}

%typemap(perl5,in) void * user_data{
  $1 = NULL;
}

%typemap(perl5,ignore) TSP_sample_t*(TSP_sample_t*sample){
/*   $1 = (TSP_sample_t*) malloc(sizeof(TSP_sample_t)); */
  $1 = &my_sample;
}

%typemap(perl5,freearg) TSP_sample_t*(TSP_sample_t*sample){
/*   free($1); */
}

%typemap(perl5,argout) TSP_sample_t*{
  if (argvi >= items) {
    EXTEND(sp,1);
  }

  SV * sv = sv_newmortal();
  SWIG_MakePtr(sv, $1, SWIGTYPE_p_TSP_sample_t, SWIG_SHADOW|0);

  $result = newRV((SV*)sv);
  sv_2mortal($result);

  argvi ++;
}

%typemap(perl5,in) TSP_server_info_string_t {
  TSP_server_info_string_t * argp;
  if (SWIG_ConvertPtr($input,(void **) &argp, SWIGTYPE_p_TSP_server_info_string_t,0) < 0) {
    SWIG_croak("Type error in argument 6 of T.
	SP_remote_open_server. Expected _p_TSP_server_info_string_t");
  }
  memcpy($1,argp,sizeof(TSP_server_info_string_t));
}

%typemap (perl5,in) char **[] {
	char * argv = "";
	char ** argv_p = &argv;
	$1 = &argv_p;
}

%typemap (perl5,in) char *[] {
	char * argv = "";
	$1 = &argv;
}

%typemap(perl5,out) TSP_consumer_symbol_info_t*{
  AV *myav;
  SV **svs;
  if ($1) {
    int len = (arg1)->len;
    int i;
    svs = (SV **) malloc(len*sizeof(SV *));
    for (i = 0; i < len ; i++) {
      svs[i] = sv_newmortal();
      SWIG_MakePtr((SV*)svs[i], &$1[i], SWIGTYPE_p_TSP_consumer_symbol_info_t, SWIG_SHADOW|0);
    };
    myav = av_make(len,svs);
    free(svs);
    ST(argvi++) = newRV((SV*)myav);
  }
}

%typemap(perl5,out) TSP_consumer_symbol_requested_t*{
  AV *myav;
  SV **svs;
  if ($1) {
    int len = (arg1)->len;
    int i;

    svs = (SV **) malloc(len*sizeof(SV *));
    for (i = 0; i < len ; i++) {
      svs[i] = sv_newmortal();
      SWIG_MakePtr((SV*)svs[i], &$1[i], SWIGTYPE_p_TSP_consumer_symbol_requested_t, SWIG_SHADOW|0);
    };
    myav = av_make(len,svs);
    free(svs);
    ST(argvi++) = newRV((SV*)myav);
  }
}

#%typemap(perl5,freearg) TSP_consumer_symbol_requested_t*{
#  printf("2 FREEING ARG !!!");
##  free($1);
#}

%typemap(perl5,in) TSP_consumer_symbol_requested_t*{
  int len;int i;

  if (!SvROK($input)) {
    croak("$input is not a reference.");
  }
  
  if (SvTYPE(SvRV($input)) != SVt_PVAV) {
    croak("CROAK CROAK !! it is not an AV ??\n");   
  }

  AV * my_vec = (AV*)SvRV($input);

  len = av_len(my_vec)+1;

  $1 = (TSP_consumer_symbol_requested_t *) malloc(len*sizeof(TSP_consumer_symbol_requested_t));

  for (i = 0 ; i < len ; i++)
    {
      TSP_consumer_symbol_requested_t* consumer_symbol_requested;
      SV ** val = av_fetch(my_vec, i, 0);
      if (!val){
	croak("Error retreiving data from vector\n");
      }
      if (!SvROK(*val)) {
	croak("ST(1) is not a reference.");
      }
      if (SWIG_ConvertPtr(*val,(void **) &consumer_symbol_requested,
			  SWIGTYPE_p_TSP_consumer_symbol_requested_t,0) < 0)
	{
	  SWIG_croak("Type error p_TSP_consumer_symbol_requested_t");
	}
      memcpy(&$1[i],consumer_symbol_requested,sizeof(TSP_consumer_symbol_requested_t));
    }
}

%typemap(perl5,freearg) TSP_consumer_symbol_requested_t*(TSP_consumer_symbol_requested_t*){
/*    free($1);  */
}

%include "tsp_consumer.h"

