/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import simtools.data.DataSource;
import simtools.shapes.PlotShape;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MenuResourceBundle;

public class CurvePropertiesPanel
extends JPropertiesPanel
implements ActionListener {
    protected JComboBox cbxcurves;
    protected JComboBox cbxstrokes;
    protected JCheckBox cbpoints;
    protected JTextField tfcurverename;
    protected JButton bcurvecolor;
    protected JButton bcurvedelete;
    protected MenuResourceBundle resources;
    protected Vector curves;
    protected String id;
    static StrokeDisplay[] defaultstrokes = new StrokeDisplay[]{new StrokeDisplay(), new StrokeDisplay(2.0f, 2.0f), new StrokeDisplay(2.0f, 4.0f), new StrokeDisplay(4.0f, 4.0f), new StrokeDisplay(2.0f, 8.0f), new StrokeDisplay(4.0f, 8.0f), new StrokeDisplay(6.0f, 8.0f), new StrokeDisplay(8.0f, 8.0f)};

    public CurvePropertiesPanel(MenuResourceBundle menuResourceBundle, String string) {
        this.resources = menuResourceBundle;
        this.id = string;
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), menuResourceBundle.getStringValue("curvesLabel")));
        this.curves = new Vector();
        this.cbxcurves = new JComboBox(this.curves);
        this.cbxcurves.addActionListener(this);
        this.add(this.cbxcurves);
        this.bcurvecolor = new JButton();
        this.bcurvecolor.addActionListener(this);
        this.add(this.bcurvecolor);
        this.cbxstrokes = new JComboBox<StrokeDisplay>(defaultstrokes);
        this.cbxstrokes.setRenderer(new StrokeDisplay());
        this.cbxstrokes.addActionListener(this);
        this.add(this.cbxstrokes);
        this.cbpoints = menuResourceBundle.getCheckBox("points", this);
        this.add(this.cbpoints);
        this.bcurvedelete = menuResourceBundle.getButton("deleteCurveButton", this);
        this.add(this.bcurvedelete);
    }

    public static String getPrefix(String string) {
        return "PLOT_CURVE_" + string;
    }

    public static String[] getPropertyNames(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(CurvePropertiesPanel.getPrefix(string) + "_LIST");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getPropertyNames() {
        return CurvePropertiesPanel.getPropertyNames(this.id, this.curves.size());
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase(CurvePropertiesPanel.getPrefix(this.id) + "_LIST") && object instanceof Vector) {
            this.curves.clear();
            this.curves.addAll((Vector)object);
            boolean bl = this.curves.size() > 0;
            this.cbxcurves.setEnabled(bl);
            this.bcurvecolor.setEnabled(bl);
            this.cbxstrokes.setEnabled(bl);
            this.cbpoints.setEnabled(bl);
            this.bcurvedelete.setEnabled(bl);
            if (bl) {
                this.cbxcurves.setSelectedIndex(0);
                CurveParameters curveParameters = (CurveParameters)this.curves.get(0);
                this.bcurvecolor.setBackground(curveParameters.color);
                this.selectStroke(curveParameters.dashes);
                this.cbpoints.setSelected(curveParameters.points);
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase(CurvePropertiesPanel.getPrefix(this.id) + "_LIST")) {
            return this.curves;
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbxcurves) {
            Object object;
            if (actionEvent.getActionCommand().equals("comboBoxChanged") && (object = this.cbxcurves.getSelectedItem()) instanceof CurveParameters) {
                CurveParameters curveParameters = (CurveParameters)object;
                this.bcurvecolor.setBackground(curveParameters.color);
                this.selectStroke(curveParameters.dashes);
                this.cbpoints.setSelected(curveParameters.points);
            }
        } else if (actionEvent.getSource() == this.cbxstrokes) {
            Object object;
            if (actionEvent.getActionCommand().equals("comboBoxChanged") && (object = this.cbxstrokes.getSelectedItem()) instanceof StrokeDisplay) {
                StrokeDisplay strokeDisplay = (StrokeDisplay)object;
                object = this.cbxcurves.getSelectedItem();
                if (object instanceof CurveParameters) {
                    CurveParameters curveParameters = (CurveParameters)object;
                    curveParameters.dashes = strokeDisplay.dashes;
                }
            }
        } else if (actionEvent.getSource() == this.bcurvecolor) {
            Object object = this.cbxcurves.getSelectedItem();
            if (object instanceof CurveParameters) {
                CurveParameters curveParameters = (CurveParameters)object;
                Color color = JColorChooser.showDialog(this, this.resources.getStringValue("curveColorChooserTitle"), curveParameters.color);
                if (color != null) {
                    curveParameters.color = color;
                }
                this.bcurvecolor.setBackground(curveParameters.color);
            }
        } else if (actionEvent.getSource() == this.cbpoints) {
            Object object = this.cbxcurves.getSelectedItem();
            if (object instanceof CurveParameters) {
                CurveParameters curveParameters = (CurveParameters)object;
                curveParameters.points = this.cbpoints.isSelected();
            }
        } else if (actionEvent.getSource() == this.bcurvedelete) {
            Object object = this.cbxcurves.getSelectedItem();
            if (object instanceof CurveParameters) {
                CurveParameters curveParameters = (CurveParameters)object;
                int n = this.curves.indexOf(curveParameters);
                this.cbxcurves.removeItemAt(n);
                if (this.curves.size() == 0) {
                    this.bcurvecolor.setEnabled(false);
                    this.cbxstrokes.setEnabled(false);
                    this.cbpoints.setEnabled(false);
                    this.bcurvedelete.setEnabled(false);
                } else {
                    if (n > this.curves.size() - 1) {
                        n = this.curves.size() - 1;
                    }
                    curveParameters = (CurveParameters)this.curves.get(n);
                    this.bcurvecolor.setBackground(curveParameters.color);
                    this.selectStroke(curveParameters.dashes);
                    this.cbpoints.setSelected(curveParameters.points);
                }
            }
            this.repaint();
        }
    }

    void selectStroke(DashParameters dashParameters) {
        for (int i = 0; i < this.cbxstrokes.getItemCount(); ++i) {
            StrokeDisplay strokeDisplay = (StrokeDisplay)this.cbxstrokes.getItemAt(i);
            if (!strokeDisplay.dashes.equals(dashParameters)) continue;
            this.cbxstrokes.setSelectedIndex(i);
            return;
        }
        StrokeDisplay strokeDisplay = new StrokeDisplay(dashParameters);
        this.cbxstrokes.addItem(strokeDisplay);
        this.cbxstrokes.setSelectedItem(strokeDisplay);
    }

    protected static class StrokeDisplay
    extends JComponent
    implements ListCellRenderer {
        private Stroke stroke;
        DashParameters dashes;
        private Dimension preferredSize;

        public StrokeDisplay() {
            this(-1.0f, -1.0f);
        }

        public StrokeDisplay(float f, float f2) {
            this.dashes = new DashParameters(f, f2);
            this.stroke = PlotShape.createStroke(this.dashes.param1, this.dashes.param2);
            this.preferredSize = new Dimension(80, 18);
        }

        public StrokeDisplay(DashParameters dashParameters) {
            this.dashes = new DashParameters(dashParameters);
            this.stroke = PlotShape.createStroke(dashParameters.param1, dashParameters.param2);
            this.preferredSize = new Dimension(80, 18);
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            double d = insets.left;
            double d2 = insets.top;
            double d3 = dimension.getWidth() - (double)insets.left - (double)insets.right;
            double d4 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
            Point2D.Double double_ = new Point2D.Double(d + 6.0, d2 + d4 / 2.0);
            Point2D.Double double_2 = new Point2D.Double(d + d3 - 6.0, d2 + d4 / 2.0);
            Line2D.Double double_3 = new Line2D.Double(double_, double_2);
            if (this.stroke != null) {
                graphics2D.setStroke(this.stroke);
            } else {
                graphics2D.setStroke(new BasicStroke());
            }
            graphics2D.draw(double_3);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.stroke = ((StrokeDisplay)object).stroke;
            this.repaint();
            return this;
        }
    }

    public static class CurveParameters {
        public DataSource xds = null;
        public DataSource yds = null;
        public boolean points = false;
        public DashParameters dashes = new DashParameters(-1.0f, -1.0f);
        public Color color = Color.BLACK;

        public String toString() {
            if (this.yds == null) {
                return "                              ";
            }
            return this.yds.getInformation().label;
        }

        public String info() {
            String string = "";
            string = this.xds == null ? string + "null," : string + this.xds.getInformation().label + ",";
            string = this.yds == null ? string + "null," : string + this.yds.getInformation().label + ",";
            string = string + this.points + ",";
            string = string + this.dashes + ",";
            string = string + this.color;
            return string;
        }

        public boolean equals(Object object) {
            if (object instanceof CurveParameters) {
                CurveParameters curveParameters = (CurveParameters)object;
                if (curveParameters.xds == this.xds && curveParameters.yds == this.yds && curveParameters.points == this.points && curveParameters.dashes.equals(this.dashes) && curveParameters.color.equals(this.color)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class DashParameters {
        public final float param1;
        public final float param2;

        public DashParameters(float f, float f2) {
            this.param1 = f;
            this.param2 = f2;
        }

        public DashParameters(DashParameters dashParameters) {
            this.param1 = dashParameters.param1;
            this.param2 = dashParameters.param2;
        }

        public boolean equals(Object object) {
            if (object instanceof DashParameters) {
                DashParameters dashParameters = (DashParameters)object;
                if (dashParameters.param1 == this.param1 && dashParameters.param2 == this.param2) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "(" + this.param1 + "," + this.param2 + ")";
        }
    }
}

