/*
 * Decompiled with CFR 0.152.
 */
package simtools.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class ListenerManager {
    protected static ReferenceQueue queue = new ReferenceQueue();
    protected ArrayList listeners;

    protected synchronized void removeReference(ReferenceCountedPointer referenceCountedPointer) {
        if (this.listeners != null) {
            this.listeners.remove(referenceCountedPointer);
        }
    }

    public synchronized void add(Object object) {
        if (object == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ReferenceCountedPointer referenceCountedPointer = (ReferenceCountedPointer)iterator.next();
            if (!object.equals(referenceCountedPointer.get())) continue;
            ++referenceCountedPointer.refcount;
            return;
        }
        this.listeners.add(new ReferenceCountedPointer(this, object));
    }

    public synchronized void remove(Object object) {
        if (object == null) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        ReferenceCountedPointer referenceCountedPointer = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ReferenceCountedPointer referenceCountedPointer2 = (ReferenceCountedPointer)iterator.next();
            if (!object.equals(referenceCountedPointer2.get())) continue;
            if (--referenceCountedPointer2.refcount > 0) {
                return;
            }
            referenceCountedPointer = referenceCountedPointer2;
            break;
        }
        if (referenceCountedPointer != null) {
            this.listeners.remove(referenceCountedPointer);
        }
    }

    public synchronized void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    public Object get(int n) {
        ReferenceCountedPointer referenceCountedPointer = (ReferenceCountedPointer)this.listeners.get(n);
        return referenceCountedPointer.get();
    }

    static {
        Thread thread = new Thread("ListenerManagerThread"){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ReferenceCountedPointer referenceCountedPointer = (ReferenceCountedPointer)queue.remove();
                            ListenerManager listenerManager = (ListenerManager)referenceCountedPointer.manager.get();
                            if (listenerManager != null) {
                                listenerManager.removeReference(referenceCountedPointer);
                            }
                            referenceCountedPointer = null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public class ReferenceCountedPointer
    extends WeakReference {
        public int refcount = 1;
        public WeakReference manager;

        public ReferenceCountedPointer(ListenerManager listenerManager2, Object object) {
            super(object);
            this.manager = new WeakReference<ListenerManager>(listenerManager2);
        }
    }
}

