/* $Id: MockSimpleSession.java,v 1.4 2005/10/05 00:11:47 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;


import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleAnswerSample;
import tsp.core.consumer.simple.TspSimpleRequestSample;
import tsp.core.consumer.simple.TspSimpleSample;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;
import tsp.core.consumer.simple.TspSimpleSession;

public class MockSimpleSession implements TspSimpleSession {

		
	private TspSimpleSampleSymbolInfo[] avInfos;
	private Map mapAvInfos = new HashMap();
	private TspSimpleSampleSymbolInfo[] subInfos;
	private boolean requestSampleInitCalled = false;
	private boolean requestSampleCalled = false;
	private boolean requestSampleFinaliseCalled = false;
	private boolean closeCalled = false;
	private LinkedList samples = new LinkedList();
	
	
		
	public MockSimpleSession(TspSimpleSampleSymbolInfo[] avInfos) throws Exception{
		this.avInfos = avInfos;	
		for(int i = 0 ; i < avInfos.length ; i++){
			mapAvInfos.put(avInfos[i].getName(), avInfos[i]);
		}
	}
	
	public void addSample(TspSimpleSample s){
		samples.add(s);
	}
		
	
	public void clearAllSamples(){
		samples.clear();
	}
		
	
	public boolean isRequestSampleInitCalled() {
		return requestSampleInitCalled;
	}
	
	public boolean isRequestSampleCalled() {
		return requestSampleCalled;
	}
	
		
	public boolean isRequestSampleFinalizeCalled() {
		return requestSampleFinaliseCalled;
	}
	
	public TspSimpleAnswerSample requestInfos() throws TspConsumerException {
		return new TspSimpleAnswerSample(avInfos);
	}

	public TspSimpleAnswerSample requestSample(TspSimpleRequestSample req){
		requestSampleCalled = true;
		subInfos = new TspSimpleSampleSymbolInfo[req.getSampleInfos().length];
		for(int i = 0 ; i < req.getSampleInfos().length ; i++){
			TspSimpleSampleSymbolInfo si = req.getSampleInfos()[i];
			int index = -1;
			for(int j = 0 ; j < avInfos.length ; j++){
				if(si.getName().equals(avInfos[j].getName())){
					index = avInfos[j].getIndex();
				}
			}
			if(index == -1) throw new IllegalStateException("Unknown symbol :" + si.getName());
			subInfos[i] = new TspSimpleSampleSymbolInfo(si.getName(), si.getPeriod(), si.getPhase(), index);
		}
		return new TspSimpleAnswerSample(subInfos);
	}

	public void requestSampleInit() throws TspConsumerException {
		requestSampleInitCalled = true;
	}

	public void requestSampleFinalize() throws TspConsumerException {
		requestSampleFinaliseCalled = true;

	}

	public void fetchSample(TspSimpleSample sample) throws NoSuchElementException {		
		sample.copy((TspSimpleSample)samples.removeFirst());
	}

	public void waitForData() {
		if(!isDataAvailable()) throw new IllegalStateException();

	}

	public boolean isDataAvailable() {
		return !samples.isEmpty();
	}

	public void close() throws TspConsumerException {
		closeCalled = true;

	}
	
	public boolean isCloseCalled() {
		return closeCalled;
	}
}
