SET(XSCRIPT_OUTPUT_PATH ${CMAKE_BINARY_DIR}/scripts)
MAKE_DIRECTORY(${XSCRIPT_OUTPUT_PATH})
# define TSP_XSCRIPT MACRO
MACRO(TSP_XSCRIPT)
  FOREACH(SCRIPT_FILE ${ARGV})
    GET_FILENAME_COMPONENT(FN ${SCRIPT_FILE} NAME)
    CONFIGURE_FILE(${SCRIPT_FILE} ${XSCRIPT_OUTPUT_PATH}/${FN} COPYONLY)
    INSTALL(
      PROGRAMS ${XSCRIPT_OUTPUT_PATH}/${FN}
      DESTINATION scripts)
  ENDFOREACH(SCRIPT_FILE)
ENDMACRO(TSP_XSCRIPT)

SET(XINCLUDE_OUTPUT_PATH ${CMAKE_BINARY_DIR}/${CMAKE_SYSTEM_NAME}/${CMAKE_BUILD_TYPE}/include)
MAKE_DIRECTORY(${XINCLUDE_OUTPUT_PATH})
# define TSP_XINCLUDE MACRO
MACRO(TSP_XINCLUDE)
  SET (TSP_XINCLUDE_DIR_FOUND "YES")
  SET (INCLUDE_DIR )
  FOREACH(INCLUDE_FILE ${ARGV})
	IF (INCLUDE_FILE STREQUAL "DIRECTORY")
		SET (TSP_XINCLUDE_DIR_FOUND "NO")
	ENDIF (INCLUDE_FILE STREQUAL "DIRECTORY")	
	
	IF (TSP_XINCLUDE_DIR_FOUND)
		# handle missing extension
		IF (NOT "${INCLUDE_FILE}" MATCHES ".h" AND NOT "${INCLUDE_FILE}" MATCHES ".H")
			SET(INCLUDE_FILE ${INCLUDE_FILE}.h)
		ENDIF ( NOT "${INCLUDE_FILE}" MATCHES ".h" AND NOT "${INCLUDE_FILE}" MATCHES ".H") 
		GET_FILENAME_COMPONENT(FN ${INCLUDE_FILE} NAME)
		CONFIGURE_FILE(${INCLUDE_FILE} ${XINCLUDE_OUTPUT_PATH}${INCLUDE_DIR}/${FN} COPYONLY)
		INSTALL_FILES(/include${INCLUDE_DIR} .h ${XINCLUDE_OUTPUT_PATH}${INCLUDE_DIR}/${FN})
	ELSE (TSP_XINCLUDE_DIR_FOUND)
		IF (NOT INCLUDE_FILE STREQUAL "DIRECTORY")
			SET (INCLUDE_DIR /${INCLUDE_FILE})
			SET (TSP_XINCLUDE_DIR_FOUND "YES")
		ENDIF (NOT INCLUDE_FILE STREQUAL "DIRECTORY")
	ENDIF (TSP_XINCLUDE_DIR_FOUND)
  ENDFOREACH(INCLUDE_FILE)
ENDMACRO(TSP_XINCLUDE)

MACRO(TSP_CONFIGURE_FILE_AUTOTOOLS_COMPAT)
  SET(configure_input "${ARGV1} generated from ${ARGV0} by CMake.")
  CONFIGURE_FILE(${ARGV})
ENDMACRO(TSP_CONFIGURE_FILE_AUTOTOOLS_COMPAT)

MACRO(TSP_PROGRAM_INSTALL)
  INSTALL(
    TARGETS ${ARGV}
    DESTINATION bin)
  IF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
	FOREACH(SCRIPT_FILE ${ARGV})
		INSTALL(FILES ${EXECUTABLE_OUTPUT_PATH}/${CMAKE_BUILD_TYPE}/${SCRIPT_FILE}.pdb 
				DESTINATION bin)
	ENDFOREACH(SCRIPT_FILE)
  ENDIF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
ENDMACRO(TSP_PROGRAM_INSTALL)

MACRO(TSP_LIBRARY_INSTALL)
  INSTALL(
    TARGETS ${ARGV}
    RUNTIME DESTINATION bin
    LIBRARY DESTINATION lib
    ARCHIVE DESTINATION lib
    )
  IF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
	FOREACH(SCRIPT_FILE ${ARGV})
		INSTALL(FILES ${LIBRARY_OUTPUT_PATH}/${CMAKE_BUILD_TYPE}/${SCRIPT_FILE}.pdb 
				DESTINATION bin)
	ENDFOREACH(SCRIPT_FILE)
  ENDIF (WIN32 AND CMAKE_BUILD_TYPE STREQUAL "Debug")
ENDMACRO(TSP_LIBRARY_INSTALL)

MACRO(TSP_XSHAREDLIB)
  FOREACH(SHARED_LIB ${ARGV})
    GET_FILENAME_COMPONENT(FN ${SHARED_LIB} NAME)
    
    SET(XSEARCH_PATH ${LIBRARY_OUTPUT_PATH})
	SET(XCOPY_PATH ${EXECUTABLE_OUTPUT_PATH})
    
	IF (WIN32)
	
		SET(XSEARCH_PATH ${XSEARCH_PATH}/${CMAKE_BUILD_TYPE})
		SET(XCOPY_PATH ${XCOPY_PATH}/${CMAKE_BUILD_TYPE})
		
	ENDIF (WIN32)
	
	FIND_LIBRARY(X_LIBRARY 
		NAMES ${FN}
		PATHS ${XSEARCH_PATH}
		DOC "The X Library")
		
	IF (X_LIBRARY)

		CONFIGURE_FILE(${XSEARCH_PATH}/${SHARED_LIB} ${XCOPY_PATH}/${FN} COPYONLY)
		
	ENDIF (X_LIBRARY)
	
  ENDFOREACH(SHARED_LIB)
ENDMACRO(TSP_XSHAREDLIB)



MARK_AS_ADVANCED(
  XSCRIPT_OUTPUT_PATH
  XINCLUDE_OUTPUT_PATH
  )

MESSAGE(STATUS "TSP CMake Tools loaded.")