
SET(PATH_DIR ${CMAKE_SOURCE_DIR}/external/ACPLT-ONCRPC c:/oncrpc)

MESSAGE(STATUS "Looking for ACPLT_ONCRPC...")

FIND_FILE(ACPLT_ONCRPC_INCLUDE
	NAMES rpc.h xdr.h
	PATHS ${PATH_DIR}
	PATH_SUFFIXES include/rpc rpc
	DOC "The ACPLT_ONCRPC Include Files"
	NO_DEFAULT_PATH)

FIND_LIBRARY(ACPLT_ONCRPC_LIBRARY
	NAMES oncrpc
	PATHS ${PATH_DIR}	
	PATH_SUFFIXES lib librpc
	DOC "The ACPLT_ONCRPC Library")

FIND_PROGRAM(ACPLT_ONCRPC_INSTALL
	NAMES acplt-oncrpc-1.14.3-tsp1.zip
	PATHS ${PATH_DIR}
	PATH_SUFFIXES source
	DOC "The ACPLT_ONCRPC install program")
		
FIND_FILE(ACPLT_ONCRPC_ETC
	NAMES rpc
	PATHS ${PATH_DIR}
	PATH_SUFFIXES etc
	DOC "The ACPLT_ONCRPC config Files"
	NO_DEFAULT_PATH)

MESSAGE(STATUS "Looking for rpcgen...")
FIND_PROGRAM(RPCGEN_PROGRAM 
  NAMES rpcgen 
  PATHS ${PATH_DIR}
  PATH_SUFFIXES bin
  DOC "A rpc generator")

IF (RPCGEN_PROGRAM) 
  MESSAGE(STATUS "Looking for rpcgen... - found rpcgen is ${RPCGEN_PROGRAM}")
  SET(RPCGEN_FOUND "YES")
ELSE (RPCGEN_PROGRAM) 
  SET(RPCGEN_FOUND "NO")
  MESSAGE(STATUS "Looking for rpcgen... - NOT found")
ENDIF (RPCGEN_PROGRAM) 

###########################################
# TO DO : Find the DLL
###########################################

IF (ACPLT_ONCRPC_INCLUDE AND ACPLT_ONCRPC_LIBRARY)

  MESSAGE(STATUS "Looking for ACPLT_ONCRPC... - found ACPLT_ONCRPC lib : ${ACPLT_ONCRPC_LIBRARY}, include is ${ACPLT_ONCRPC_INCLUDE}")
  SET(ACPLT_ONCRPC_FOUND "YES")
  GET_FILENAME_COMPONENT(ACPLT_ONCRPC_BINARY_DIRS ${RPCGEN_PROGRAM} PATH)
  GET_FILENAME_COMPONENT(ACPLT_ONCRPC_LIBRARY_DIRS ${ACPLT_ONCRPC_LIBRARY} PATH)
  GET_FILENAME_COMPONENT(ACPLT_INCLUDE_DIR1 ${ACPLT_ONCRPC_INCLUDE} PATH)
  GET_FILENAME_COMPONENT(ACPLT_INCLUDE_DIR2 ${ACPLT_INCLUDE_DIR1} PATH)
  # Suming up the search directory which may contents the onc-rpc includes
  SET(ACPLT_ONCRPC_INCLUDE_DIRS ${ACPLT_INCLUDE_DIR1} ${ACPLT_INCLUDE_DIR2})  
ELSE (ACPLT_ONCRPC_INCLUDE AND ACPLT_ONCRPC_LIBRARY)

  SET(ACPLT_ONCRPC_FOUND "NO")
  MESSAGE(STATUS "Looking for ACPLT_ONCRPC... - NOT found")

ENDIF (ACPLT_ONCRPC_INCLUDE AND ACPLT_ONCRPC_LIBRARY)


IF (ACPLT_ONCRPC_ETC)
  GET_FILENAME_COMPONENT(ACPLT_ONCRPC_ETC_DIR ${ACPLT_ONCRPC_ETC} PATH)
ELSE (ACPLT_ONCRPC_ETC)
  SET(ACPLT_ETC_DIR "unknown-notfound")
ENDIF (ACPLT_ONCRPC_ETC)
