#$Id: consumer_example.rb,v 1.2 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer Example
#
#-----------------------------------------------------------------------

#-----------------------------------------------------------------------
# This example fetches some samples from the tsp_stub_server
#-----------------------------------------------------------------------

$:.unshift File.join(File.dirname(__FILE__),"../..","lib")
require 'tspconsumer'

# use localhost if no command line first arg
if (ARGV.empty?)
   provider_host="localhost"
else
    provider_host=ARGV[0]
end

# connect to the consumer
consumer = ConsumerFactory.create(provider_host, 8000)
consumer.request_open

# get all available symbols
available_symbols = consumer.request_information

# pick some symbols by name
req_symbols = Array.new
[
 /^t$/,
  /^Symbol[1-8]$/,
  /^FLOAT_/,
  /^CHAR_/, /^UCHAR_/,
  /^INT8_/, /^INT16_/,  /^INT32_/,
  /^UINT8_/, /^UINT16_/,  /^UINT32_/,
  /^TAB_INT8/,/^TAB_CHAR/
].each do |re|
  req_symbols += available_symbols.select {|s| s.name =~ re}
end

puts "Building symbol list to be requested :"
req_symbols.each do |s|
    # change phase for symbol8
    s.period=3 if s.name =~ /^Symbol8$/
    # do not request all elements in the array fot TAB_CHAR
    s.nelem=s.dimension/3 if s.name =~ /^TAB_CHAR/    
    puts s
end

# request the data
req_ans_symbols = consumer.request_sample(req_symbols)

#compute a reverted acces to the symbols, by global_index
symbols_by_id = Hash.new
req_ans_symbols.each {|s| symbols_by_id[s.global_index] = s}

# fetch the data
consumer.request_sample_init

# get 300 samples
300.times {
  sample = consumer.deq_sample
  puts symbols_by_id[sample.global_index].name + " --> " + sample.to_str
}

# end of work
consumer.request_sample_destroy
#consumer.request_close

