#$Id: consumer_ror.rb,v 1.7 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2007 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------

$:.unshift File.join(File.dirname(__FILE__), "../../..", "lib")
require 'tspconsumer'
require 'drb'
require 'yaml'

class TspDrbBridge

    NB_SAMPLES=100*4

    attr_reader :consumer_name

    def initialize(symbols_by_id, consumer, consumer_name)
        @symbols_by_id=symbols_by_id
        @consumer=consumer
        @consumer_name=consumer_name
        @mutex = Mutex.new
        @thread = nil

        # User specific        
        @samples=Hash.new {|hash, name| hash[name] = Array.new()}
        @choosen_symbols=Hash.new {|hash, name| hash[name] = Array.new()}
        @absys_symbol=Hash.new
    end


    # Y symbols

    def choose_symbol(username, symbolname)
        @mutex.synchronize do
            puts "User #{username} chose symbol #{symbolname}"
            symbols = @choosen_symbols[username]
            symbols.push(symbolname) if !symbols.include?(symbolname)
        end

    end

    def unchoose_symbol(username, symbolname)
        @mutex.synchronize do
            symbols = @choosen_symbols[username]
            symbols.delete(symbolname)
        end

    end

    def unchoose_symbols(username)
        @mutex.synchronize do
            puts "User #{username} unchose all symbols"
            symbols = @choosen_symbols[username]
            symbols.clear
        end
    end

    def choosen_symbols(username)
        @mutex.synchronize do
            @choosen_symbols[username]
        end
    end

    # X symbols

    def choose_absys(username, absys)
        @mutex.synchronize do
            @absys_symbol[username]=absys
        end
    end

    def unchoose_absys(username)
        @mutex.synchronize do
            @absys_symbol[username]=nil
        end
    end

    def choosen_absys(username)
        @mutex.synchronize do
            @absys_symbol[username]
        end
    end

    # Symbols

    def symbols_name
        @symbols_by_id.values.collect{|s| s.name}.sort
    end

    def get_array(name)
        @mutex.synchronize do
            @samples[name]
        end
    end

    def yield_sample
        sample = @consumer.deq_sample
        name = @symbols_by_id[sample.global_index].name
        @mutex.synchronize do
            array=@samples[name]
            array.shift if (array.size==NB_SAMPLES)
            array << sample.value
        end
    end



end


if (ARGV.empty?)
    puts "USAGE : ruby consumer_ror.rb CONFIG_FILE.yaml"
    exit 1
else
    config_file = ARGV[0]  
end    

config = YAML.load_file(config_file)
provider_host = config["hostname"]
re_symbols = config["re_symbols"].map{|re_string| Regexp.new(re_string)}
puts "hostname=#{provider_host} re_symbols=#{re_symbols}"

# connect to the consumer
consumer = ConsumerFactory.create(provider_host, 8000)
consumer.request_open

# get all available symbols
available_symbols = consumer.request_information

# pick some symbols by name
request_symbols = Array.new
re_symbols.each do |re|
    request_symbols += available_symbols.select {|s| s.name =~ re}
end

puts "Building symbol list to be requested :"
request_symbols.each do |s|
    s.period=16*2
    puts s
end

# request the data
req_ans_symbols = consumer.request_sample(request_symbols)

#compute a reverted acces to the symbols, by global_index
symbols_by_id = Hash.new
req_ans_symbols.each {|s| symbols_by_id[s.global_index] = s}
symbols_name= req_ans_symbols.collect{|s| s.name}

# fetch the data
consumer.request_sample_init


#drb
bridge = TspDrbBridge.new(symbols_by_id, consumer, provider_host)
#bridge.start
DRb.start_service("druby://localhost:9001", bridge)
puts "waiting for drb connection"
while (true)
    bridge.yield_sample
end
#DRb.thread.join



