#Copyright (c) 2005 Geoffrey Grosenbach boss@topfunky.com
#
#Permission is hereby granted, free of charge, to any person obtaining
#a copy of this software and associated documentation files (the
#"Software"), to deal in the Software without restriction, including
#without limitation the rights to use, copy, modify, merge, publish,
#distribute, sublicense, and/or sell copies of the Software, and to
#permit persons to whom the Software is furnished to do so, subject to
#the following conditions:
#
#The above copyright notice and this permission notice shall be
#included in all copies or substantial portions of the Software.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
#LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
#OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
#WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#--------------------------------------------------------------------
#This Plot class is a quick and dirty modification of the Gruff::Line class
#in order to be able to plot y=f(x)
#
#This is some temporary code, really.


class Plot < Gruff::Base

    attr_accessor :x_data, :x_name

    # Draw a dashed line at the given value
    attr_accessor :baseline_value

    # Color of the baseline
    attr_accessor :baseline_color

    # Hide parts of the graph to fit more datapoints, or for a different appearance.
    attr_accessor :hide_dots, :hide_lines

    def initialize(*args)
        raise ArgumentError, "Wrong number of arguments" if args.length > 2
        if args.empty? or ((not Numeric === args.first) && (not String === args.first)) then
            super()
        else
            super args.shift
        end

        @hide_dots = @hide_lines = false
        @baseline_color = 'red'
        @baseline_value = nil
        @x_data = nil
        @x_name = nil
    end

    def draw
        super

        return unless @has_data

        # Check to see if more than one datapoint was given. NaN can result otherwise.
        @x_increment = (@column_count > 1) ? (@graph_width / (@column_count - 1).to_f) : @graph_width
        x_min = @x_data.min.to_f
        x_max = @x_data.max.to_f
        self.labels = {@x_data.index(x_min)=>"#{x_min}",
        @x_data.index(x_max)=>"#{x_max}",
        index_for_midle(@x_data)=>@x_name
        }
        @labels_pos =  {@x_data.index(x_min)=>@graph_left +  @graph_width * 0.05,
        @x_data.index(x_max)=>@graph_left +  @graph_width * 0.95,
        index_for_midle(@x_data)=>@graph_left +  @graph_width / 2
        }

        if (defined?(@norm_baseline)) then
            level = @graph_top + (@graph_height - @norm_baseline * @graph_height)
            @d = @d.push
            @d.stroke_color @baseline_color
            @d.fill_opacity 0.0
            @d.stroke_dasharray(10, 20)
            @d.stroke_width 5
            @d.line(@graph_left, level, @graph_left + @graph_width, level)
            @d = @d.pop
        end



        @norm_data.each do |data_row|
            prev_x = prev_y = nil

            data_row[1].each_with_index do |data_point, index|
                if (@x_name)
                    if (x_max != x_min)
                        new_x = @graph_left + ((@x_data[index] - x_min) / (x_max - x_min)) * @graph_width
                    else
                        new_x = @graph_left +  @graph_width / 2
                    end
                else
                    new_x = @graph_left + (@x_increment * index)
                end
                next if data_point.nil?

                draw_label(@labels_pos[index], index) if @x_data

                new_y = @graph_top + (@graph_height - data_point * @graph_height)

                # Reset each time to avoid thin-line errors
                @d = @d.stroke data_row[DATA_COLOR_INDEX]
                @d = @d.fill data_row[DATA_COLOR_INDEX]
                @d = @d.stroke_opacity 1.0
                @d = @d.stroke_width clip_value_if_greater_than(@columns / (@norm_data.first[1].size * 4), 5.0)

                if !@hide_lines and !prev_x.nil? and !prev_y.nil? then
                    @d = @d.line(prev_x, prev_y, new_x, new_y)
                end
                circle_radius = clip_value_if_greater_than(@columns / (@norm_data.first[1].size * 2.5), 5.0)
                @d = @d.circle(new_x, new_y, new_x - circle_radius, new_y) unless @hide_dots

                prev_x = new_x
                prev_y = new_y
            end

        end

        @d.draw(@base_image)
    end

    def normalize
        @maximum_value = [@maximum_value.to_f, @baseline_value.to_f].max
        super
        @norm_baseline = (@baseline_value.to_f / @maximum_value.to_f) if @baseline_value
    end

    def index_for_midle(array)
        buf = Array.new(array)
        while (buf.size > 1)
            buf.delete(buf.max) if buf.size > 1
            buf.delete(buf.min) if buf.size > 1
        end
        return array.index(buf.first)
    end

end
