#$Id: consumer_domain.rb,v 1.5 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



require 'consumer_core_domain'
require 'value_object_identity'  
  
class SymbolInfo
  
  include ValueObjectIdentity

  def initialize(name, period=1, phase=0, global_index=-1, dimension=1, nelem=0, offset=0)
    @name = name
    @period = period
    @phase = phase
    @global_index  = global_index
    @dimension = dimension
    @nelem = nelem
    @offset = offset
    @type = 0
  end
  
  attr_reader    :name,                 
                 :global_index
                 
  attr_accessor  :period,
                 :phase,
                 :dimension,
                 :nelem,
                 :offset,
                 :type 
     
  def to_core_symbol
    core = CoreSymbolInfo.new(@name,@period,@phase,@global_index,0,0,@type) 
    core.nelem = @nelem
    core.offset = @offset
    core.dimension = @dimension  
    return core
  end                 
          
  def SymbolInfo.from_core_symbol(core_symbol)
    symbol = SymbolInfo.new(core_symbol.name, core_symbol.period, core_symbol.phase, core_symbol.global_index, core_symbol.dimension, core_symbol.nelem, core_symbol.offset)
    symbol.type = core_symbol.type
    return symbol
  end

  def to_s
    "SymbolInfo: index=#{@global_index} name=#{@name} period=#{@period} phase=#{@phase}  dimension=#{@dimension} nelem=#{@nelem} offset=#{@offset} type=#{@type}"
  end
    
end

class Sample

  include ValueObjectIdentity

  def initialize(value, global_index, array_index)
    @value = value
    @global_index = global_index
    @array_index = array_index
  end
  
  attr_reader    :value,
                 :global_index,
                 :array_index

  def to_str
    "Sample: global_index = #{@global_index}  array_index=#{@array_index} value = #{@value}"
  end
 
end

