#$Id: test_active_data_fetcher.rb,v 1.3 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------



$:.unshift File.join(File.dirname(__FILE__),"..","lib")
require 'test/unit'

require 'active_data_fetcher'


class TestActiveDataFetcher < Test::Unit::TestCase
  
  class MockDataFetcher
    def initialize
      @nb_called = 0
      @end_of_work_called = false
    end
    def fetch_next_group
      @nb_called += 1
      sleep(0.100)
    end
    def end_of_work
      @end_of_work_called = true
    end
    
    attr_reader :nb_called, :end_of_work_called 
  end
  
  def setup      
    @mock_df = MockDataFetcher.new
    @active_df = ActiveDataFetcher.new(@mock_df)   
  end
  
  def test_that_after_start_fetch_next_group_is_call_multiple_times  
    @active_df.start
    begin
    end until @mock_df.nb_called > 2    
  end
  
  
  def test_that_stop_stops_the_thread
    @active_df.start
    begin
    end until @mock_df.nb_called > 2 
    @active_df.stop
    assert(@mock_df.end_of_work_called)   
  end
        
end
