#$Id: test_group.rb,v 1.3 2007/04/24 21:32:12 sgalles Exp $
#-----------------------------------------------------------------------
#
#TSP Ruby consumer - component for a generic Transport Sampling Protocol.
#
#Copyright (c) 2006 Stephane GALLES
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU Lesser General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#Lesser General Public License for more details.
#
#You should have received a copy of the GNU Lesser General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#-----------------------------------------------------------------------
#
#Project    : TSP
#Maintainer : stephane.galles@free.fr
#Component  : RubyTsp Consumer
#
#-----------------------------------------------------------------------


$:.unshift File.join(File.dirname(__FILE__),"..","lib")
require 'test/unit'

require 'group'

require 'stringio'



class TestGroupItem < Test::Unit::TestCase
     
  def test_that_group_item_decode_data_with_its_decoder_handler

    mock_io = "IO!"    
    gi = GroupItem.new("s1",111,1)
    gi.on_decode { |io,buf| io + "DECODED!"}
    sample = nil
    gi.decode(mock_io) { |s| sample = s }
    assert_equal(Sample.new("IO!DECODED!",111,0),sample)
    
  end
  
  def test_that_group_item_with_n_elements_repeats_decode_n_times    
    mock_io = "IO!"    
    gi = GroupItem.new("s1",111,10)
    gi.on_decode { |io,buf| "DECODED!"}
    
    nb_repeats = 0
    gi.decode(mock_io) { |s|  nb_repeats += 1}
    assert_equal(10,nb_repeats)
  end
  
  def test_that_group_item_with_n_elements_set_the_array_index_in_sample
    mock_io = "IO!"    
    gi = GroupItem.new("s1",111,10)
    gi.on_decode { |io,buf| "DECODED!"}
    
    index = 0
    gi.decode(mock_io) do |s|
      assert_equal(index,s.array_index)  
      index += 1
    end  
    
  end
  
end

