/*
  Copyright (C) 2006   Hans-Georg Breunig

  This file is part of TsumeGo.

  TsumeGo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  TsumeGo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with TsumeGo; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#include "board.h"

void show_help();
void show_version();
void show_error(int);

static int verbose_flag;
char* progname;

int main(int argc, char **argv) {

	int c;
	progname = argv[0];
	while(1) {
		static struct option long_options[] = {
			{"verbose", no_argument, &verbose_flag, 1},
			//{"file", required_argument, 0, 'f'},
			{"help", no_argument, 0, 'h'},
			{"version", no_argument, 0, 'V'},
			{0, 0, 0, 0}
		};

		int option_index = 0;

		c = getopt_long(argc, argv, "f:hV", long_options, &option_index);

		if(c == -1)
			break;

		switch(c) {
			//case 'f':
			//	printf("option -f with value `%s'\n", optarg);
			//	break;
			case 'h':
				show_help();
				/* not reached */
				break;
			case 'v':
				show_version();
				/* not reached */
				break;
		}
	}

	//if(verbose_flag)
	//	puts("verbose flag is set\n");

	if(optind == argc) show_error(1);
	if(optind < argc-1) show_error(2);

	init_board();

	load(argv[optind]);

	minmax();
	
	return 0;
}


void show_help() {
	printf("Usage: %s FILE\n\n", progname);
	printf("  -h, --help       display this help\n");
	printf("      --version    display the version\n");
	printf("\n  ** For sample files see `%s/'. **\n\n", DATADIR);
	exit(0);
}


void show_version() {
	printf("TsumeGo %s\n", VERSION);
	printf("Copyright (C) 2006  Hans-Georg Breunig\nSee http://tsumego.nongnu.org/ for information about TsumeGo.\n\nThis is free software; see the source for copying conditions.  There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
	exit(0);
}


void show_error(int errnum) {
	if(errnum == 1)
		printf("%s: missing file argument\n", progname, progname);
	else
		printf("%s: too many arguments\n", progname, progname);

	printf("%s: Try `%s --help' for more information.\n", progname, progname);
	exit(-1);
}


// vim:tabstop=4:shiftwidth=4
