/*
  Copyright (C) 2006   Hans-Georg Breunig

  This file is part of TsumeGo.

  TsumeGo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  TsumeGo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with TsumeGo; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <stdio.h>
#include <stdlib.h>  /* for exit() */
#include <string.h>  /* for memcmp() */

#include "board.h"

#define MAXPATHLEN 10


int boards[MAXPATHLEN][BOARDSIZE*BOARDSIZE];
int resultpath[MAXPATHLEN];
int depth;


int max() {
	int i, r;
	int val = -100;

	update_freelist();
	for(i = 0; i < freelist_size; i++) {
		printf("black trymove: %d, %d\n", freelist[i].x, freelist[i].y);
		col = BLACK;
		if(trymove(freelist[i].x, freelist[i].y)) {
			printboard(board);
			if(captured != 0) return val = 100;
			if(depth == MAXPATHLEN - 3) {
				printf("Error: Maximal search depth exceeded.\n");
				exit(-1);
			}
			memcpy(boards[depth+1], board, BOARDSIZE*BOARDSIZE*sizeof(int));
			depth++;
			r = min();
			depth--;
			if(r > val) val = r;
		}
		memcpy(board, boards[depth], BOARDSIZE*BOARDSIZE*sizeof(int));
		update_freelist();
	}
	return val;
}


int min() {
	int i, r;
	int val = 100;

	update_freelist();
	for(i = 0; i < freelist_size; i++) {
		printf("white trymove: %d, %d\n", freelist[i].x, freelist[i].y);
		col = WHITE;
		if(trymove(freelist[i].x, freelist[i].y)) {
			printboard(board);
			if(captured != 0) return val = -100;
			memcpy(boards[depth+1], board, BOARDSIZE*BOARDSIZE*sizeof(int));
			depth++;
			r = max();
			depth--;
			if(r < val) val = r;
		}
		memcpy(board, boards[depth], BOARDSIZE*BOARDSIZE*sizeof(int));
		update_freelist();
	}
	return val;
}


void minmax() {
	int result;
	memcpy(boards[0], board, BOARDSIZE*BOARDSIZE*sizeof(int));

	printboard(board);

	depth = 0;
	result = max();
	printf("  ... %d\n", result);
	if(result == 100) printf(" (solved!)\n");
}



int trypath(int *path) {
	int i;
	int x, y;

	restore_board();

	for(i = 0; path[i] != -1; i++) {
		printf("path: %d\n", path[i]);
		x = path[i] % BOARDSIZE;
		y = path[i] / BOARDSIZE;
		printf("trymove: %d, %d\n", x, y);
		if(!trymove(x, y)) {
			return;
		}
	}
}


void search() {
	int i, j;
	int path[] = { 14, 8, 13, -1 };

	save_board();

/*
	printf("%d %d %d %d\n", path[0], path[1], path[2], path[3]);
r:
	for(i = 0; i < 4; i++) {
		if(path[i] < 16) {
			path[i]++;
			for(j = 0; j < i; j++)
				path[j] = 0;
			printf("%d %d %d %d\n", path[0], path[1], path[2], path[3]);
			goto r;
		}
	}
*/

	memcpy(boards[0], board, BOARDSIZE*BOARDSIZE*sizeof(int));
	memcpy(boards[1], boards[0], BOARDSIZE*BOARDSIZE*sizeof(int));

	printboard(board);
	//printf("%d\n", numstones(WHITE));
	//trypath(path);
	printboard(boards[0]);
	//printf("%d\n", numstones(WHITE));
}


// vim:tabstop=4:shiftwidth=4
