(define (tunnel-frame prefix)
  (let* ((imdr #f)
         (lcol '(255 215 0))
         (fcol '(72 61 139))
         (w 16)
         (xb 0)
         (xl 2)
         (x0 0)
         (x1 xb)
         (x2 (+ xb xl))
         (x3 (- w x2))
         (x4 (- w x1))
         (x5 w)
         (h 16)
         (yb 0)
         (yl 2)
         (y0 0)
         (y1 yb)
         (y2 (+ yb yl))
         (y3 (- h y2))
         (y4 (- h y1))
         (y5 h)
         (line (lambda (xb yb xe ye)
                 (if (and (> xe xb) (> ye yb))
                     (begin
                       (gimp-rect-select (car imdr) xb yb (- xe xb) (- ye yb)
                                         REPLACE FALSE 0)
                       (gimp-palette-set-foreground lcol)
                       (gimp-bucket-fill (cadr imdr) FG-BUCKET-FILL NORMAL-MODE
                                         100 0 0 0 0)))))
         (fill (lambda (xb yb xe ye)
                 (if (and (> xe xb) (> ye yb))
                     (begin
                       (gimp-rect-select (car imdr) xb yb (- xe xb) (- ye yb)
                                         REPLACE FALSE 0)
                       (gimp-palette-set-foreground fcol)
                       (gimp-bucket-fill (cadr imdr) FG-BUCKET-FILL NORMAL-MODE
                                         100 0 0 0 0))))))
    ; frame_b
    (set! imdr (tunnel-new w h))
    (line x0 y1 x2 y2)
    (line x0 y3 x5 y4)
    (line x1 y0 x2 y1)
    (line x3 y0 x4 y2)
    (line x4 y1 x5 y2)
    (fill x0 y2 x5 y3)
    (fill x2 y0 x3 y2)
    (tunnel-save imdr (string-append prefix "frame_b"))
    ; frame_bl
    (set! imdr (tunnel-new w h))
    (line x1 y0 x2 y4)
    (line x2 y3 x5 y4)
    (line x3 y0 x4 y2)
    (line x4 y1 x5 y2)
    (fill x2 y0 x3 y3)
    (fill x3 y2 x5 y3)
    (tunnel-save imdr (string-append prefix "frame_bl"))
    ; frame_br
    (set! imdr (tunnel-new w h))
    (line x0 y1 x2 y2)
    (line x0 y3 x4 y4)
    (line x1 y0 x2 y1)
    (line x3 y0 x4 y3)
    (fill x0 y2 x3 y3)
    (fill x2 y0 x3 y2)
    (tunnel-save imdr (string-append prefix "frame_br"))
    ; frame_c
    (set! imdr (tunnel-new w h))
    (line x0 y1 x2 y2)
    (line x0 y3 x2 y4)
    (line x1 y0 x2 y1)
    (line x1 y4 x2 y5)
    (line x3 y0 x4 y2)
    (line x3 y3 x4 y5)
    (line x4 y1 x5 y2)
    (line x4 y3 x5 y4)
    (fill x0 y2 x5 y3)
    (fill x2 y0 x3 y5)
    (tunnel-save imdr (string-append prefix "frame_c"))
    ; frame_h
    (set! imdr (tunnel-new w h))
    (line x0 y1 x5 y2)
    (line x0 y3 x5 y4)
    (fill x0 y2 x5 y3)
    (tunnel-save imdr (string-append prefix "frame_h"))
    ; frame_l
    (set! imdr (tunnel-new w h))
    (line x1 y0 x2 y5)
    (line x3 y0 x4 y2)
    (line x3 y3 x4 y5)
    (line x4 y1 x5 y2)
    (line x4 y3 x5 y4)
    (fill x2 y0 x3 y5)
    (fill x3 y2 x5 y3)
    (tunnel-save imdr (string-append prefix "frame_l"))
    ; frame_r
    (set! imdr (tunnel-new w h))
    (line x0 y1 y2 y2)
    (line x0 y3 x2 y4)
    (line x1 y0 x2 y1)
    (line x1 y4 x2 y5)
    (line x3 y0 x4 y5)
    (fill x0 y2 x2 y3)
    (fill x2 y0 x3 y5)
    (tunnel-save imdr (string-append prefix "frame_r"))
    ; frame_t
    (set! imdr (tunnel-new w h))
    (line x0 y1 x5 y2)
    (line x0 y3 x2 y4)
    (line x1 y4 x2 y5)
    (line x3 y3 x4 y5)
    (line x4 y3 x5 y4)
    (fill x0 y2 x5 y3)
    (fill x2 y3 x3 y5)
    (tunnel-save imdr (string-append prefix "frame_t"))
    ; frame_tl
    (set! imdr (tunnel-new w h))
    (line x1 y1 x2 y5)
    (line x2 y1 x5 y2)
    (line x3 y3 x4 y5)
    (line x4 y3 x5 y4)
    (fill x2 y2 x3 y5)
    (fill x3 y2 x5 y3)
    (tunnel-save imdr (string-append prefix "frame_tl"))
    ; frame_tr
    (set! imdr (tunnel-new w h))
    (line x0 y1 x4 y2)
    (line x0 y3 x2 y4)
    (line x3 y2 x4 y5)
    (line x1 y4 x2 y5)
    (fill x0 y2 x3 y3)
    (fill x2 y3 x3 y5)
    (tunnel-save imdr (string-append prefix "frame_tr"))
    ; frame_v
    (set! imdr (tunnel-new w h))
    (line x1 y0 x2 y5)
    (line x3 y0 x4 y5)
    (fill x2 y0 x3 y5)
    (tunnel-save imdr (string-append prefix "frame_v"))))
