(define (tunnel-blank prefix)
  (let* ((imdr (tunnel-new 4 1))
         (arr (cons-array 4 'byte)))
    (aset arr 0 0)
    (aset arr 1 0)
    (aset arr 2 0)
    (aset arr 3 0)
    (gimp-drawable-set-pixel (cadr imdr) 0 0 4 arr)
    (tunnel-save imdr (string-append prefix "blank"))))

(define (tunnel-dial prefix)
  (let* ((imdr (tunnel-new 4 1))
         (arr (cons-array 4 'byte))
         (setpix (lambda (x y r g b a)
                   (aset arr 0 r)
                   (aset arr 1 g)
                   (aset arr 2 b)
                   (aset arr 3 a)
                   (gimp-drawable-set-pixel (cadr imdr) x y 4 arr))))
    (setpix 0 0 178  34  34 255)
    (setpix 1 0   0 205 102 255)
    (setpix 2 0   0 139  69 255)
    (setpix 3 0 178  34  34 255)
    (tunnel-save imdr (string-append prefix "dial"))))

(define (tunnel-tunnel-gradient prefix)
  (let* ((imdr (tunnel-new 1536 1))
         (blend (lambda (start-col end-col start-x end-x)
                  (gimp-palette-set-foreground start-col)
                  (gimp-palette-set-background end-col)
                  (gimp-rect-select (car imdr) start-x 0
                                    (- (+ 1 end-x) start-x) 1 REPLACE FALSE 0)
                  (gimp-blend (cadr imdr) FG-BG-RGB NORMAL-MODE LINEAR 100 0
                              REPEAT-NONE FALSE 0 0 start-x 0 end-x 0)))
;          (color0 '( 40  64 136))
;          (color1 '(136  32  96))
;          (color2 '(120  56 136))
;          (color3 '(136 112  88))
;          (color4 '( 56 104 136))
;          (color5 '( 88 104  48)))
         (color0 '( 39  64 139))
         (color1 '(139  29  98))
         (color2 '(122  59 139))
         (color3 '(139 115  85))
         (color4 '( 54 100 139))
         (color5 '( 85 107  47)))
    (blend color0 color1    0  255)
    (blend color1 color2  256  511)
    (blend color2 color3  512  767)
    (blend color3 color4  768 1023)
    (blend color4 color5 1024 1279)
    (blend color5 color0 1280 1535)
    (tunnel-save imdr (string-append prefix "tunnel_gradient"))))

(define (tunnel-lines prefix)
  (tunnel-blank prefix)
  (tunnel-dial prefix)
  (tunnel-tunnel-gradient prefix))
