(define (tunnel-labels prefix)
  (let* ((border 1)
         (size 20)
         (text-color '(238 173 0))
         (make-text
          (lambda (text basename)
            (let* ((imdr (tunnel-new 256 256))
                   (text-layer (car (gimp-text-fontname (car imdr) -1 0 0 text
							border TRUE size PIXELS
							"-urw-bookman-demibold-r-normal-*-*-180-*-*-*-*-*-*")))
                   (width (car (gimp-drawable-width text-layer)))
                   (height (car (gimp-drawable-height text-layer))))
              (gimp-image-resize (car imdr) width 18 0 0) ; 18 instead of height
              (gimp-palette-set-foreground text-color)
              (gimp-layer-set-preserve-trans text-layer TRUE)
              (gimp-edit-fill text-layer FG-IMAGE-FILL)
	      (perl-fu-center-layer FALSE (car imdr) text-layer)
	      (tunnel-save
	       (list (car imdr)
		     (car (gimp-image-merge-visible-layers (car imdr) CLIP-TO-IMAGE)))
	       (string-append prefix basename))))))
    (make-text "SCORE" "score")
    (make-text "DEPTH" "depth")
    (make-text "TIME" "time")
    (make-text "VELOCITY" "velocity")
    (make-text "STRENGTH" "strength")
    (make-text "SHIELD" "shield")
    (make-text "AMMO" "ammo")))

(define (tunnel-numbers prefix)
  (let* ((border 1)
         (size 20)
         (text-color '(64 224 108))
         (imdr (list (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)
                     (tunnel-new 256 256)))
         (text-layer #f)
         (width 13)
         (height 18)
	 (old-fg (car (gimp-palette-get-foreground))))
    (let ((n -1))
      (set! text-layer (tunnel-map (lambda (imdr)
                                     (set! n (+ n 1))
                                     (car
                                      (gimp-text-fontname (car imdr) -1 0 0
							  (number->string n)
							  border TRUE size
							  PIXELS
							  "-urw-bookman-demibold-r-normal-*-*-180-*-*-*-*-*-*")))
                                   imdr)))
    (tunnel-map (lambda (text-layer)
                  (if (> (car (gimp-drawable-width text-layer)) width)
                      (set! width (car (gimp-drawable-width text-layer))))
                  (if (> (car (gimp-drawable-height text-layer)) height)
                      (set! height (car (gimp-drawable-height text-layer)))))
                text-layer)
    (tunnel-map (lambda (imdr)
                  (gimp-image-resize (car imdr) width height 0 0))
                imdr)
    
    (gimp-palette-set-foreground text-color)
    (tunnel-map
     (lambda (text-layer)
       (gimp-layer-set-preserve-trans text-layer TRUE)
       (gimp-edit-fill text-layer FG-IMAGE-FILL))
     text-layer)
    (gimp-palette-set-foreground old-fg)
    (let ((n 0))
      (tunnel-for-each
       (lambda (imdr text-layer)
         (perl-fu-center-layer FALSE (car imdr) text-layer)
         (tunnel-save
          (list (car imdr)
                (car (gimp-image-merge-visible-layers (car imdr) CLIP-TO-IMAGE)))
          (string-append prefix "number" (number->string n)))

         (set! n (+ n 1)))
       imdr text-layer))))

(define (tunnel-text prefix)
  (tunnel-labels prefix)
  (tunnel-numbers prefix))
