// audio.h - interface for audio
//
// Copyright (C) 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef AUDIO_H
#define AUDIO_H

#include <string>

#include "record.h"

namespace audio {

	// a sound loaded from a file
	class raw_sound {
	public:
		virtual ~raw_sound() { }
	};

	// a sound which is playable to a target
	// (the sound knows its target)
	//
	// play() puts the sound on the target sound queue
	class sound {
	public:
		virtual  ~sound() { }

		virtual void play(double volume) const = 0;
	};

	// a number of sounds indexed through their name
	typedef rec::map<sound*> sound_map;

	// an audio target, handles sounds and mixes them
	//
	// make_sound() : from a raw sound, this creates a sound that
	//     is playable on this target
	// time_passed() : mix sounds that have been play()ed for the
	//     specified amount of milliseconds
	class taudio {
	public:
		virtual ~taudio() { }

		virtual raw_sound* make_raw_sound(const std::string& filename) = 0;
		virtual sound* make_sound(const raw_sound* src) = 0;
		virtual void time_passed(int msec) = 0;
	};

} // namespace audio

#endif // !AUDIO_H

// Local Variables:
// mode: c++
// End:
