// misc.cc - contains code required by some miscellaneous classes
//
// Copyright (C) 2000, 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <cctype>
#include <climits>
#include <cstdlib>
#include <sstream>

#include "misc.h"

// conversions

std::string misc::s2lc(const std::string& s)
{
	std::string r = s;
	for (std::string::iterator i = r.begin(); i != r.end(); ++i)
		*i = std::tolower(*i);
	return r;
}

bool misc::s2b(const std::string& s)
{
	std::string lc = s2lc(s);
	if (lc == "yes"
	    || lc == "y"
	    || lc == "true"
	    || lc == "t"
	    || lc == "on")
		return true;
	if (std::strtol(s.c_str(), 0, 0) == 1)
		return true;
	return false;
}

int misc::s2i(const std::string& s)
{
	long int l = std::strtol(s.c_str(), 0, 0);

	if (l > long(INT_MAX))
		return INT_MAX;
	if (l < long(INT_MIN))
		return INT_MIN;
	return int(l);
}

double misc::s2d(const std::string& s)
{
	double d = std::strtod(s.c_str(), 0);
	return d;
}

std::string misc::b2s(bool b)
{
	return b ? "true" : "false";
}

std::string misc::i2s(int i)
{
	std::string s;
	std::ostringstream os(s);
	os << i << std::ends;
	return s;
}

std::string misc::d2s(double d)
{
	std::string s;
	std::ostringstream os(s);
	os << d << std::ends;
	return s;
}

std::string misc::string_tokener::next()
{
	std::string::const_iterator beg = i;
	for (; ; ) {
		if (i == st.end())
			return std::string(beg, i);
		if (*i == d)
			return std::string(beg, i++);
		++i;
	}
}

// give a random number.
// Function borrowed from rand_r() in glibc-2.1.2 (C) FSF, LGPL,
// written by Ulrich Drepper
int misc::random::operator()()
{
	int result;

	seed *= 1103515245;
	seed += 12345;
	result = (unsigned int) (seed / 65536) % 2048;

	seed *= 1103515245;
	seed += 12345;
	result <<= 10;
	result ^= (unsigned int) (seed / 65536) % 1024;

	seed *= 1103515245;
	seed += 12345;
	result <<= 10;
	result ^= (unsigned int) (seed / 65536) % 1024;

	return result;
}

int misc::random::max() const
{
	return 0x7fffffff;
}

// Local Variables:
// mode: c++
// End:
