// new_ball.h - how to create new balls
//
// Copyright (C) 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef NEW_BALL_H
#define NEW_BALL_H

#include <string>
#include <utility>
#include <vector>

#include "ball.h"
#include "misc.h"
#include "record.h"
#include "ship.h"

namespace balls {

	class level_creator : public creator {
	public:
		level_creator(Game::game* gg, const rec::record& levels);
		void move(double t);
		void skip_level();
	private:
		Game::game* g;
		const ship* sp;
		const rec::record& levs;
		double this_at, next_at;
		std::string this_level, next_level;
		bool repeat;

		typedef std::vector<std::pair<double, std::string> > vect_t;
		vect_t new_balls;
		vect_t::iterator next;

		void check_level();
		void flush_new_balls(double depth);

		level_creator(const level_creator&);
		level_creator operator=(const level_creator&);
	};

} // namespace balls

#endif // !NEW_BALL_H

// Local Variables:
// mode: c++
// End:
