// sdl_controller.h - handles keyboard using SDL
//
// Copyright (C) 2000 - 2002 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SDL_CONTROLLER_H
#define SDL_CONTROLLER_H

#include "SDL.h"

#include "controller.h"

namespace {
	const int array_size = (SDLK_LAST + 1 + SDL_BUTTON_WHEELDOWN);
}

namespace sdl {

	// SDL implementation of the controller interface
	class controller : public control::controller {
	public:
		controller();
		~controller();
		void wait();
		void poll();

		void clear();
		void add_up(const std::string& s);
		void add_down(const std::string& s);
		void add_left(const std::string& s);
		void add_right(const std::string& s);
		void add_accel(const std::string& s);
		void add_decel(const std::string& s);
		void add_fire(const std::string& s);
		void add_weapon(const std::string& s);
		void add_start(const std::string& s);
		void add_quit(const std::string& s);
		void add_pause(const std::string& s);

		void reset_click();
	private:
		static const int size = array_size;
		unsigned actions[array_size];
		unsigned state[array_size];
	};

} // namespace sdl

#endif // !SDL_CONTROLLER_H

// Local Variables:
// mode: c++
// End:
