// sdl_timer.h - SDL timer implementation
//
// Copyright (C) 2001 Trevor Spiteri
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SDL_TIMER_H
#define SDL_TIMER_H

#include "SDL.h"

#include "timer.h"

namespace sdl {

	// Implementation of tim::timer
	class timer : public tim::timer {
	public:
		timer(double cycle, double drawmin, double drawmax);

		item next();
		void start();
		void pause();
		void reset();
	private:
		double cycle_dur, draw_min, draw_max;
		bool paused;
		Uint32 first_time;
		double last_time[no_of_items + 1];

		void sleep(double msec);
	};

} // namespace sdl

#endif // !SDL_TIMER_H

// Local Variables:
// mode: c++
// End:
