/* editor.h
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _EDITOR_H
#define _EDITOR_H

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>
#include "song.h"
#include "block.h"
#include "gui.h"
#include "player.h"

#define DEFAULT_TEMPO 130

struct editor {
  /* The song currently being edited */
  struct song *song;
  /* The full file name of the song currently being edited */
  char *filename;
  /* Current location in song */
  unsigned int section, playseq, position, block, line, time, cmdpage;
  /* Editor modes */
  unsigned int octave, instrument, edit, chord, space, recordcontrollers;
  /* Tracks currently skipped in chord mode */
  unsigned int chordstatus;
  /* Buffers for copy & paste */
  struct block *copyblock, *copytrack, *copyarea;
  /* GUI for this editor */
  struct gui *gui;
  /* Editor thread pointer */
  GThread *thread;
  /* Player for this editor */
  struct player *player;
};

/* Initializes the editor */
struct editor *editor_open(char *);
/* Opens an existing song or creates new */
void editor_song_open(struct editor *, char *);
/* Deinitializes the editor */
void editor_close(struct editor *);

/* Refreshes playseq from section and block from position */
void editor_refresh_playseq_and_block(struct editor *);

/* Sets the position of the editor */
void editor_set_section(struct editor *, int);
void editor_set_playseq(struct editor *, int);
void editor_set_position(struct editor *, int);
void editor_set_block(struct editor *, int);
void editor_set_line(struct editor *, int);
void editor_set_commandpage(struct editor *, int);
void editor_set_time(struct editor *, int);
void editor_set_tempo(struct editor *);
/* Refreshes the GUI when the player has stopped */
void editor_stop(struct editor *);

/* Reads MIDI input */
void editor_midi_input(struct editor *, unsigned char *);

#endif
