/* conversion.h
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CONVERSION_H
#define _CONVERSION_H

#include "mmd.h"
#include "song.h"

/* Converts an MMD2 module to a song */
struct song *MMD2_convert(struct MMD2 *);
/* Converts MMD command values at given location */
void MMD2_commands_convert(unsigned char *, struct MMDMIDICmd3x *);
/* Converts a song to an MMD2 module */
struct MMD2 *song_convert(struct song *);
/* Converts song command values at given location */
void song_commands_convert(unsigned char *);

#endif
