/* tutkaplayer.c
 *
 * Copyright 2002-2003 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <signal.h>
#include <unistd.h>
#include <glib.h>
#include "editor.h"
#include "player.h"
#include "mmd.h"

static struct editor *editor;
static int playing = 1, statuschanged = 0;
static int oldsection = 0, oldplayseq = 0, oldposition = 0;
static int oldblock = 0, oldline = 0, oldtime = 0;

/* Not used */
struct MMD2 *MMD2_load(char *filename)
{
  return NULL;
}
void MMD2_free(struct MMD2 *mmd)
{
}

/* Stops the player */
int stop()
{
  playing = 0;

  return 0;
}

/* Changes the position of the editor and refreshes the GUI accordingly */
void editor_set_values(struct editor *editor, int newsection, int newplayseq, int newposition, int newblock, int newline, int newtime, int tempochanged)
{
  if (editor == NULL) {
    fprintf(stderr, "editor_set_values() called with null editor\n");
    return;
  }

  if (oldsection != newsection) {
    oldsection = newsection;
    statuschanged = 1;
  }
  if (oldplayseq != newplayseq) {
    oldplayseq = newplayseq;
    statuschanged = 1;
  }
  if (oldposition != newposition) {
    oldposition = newposition;
    statuschanged = 1;
  }
  if (oldblock != newblock) {
    oldblock = newblock;
    statuschanged = 1;
  }
  if (oldline != newline) {
    oldline = newline;
    statuschanged = 1;
  }
  if (oldtime != newtime) {
    oldtime = newtime;
    statuschanged = 1;
  }
  if (tempochanged)
    statuschanged = 1;
}

void editor_set_section(struct editor *editor, int blah)
{
}
void editor_set_playseq(struct editor *editor, int blah)
{
}
void editor_set_position(struct editor *editor, int blah)
{
}
void editor_set_block(struct editor *editor, int blah)
{
}
void editor_set_line(struct editor *editor, int blah)
{
}
void editor_set_time(struct editor *editor, int blah)
{
}
void editor_set_tempo(struct editor *editor)
{
}
void editor_stop(struct editor *editor)
{
}

int main(int argc, char *argv[])
{
  /* Check command line arguments */
  if (argc < 2) {
    fprintf(stderr, "%s: Not enough arguments\n", argv[0]);
    exit(1);
  }

  /* Threads are needed */
  if (!g_thread_supported()) {
    g_thread_init(NULL);
    gdk_threads_init();
  } else {
    fprintf(stderr, "No threads implementation. Tutka requires threads.\n");
    return -1;
  }

  /* Trap CTRL-C */
  signal(SIGINT, stop);

  /* Load a song to the "editor" */
  editor = (struct editor *)calloc(1, sizeof(struct editor));
  editor->song = song_load(argv[1]);

  if (editor->song != NULL) {
    /* Open the player and start playing */
    editor->player = player_open(editor->song, editor);
    editor->player->sched = SCHED_RTC;
    player_start(editor->player, MODE_PLAY_SONG, 0, 0, 0, 0);

    /* Wait while playing */
    while (playing) {
      if (statuschanged) {
	fprintf(stdout, "%c[80D%.2d:%.2d: Section %.2d/%.2d - Position %.2d/%.2d - Block %.2d/%.2d - Line %.2d/%.2d", 27, oldtime / 60, oldtime % 60, oldsection + 1, editor->song->numsections, oldposition + 1, editor->song->playseqs[oldplayseq]->length, oldblock + 1, editor->song->numblocks, oldline, editor->song->blocks[oldblock]->length);
	fflush(stdout);
	statuschanged = 0;
      }
      usleep(40);
    }

    /* Close the player */
    player_close(editor->player);
    song_free(editor->song);
  }
  free(editor);

  fprintf(stdout, "\n");
  fflush(stdout);

  return 0;
}
