/* midi.h
 *
 * Copyright 2002-2004 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _MIDI_H
#define _MIDI_H

#include <libxml/tree.h>

/* MIDI data structure */
struct midi {
  /* MIDI device file descriptor */
  int fd;
};

struct message {
  /* Name */
  char *name;
  /* Length in bytes */
  unsigned int length;
  /* Dump data */
  unsigned char *data;
  /* Automatically send after loading? */
  unsigned int autosend;
};

/* Opens a MIDI device */
struct midi *midi_open(char *);
/* Closes a MIDI device */
void midi_close(struct midi *);
/* Stops a note playing on a MIDI channel using requested velocity */
void midi_note_off(struct midi *, unsigned char, unsigned char, unsigned char);
/* Plays a note on a MIDI channel using requested velocity */
void midi_note_on(struct midi *, unsigned char, unsigned char, unsigned char);
/* Sets the aftertouch pressure of a note playing on a MIDI channel */
void midi_aftertouch(struct midi *, unsigned char, unsigned char, unsigned char);
/* Sets the MIDI controller value of a MIDI channel */
void midi_controller(struct midi *, unsigned char, unsigned char, unsigned char);
/* Send a program change on a MIDI channel */
void midi_program_change(struct midi *, unsigned char, unsigned char);
/* Sets the channel pressure of a MIDI channel */
void midi_channel_pressure(struct midi *, unsigned char, unsigned char);
/* Sets the pitch wheel value of a MIDI channel */
void midi_pitch_wheel(struct midi *, unsigned char, unsigned short);
/* Sends a MIDI message */
void midi_write(struct midi *, unsigned char *, unsigned short);
/* Send a clock message */
void midi_clock(struct midi *);
/* Receives a MIDI message */
unsigned char *midi_read(struct midi *);
/* Receives a MIDI message */
void midi_read_system_exclusive(struct midi *, struct message *, int);
/* Sets the length of a MIDI message */
void message_set_length(struct message *, unsigned int);
/* Sets the auto send flag of a MIDI message */
void message_set_autosend(struct message *, unsigned int);
/* Parses a element in an XML file */
struct message *message_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
/* Saves a message to an XML file */
void message_save(struct message *, int, xmlNodePtr);
/* Loads a message from a file */
void message_load_binary(struct message *, char *);
/* Saves a message to a file */
void message_save_binary(struct message *, char *);

#endif
