/* instrument.c
 *
 * Copyright 2002-2004 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include "instrument.h"

struct instrument *instrument_alloc() {
  struct instrument *instrument;

  instrument=(struct instrument *)calloc(1, sizeof(struct instrument));
  instrument->defaultvelocity=127;
  instrument->name=(char *)strdup("Unnamed");

  return instrument;
}

void instrument_free(struct instrument *instrument) {
  if(instrument) {
    if(instrument->name)
      free(instrument->name);

    free(instrument);
  }
}

/* Parses an instrument element in an XML file */
struct instrument *instrument_parse(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
  struct instrument *instrument=NULL;

  if((!xmlStrcmp(cur->name, "instrument")) && (cur->ns==ns)) {
    char *prop;
    xmlNodePtr temp=cur->xmlChildrenNode;

    /* Allocate instrument */
    instrument=(struct instrument *)calloc(1, sizeof(struct instrument));
    if(temp!=NULL)
      instrument->name=strdup(temp->content);
    else
      instrument->name=(char *)calloc(1, sizeof(char));
    prop=xmlGetProp(cur, "midipreset");
    if(prop!=NULL)
      instrument->midipreset=atoi(prop);
    prop=xmlGetProp(cur, "midichannel");
    if(prop!=NULL)
      instrument->midichannel=atoi(prop);
    prop=xmlGetProp(cur, "defaultvelocity");
    if(prop!=NULL)
      instrument->defaultvelocity=atoi(prop);
    prop=xmlGetProp(cur, "transpose");
    if(prop!=NULL)
      instrument->transpose=atoi(prop);
    prop=xmlGetProp(cur, "hold");
    if(prop!=NULL)
      instrument->hold=atoi(prop);
  } else if(cur->type!=XML_COMMENT_NODE)
    fprintf(stderr, "XML error: expected instrument, got %s\n", cur->name);

  return instrument;
}

/* Saves an instrument to an XML document */
void instrument_save(struct instrument *instrument, int number,
		     xmlNodePtr parent) {
  char c[10];

  xmlNodePtr node;

  node=xmlNewChild(parent, NULL, "instrument", instrument->name);
  snprintf(c, 10, "%d", number);
  xmlSetProp(node, "number", c);
  snprintf(c, 10, "%d", instrument->midipreset);
  xmlSetProp(node, "midipreset", c);
  snprintf(c, 10, "%d", instrument->midichannel);
  xmlSetProp(node, "midichannel", c);
  snprintf(c, 10, "%d", instrument->defaultvelocity);
  xmlSetProp(node, "defaultvelocity", c);
  snprintf(c, 10, "%d", instrument->transpose);
  xmlSetProp(node, "transpose", c);
  snprintf(c, 10, "%d", instrument->hold);
  xmlSetProp(node, "hold", c);

  xmlAddChild(parent, xmlNewText("\n"));
}
