/* tutka.h
 *
 * Copyright 2002-2005 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _TUTKA_H
#define _TUTKA_H

extern char *nullcheck_error_string;
#define nullcheck_void(object, funcname) if (object == NULL) { fprintf(stderr, nullcheck_error_string, #funcname, #object); return; }
#define nullcheck_int(object, funcname) if (object == NULL) { fprintf(stderr, nullcheck_error_string, #funcname, #object); return 0; }
#define nullcheck_pointer(object, funcname) if (object == NULL) { fprintf(stderr, nullcheck_error_string, #funcname, #object); return NULL; }

#endif
