/* jack.h
 *
 * Copyright 2005 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_JACK
#ifndef _JACK_H
#define _JACK_H

#include <jack/jack.h>
#include "editor.h"

struct jack {
  struct editor *editor;
  jack_port_t *input_port;
  jack_port_t *output_port;
  jack_client_t *client;
  jack_transport_state_t prevstate;
  int prevticks;
};

struct jack *jack_open(struct editor *);
void jack_close(struct jack *);
  
#endif
#endif
