/* smf.c
 *
 * Copyright 2002-2006 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tutka.h"
#include "smf.h"

#define getlong(a) (((*(a+0))<<24)|((*(a+1))<<16)|((*(a+2))<<8)|((*(a+3))))
#define getword(a) (((*(a+0))<<8)|((*(a+1))))
#define getbyte(a) (*(a))
#define putlong(a, b) *(a)=((b)>>24); *(a+1)=(((b)>>16)&0xff); *(a+2)=(((b)>>8)&0xff); *(a+3)=((b)&0xff)
#define putword(a, b) *(a)=((b)>>8); *(a+1)=((b)&0xff)
#define putbyte(a, b) *(a)=(b)

/* Returns the length of the SMF file in bytes */
int smf_length_get(struct smf *smf)
{
  nullcheck_int(smf, smf_length_get);

  int i, length = 14;
  
  for (i = 0; i < smf->MThd->NumTracks; i++) {
    length += 8;
    length += smf->MTrks[i]->Length;
  }
  
  return length;
}

/* Saves an SMF file */
void smf_save(struct smf *smf, char *filename)
{
  nullcheck_void(smf, smf_save);
  nullcheck_void(filename, smf_save);

  FILE *file;
  int i, length = smf_length_get(smf);
  unsigned char *data = malloc(length);
  unsigned char *ptr = data;
  
  /* Copy MThd structure */
  putbyte(ptr, smf->MThd->ID[0]);
  putbyte(ptr + 1, smf->MThd->ID[1]);
  putbyte(ptr + 2, smf->MThd->ID[2]);
  putbyte(ptr + 3, smf->MThd->ID[3]);
  putlong(ptr + 4, smf->MThd->Length);
  putword(ptr + 8, smf->MThd->Format);
  putword(ptr + 10, smf->MThd->NumTracks);
  putword(ptr + 12, smf->MThd->Division);
  ptr += 14;
  
  /* Copy MTrk structures */ 
  for (i = 0; i < smf->MThd->NumTracks; i++) {
    putbyte(ptr, smf->MTrks[i]->ID[0]);
    putbyte(ptr + 1, smf->MTrks[i]->ID[1]);
    putbyte(ptr + 2, smf->MTrks[i]->ID[2]);
    putbyte(ptr + 3, smf->MTrks[i]->ID[3]);
    putlong(ptr + 4, smf->MTrks[i]->Length);
    ptr += 8;
    memcpy(ptr, smf->MTrks[i]->Data, smf->MTrks[i]->Length);
    ptr += smf->MTrks[i]->Length;
  }

  /* Write to file */  
  if ((file = fopen(filename, "w")) == NULL) {
    free(data);
    return;
  }
  fwrite(data, sizeof(unsigned char), length, file);
  free(data);
  fclose(file);
}

/* Frees an smf structure and all associated data */
void smf_free(struct smf *smf)
{
  nullcheck_void(smf, smf_free);
  
  if (smf->MTrks != NULL) {
    if (smf->MThd != NULL) {
      int i;
      
      for (i = 0; i < smf->MThd->NumTracks; i++) {
        if (smf->MTrks[i]->Data != NULL)
          free (smf->MTrks[i]->Data);
        
        free (smf->MTrks[i]);
      }
    }
    free (smf->MTrks);
  }
  
  if (smf->MThd != NULL)
    free (smf->MThd);
  
  free(smf);
}
