/* callbacks.h
 *
 * Copyright 2002-2011 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CALLBACKS_H
#define _CALLBACKS_H

#include <gnome.h>
#include <glade/glade.h>
#include "gui.h"

void on_adjustment_trackvolumes_volume_changed(GtkAdjustment *, gpointer);
void on_togglebutton_trackvolumes_mute_toggled(GtkToggleButton *, gpointer);
void on_togglebutton_trackvolumes_solo_toggled(GtkToggleButton *, gpointer);
void on_entry_trackvolumes_name_changed(GtkEditable *, gpointer);
void on_button_block_clicked(GtkButton *, gpointer);
gboolean keyboard_event(GtkWidget *, GdkEventKey *, gboolean, struct gui *);
void on_selection_message_changed(GtkTreeSelection *, gpointer);
void on_selection_sectionlist_changed(GtkTreeSelection *, gpointer);
void on_selection_playseqlist_changed(GtkTreeSelection *, gpointer);
void on_selection_playseq_changed(GtkTreeSelection *, gpointer);
void on_selection_blocklist_changed(GtkTreeSelection *, gpointer);
void on_selection_messagelist_changed(GtkTreeSelection *, gpointer);
void on_menuitem_edit_cut_activate(GtkMenuItem *, gpointer);
void on_menuitem_edit_copy_activate(GtkMenuItem *, gpointer);
void on_menuitem_edit_paste_activate(GtkMenuItem *, gpointer);
void on_menuitem_block_cut_activate(GtkMenuItem *, gpointer);
void on_menuitem_block_copy_activate(GtkMenuItem *, gpointer);
void on_menuitem_block_paste_activate(GtkMenuItem *, gpointer);
void on_menuitem_track_cut_activate(GtkMenuItem *, gpointer);
void on_menuitem_track_copy_activate(GtkMenuItem *, gpointer);
void on_menuitem_track_paste_activate(GtkMenuItem *, gpointer);
void on_menuitem_track_insert_activate(GtkMenuItem *, gpointer);
void on_menuitem_file_saveas_activate(GtkMenuItem *, gpointer);
void gconf_notify_function(GConfClient *, guint, GConfEntry *, gpointer);
void on_cell_sectionlist_edited(GtkCellRendererText *, gchar *, gchar *, gpointer);
void on_cell_playseqlist_edited(GtkCellRendererText *, gchar *, gchar *, gpointer);
void on_cell_playseq_edited(GtkCellRendererText *, gchar *, gchar *, gpointer);
void on_cell_blocklist_edited(GtkCellRendererText *, gchar *, gchar *, gpointer);
void on_cell_messagelist_edited(GtkCellRendererText *, gchar *, gchar *, gpointer);
void on_cell_messagelist_toggled(GtkCellRendererToggle *, gchar *, gpointer);
void on_cell_preferences_midi_interfaces_toggled(GtkCellRendererToggle *, gchar *, gpointer);
void on_entry_instrumentproperties_name_changed(GtkEditable *, gpointer);
void on_spinbutton_instrument_changed(GtkEditable *, gpointer);
void on_entry_songname_changed(GtkEditable *, gpointer);
void on_scale_tempo_value_changed(GtkRange *, gpointer);
void on_scale_tpl_value_changed(GtkRange *, gpointer);
gboolean on_entry_preferences_midi_interface_changed(GtkEditable *, gpointer);
void on_scale_volume_value_changed(GtkRange *, gpointer);
void on_scale_transpose_value_changed(GtkRange *, gpointer);
void on_scale_hold_value_changed(GtkRange *, gpointer);
void on_scale_midich_value_changed(GtkRange *, gpointer);
void on_spinbutton_space_changed(GtkSpinButton *, gpointer);
void on_checkbutton_edit_toggled(GtkToggleButton *, gpointer);
void on_combobox_keyboard_changed(GtkComboBox *, gpointer);
void on_combobox_preferences_scheduling_mode_changed(GtkComboBox *, gpointer);
void on_combobox_instrumentproperties_midiinterface_changed(GtkComboBox *, gpointer);
void on_button_receive_close_clicked(GtkButton *, gpointer);
void on_button_receive_stop_clicked(GtkButton *, gpointer);
void on_menuitem_settings_sendmidisync_activate(GtkMenuItem *, gpointer);

#endif
