/* playseq.h
 *
 * Copyright 2002-2011 Vesa Halttunen
 *
 * This file is part of Tutka.
 *
 * Tutka is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tutka is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tutka; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PLAYSEQ_H
#define _PLAYSEQ_H

#include <libxml/tree.h>

struct playseq {
  /* Name */
  char *name;
  /* Number of blocks in playing sequence */
  unsigned int length;
  /* Block number array */
  unsigned int *blocknumbers;
};

struct playseq *playseq_alloc();
void playseq_free(struct playseq *);
/* Inserts a new block in the block array in the given position */
void playseq_insert(struct playseq *, int);
/* Deletes a section from the given position of the section array */
void playseq_delete(struct playseq *, int);
void playseq_set(struct playseq *, unsigned int, unsigned int);
struct playseq *playseq_parse(xmlDocPtr, xmlNsPtr, xmlNodePtr);
void playseq_save(struct playseq *, int, xmlNodePtr);

#endif
